/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.tools.rumen.EventType;
import org.apache.hadoop.tools.rumen.HistoryEvent;

public class JobUnsuccessfulCompletionEvent
implements HistoryEvent {
    private JobID jobId;
    private long finishTime;
    private int finishedMaps;
    private int finishedReduces;
    private String jobStatus;

    public JobUnsuccessfulCompletionEvent(JobID id, long finishTime, int finishedMaps, int finishedReduces, String status) {
        this.jobId = id;
        this.finishTime = finishTime;
        this.finishedMaps = finishedMaps;
        this.finishedReduces = finishedReduces;
        this.jobStatus = status;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public int getFinishedMaps() {
        return this.finishedMaps;
    }

    public int getFinishedReduces() {
        return this.finishedReduces;
    }

    public String getStatus() {
        return this.jobStatus;
    }

    @Override
    public EventType getEventType() {
        if ("FAILED".equals(this.getStatus())) {
            return EventType.JOB_FAILED;
        }
        return EventType.JOB_KILLED;
    }
}

