/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.ObjectName;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.util.MathUtils;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.MetricsBuffer;
import org.apache.hadoop.metrics2.impl.MetricsBufferBuilder;
import org.apache.hadoop.metrics2.impl.MetricsBuilderImpl;
import org.apache.hadoop.metrics2.impl.MetricsConfig;
import org.apache.hadoop.metrics2.impl.MetricsConfigException;
import org.apache.hadoop.metrics2.impl.MetricsSinkAdapter;
import org.apache.hadoop.metrics2.impl.MetricsSourceAdapter;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableStat;
import org.apache.hadoop.metrics2.util.Contracts;
import org.apache.hadoop.metrics2.util.MBeans;

public class MetricsSystemImpl
implements MetricsSystem {
    private static final Log LOG = LogFactory.getLog(MetricsSystemImpl.class);
    static final String MS_CONTEXT = "metricssystem";
    static final String NUM_SOURCES_KEY = "num_sources";
    static final String NUM_SOURCES_DESC = "Number of metrics sources";
    static final String NUM_SINKS_KEY = "num_sinks";
    static final String NUM_SINKS_DESC = "Number of metrics sinks";
    static final String MS_NAME = "MetricsSystem";
    static final String MS_STATS_NAME = "MetricsSystem,sub=Stats";
    static final String MS_STATS_DESC = "Metrics system metrics";
    static final String MS_CONTROL_NAME = "MetricsSystem,sub=Control";
    private final Map<String, MetricsSourceAdapter> sources;
    private final Map<String, MetricsSinkAdapter> sinks;
    private final List<MetricsSystem.Callback> callbacks;
    private final MetricsBuilderImpl metricsBuilder;
    private final MetricMutableStat snapshotStat = new MetricMutableStat("snapshot", "snapshot stats", "ops", "time", true);
    private final MetricMutableStat publishStat = new MetricMutableStat("publish", "publishing stats", "ops", "time", true);
    private final MetricMutableCounterLong dropStat = new MetricMutableCounterLong("dropped_pub_all", "number of dropped updates by all sinks", 0L);
    private final List<MetricsTag> injectedTags;
    private String prefix;
    private MetricsFilter sourceFilter;
    private MetricsConfig config;
    private Map<String, MetricsConfig> sourceConfigs;
    private Map<String, MetricsConfig> sinkConfigs;
    private boolean monitoring = false;
    private Timer timer;
    private int period;
    private long logicalTime;
    private ObjectName mbeanName;
    private boolean publishSelfMetrics = true;
    private MetricsSourceAdapter sysSource;

    public MetricsSystemImpl(String prefix) {
        this.prefix = prefix;
        this.sources = new LinkedHashMap<String, MetricsSourceAdapter>();
        this.sinks = new LinkedHashMap<String, MetricsSinkAdapter>();
        this.sourceConfigs = new HashMap<String, MetricsConfig>();
        this.sinkConfigs = new HashMap<String, MetricsConfig>();
        this.callbacks = new ArrayList<MetricsSystem.Callback>();
        this.injectedTags = new ArrayList<MetricsTag>();
        this.metricsBuilder = new MetricsBuilderImpl();
        if (prefix != null) {
            this.initSystemMBean();
        }
    }

    public MetricsSystemImpl() {
        this(null);
    }

    public synchronized void init(String prefix) {
        if (this.monitoring) {
            LOG.warn(this.prefix + " metrics system already initialized!");
            return;
        }
        this.prefix = Contracts.checkNotNull(prefix, "prefix");
        try {
            this.start();
        }
        catch (MetricsConfigException e) {
            LOG.warn("Metrics system not started: " + e.getMessage());
            LOG.debug("Stacktrace: ", e);
        }
        this.initSystemMBean();
    }

    @Override
    public synchronized void start() {
        Contracts.checkNotNull(this.prefix, "prefix");
        if (this.monitoring) {
            LOG.warn(this.prefix + " metrics system already started!", new MetricsException("Illegal start"));
            return;
        }
        for (MetricsSystem.Callback cb : this.callbacks) {
            cb.preStart();
        }
        this.configure(this.prefix);
        this.startTimer();
        this.monitoring = true;
        LOG.info(this.prefix + " metrics system started");
        for (MetricsSystem.Callback cb : this.callbacks) {
            cb.postStart();
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.monitoring) {
            LOG.warn(this.prefix + " metrics system not yet started!", new MetricsException("Illegal stop"));
            return;
        }
        for (MetricsSystem.Callback cb : this.callbacks) {
            cb.preStop();
        }
        LOG.info("Stopping " + this.prefix + " metrics system...");
        this.stopTimer();
        this.stopSources();
        this.stopSinks();
        this.clearConfigs();
        this.monitoring = false;
        LOG.info(this.prefix + " metrics system stopped.");
        for (MetricsSystem.Callback cb : this.callbacks) {
            cb.postStop();
        }
    }

    @Override
    public synchronized <T extends MetricsSource> T register(final String name, final String desc, final T source) {
        if (this.monitoring) {
            this.registerSource(name, desc, source);
        }
        this.register(new MetricsSystem.AbstractCallback(){

            @Override
            public void postStart() {
                MetricsSystemImpl.this.registerSource(name, desc, source);
            }
        });
        return source;
    }

    synchronized void registerSource(String name, String desc, MetricsSource source) {
        Contracts.checkNotNull(this.config, "config");
        MetricsSourceAdapter sa = this.sources.get(name);
        if (sa != null) {
            LOG.warn("Source name " + name + " already exists!");
            return;
        }
        MetricsConfig conf = this.sourceConfigs.get(name);
        sa = conf != null ? new MetricsSourceAdapter(this.prefix, name, desc, source, this.injectedTags, this.period, conf) : new MetricsSourceAdapter(this.prefix, name, desc, source, this.injectedTags, this.period, this.config.subset("source"));
        this.sources.put(name, sa);
        sa.start();
        LOG.debug("Registered source " + name);
    }

    @Override
    public synchronized <T extends MetricsSink> T register(final String name, final String description, final T sink) {
        if (this.config != null) {
            this.registerSink(name, description, sink);
        }
        this.register(new MetricsSystem.AbstractCallback(){

            @Override
            public void postStart() {
                MetricsSystemImpl.this.registerSink(name, description, sink);
            }
        });
        return sink;
    }

    synchronized void registerSink(String name, String desc, MetricsSink sink) {
        Contracts.checkNotNull(this.config, "config");
        MetricsSinkAdapter sa = this.sinks.get(name);
        if (sa != null) {
            LOG.warn("Sink name " + name + " already exists!");
            return;
        }
        MetricsConfig conf = this.sinkConfigs.get(name);
        sa = conf != null ? MetricsSystemImpl.newSink(name, desc, sink, conf) : MetricsSystemImpl.newSink(name, desc, sink, this.config.subset("sink"));
        this.sinks.put(name, sa);
        sa.start();
        LOG.debug("Registered sink " + name);
    }

    @Override
    public synchronized void register(final MetricsSystem.Callback callback) {
        this.callbacks.add((MetricsSystem.Callback)Proxy.newProxyInstance(callback.getClass().getClassLoader(), new Class[]{MetricsSystem.Callback.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke((Object)callback, args);
                }
                catch (Exception e) {
                    LOG.warn("Caught exception in callback " + method.getName(), e);
                    return null;
                }
            }
        }));
    }

    @Override
    public synchronized void refreshMBeans() {
        for (MetricsSourceAdapter sa : this.sources.values()) {
            sa.refreshMBean();
        }
    }

    @Override
    public synchronized String currentConfig() {
        PropertiesConfiguration saver = new PropertiesConfiguration();
        StringWriter writer = new StringWriter();
        saver.copy(this.config);
        try {
            saver.save(writer);
        }
        catch (Exception e) {
            throw new MetricsConfigException("Error stringify config", e);
        }
        return writer.toString();
    }

    private synchronized void startTimer() {
        if (this.timer != null) {
            LOG.warn(this.prefix + " metrics system timer already started!");
            return;
        }
        this.logicalTime = 0L;
        long millis = this.period * 1000;
        this.timer = new Timer("Timer for '" + this.prefix + "' metrics system", true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    MetricsSystemImpl.this.onTimerEvent();
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
        }, millis, millis);
        LOG.info("Scheduled snapshot period at " + this.period + " second(s).");
    }

    synchronized void onTimerEvent() {
        this.logicalTime += (long)this.period;
        if (this.sinks.size() > 0) {
            this.publishMetrics(this.snapshotMetrics(), false);
        }
    }

    @Override
    public void publishMetricsNow() {
        if (this.sinks.size() > 0) {
            this.publishMetrics(this.snapshotMetrics(), true);
        }
    }

    synchronized MetricsBuffer snapshotMetrics() {
        this.metricsBuilder.clear();
        MetricsBufferBuilder bufferBuilder = new MetricsBufferBuilder();
        for (Map.Entry<String, MetricsSourceAdapter> entry : this.sources.entrySet()) {
            if (this.sourceFilter != null && !this.sourceFilter.accepts(entry.getKey())) continue;
            this.snapshotMetrics(entry.getValue(), bufferBuilder);
        }
        if (this.publishSelfMetrics) {
            this.snapshotMetrics(this.sysSource, bufferBuilder);
        }
        MetricsBuffer buffer = bufferBuilder.get();
        return buffer;
    }

    private void snapshotMetrics(MetricsSourceAdapter sa, MetricsBufferBuilder bufferBuilder) {
        long startTime = System.currentTimeMillis();
        bufferBuilder.add(sa.name(), sa.getMetrics(this.metricsBuilder, false));
        this.metricsBuilder.clear();
        this.snapshotStat.add(System.currentTimeMillis() - startTime);
        LOG.debug("Snapshotted source " + sa.name());
    }

    synchronized void publishMetrics(MetricsBuffer buffer, boolean immediate) {
        int dropped = 0;
        for (MetricsSinkAdapter sa : this.sinks.values()) {
            long startTime = System.currentTimeMillis();
            boolean result = immediate ? sa.putMetricsImmediate(buffer) : sa.putMetrics(buffer, this.logicalTime);
            dropped += result ? 0 : 1;
            this.publishStat.add(System.currentTimeMillis() - startTime);
        }
        this.dropStat.incr(dropped);
    }

    private synchronized void stopTimer() {
        if (this.timer == null) {
            LOG.warn(this.prefix + " metrics system timer already stopped!");
            return;
        }
        this.timer.cancel();
        this.timer = null;
    }

    private synchronized void stopSources() {
        for (Map.Entry<String, MetricsSourceAdapter> entry : this.sources.entrySet()) {
            MetricsSourceAdapter sa = entry.getValue();
            LOG.info("Stopping metrics source " + entry.getKey() + "(" + sa.source().getClass().getName() + ")");
            sa.stop();
        }
        this.sysSource.stop();
        this.sources.clear();
    }

    private synchronized void stopSinks() {
        for (Map.Entry<String, MetricsSinkAdapter> entry : this.sinks.entrySet()) {
            MetricsSinkAdapter sa = entry.getValue();
            LOG.info("Stopping metrics sink " + entry.getKey() + "(" + sa.sink().getClass().getName() + ")");
            sa.stop();
        }
        this.sinks.clear();
    }

    private synchronized void configure(String prefix) {
        this.config = MetricsConfig.create(prefix);
        this.configureSinks();
        this.configureSources();
        this.configureSystem();
    }

    private synchronized void configureSystem() {
        this.injectedTags.add(new MetricsTag("hostName", "Local hostname", MetricsSystemImpl.getHostname()));
    }

    private synchronized void configureSinks() {
        this.sinkConfigs = this.config.getInstanceConfigs("sink");
        int confPeriod = 0;
        for (Map.Entry<String, MetricsConfig> entry : this.sinkConfigs.entrySet()) {
            MetricsConfig conf = entry.getValue();
            int sinkPeriod = conf.getInt("period", 10);
            confPeriod = confPeriod == 0 ? sinkPeriod : MathUtils.gcd(confPeriod, sinkPeriod);
            String sinkName = entry.getKey();
            LOG.debug("sink " + sinkName + " config:\n" + conf);
            try {
                MetricsSinkAdapter sa = MetricsSystemImpl.newSink(sinkName, conf.getString("description", sinkName), conf);
                if (sa == null) continue;
                sa.start();
                this.sinks.put(sinkName, sa);
            }
            catch (Exception e) {
                LOG.warn("Error creating " + sinkName, e);
            }
        }
        this.period = confPeriod > 0 ? confPeriod : this.config.getInt("period", 10);
    }

    static MetricsSinkAdapter newSink(String name, String desc, MetricsSink sink, MetricsConfig conf) {
        return new MetricsSinkAdapter(name, desc, sink, conf.getString("context"), conf.getFilter("source.filter"), conf.getFilter("record.filter"), conf.getFilter("metric.filter"), conf.getInt("period", 10), conf.getInt("queue.capacity", 1), conf.getInt("retry.delay", 10), conf.getFloat("retry.backoff", 2.0f), conf.getInt("retry.count", 1));
    }

    static MetricsSinkAdapter newSink(String name, String desc, MetricsConfig conf) {
        MetricsSink sink = (MetricsSink)conf.getPlugin("");
        if (sink == null) {
            return null;
        }
        return MetricsSystemImpl.newSink(name, desc, sink, conf);
    }

    private void configureSources() {
        this.sourceFilter = this.config.getFilter("*.source.filter");
        Map<String, MetricsConfig> confs = this.config.getInstanceConfigs("source");
        for (Map.Entry<String, MetricsConfig> entry : confs.entrySet()) {
            this.sourceConfigs.put(entry.getKey(), entry.getValue());
        }
        this.registerSystemSource();
    }

    private void clearConfigs() {
        this.sinkConfigs.clear();
        this.sourceConfigs.clear();
        this.injectedTags.clear();
        this.config = null;
    }

    static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOG.error("Error getting localhost name. Using 'localhost'...", e);
            return "localhost";
        }
    }

    private void registerSystemSource() {
        this.sysSource = new MetricsSourceAdapter(this.prefix, MS_STATS_NAME, MS_STATS_DESC, new MetricsSource(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getMetrics(MetricsBuilder builder, boolean all) {
                int numSinks;
                int numSources;
                MetricsSystemImpl metricsSystemImpl = MetricsSystemImpl.this;
                synchronized (metricsSystemImpl) {
                    numSources = MetricsSystemImpl.this.sources.size();
                    numSinks = MetricsSystemImpl.this.sinks.size();
                }
                MetricsRecordBuilder rb = builder.addRecord(MetricsSystemImpl.MS_NAME).setContext(MetricsSystemImpl.MS_CONTEXT).addGauge(MetricsSystemImpl.NUM_SOURCES_KEY, MetricsSystemImpl.NUM_SOURCES_DESC, numSources).addGauge(MetricsSystemImpl.NUM_SINKS_KEY, MetricsSystemImpl.NUM_SINKS_DESC, numSinks);
                MetricsSystemImpl metricsSystemImpl2 = MetricsSystemImpl.this;
                synchronized (metricsSystemImpl2) {
                    for (MetricsSinkAdapter sa : MetricsSystemImpl.this.sinks.values()) {
                        sa.snapshot(rb, all);
                    }
                }
                MetricsSystemImpl.this.snapshotStat.snapshot(rb, all);
                MetricsSystemImpl.this.publishStat.snapshot(rb, all);
                MetricsSystemImpl.this.dropStat.snapshot(rb, all);
            }
        }, this.injectedTags, null, null, this.period);
        this.sysSource.start();
    }

    private void initSystemMBean() {
        Contracts.checkNotNull(this.prefix, "prefix should not be null here!");
        this.mbeanName = MBeans.register(this.prefix, MS_CONTROL_NAME, this);
    }

    @Override
    public synchronized void shutdown() {
        if (this.monitoring) {
            try {
                this.stop();
            }
            catch (Exception e) {
                LOG.warn("Error stopping the metrics system", e);
            }
        }
        MBeans.unregister(this.mbeanName);
    }
}

