/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml.util.jsse;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.core.xml.util.jsse.AbstractJsseUtilFactoryBean;
import org.apache.camel.core.xml.util.jsse.CipherSuitesParametersDefinition;
import org.apache.camel.core.xml.util.jsse.FilterParametersDefinition;
import org.apache.camel.core.xml.util.jsse.SecureSocketProtocolsParametersDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.jsse.BaseSSLContextParameters;
import org.apache.camel.support.jsse.CipherSuitesParameters;
import org.apache.camel.support.jsse.FilterParameters;
import org.apache.camel.support.jsse.SecureSocketProtocolsParameters;

@XmlTransient
public abstract class AbstractBaseSSLContextParametersFactoryBean<T extends BaseSSLContextParameters>
extends AbstractJsseUtilFactoryBean<T> {
    private CipherSuitesParametersDefinition cipherSuites;
    private FilterParametersDefinition cipherSuitesFilter;
    private SecureSocketProtocolsParametersDefinition secureSocketProtocols;
    private FilterParametersDefinition secureSocketProtocolsFilter;
    @XmlAttribute
    @Metadata(description="The optional SSLSessionContext timeout time for javax.net.ssl.SSLSession in seconds.")
    private String sessionTimeout;
    @XmlTransient
    private T instance;

    @Override
    public final T getObject() throws Exception {
        if (this.isSingleton()) {
            if (this.instance == null) {
                this.instance = this.createInstanceInternal();
            }
            return this.instance;
        }
        return this.createInstanceInternal();
    }

    protected abstract T createInstance() throws Exception;

    private T createInstanceInternal() throws Exception {
        T newInstance = this.createInstance();
        newInstance.setCamelContext(this.getCamelContext());
        if (this.cipherSuites != null) {
            CipherSuitesParameters cipherSuitesInstance = new CipherSuitesParameters();
            cipherSuitesInstance.setCipherSuite(this.cipherSuites.getCipherSuite());
            newInstance.setCipherSuites(cipherSuitesInstance);
        }
        if (this.cipherSuitesFilter != null) {
            newInstance.setCipherSuitesFilter(this.createFilterParameters(this.cipherSuitesFilter));
        }
        if (this.secureSocketProtocols != null) {
            SecureSocketProtocolsParameters secureSocketProtocolsInstance = new SecureSocketProtocolsParameters();
            secureSocketProtocolsInstance.setSecureSocketProtocol(this.secureSocketProtocols.getSecureSocketProtocol());
            newInstance.setSecureSocketProtocols(secureSocketProtocolsInstance);
        }
        if (this.secureSocketProtocolsFilter != null) {
            newInstance.setSecureSocketProtocolsFilter(this.createFilterParameters(this.secureSocketProtocolsFilter));
        }
        if (this.sessionTimeout != null) {
            newInstance.setSessionTimeout(this.sessionTimeout);
        }
        return newInstance;
    }

    private FilterParameters createFilterParameters(FilterParametersDefinition definition) {
        FilterParameters filter = new FilterParameters();
        filter.getInclude().addAll(definition.getInclude());
        filter.getExclude().addAll(definition.getExclude());
        filter.setCamelContext(this.getCamelContext());
        return filter;
    }

    public CipherSuitesParametersDefinition getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(CipherSuitesParametersDefinition cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public FilterParametersDefinition getCipherSuitesFilter() {
        return this.cipherSuitesFilter;
    }

    public void setCipherSuitesFilter(FilterParametersDefinition cipherSuitesFilter) {
        this.cipherSuitesFilter = cipherSuitesFilter;
    }

    public SecureSocketProtocolsParametersDefinition getSecureSocketProtocols() {
        return this.secureSocketProtocols;
    }

    public void setSecureSocketProtocols(SecureSocketProtocolsParametersDefinition secureSocketProtocols) {
        this.secureSocketProtocols = secureSocketProtocols;
    }

    public FilterParametersDefinition getSecureSocketProtocolsFilter() {
        return this.secureSocketProtocolsFilter;
    }

    public void setSecureSocketProtocolsFilter(FilterParametersDefinition secureSocketProtocolsFilter) {
        this.secureSocketProtocolsFilter = secureSocketProtocolsFilter;
    }

    public String getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(String sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }
}

