package Travel::Status::DE::HAFAS::Services;

# vim:readonly
# This module has been automatically generated
# by lib/Travel/Status/DE/HAFAS/Services.pm.PL.
# Do not edit, changes will be lost.

use strict;
use warnings;
use 5.014;
use utf8;

our $VERSION = '6.21';

# Most of these have been adapted from
# <https://github.com/public-transport/transport-apis> and
# <https://github.com/public-transport/hafas-client/tree/main/p>.
# Many thanks to Jannis R / @derhuerst and all contributors for maintaining
# these resources.

my $hafas_instance = {'AVV' => {'coverage' => {'area' => {'coordinates' => [[['5.85918841707277','51.051488002301'],['5.8724876173584','51.0158627609709'],['5.89773869885354','50.9991887664937'],['5.88556375505712','50.9810473832294'],['5.89169853080838','50.9719132496853'],['5.95125772312682','50.9827654696492'],['5.96710474145994','50.9749066309938'],['6.0178497913983','50.9789163158199'],['5.99806000215941','50.9567880375218'],['6.00863667867983','50.950269604531'],['6.01202630713695','50.9324491045801'],['6.05120858565616','50.9181154944811'],['6.08090891900315','50.9165993303044'],['6.06807432649071','50.8933006881814'],['6.07970800487149','50.8733877373965'],['6.06846191086424','50.8534930044325'],['6.05473841693232','50.861726460833'],['6.01417596000511','50.8495948423859'],['6.00883589619781','50.8390767550787'],['6.01554466342868','50.8150497409345'],['6.0045840421267','50.8070110560918'],['5.98072020670504','50.8140905820394'],['5.96793075373169','50.7970246800139'],['6.01792853285814','50.7722550401034'],['6.01256261954864','50.7578547396512'],['6.03245069812976','50.7434488321122'],['6.02614734789874','50.7272182407903'],['6.03437957579858','50.7151691789743'],['6.04942732680092','50.7213694650866'],['6.11400387896336','50.7163281358733'],['6.13831498679623','50.6789852681507'],['6.17434382700463','50.6506834905917'],['6.15962888019785','50.6440497725672'],['6.17346617734777','50.631658566054'],['6.17171795443031','50.6223760131276'],['6.18358006084488','50.619443960291'],['6.19548200235069','50.627797899968'],['6.26249927959527','50.623064531481'],['6.23699026376521','50.5929810212201'],['6.22132879427959','50.5942031506751'],['6.1674720361122','50.5586660480513'],['6.17171177379472','50.5396809835758'],['6.18758271192398','50.5342823165086'],['6.18119599997733','50.5236971542953'],['6.20113533851238','50.5163939184341'],['6.22065713205321','50.4912497371205'],['6.27088153226096','50.4986981440166'],['6.31765945644456','50.4922650869747'],['6.37093253582246','50.5125224122119'],['6.38726602869792','50.533183241579'],['6.37220406707367','50.5413763843543'],['6.3718420134678','50.5596587499821'],['6.40093628088609','50.5809603771984'],['6.39752667169208','50.5924702678339'],['6.42318855115155','50.5989825723249'],['6.42569709638268','50.6124941426901'],['6.4664688569211','50.6074214861678'],['6.48965106453327','50.5957057043951'],['6.5572298319165','50.5961080348776'],['6.56759836517031','50.6038245922788'],['6.56835967154641','50.6265888944299'],['6.58459394008646','50.639268067858'],['6.57741062741306','50.6556433799611'],['6.60829405861175','50.6721222460629'],['6.59494706566708','50.7038369221661'],['6.61841970680894','50.7112069356729'],['6.63209658739428','50.7252504889061'],['6.68108360302485','50.7089920835465'],['6.70946883805374','50.7294432556766'],['6.70335421204324','50.7358070927601'],['6.70664758499995','50.7511617826482'],['6.68736026461023','50.7710115817843'],['6.71931188837997','50.7861626028306'],['6.7238267417931','50.8265459571956'],['6.71022849308802','50.8391482668361'],['6.67761267367078','50.8426093575148'],['6.61958920009716','50.8302055899913'],['6.61870005535494','50.8403164467307'],['6.60226654433653','50.8513340540655'],['6.56731360133394','50.8582027561987'],['6.56235992033005','50.8643086808942'],['6.5686096815346','50.8785090325091'],['6.55873889026983','50.8953463622372'],['6.52702775573136','50.8982663460733'],['6.53107646772237','50.9335964903774'],['6.50843186916183','50.9357055142415'],['6.49489511280765','50.9543405366384'],['6.49167473552434','50.9632791565377'],['6.50598140367553','50.9687345219757'],['6.50593627316084','50.9784415449747'],['6.49607266438588','50.9877168387339'],['6.47991396415937','50.9886447033693'],['6.46877911451484','51.0024708183425'],['6.47074576175071','51.0227526837565'],['6.48749510366786','51.0347715344996'],['6.46978462143488','51.0439667240046'],['6.48370160666999','51.0582735430162'],['6.45437124807738','51.0669477890648'],['6.46156784673012','51.07856644137'],['6.45667018410309','51.0923444496607'],['6.40552843739823','51.0925660216355'],['6.39263839500154','51.1035272437039'],['6.36518613679095','51.1000678467132'],['6.35800961402029','51.114417136898'],['6.36179085126397','51.1284874268305'],['6.31040082558538','51.1570812636845'],['6.31274455126878','51.1667533846223'],['6.29864696848826','51.1774065551679'],['6.26581578786926','51.1903933239893'],['6.24710994874046','51.1940084181641'],['6.21247546003432','51.1724841741162'],['6.17563397154959','51.1890419447615'],['6.13443821420098','51.1769079003813'],['6.13393303497103','51.1700375264873'],['6.16327657168424','51.1579638063132'],['6.08826775684023','51.13888777965'],['6.03225865934815','51.1001711071409'],['6.00522154111898','51.094438427738'],['5.97412453526404','51.0745958703468'],['5.95074631152744','51.041424394743'],['5.94234833888911','51.0410687299051'],['5.91414592231193','51.0713407867524'],['5.85918841707277','51.051488002301']]],'type' => 'Polygon'},'regions' => ['DE-NW']},'homepage' => 'https://avv.de/','languages' => ['de'],'mgate' => 'https://auskunft.avv.de/bin/mgate.exe','name' => 'Aachener Verkehrsverbund','productbits' => [['regional-train','Regionalzug'],['long-distance-train','Fernzug'],['express-train','ICE/Thalys'],['fernbus','Fernbus'],['suburban-train','S-Bahn'],['subway','U-Bahn'],['tram',"Stra\x{df}enbahn"],['bus','Bus'],['added-bus',"Bus, Verst\x{e4}rkerfahrt"],['on-call','Bedarfsverkehr'],['ferry',"F\x{e4}hre"]],'request' => {'auth' => {'aid' => '4vV1AcH3N511icH','type' => 'AID'},'client' => {'id' => 'AVV_AACHEN','l' => 'vs_avv','name' => 'webapp','type' => 'WEB'},'lang' => 'deu','ver' => '1.26'},'stopfinder' => 'https://auskunft.avv.de/bin/ajax-getstop.exe','time_zone' => 'Europe/Berlin','tls_verify' => 1},'BART' => {'coverage' => {'area' => {'coordinates' => [[['-122.4375','38.0039'],['-122.4121','37.9011'],['-122.3507','37.8924'],['-122.3333','37.8549'],['-122.4705','37.8195'],['-122.5283','37.7907'],['-122.5047','37.6603'],['-122.4109','37.5689'],['-122.3262','37.5935'],['-122.3691','37.6759'],['-122.3452','37.7108'],['-122.3503','37.7482'],['-122.3368','37.7686'],['-122.2412','37.6921'],['-122.2018','37.6853'],['-121.9058','37.2821'],['-121.7902','37.3224'],['-121.8428','37.4048'],['-121.9187','37.56'],['-122.0138','37.615'],['-122.0441','37.6639'],['-121.8919','37.681'],['-121.8938','37.725'],['-122.0704','37.7156'],['-122.1051','37.7329'],['-122.2038','37.8273'],['-122.0528','37.8726'],['-122.0152','37.9936'],['-121.7662','37.9798'],['-121.7389','38.0257'],['-121.9899','38.0612'],['-122.0679','38.0557'],['-122.1284','37.9264'],['-122.2412','37.9061'],['-122.2903','38.011'],['-122.4375','38.0039']]],'type' => 'Polygon'},'regions' => ['US-CA']},'homepage' => 'https://bart.gov/','languages' => ['en','es'],'mgate' => 'https://planner.bart.gov/bin/mgate.exe','name' => 'Bay Area Rapid Transit','productbits' => [['_',undef],['_',undef],['cable-car','cable car'],['_',undef],['_',undef],['regional-train','regional trains (Caltrain, Capitol Corridor, ACE)'],['_',undef],['_',undef],['_',undef],['bus','Bus'],['_',undef],['_',undef],['_',undef],['ferry','Ferry'],['_',undef],['_',undef],['_',undef],['bart','BART'],['_',undef],['_',undef],['_',undef],['tram','Tram']],'request' => {'auth' => {'aid' => 'kEwHkFUCIL500dym','type' => 'AID'},'client' => {'id' => 'BART','l' => 'vs_webapp','name' => 'webapp','type' => 'WEB'},'lang' => 'en','ver' => '1.40'},'stopfinder' => 'https://planner.bart.gov/bin/ajax-getstop.exe','time_zone' => 'America/Los_Angeles','tls_verify' => 1},'BLS' => {'coverage' => {'area' => {'coordinates' => [[['7.24273681640625','47.0252060015854'],['7.25921630859375','46.9052455464292'],['7.3663330078125','46.8733358290102'],['7.4761962890625','46.7153855983936'],['7.64373779296875','46.5739667965278'],['8.04473876953125','46.6249201541477'],['8.45672607421875','46.8921085501036'],['8.52813720703125','47.0383103567328'],['8.39630126953125','47.174778339299'],['8.1024169921875','47.1374246462939'],['8.1024169921875','47.0401821448067'],['7.8826904296875','46.9446372241817'],['7.6629638671875','47.0532828227366'],['7.45147705078125','47.1131306644702'],['7.24273681640625','47.0252060015854']]],'type' => 'Polygon'},'regions' => ['CH-BE','CH-LU']},'homepage' => 'https://www.bls.ch/','languages' => ['de','en','fr','it'],'mgate' => 'https://bls.hafas.de/gate','name' => 'BLS AG','productbits' => [['ice','ICE'],['ic-ec','IC/EC'],['ir','IR'],['local','Nahverkehr'],['watercraft','Schiff'],['s-bahn','S-Bahn'],['bus','Bus'],['gondola','Seilbahn'],['_',undef],['tram','Tram'],['_',undef],['_',undef],['_',undef],['car-shuttle-train','Autoverlad']],'request' => {'auth' => {'aid' => '3jkAncud78HSoqclmN54812A','type' => 'AID'},'client' => {'id' => 'HAFAS','l' => 'vs_webapp','name' => 'webapp','type' => 'WEB'},'lang' => 'deu','ver' => '1.68'},'stopfinder' => 'https://bls.hafas.de/bin/ajax-stopfinder.exe','time_zone' => 'Europe/Zurich','tls_verify' => 1},'BVG' => {'coverage' => {'area' => undef,'regions' => ['DE-BE','DE-BB']},'homepage' => 'https://www.bvg.de/','languages' => ['de','en'],'mgate' => 'https://bvg-apps-ext.hafas.de/bin/mgate.exe','name' => 'Berliner Verkehrsbetriebe','productbits' => [['suburban','S-Bahn'],['subway','U-Bahn'],['tram','Tram'],['bus','Bus'],['ferry',"F\x{e4}hre"],['express','IC/ICE'],['regional','RB/RE']],'request' => {'auth' => {'aid' => 'dVg4TZbW8anjx9ztPwe2uk4LVRi9wO','type' => 'AID'},'client' => {'id' => 'VBB','l' => 'vs_webapp','name' => 'webapp','type' => 'WEB','v' => 10002},'ext' => 'BVG.1','lang' => 'deu','ver' => '1.72'},'stopfinder' => 'https://bvg-apps-ext.hafas.de/bin/ajax-getstop.exe','time_zone' => 'Europe/Berlin','tls_verify' => 1},'CMTA' => {'coverage' => {'area' => {'coordinates' => [[['-98.1782','30.3559'],['-97.7112','30.0193'],['-97.6532','30.0651'],['-97.3177','29.7824'],['-97.0193','30.0507'],['-97.0778','30.2622'],['-97.1961','30.3413'],['-97.3222','30.4018'],['-97.15','30.457'],['-97.2669','30.7382'],['-97.6237','30.8747'],['-97.8285','30.9153'],['-97.8709','30.8782'],['-97.9675','30.7874'],['-98.1275','30.4872'],['-98.1014','30.4902'],['-98.1023','30.4687'],['-98.1782','30.3559']]],'type' => 'Polygon'},'regions' => ['US-TX']},'homepage' => 'https://www.capmetro.org/','languages' => ['en'],'mgate' => 'https://capmetro.hafas.cloud/bin/mgate.exe','name' => 'Capital Metro Austin Public Transport','productbits' => [['_',undef],['_',undef],['_',undef],['rail','MetroRail'],['_',undef],['_',undef],['_',undef],['_',undef],['bus','MetroBus'],['_',undef],['_',undef],['_',undef],['_',undef],['_',undef],['_',undef],['_',undef],['_',undef],['_',undef],['_',undef],['rapid','MetroRapid']],'request' => {'auth' => {'aid' => 'ioslaskdcndrjcmlsd','type' => 'AID'},'client' => {'id' => 'CMTA','name' => 'CapMetro','type' => 'IPH','v' => '2'},'lang' => 'en','ver' => '1.40'},'stopfinder' => 'https://capmetro.hafas.cloud/bin/ajax-getstop.exe','time_zone' => 'America/Chicago','tls_verify' => 1},'DB' => {'coverage' => {'area' => {'coordinates' => [[[['6.15','50.47'],['6.31','50.4'],['6.32','50.37'],['6.13','50.29'],['6.11','50.27'],['6.1','50.24'],['6.02','50.25'],['5.99','50.25'],['5.67','49.93'],['5.66','49.88'],['5.82','49.67'],['5.72','49.55'],['5.78','49.46'],['5.8','49.47'],['5.98','49.38'],['6.01','49.39'],['6.23','49.44'],['6.26','49.43'],['6.26','49.42'],['6.3','49.41'],['6.38','49.38'],['6.39','49.39'],['6.51','49.36'],['6.71','49.08'],['6.76','49.1'],['6.92','49.14'],['7.02','49.05'],['7.04','49.04'],['7.31','49.04'],['7.32','49.05'],['7.44','49.1'],['7.6','48.99'],['7.63','48.98'],['7.92','48.99'],['8.09','48.94'],['7.74','48.63'],['7.73','48.61'],['7.68','48.36'],['7.51','48.15'],['7.51','48.13'],['7.45','47.64'],['7.47','47.61'],['7.49','47.59'],['7.38','47.5'],['7.28','47.49'],['7.24','47.55'],['7.21','47.56'],['6.94','47.56'],['6.93','47.53'],['6.8','47.36'],['6.83','47.29'],['6.87','47.29'],['6.9','47.28'],['6.68','47.11'],['6.34','46.96'],['6.37','46.91'],['6.38','46.81'],['5.99','46.58'],['6.04','46.55'],['5.98','46.38'],['6.04','46.36'],['6.06','46.35'],['5.85','46.1'],['5.95','46.06'],['6.33','46.17'],['6.39','46.22'],['6.31','46.31'],['6.36','46.34'],['6.43','46.35'],['6.68','46.39'],['6.75','46.37'],['6.73','46.11'],['6.76','46.07'],['6.81','46.07'],['6.79','46.02'],['6.87','45.98'],['6.91','45.99'],['7.07','45.79'],['7.12','45.79'],['7.57','45.92'],['7.87','45.85'],['7.9','45.86'],['8.22','46.12'],['8.22','46.17'],['8.18','46.24'],['8.38','46.35'],['8.38','46.19'],['8.42','46.19'],['8.59','46.06'],['8.6','46.06'],['8.74','46.03'],['8.66','45.95'],['8.77','45.93'],['8.84','45.91'],['8.86','45.75'],['8.92','45.76'],['9.02','45.75'],['9.05','45.76'],['9.19','45.91'],['9.14','45.95'],['9.09','46.02'],['9.33','46.22'],['9.32','46.25'],['9.34','46.43'],['9.42','46.44'],['9.51','46.22'],['9.57','46.24'],['9.92','46.31'],['10','46.17'],['10.04','46.16'],['10.19','46.16'],['10.2','46.21'],['10.24','46.43'],['10.2','46.47'],['10.11','46.49'],['10.11','46.5'],['10.22','46.55'],['10.26','46.49'],['10.29','46.48'],['10.5','46.48'],['10.56','46.53'],['10.46','46.69'],['10.5','46.79'],['10.64','46.8'],['10.69','46.73'],['10.71','46.72'],['11','46.7'],['11.05','46.7'],['11.2','46.9'],['11.62','46.95'],['11.71','46.91'],['11.73','46.89'],['12.09','47'],['12.08','46.95'],['12.03','46.91'],['12.51','46.6'],['12.52','46.59'],['13.9','46.46'],['14.55','46.31'],['14.58','46.3'],['15.06','46.58'],['15.47','46.55'],['15.48','46.54'],['15.84','46.65'],['16.01','46.6'],['16.05','46.58'],['16.11','46.63'],['16.07','46.8'],['16.31','46.95'],['16.51','46.93'],['16.57','46.93'],['16.59','47.04'],['16.55','47.06'],['16.56','47.06'],['16.59','47.07'],['16.6','47.16'],['16.49','47.23'],['16.5','47.34'],['16.58','47.34'],['16.61','47.35'],['16.78','47.51'],['16.78','47.56'],['16.74','47.61'],['17.1','47.64'],['17.2','47.65'],['17.09','47.85'],['17.21','47.96'],['17.25','48.01'],['16.93','48.36'],['17.02','48.52'],['17.02','48.55'],['16.96','48.76'],['16.92','48.78'],['16.7','48.79'],['16.57','48.88'],['16.53','48.88'],['16.36','48.8'],['16.11','48.81'],['15.87','48.94'],['15.85','48.95'],['15.7','48.92'],['15.3','49.06'],['15.27','49.06'],['15.16','49.02'],['15.04','49.09'],['14.96','49.09'],['14.92','48.84'],['14.8','48.85'],['14.76','48.83'],['14.67','48.66'],['14.48','48.71'],['14.45','48.72'],['14.32','48.62'],['14.13','48.65'],['14.16','48.7'],['13.88','48.83'],['13.86','48.85'],['13.67','49.01'],['13.65','49.02'],['13.44','49.05'],['13.06','49.37'],['13.04','49.38'],['12.7','49.5'],['12.49','49.75'],['12.65','49.93'],['12.58','49.98'],['12.4','50.08'],['12.41','50.15'],['12.55','50.33'],['12.81','50.39'],['13','50.3'],['13.01','50.37'],['13.07','50.44'],['13.23','50.43'],['13.25','50.45'],['13.38','50.56'],['13.48','50.51'],['13.55','50.59'],['13.59','50.64'],['13.87','50.66'],['13.9','50.67'],['13.94','50.73'],['14.39','50.83'],['14.44','50.84'],['14.45','50.93'],['14.39','50.98'],['14.46','50.97'],['14.51','50.87'],['14.54','50.85'],['14.51','50.79'],['14.61','50.79'],['14.81','50.74'],['14.85','50.77'],['15.12','51.24'],['15.11','51.27'],['15.04','51.48'],['15.02','51.5'],['14.81','51.58'],['14.84','51.68'],['14.81','51.71'],['14.68','51.83'],['14.83','52.04'],['14.83','52.08'],['14.78','52.28'],['14.76','52.29'],['14.63','52.41'],['14.73','52.58'],['14.69','52.63'],['14.2','52.88'],['14.21','52.91'],['14.42','53.01'],['14.42','53.04'],['14.53','53.25'],['14.52','53.28'],['14.06','54.69'],['14.03','54.72'],['13.57','54.94'],['13.49','54.95'],['13.19','54.94'],['13.16','54.93'],['12.27','54.64'],['12.23','54.56'],['12.13','54.46'],['11.67','54.41'],['11.63','54.44'],['11.16','54.65'],['10.99','54.64'],['10.6','54.59'],['10.53','54.61'],['9.91','54.92'],['9.82','54.91'],['9.6','54.96'],['9.57','54.96'],['9.3','54.88'],['9.16','54.94'],['9.15','54.94'],['8.63','54.99'],['8.63','55.03'],['8.5','55.12'],['8.41','55.14'],['7.99','55.18'],['7.97','55.11'],['7.86','54.7'],['7.88','54.63'],['8.01','54.44'],['7.83','54.47'],['7.8','54.46'],['7.55','54.37'],['7.51','54.34'],['7.48','54.22'],['7.33','54.22'],['7.33','54.01'],['6.72','53.93'],['6.69','53.93'],['6.24','53.76'],['6.36','53.55'],['6.83','53.39'],['6.87','53.28'],['6.92','53.26'],['7.13','53.25'],['7.14','53.02'],['7.01','52.71'],['6.74','52.72'],['6.67','52.7'],['6.68','52.63'],['6.63','52.62'],['6.6','52.54'],['6.63','52.51'],['6.71','52.4'],['6.75','52.39'],['6.94','52.39'],['6.98','52.28'],['6.59','52.1'],['6.64','52.02'],['6.71','51.98'],['6.7','51.97'],['6.29','51.94'],['6.07','52.01'],['6.08','51.91'],['5.89','51.89'],['5.86','51.79'],['5.9','51.77'],['6.14','51.48'],['6.15','51.39'],['5.97','51.26'],['6.02','51.19'],['6.03','51.18'],['5.79','51.1'],['5.8','51.03'],['5.85','50.9'],['5.89','50.9'],['5.96','50.88'],['5.86','50.78'],['5.94','50.74'],['6.1','50.65'],['6.1','50.47'],['6.15','50.47']]]],'type' => 'MultiPolygon'},'regions' => ['DE','LU','CH','LI','AT']},'homepage' => 'https://www.bahn.de/','languages' => ['de','en','fr','es'],'mgate' => 'https://reiseauskunft.bahn.de/bin/mgate.exe','name' => 'Deutsche Bahn','productbits' => [['express-train','Long-distance train (ICE)'],['long-distance-train','Long-Distance Train (IC/EC)'],['local-train','Local Train (D)'],['regional-train','Local Train (RE/RB)'],['rapid-transit','Rapid Transit (S)'],['bus','Bus'],['ferry','Ferry'],['metro','Metro'],['tram','Tram'],['taxi','Taxi']],'request' => {'auth' => {'aid' => 'n91dB8Z77MLdoR0K','type' => 'AID'},'client' => {'id' => 'DB','name' => 'DB Navigator','type' => 'IPH','v' => '20100000'},'ext' => 'DB.R22.04.a','lang' => 'deu','ver' => '1.78'},'salt' => 'bdI8UVj40K5fvxwf','stopfinder' => 'https://reiseauskunft.bahn.de/bin/ajax-getstop.exe','time_zone' => 'Europe/Berlin','tls_verify' => 1},'DSB' => {'coverage' => {'area' => undef,'regions' => ['DK']},'homepage' => 'https://rejseplanen.dk/','languages' => ['dk','en','de'],'mgate' => 'https://mobilapps.rejseplanen.dk/bin/iphone.exe','name' => 'Rejseplanen','productbits' => [['intercity','InterCity'],['icl','ICL'],['regional','Regional'],['oe',"\x{d8}"],['s-tog','S-Tog A/B/Bx/C/E/F/H']],'request' => {'auth' => {'aid' => 'irkmpm9mdznstenr-android','type' => 'AID'},'client' => {'id' => 'DK','type' => 'AND'},'ext' => 'DK.9','lang' => 'deu','ver' => '1.21'},'time_zone' => 'Europe/Copenhagen','tls_verify' => 1},'IE' => {'coverage' => {'area' => undef,'regions' => ['IE','GB-NIR']},'homepage' => 'https://www.irishrail.ie/','languages' => ['en','ga'],'mgate' => 'https://journeyplanner.irishrail.ie/bin/mgate.exe','micmac' => 1,'name' => "Iarnród Éireann",'productbits' => [['_',undef],['intercity','InterCity'],['_',undef],['_',undef],['commuter','Commuter'],['_',undef],['_',undef],['dart','Dublin Area Rapid Transit'],['_',undef],['_',undef],['_',undef],['luas','LUAS Tram']],'request' => {'auth' => {'aid' => 'P9bplgVCGnozdgQE','type' => 'AID'},'client' => {'id' => 'IRISHRAIL','name' => 'IrishRailPROD-APPSTORE','os' => 'iOS 12.4.8','type' => 'IPA','v' => '4000100'},'lang' => 'en','ver' => '1.33'},'salt' => 'i5s7m3q9z6b4k1c2','stopfinder' => 'https://journeyplanner.irishrail.ie/bin/ajax-getstop.exe','time_zone' => 'Europe/Dublin','tls_verify' => 1},'KVB' => {'coverage' => {'area' => {'coordinates' => [[['6.92962','51.02714'],['6.83074','50.99474'],['6.8074','50.92597'],['6.85684','50.88007'],['6.97425','50.83543'],['7.09373','50.87141'],['7.11845','50.92424'],['7.10609','50.97615'],['7.05253','51.01893'],['6.92962','51.02714']]],'type' => 'Polygon'},'regions' => []},'homepage' => 'https://kvb.koeln/','languages' => ['de'],'mgate' => 'https://auskunft.kvb.koeln/gate','name' => "Kölner Verkehrs-Betriebe",'productbits' => [['s-bahn','S-Bahn'],['stadtbahn','Stadtbahn'],['_',undef],['bus','Bus'],['_',undef],['regionalverkehr','Regionalverkehr'],['_',undef],['fernverkehr','Fernverkehr'],['_',undef],['_',undef],['_',undef],['taxibus','Taxibus']],'request' => {'auth' => {'aid' => 'Rt6foY5zcTTRXMQs','type' => 'AID'},'client' => {'id' => 'HAFAS','l' => 'vs_webapp','name' => 'webapp','type' => 'WEB','v' => '154'},'lang' => 'deu','ver' => '1.58'},'time_zone' => 'Europe/Berlin','tls_verify' => 0},'NAHSH' => {'coverage' => {'area' => {'coordinates' => [[['7.51348','54.19582'],['7.52682','54.13879'],['7.56686','54.08601'],['7.63597','54.03071'],['7.72569','53.98987'],['7.8673','54.01829'],['8.49748','54.02396'],['8.76252','53.96096'],['8.80734','53.90242'],['8.99377','53.86812'],['9.03776','53.87652'],['9.19939','53.87556'],['9.28603','53.85944'],['9.31385','53.84776'],['9.35247','53.81532'],['9.42724','53.72935'],['9.49602','53.69431'],['9.54444','53.61338'],['9.70223','53.5548'],['9.73668','53.5554'],['9.74997','53.57716'],['9.75131','53.59694'],['9.76162','53.60007'],['9.7665','53.61225'],['9.7836','53.60716'],['9.78514','53.59867'],['9.81157','53.58276'],['9.83953','53.58349'],['9.89525','53.62016'],['9.91328','53.6483'],['9.98963','53.64435'],['10.0021','53.67647'],['10.07334','53.67573'],['10.08636','53.71551'],['10.12314','53.70882'],['10.16924','53.73408'],['10.18396','53.72341'],['10.15057','53.70696'],['10.15117','53.69269'],['10.13244','53.67977'],['10.18759','53.65155'],['10.18357','53.63568'],['10.20904','53.62972'],['10.18173','53.61461'],['10.1869','53.58999'],['10.15885','53.58991'],['10.1453','53.57936'],['10.14028','53.5635'],['10.15255','53.55769'],['10.14087','53.54585'],['10.14532','53.53323'],['10.15562','53.53152'],['10.15624','53.51984'],['10.1853','53.50727'],['10.20692','53.51172'],['10.21135','53.49744'],['10.22716','53.49127'],['10.23213','53.48017'],['10.25761','53.47013'],['10.30278','53.43804'],['10.30206','53.4307'],['10.3234','53.42205'],['10.37051','53.42124'],['10.49355','53.37093'],['10.57857','53.35532'],['10.60023','53.36046'],['10.60573','53.37407'],['10.62363','53.38248'],['10.62724','53.42209'],['10.64071','53.45102'],['10.65501','53.45669'],['10.69659','53.45093'],['10.70768','53.47299'],['10.76','53.47956'],['10.78349','53.49233'],['10.79208','53.50681'],['10.82895','53.51035'],['10.82606','53.53183'],['10.83964','53.54257'],['10.83322','53.56987'],['10.86271','53.56006'],['10.91607','53.56857'],['10.93171','53.58436'],['10.92659','53.59711'],['10.93665','53.62633'],['10.95981','53.64622'],['10.96219','53.65952'],['10.94867','53.66645'],['10.94933','53.68581'],['10.92723','53.70295'],['10.82879','53.71548'],['10.81575','53.72519'],['10.81274','53.74161'],['10.76578','53.75294'],['10.78105','53.7931'],['10.76945','53.82375'],['10.75652','53.83485'],['10.77218','53.86503'],['10.85232','53.89334'],['10.88365','53.91763'],['10.89831','53.91238'],['10.89443','53.90186'],['10.90908','53.89297'],['10.97325','53.9044'],['10.96859','53.91719'],['10.9028','53.92844'],['10.91711','53.94493'],['10.91206','53.95583'],['11.12888','54.09953'],['11.68009','54.31527'],['11.67207','54.33411'],['11.64818','54.33528'],['11.54411','54.41056'],['11.32803','54.51617'],['11.31564','54.53319'],['11.14343','54.5814'],['10.99863','54.57389'],['10.97592','54.56028'],['10.81763','54.55164'],['10.75159','54.51871'],['10.65251','54.51586'],['10.59503','54.52489'],['10.34354','54.59687'],['10.1746','54.74152'],['10.08914','54.76825'],['10.05473','54.77041'],['9.89688','54.84604'],['9.74065','54.82801'],['9.61564','54.85685'],['9.63498','54.88182'],['9.59161','54.89149'],['9.46445','54.83704'],['9.43197','54.83159'],['9.40685','54.84703'],['9.37732','54.84237'],['9.36542','54.82338'],['9.33572','54.80827'],['9.2555','54.81485'],['9.24356','54.83198'],['9.25271','54.84374'],['9.24559','54.85328'],['9.1452','54.87733'],['9.04949','54.87664'],['8.94938','54.90696'],['8.8905','54.90938'],['8.85707','54.90139'],['8.82381','54.91131'],['8.76997','54.89797'],['8.72948','54.89732'],['8.68284','54.91479'],['8.56335','54.92448'],['8.56452','54.9945'],['8.50732','55.00317'],['8.48038','55.02638'],['8.48572','55.04673'],['8.47485','55.05899'],['8.3966','55.07373'],['8.3507','55.06947'],['8.335','55.08666'],['8.32041','55.08939'],['8.30032','55.08612'],['8.28218','55.0705'],['8.04462','55.10366'],['7.98107','55.01209'],['7.94644','54.94426'],['7.93364','54.8856'],['7.92356','54.74392'],['7.94017','54.64076'],['7.95717','54.60022'],['8.13895','54.3512'],['8.04678','54.38269'],['7.95301','54.39584'],['7.82886','54.39753'],['7.71774','54.38029'],['7.63437','54.34918'],['7.5694','54.30562'],['7.52793','54.25297'],['7.51348','54.19582']]],'type' => 'Polygon'},'regions' => ['DE-SH']},'homepage' => 'https://www.nah.sh/','languages' => ['de'],'mgate' => 'https://nah.sh.hafas.de/bin/mgate.exe','name' => 'Nahverkehrsverbund Schleswig-Holstein','productbits' => [['highspeed','High-speed rail'],['national','InterCity & EuroCity'],['interregional','Interregional'],['regional','Regional & RegionalExpress'],['suburban','S-Bahn'],['bus','Bus'],['ferry','Ferry'],['subway','U-Bahn'],['tram','Tram'],['onCall','On-call transit']],'request' => {'auth' => {'aid' => 'r0Ot9FLFNAFxijLW','type' => 'AID'},'client' => {'id' => 'NAHSH','name' => 'NAHSHPROD','type' => 'IPH','v' => '3000700'},'ver' => '1.16'},'stopfinder' => 'https://nah.sh.hafas.de/bin/ajax-getstop.exe','time_zone' => 'Europe/Berlin','tls_verify' => 1},'NASA' => {'coverage' => {'area' => {'coordinates' => [[['10.55345','52.00362'],['10.5821','51.97082'],['10.59917','51.97091'],['10.61473','51.95452'],['10.62991','51.95402'],['10.60612','51.94015'],['10.60567','51.91959'],['10.64284','51.90171'],['10.6425','51.89095'],['10.62704','51.87603'],['10.57156','51.84875'],['10.56962','51.84121'],['10.57953','51.83617'],['10.56658','51.81128'],['10.57752','51.79615'],['10.57223','51.77981'],['10.58657','51.76403'],['10.62179','51.75449'],['10.63512','51.72338'],['10.6601','51.70825'],['10.66185','51.66664'],['10.69008','51.63854'],['10.75417','51.63638'],['10.76443','51.64252'],['10.8036','51.63669'],['10.81474','51.62078'],['10.85698','51.62817'],['10.894','51.60616'],['10.88186','51.59793'],['10.87584','51.57784'],['10.88579','51.57387'],['10.89503','51.54762'],['10.93289','51.53837'],['10.91961','51.52017'],['10.93626','51.50591'],['10.93331','51.49847'],['10.96209','51.4816'],['10.95324','51.4714'],['10.96335','51.45121'],['10.96144','51.42936'],['11.00653','51.41242'],['11.06878','51.42426'],['11.15277','51.39716'],['11.19383','51.39849'],['11.22133','51.40843'],['11.24849','51.39065'],['11.31843','51.40381'],['11.32506','51.38781'],['11.3446','51.38047'],['11.38707','51.38005'],['11.38272','51.36762'],['11.39334','51.34238'],['11.46494','51.29736'],['11.45387','51.29635'],['11.44633','51.27766'],['11.43536','51.27576'],['11.41121','51.24741'],['11.37543','51.24678'],['11.35817','51.22045'],['11.38171','51.21489'],['11.38901','51.19949'],['11.43019','51.20786'],['11.43772','51.20554'],['11.43249','51.19886'],['11.4409','51.19086'],['11.46218','51.18902'],['11.47072','51.15656'],['11.44431','51.14598'],['11.45811','51.12336'],['11.45749','51.11014'],['11.48103','51.09883'],['11.54683','51.09798'],['11.57438','51.11556'],['11.60972','51.1048'],['11.60881','51.09589'],['11.61679','51.09263'],['11.65962','51.10514'],['11.68515','51.09479'],['11.69606','51.06596'],['11.72913','51.06315'],['11.75619','51.03869'],['11.77639','51.0414'],['11.7791','51.04829'],['11.80498','51.04132'],['11.88344','51.05114'],['11.90348','51.03965'],['11.90804','51.0244'],['11.94172','51.02615'],['11.96895','51.01271'],['11.96431','50.99169'],['12.00899','50.97944'],['12.00363','50.97037'],['12.01042','50.96433'],['12.08833','50.97172'],['12.12947','50.95652'],['12.16417','50.95423'],['12.17992','50.96945'],['12.19335','50.9538'],['12.20482','50.95226'],['12.21302','50.93345'],['12.24419','50.94869'],['12.2461','50.97304'],['12.29096','51.00477'],['12.30187','51.02498'],['12.29077','51.0419'],['12.26237','51.04256'],['12.26946','51.04896'],['12.26679','51.06447'],['12.29476','51.09013'],['12.28126','51.1035'],['12.23424','51.10872'],['12.23172','51.11614'],['12.24754','51.13286'],['12.20412','51.14458'],['12.22037','51.18278'],['12.19348','51.18946'],['12.19719','51.20274'],['12.21176','51.21303'],['12.20267','51.22436'],['12.20654','51.23938'],['12.1952','51.26014'],['12.1807','51.26286'],['12.17573','51.29458'],['12.16343','51.29774'],['12.15814','51.31591'],['12.20157','51.32971'],['12.19752','51.3494'],['12.20312','51.36147'],['12.18285','51.39747'],['12.20108','51.42191'],['12.18894','51.43397'],['12.16508','51.43775'],['12.15886','51.46008'],['12.1813','51.46686'],['12.18363','51.47863'],['12.21006','51.48381'],['12.21501','51.5031'],['12.2015','51.50967'],['12.2017','51.52679'],['12.23697','51.54437'],['12.24261','51.55897'],['12.29449','51.55608'],['12.35322','51.58124'],['12.42769','51.57784'],['12.44575','51.60337'],['12.47376','51.60064'],['12.47127','51.59334'],['12.48353','51.58817'],['12.5099','51.60242'],['12.54164','51.59781'],['12.58243','51.61678'],['12.59781','51.61388'],['12.61655','51.62243'],['12.6007','51.61254'],['12.61043','51.60672'],['12.65419','51.6176'],['12.67187','51.62897'],['12.69012','51.6574'],['12.77378','51.64296'],['12.79559','51.66097'],['12.83894','51.67752'],['12.8504','51.67473'],['12.86238','51.65118'],['12.8844','51.65539'],['12.89611','51.64301'],['12.9256','51.64532'],['12.94186','51.63376'],['12.95849','51.64601'],['12.97782','51.64827'],['12.97683','51.65878'],['12.99355','51.66438'],['13.01059','51.65773'],['13.00946','51.64335'],['13.02644','51.63325'],['13.15939','51.68319'],['13.16942','51.69067'],['13.16443','51.70463'],['13.19414','51.71577'],['13.18487','51.73353'],['13.1652','51.74643'],['13.17067','51.75559'],['13.15949','51.76809'],['13.17779','51.7873'],['13.13192','51.85262'],['13.15835','51.86078'],['13.15613','51.87423'],['13.13687','51.88601'],['13.11602','51.88729'],['13.07615','51.87339'],['13.04289','51.87491'],['13.04555','51.88689'],['13.05531','51.8907'],['13.05127','51.90343'],['12.98164','51.90786'],['12.98358','51.92104'],['12.96561','51.92645'],['12.96506','51.93851'],['12.91534','51.94371'],['12.89859','51.93246'],['12.89025','51.93924'],['12.85965','51.93924'],['12.84797','51.97148'],['12.78392','51.96853'],['12.78261','51.97864'],['12.76','51.99035'],['12.73285','51.99309'],['12.66963','52.01748'],['12.64942','52.01568'],['12.63794','51.99853'],['12.60956','51.99528'],['12.60702','51.98632'],['12.54747','51.98897'],['12.54174','52.00556'],['12.499','52.01499'],['12.48418','52.03714'],['12.45667','52.03831'],['12.43774','52.02128'],['12.39296','52.04756'],['12.36338','52.05078'],['12.33698','52.0708'],['12.32171','52.09513'],['12.28169','52.10866'],['12.27127','52.13294'],['12.2496','52.14319'],['12.24036','52.16465'],['12.22508','52.17044'],['12.23151','52.18006'],['12.25393','52.18146'],['12.24998','52.19352'],['12.26014','52.20336'],['12.25723','52.20971'],['12.28562','52.2127'],['12.30434','52.22802'],['12.25486','52.25362'],['12.27061','52.2945'],['12.31528','52.34366'],['12.29184','52.36573'],['12.31359','52.37638'],['12.29994','52.38656'],['12.31034','52.39586'],['12.3095','52.40617'],['12.28437','52.41449'],['12.30391','52.42193'],['12.31359','52.44746'],['12.33207','52.46292'],['12.33745','52.48032'],['12.31701','52.48514'],['12.3327','52.48817'],['12.33781','52.49711'],['12.29731','52.50063'],['12.27767','52.4937'],['12.26371','52.52102'],['12.2359','52.52839'],['12.22462','52.52416'],['12.21774','52.50594'],['12.18657','52.50301'],['12.17538','52.5135'],['12.19547','52.53408'],['12.17552','52.54309'],['12.15637','52.53881'],['12.16588','52.55877'],['12.18862','52.57396'],['12.18099','52.58231'],['12.18271','52.61749'],['12.20602','52.61437'],['12.24397','52.62779'],['12.23858','52.63667'],['12.24621','52.67268'],['12.23904','52.69106'],['12.22504','52.69777'],['12.23087','52.70466'],['12.21232','52.72235'],['12.22959','52.73978'],['12.22609','52.75248'],['12.21401','52.75924'],['12.23005','52.77351'],['12.23089','52.78399'],['12.25055','52.78388'],['12.26503','52.804'],['12.25106','52.8218'],['12.24012','52.86189'],['12.20809','52.87164'],['12.19727','52.88239'],['12.13847','52.86186'],['12.12783','52.87713'],['12.13605','52.89443'],['12.12751','52.89865'],['12.10705','52.88134'],['12.02242','52.89488'],['11.98092','52.88063'],['11.94421','52.89364'],['11.8984','52.89816'],['11.87295','52.91355'],['11.83656','52.91455'],['11.8331','52.92473'],['11.85607','52.94243'],['11.85155','52.95443'],['11.79139','52.96428'],['11.76692','52.98555'],['11.74515','52.99218'],['11.69573','52.98311'],['11.68116','53.01164'],['11.63354','53.01419'],['11.64948','53.03433'],['11.63207','53.0459'],['11.59332','53.03942'],['11.54478','53.00443'],['11.52703','53.01283'],['11.50733','53.0103'],['11.48505','52.95996'],['11.49366','52.94608'],['11.4498','52.93688'],['11.4038','52.90827'],['11.38219','52.90797'],['11.31123','52.8826'],['11.30222','52.88135'],['11.2914','52.89351'],['11.24537','52.88342'],['11.22441','52.90148'],['11.15633','52.91082'],['11.13556','52.90218'],['11.10148','52.90176'],['11.10612','52.9133'],['11.09952','52.91716'],['10.9999','52.91594'],['10.9853','52.90794'],['10.97951','52.88499'],['10.96187','52.88214'],['10.93721','52.8577'],['10.89641','52.86063'],['10.88665','52.85109'],['10.86443','52.86014'],['10.75869','52.84465'],['10.7482','52.7831'],['10.76974','52.75227'],['10.78409','52.74714'],['10.78075','52.73316'],['10.79014','52.7121'],['10.82377','52.71269'],['10.82743','52.69752'],['10.87024','52.66202'],['10.9152','52.60683'],['10.93021','52.60507'],['10.96955','52.62057'],['10.9672','52.60724'],['10.93316','52.59159'],['10.93725','52.58352'],['10.92989','52.56732'],['10.95202','52.53208'],['10.99242','52.50149'],['10.97402','52.50574'],['10.93767','52.49516'],['10.92645','52.4595'],['10.99933','52.4061'],['11.00979','52.39658'],['11.00934','52.38503'],['11.05654','52.37631'],['11.0611','52.36203'],['11.05191','52.35373'],['10.97612','52.3416'],['11.02887','52.30604'],['11.00601','52.29344'],['11.00511','52.28616'],['11.02357','52.26701'],['11.04356','52.26562'],['11.05316','52.23759'],['11.07106','52.23722'],['11.07669','52.22934'],['11.023','52.21427'],['11.00642','52.20074'],['11.00475','52.18654'],['11.01343','52.17538'],['11.05343','52.16811'],['11.0391','52.13861'],['10.97409','52.11057'],['10.93497','52.10484'],['10.93416','52.09256'],['10.96328','52.08353'],['10.95902','52.06213'],['10.8796','52.06323'],['10.82855','52.05201'],['10.68376','52.0522'],['10.64291','52.04495'],['10.649','52.02833'],['10.6306','52.01728'],['10.58849','52.01839'],['10.55345','52.00362']],[['10.89569','51.60626'],['10.92942','51.60168'],['10.91315','51.59721'],['10.89569','51.60626']]],'type' => 'Polygon'},'regions' => ['DE-ST']},'homepage' => 'https://www.nasa.de/','languages' => ['de','en'],'mgate' => 'https://reiseauskunft.insa.de/bin/mgate.exe','name' => 'Personennahverkehr in Sachsen-Anhalt','productbits' => [['intercityexpress','InterCityExpress'],['national','InterCity & EuroCity'],['local','FlixTrain etc.'],['regional','RegionalExpress & RegionalBahn'],['suburban','S-Bahn'],['tram','Tram'],['bus','Bus'],['on-demand','Rufbus'],['tourismTrain','Tourism Train']],'request' => {'auth' => {'aid' => 'nasa-apps','type' => 'AID'},'client' => {'id' => 'NASA','name' => 'nasaPROD','os' => 'iPhone OS 11.2.5','type' => 'IPH','v' => '4000200'},'lang' => 'deu','ver' => '1.18'},'stopfinder' => 'https://reiseauskunft.insa.de/bin/ajax-getstop.exe','time_zone' => 'Europe/Berlin','tls_verify' => 1},'NVV' => {'coverage' => {'area' => {'coordinates' => [[['8.46618','50.97396'],['8.51477','50.95018'],['8.55949','50.95103'],['8.57394','50.94416'],['8.60064','50.94518'],['8.65153','50.96238'],['8.67669','50.99109'],['8.69805','50.98655'],['8.729','50.96074'],['8.76425','50.97081'],['8.78515','50.9519'],['8.84688','50.95813'],['8.90774','50.94759'],['8.92448','50.9565'],['8.9217','50.96374'],['8.93182','50.96202'],['8.94288','50.94758'],['8.96187','50.94256'],['8.96843','50.92858'],['9.00237','50.92121'],['9.00482','50.90819'],['9.02341','50.8987'],['9.04371','50.90381'],['9.04757','50.91491'],['9.07374','50.90582'],['9.1065','50.91351'],['9.12186','50.89695'],['9.10702','50.89454'],['9.10194','50.88564'],['9.13431','50.86076'],['9.1483','50.83072'],['9.25493','50.8117'],['9.2681','50.79267'],['9.30251','50.80126'],['9.32781','50.79074'],['9.35842','50.79505'],['9.37048','50.77636'],['9.38968','50.76819'],['9.40294','50.77266'],['9.40967','50.78557'],['9.43469','50.78694'],['9.42777','50.77053'],['9.45257','50.75728'],['9.47339','50.75988'],['9.50351','50.73055'],['9.57877','50.76033'],['9.59698','50.75509'],['9.60081','50.73348'],['9.62097','50.73427'],['9.64874','50.71597'],['9.66712','50.71345'],['9.68791','50.73082'],['9.72755','50.74308'],['9.7349','50.75369'],['9.71972','50.76786'],['9.73909','50.77634'],['9.73407','50.78591'],['9.76743','50.79917'],['9.82821','50.78638'],['9.8776','50.79171'],['9.88296','50.77344'],['9.92625','50.76317'],['9.95818','50.7716'],['9.9616','50.78681'],['9.95059','50.79683'],['9.96345','50.80845'],['9.96111','50.81921'],['9.97684','50.82768'],['9.99632','50.82134'],['10.00902','50.83007'],['10.03025','50.82881'],['10.04587','50.85303'],['10.02638','50.85932'],['10.06217','50.8777'],['10.06562','50.89098'],['10.01781','50.92438'],['9.99008','50.92028'],['9.99849','50.9322'],['10.05146','50.93414'],['10.07126','50.9436'],['10.06562','50.95169'],['10.05279','50.95102'],['10.04356','50.96194'],['10.04796','50.96918'],['10.02917','50.98146'],['10.03528','51.0058'],['10.10364','50.9988'],['10.11831','51.00781'],['10.12591','50.99405'],['10.14544','50.98893'],['10.1796','50.99165'],['10.21104','51.00459'],['10.20865','51.01442'],['10.22135','51.02693'],['10.1895','51.05252'],['10.15321','51.05977'],['10.16201','51.07028'],['10.15473','51.0853'],['10.18149','51.10455'],['10.18158','51.11609'],['10.19785','51.10766'],['10.21558','51.11607'],['10.21084','51.13271'],['10.21769','51.14246'],['10.20869','51.14945'],['10.24363','51.18684'],['10.20455','51.19571'],['10.17168','51.21611'],['10.15338','51.21168'],['10.14268','51.22387'],['10.07656','51.22859'],['10.08557','51.24435'],['10.05543','51.26193'],['10.06577','51.26834'],['10.06501','51.27915'],['10.00578','51.29132'],['9.98331','51.28817'],['9.97475','51.30318'],['9.94739','51.30771'],['9.95592','51.31611'],['9.95458','51.32721'],['9.93828','51.34129'],['9.93047','51.36705'],['9.9398','51.37897'],['9.93858','51.39276'],['9.90506','51.42553'],['9.87575','51.41542'],['9.84743','51.41847'],['9.84453','51.40636'],['9.79955','51.41428'],['9.78612','51.40584'],['9.79278','51.39457'],['9.69679','51.36748'],['9.69573','51.35834'],['9.71372','51.34626'],['9.73209','51.31643'],['9.76423','51.31972'],['9.76187','51.31029'],['9.734','51.30102'],['9.67238','51.32171'],['9.65382','51.31937'],['9.63315','51.33137'],['9.60347','51.33314'],['9.56567','51.34983'],['9.56247','51.35663'],['9.58399','51.37051'],['9.56758','51.38311'],['9.58363','51.39757'],['9.59573','51.39371'],['9.61211','51.40299'],['9.59512','51.4158'],['9.57509','51.41282'],['9.55832','51.41985'],['9.54126','51.40736'],['9.53145','51.41322'],['9.52305','51.4062'],['9.51166','51.41467'],['9.45299','51.41346'],['9.41579','51.38325'],['9.3926','51.38865'],['9.34476','51.36989'],['9.34481','51.35623'],['9.36393','51.34571'],['9.3733','51.32724'],['9.35073','51.31923'],['9.34289','51.30695'],['9.37153','51.27772'],['9.46522','51.25731'],['9.45332','51.24236'],['9.47009','51.23086'],['9.41147','51.22682'],['9.40199','51.23665'],['9.36545','51.23867'],['9.36055','51.25353'],['9.34971','51.25888'],['9.32581','51.26208'],['9.29964','51.25294'],['9.28271','51.25849'],['9.26948','51.2494'],['9.2673','51.21945'],['9.25728','51.20268'],['9.21811','51.20029'],['9.21823','51.18465'],['9.18677','51.17634'],['9.17447','51.19797'],['9.1344','51.22242'],['9.13531','51.24648'],['9.10156','51.25883'],['9.10262','51.26516'],['9.13332','51.27568'],['9.11705','51.29227'],['9.11982','51.32194'],['9.11135','51.32762'],['9.13289','51.3368'],['9.13617','51.3454'],['9.11366','51.35965'],['9.13593','51.36532'],['9.15913','51.35211'],['9.17445','51.35674'],['9.17037','51.36589'],['9.18137','51.37003'],['9.17619','51.39579'],['9.15998','51.40854'],['9.16787','51.41382'],['9.16186','51.44373'],['9.13717','51.4545'],['9.0944','51.44977'],['9.08633','51.46633'],['9.09807','51.49711'],['9.07825','51.50769'],['9.04254','51.50667'],['9.01911','51.52333'],['8.89825','51.49302'],['8.88386','51.4834'],['8.88702','51.46976'],['8.91295','51.44491'],['8.91221','51.42823'],['8.941','51.42279'],['8.93198','51.39449'],['8.88805','51.39693'],['8.85447','51.38212'],['8.83979','51.39249'],['8.80297','51.39505'],['8.73017','51.37665'],['8.68039','51.37817'],['8.66956','51.37193'],['8.67419','51.36375'],['8.65481','51.35661'],['8.64764','51.34512'],['8.61548','51.33941'],['8.58751','51.30757'],['8.55896','51.289'],['8.54994','51.27541'],['8.59522','51.2423'],['8.61437','51.2427'],['8.63543','51.25757'],['8.7144','51.27035'],['8.72709','51.26042'],['8.72022','51.24913'],['8.7344','51.21712'],['8.75588','51.20719'],['8.74256','51.19982'],['8.74599','51.17746'],['8.74021','51.17063'],['8.68788','51.13783'],['8.68511','51.12764'],['8.6968','51.11315'],['8.65495','51.09916'],['8.54985','51.10833'],['8.50231','51.0887'],['8.49593','51.07311'],['8.51819','51.06202'],['8.49666','51.03996'],['8.52754','51.02266'],['8.46618','50.97396']],[['9.84682','51.39157'],['9.85155','51.39208'],['9.84873','51.38671'],['9.84682','51.39157']],[['9.84779','51.38466'],['9.84856','51.3861'],['9.84962','51.38298'],['9.84779','51.38466']],[['9.96221','50.93809'],['9.96281','50.9379'],['9.96227','50.93767'],['9.96221','50.93809']],[['9.97227','50.93744'],['9.97539','50.9375'],['9.97615','50.9367'],['9.97421','50.93656'],['9.97227','50.93744']],[['9.97633','50.9119'],['9.9834','50.91546'],['9.97994','50.91259'],['9.97884','50.91015'],['9.97706','50.91061'],['9.97633','50.9119']],[['10.13175','51.13999'],['10.13327','51.1409'],['10.14645','51.14011'],['10.14922','51.14045'],['10.15521','51.14374'],['10.16137','51.14406'],['10.16694','51.14713'],['10.16961','51.14547'],['10.17011','51.14092'],['10.17133','51.13904'],['10.17656','51.13686'],['10.17688','51.13612'],['10.17701','51.13529'],['10.17396','51.1338'],['10.17277','51.13213'],['10.17175','51.12871'],['10.17221','51.12627'],['10.17525','51.12345'],['10.18111','51.12026'],['10.18138','51.11803'],['10.17713','51.12187'],['10.17158','51.12334'],['10.1594','51.124'],['10.15557','51.12306'],['10.15374','51.12468'],['10.15322','51.12751'],['10.15176','51.12897'],['10.14824','51.13027'],['10.14535','51.13033'],['10.14245','51.1319'],['10.13916','51.13622'],['10.1357','51.13851'],['10.13175','51.13999']]],'type' => 'Polygon'},'regions' => ['DE-HE']},'homepage' => 'https://www.nvv.de/','languages' => ['de'],'mgate' => 'https://auskunft.nvv.de/auskunft/bin/app/mgate.exe','name' => 'Nordhessischer Verkehrsverbund','productbits' => [['express','InterCityExpress'],['national','EuroCity/InterCity'],['tram','Tram'],['regiotram','RegioTram'],['regiotram','RegioTram'],['tram','Tram'],['bus','Bus'],['bus','Bus'],['_',undef],['on-call','AnrufSammelTaxi'],['_',undef],['regiotram','RegioTram']],'request' => {'auth' => {'aid' => 'Kt8eNOH7qjVeSxNA','type' => 'AID'},'client' => {'id' => 'NVV','name' => 'NVVMobilPROD_APPSTORE','os' => 'iOS 12.1.4','type' => 'IPH','v' => '5000300'},'ext' => 'NVV.6.0','lang' => 'deu','ver' => '1.18'},'stopfinder' => 'https://auskunft.nvv.de/auskunft/bin/jp/ajax-getstop.exe','time_zone' => 'Europe/Berlin','tls_verify' => 1},'PKP' => {'coverage' => {'area' => {'coordinates' => [[['13.5596','54.3948'],['14.8372','50.3015'],['23.0239','48.5807'],['25.5789','52.1787'],['22.007','55.6724'],['13.5596','54.3948']]],'type' => 'Polygon'},'regions' => ['PL']},'geoip_lock' => 'PKP','homepage' => undef,'languages' => ['en','pl'],'mgate' => 'https://mobil.rozklad-pkp.pl:8019/bin/mgate.exe','name' => "Polskie Koleje Pa\x{144}stwowe",'productbits' => [['high-speed-train','ExpressInterCity, ExpressInterCity Premium, InterCityExpress'],['high-speed-train','ExpressInterCity, ExpressInterCity Premium, InterCityExpress'],['long-distance-train','InterCity, Twoje Linie Kolejowe, EuroCity, EuroNight'],['regional-train','Regional'],['bus','Bus'],['bus','Bus'],['ferry','Ferry']],'request' => {'auth' => {'aid' => 'DrxJYtYZQpEBCtcb','type' => 'AID'},'client' => {'id' => 'HAFAS','type' => 'AND'},'lang' => 'pol','ver' => '1.21'},'time_zone' => 'Europe/Warsaw','tls_verify' => 1,'ua_string' => 'Dalvik/2.1.0'},'RMV' => {'coverage' => {'area' => {'coordinates' => [[['7.65789','50.03203'],['7.75207','49.99162'],['7.77468','49.96634'],['7.81007','49.95349'],['7.79515','49.9383'],['7.80748','49.92965'],['7.8462','49.93787'],['7.89107','49.92636'],['7.91341','49.8796'],['7.94241','49.8753'],['7.96166','49.85638'],['7.94562','49.84232'],['7.95556','49.83424'],['7.91753','49.80645'],['7.92363','49.76883'],['7.89815','49.75096'],['7.91905','49.73754'],['7.94238','49.75006'],['7.92836','49.73598'],['7.9621','49.72174'],['7.95502','49.69857'],['7.98611','49.69196'],['8.02097','49.70383'],['8.05724','49.69083'],['8.09705','49.69224'],['8.11607','49.66751'],['8.14929','49.65355'],['8.1477','49.62211'],['8.19959','49.61666'],['8.23066','49.58377'],['8.34484','49.59056'],['8.35508','49.60232'],['8.41844','49.59119'],['8.36301','49.6779'],['8.36715','49.69472'],['8.44913','49.72448'],['8.54156','49.71262'],['8.61098','49.72605'],['8.64289','49.63966'],['8.63467','49.62669'],['8.66978','49.55592'],['8.65923','49.47952'],['8.66999','49.44249'],['8.69342','49.41188'],['8.68396','49.39539'],['8.68892','49.3762'],['8.70094','49.37415'],['8.69369','49.31227'],['8.72193','49.31027'],['8.73862','49.33936'],['8.7681','49.34144'],['8.77941','49.35689'],['8.8041','49.36199'],['8.81474','49.3311'],['8.87837','49.3553'],['8.9211','49.34124'],['8.97209','49.37945'],['9.02288','49.40108'],['9.03982','49.37081'],['9.08641','49.37364'],['9.09252','49.36239'],['9.135','49.34777'],['9.14892','49.35322'],['9.15297','49.37144'],['9.20536','49.39497'],['9.24104','49.42726'],['9.26448','49.49009'],['9.31087','49.50498'],['9.3067','49.51779'],['9.32225','49.54014'],['9.36664','49.56457'],['9.35165','49.58587'],['9.41755','49.59344'],['9.45688','49.61369'],['9.42877','49.66494'],['9.3801','49.67399'],['9.31609','49.71144'],['9.22202','49.70235'],['9.20265','49.72719'],['9.16808','49.74191'],['9.18023','49.75523'],['9.16422','49.76201'],['9.12839','49.81936'],['9.10683','49.82721'],['9.15047','49.86308'],['9.11492','49.89928'],['9.11401','49.92951'],['9.1441','49.91557'],['9.22021','49.93097'],['9.26143','49.92173'],['9.2746','49.9028'],['9.2392','49.86793'],['9.24018','49.85625'],['9.26039','49.84816'],['9.28231','49.861'],['9.3162','49.82827'],['9.37581','49.83107'],['9.3736','49.85176'],['9.44097','49.88189'],['9.43668','49.91438'],['9.46958','49.91316'],['9.47579','49.93425'],['9.49288','49.94302'],['9.48855','49.95338'],['9.45464','49.95383'],['9.43698','49.99306'],['9.41572','49.99723'],['9.44225','50.01999'],['9.41204','50.03893'],['9.42945','50.04676'],['9.41037','50.0752'],['9.51212','50.08281'],['9.5331','50.10405'],['9.53486','50.1464'],['9.55139','50.16275'],['9.51725','50.17981'],['9.53215','50.19417'],['9.51757','50.22537'],['9.59087','50.21554'],['9.65667','50.22278'],['9.68317','50.23745'],['9.65507','50.25241'],['9.76003','50.3034'],['9.76005','50.341'],['9.74908','50.35987'],['9.76512','50.42052'],['9.80087','50.41942'],['9.80409','50.4085'],['9.86033','50.393'],['9.96585','50.42187'],['10.03995','50.4793'],['10.04583','50.52887'],['10.06854','50.55664'],['10.05291','50.57363'],['10.05584','50.59947'],['10.04432','50.61114'],['10.06054','50.62086'],['10.08574','50.61621'],['10.08993','50.63417'],['10.05534','50.67684'],['10.00267','50.68095'],['9.94324','50.66674'],['9.95994','50.64174'],['9.95386','50.63352'],['9.90626','50.64469'],['9.88569','50.6385'],['9.88913','50.67116'],['9.93067','50.69412'],['9.91656','50.70453'],['9.94228','50.72289'],['9.9458','50.75751'],['9.89488','50.78387'],['9.88444','50.79998'],['9.82775','50.79667'],['9.77237','50.81407'],['9.71959','50.79355'],['9.70166','50.76822'],['9.71855','50.75474'],['9.71405','50.74806'],['9.67835','50.74484'],['9.66454','50.72251'],['9.62238','50.74484'],['9.60441','50.73666'],['9.60474','50.70727'],['9.63367','50.67646'],['9.61299','50.6507'],['9.63224','50.62798'],['9.60399','50.61214'],['9.56091','50.62512'],['9.54296','50.64471'],['9.50684','50.64179'],['9.48452','50.68591'],['9.33032','50.74048'],['8.99455','50.72624'],['8.85712','50.76303'],['8.79662','50.6983'],['8.76313','50.70044'],['8.73318','50.68559'],['8.64908','50.70813'],['8.61844','50.68069'],['8.60028','50.68102'],['8.58353','50.7096'],['8.5573','50.712'],['8.54946','50.74215'],['8.49732','50.74232'],['8.45674','50.72821'],['8.44266','50.76178'],['8.46543','50.78906'],['8.44688','50.80167'],['8.40766','50.79793'],['8.40434','50.8508'],['8.35394','50.86981'],['8.3118','50.86632'],['8.29585','50.88576'],['8.26837','50.88658'],['8.16053','50.80675'],['8.11876','50.78958'],['8.15961','50.73536'],['8.13806','50.69995'],['8.12032','50.69544'],['8.10338','50.67157'],['8.10385','50.65517'],['8.13231','50.63039'],['8.11925','50.60867'],['8.14499','50.59591'],['8.12573','50.55411'],['8.1037','50.5389'],['8.03864','50.56116'],['7.97598','50.51179'],['7.9726','50.48295'],['8.00329','50.45467'],['7.96945','50.4397'],['7.97901','50.42874'],['7.95776','50.4082'],['7.98284','50.39362'],['8.01393','50.39478'],['8.00946','50.38095'],['8.05631','50.36884'],['8.06875','50.34795'],['8.06453','50.32977'],['8.09884','50.31965'],['8.11416','50.27831'],['8.10209','50.26559'],['8.07394','50.27765'],['8.03111','50.2742'],['8.01476','50.25705'],['8.04767','50.23429'],['8.02781','50.22088'],['7.98747','50.24309'],['7.98053','50.23074'],['7.90072','50.20415'],['7.90327','50.19605'],['7.87655','50.1833'],['7.8775','50.1677'],['7.9202','50.14223'],['7.91882','50.11812'],['7.85078','50.13244'],['7.82862','50.11103'],['7.82863','50.08642'],['7.80073','50.08906'],['7.78137','50.07461'],['7.76756','50.08718'],['7.74306','50.08338'],['7.69088','50.06035'],['7.65789','50.03203']],[['9.39247','50.05606'],['9.39944','50.0665'],['9.40233','50.05624'],['9.39247','50.05606']],[['9.41134','50.02647'],['9.41547','50.02615'],['9.41406','50.02549'],['9.41134','50.02647']]],'type' => 'Polygon'},'regions' => ['DE-HE','DE-BW','DE-BY','DE-RP']},'homepage' => 'https://www.rmv.de/','languages' => ['de','en'],'mgate' => 'https://www.rmv.de/auskunft/bin/jp/mgate.exe','name' => 'Rhein-Main-Verkehrsverbund','productbits' => [['express-train','InterCityExpress/Fernzug'],['long-distance-train','EuroCity/InterCity/EuroNight/InterRegio'],['regional-train','RegionalExpress/Regionalbahn'],['s-bahn','S-Bahn'],['u-bahn','U-Bahn'],['tram',"Stra\x{df}enbahn"],['bus','Bus'],['_',undef],['watercraft','Schiff'],['_',undef],['ast','Anruf-Sammel-Taxi'],['_',undef],['cable-car','Seilbahn']],'request' => {'auth' => {'aid' => 'x0k4ZR33ICN9CWmj','type' => 'AID'},'client' => {'id' => 'RMV','name' => 'webapp','type' => 'WEB'},'ext' => 'RMV.1','lang' => 'deu','ver' => '1.18'},'time_zone' => 'Europe/Berlin','tls_verify' => 1},'RSAG' => {'coverage' => {'area' => {'coordinates' => [[['11.50385','54.0477'],['11.50661','54.03602'],['11.52016','54.03426'],['11.52451','54.04748'],['11.54738','54.0516'],['11.60869','54.09893'],['11.61851','54.08847'],['11.61601','54.07881'],['11.57596','54.06623'],['11.57925','54.04784'],['11.55396','54.02866'],['11.58053','54.00131'],['11.57708','53.98589'],['11.64964','53.98114'],['11.64401','53.97259'],['11.66459','53.96139'],['11.65921','53.95466'],['11.66656','53.93439'],['11.68487','53.92981'],['11.70706','53.95043'],['11.73295','53.94845'],['11.75252','53.95602'],['11.75582','53.96868'],['11.79141','53.96508'],['11.78302','53.9354'],['11.79636','53.92147'],['11.78082','53.91261'],['11.78303','53.88999'],['11.75421','53.87489'],['11.76889','53.86179'],['11.75188','53.85303'],['11.75899','53.84409'],['11.74892','53.82576'],['11.79216','53.81703'],['11.80288','53.79488'],['11.78435','53.77958'],['11.7876','53.76932'],['11.83469','53.76003'],['11.83382','53.74763'],['11.90297','53.72783'],['11.91719','53.73541'],['11.98034','53.73791'],['11.9855','53.73542'],['11.96792','53.731'],['11.96934','53.72202'],['11.99327','53.72279'],['12.00234','53.71097'],['12.02012','53.70737'],['12.02568','53.70048'],['12.01958','53.69014'],['12.04427','53.66315'],['12.07577','53.64476'],['12.0936','53.63815'],['12.11964','53.64186'],['12.14033','53.63126'],['12.19096','53.63788'],['12.20587','53.61054'],['12.2035','53.60016'],['12.24964','53.57842'],['12.27924','53.57777'],['12.28384','53.56792'],['12.29913','53.56343'],['12.31511','53.5644'],['12.34738','53.58353'],['12.39499','53.56323'],['12.416','53.57173'],['12.42379','53.58489'],['12.40977','53.59995'],['12.4194','53.61075'],['12.41738','53.63659'],['12.42501','53.64759'],['12.4053','53.6633'],['12.42941','53.66761'],['12.4637','53.65613'],['12.47578','53.66312'],['12.46199','53.67481'],['12.48468','53.68398'],['12.49647','53.6561'],['12.51041','53.64918'],['12.55464','53.65415'],['12.62738','53.63632'],['12.65953','53.65269'],['12.66466','53.66497'],['12.63132','53.69073'],['12.64658','53.71535'],['12.63637','53.72971'],['12.63674','53.74894'],['12.65303','53.75175'],['12.65531','53.76672'],['12.70201','53.76797'],['12.71136','53.80946'],['12.75721','53.82175'],['12.76452','53.84394'],['12.7604','53.85776'],['12.78279','53.86866'],['12.80718','53.8697'],['12.80987','53.87923'],['12.79458','53.88199'],['12.79022','53.8958'],['12.77515','53.90026'],['12.7881','53.917'],['12.80632','53.91676'],['12.82103','53.9296'],['12.79804','53.95641'],['12.82339','53.98734'],['12.816','54.00607'],['12.76275','54.03392'],['12.7409','54.03764'],['12.71657','54.02406'],['12.70375','54.02995'],['12.7016','54.03941'],['12.66433','54.05008'],['12.61165','54.08176'],['12.587','54.07614'],['12.55943','54.09758'],['12.46401','54.09806'],['12.4671','54.10898'],['12.43818','54.12864'],['12.39193','54.11874'],['12.39948','54.13484'],['12.38332','54.14927'],['12.38884','54.15972'],['12.37347','54.16472'],['12.38264','54.17665'],['12.37188','54.18395'],['12.38059','54.18963'],['12.37903','54.20914'],['12.32706','54.23442'],['12.3168','54.25444'],['12.28951','54.26319'],['12.29293','54.27457'],['12.28647','54.279'],['12.19493','54.24814'],['12.11014','54.18377'],['12.09117','54.1917'],['12.05883','54.18232'],['12.00908','54.18254'],['11.85147','54.14966'],['11.79669','54.15159'],['11.76359','54.16148'],['11.6789','54.15694'],['11.60102','54.10866'],['11.54829','54.09658'],['11.5157','54.0706'],['11.50385','54.0477']],[['11.52294','54.0541'],['11.52824','54.06316'],['11.5282','54.05863'],['11.52294','54.0541']],[['12.17339','54.23476'],['12.1734','54.23476'],['12.1734','54.23476'],['12.17339','54.23476']]],'type' => 'Polygon'},'regions' => ['DE-MV']},'homepage' => 'https://www.rsag-online.de','languages' => ['de','en','fr'],'mgate' => 'https://fahrplan.rsag-online.de/bin/mgate.exe','name' => "Rostocker Stra\x{df}enbahn",'productbits' => [['ice','InterCityExpress'],['ic-ec','InterCity & EuroCity'],['long-distance-train','InterRegio/high-speed train'],['regional-train','regional train'],['s-bahn','S-Bahn'],['bus','Bus'],['ferry','Schiff'],['u-bahn','U-Bahn'],['tram','Tram'],['on-call','Taxi/on-call vehicle']],'request' => {'auth' => {'aid' => 'tF5JTs25rzUhGrrl','type' => 'AID'},'client' => {'id' => 'RSAG','name' => 'webapp','type' => 'WEB'},'ext' => 'VBN.2','lang' => 'deu','ver' => '1.24'},'time_zone' => 'Europe/Berlin','tls_verify' => 1},'Resrobot' => {'coverage' => {'area' => undef,'regions' => []},'homepage' => undef,'languages' => ['sv'],'mgate' => 'https://reseplanerare.resrobot.se/bin/mgate.exe','name' => 'Resrobot','productbits' => ['air','long-distance-train','local-train','bus-1','rapid-transit','metro','tramway','bus-2','ferry','on-demand'],'request' => {'auth' => {'aid' => 'h5o3n7f4t2m8l9x1','type' => 'AID'},'client' => {'id' => 'SAMTRAFIKEN','type' => 'WEB'},'lang' => 'sve','ver' => '1.18'},'time_zone' => 'Europe/Stockholm','tls_verify' => 1},'STV' => {'coverage' => {'area' => {'coordinates' => [[[['15.11','46.58'],['15.51','46.55'],['15.52','46.55'],['15.84','46.65'],['16.08','46.57'],['16.11','46.65'],['16.06','46.81'],['16.24','46.98'],['16.22','47.02'],['16.15','47.22'],['16.11','47.33'],['16.23','47.37'],['16.24','47.46'],['16.22','47.47'],['16.14','47.6'],['16.1','47.59'],['15.94','47.6'],['15.76','47.77'],['15.74','47.77'],['15.38','47.89'],['15.36','47.89'],['14.93','47.78'],['14.68','47.84'],['14.67','47.82'],['14.31','47.68'],['13.73','47.8'],['13.7','47.68'],['13.7','47.68'],['13.67','47.53'],['13.52','47.55'],['13.52','47.49'],['13.49','47.43'],['13.5','47.4'],['13.56','47.23'],['13.6','47.22'],['13.8','47.23'],['13.86','47.17'],['13.78','47.15'],['13.81','47.1'],['13.72','46.83'],['13.84','46.85'],['14.2','47'],['14.38','46.91'],['14.4','46.92'],['14.83','46.98'],['14.95','46.89'],['14.88','46.71'],['14.95','46.72'],['15.08','46.54'],['15.11','46.58']]]],'type' => 'MultiPolygon'},'regions' => ['AT-6']},'homepage' => 'https://verbundlinie.at/','languages' => ['de','en'],'mgate' => 'https://verkehrsauskunft.verbundlinie.at/hamm/gate','name' => 'Steirischer Verkehrsverbund','productbits' => [['trains','Bahn & S-Bahn'],['trains','Bahn & S-Bahn'],['subway','U-Bahn'],['_',undef],['tram',"Stra\x{df}enbahn"],['_',undef],['long-distance-bus','Fernbus'],['_',undef],['regional-bus','Regionalbus'],['_',undef],['city-bus','Stadtbus'],['_',undef],['aerial-lift','Seil-/Zahnradbahn'],['_',undef],['ferry','Schiff'],['_',undef],['on-call','Anrufbus'],['_',undef],['other','Sonstige']],'request' => {'auth' => {'aid' => 'wf7mcf9bv3nv8g5f','type' => 'AID'},'client' => {'id' => 'VAO','l' => 'vs_stv','name' => 'webapp','type' => 'WEB'},'ext' => 'VAO.13','lang' => 'deu','ver' => '1.32'},'time_zone' => 'Europe/Vienna','tls_verify' => 1},'SaarVV' => {'coverage' => {'area' => {'coordinates' => [[['7.280321','49.550991'],['7.279553','49.55119'],['7.275442','49.557117'],['7.270106','49.562579'],['7.266358','49.569123'],['7.261982','49.575266'],['7.266962','49.581618'],['7.259573','49.57957'],['7.253282','49.574672'],['7.245535','49.574248'],['7.239335','49.56916'],['7.231867','49.568044'],['7.225073','49.565109'],['7.213101','49.565889'],['7.212613','49.573143'],['7.206124','49.577305'],['7.197528','49.577824'],['7.189672','49.577361'],['7.182141','49.582593'],['7.174033','49.585027'],['7.174698','49.592861'],['7.173427','49.599972'],['7.16589','49.600909'],['7.158775','49.602726'],['7.151455','49.603395'],['7.144539','49.601005'],['7.13815','49.596521'],['7.1236','49.595555'],['7.114682','49.597552'],['7.104833','49.598861'],['7.101545','49.605471'],['7.094304','49.60331'],['7.088189','49.599443'],['7.079982','49.612029'],['7.0741','49.616368'],['7.068765','49.622834'],['7.062184','49.628082'],['7.02815','49.63929'],['7.021994','49.634459'],['7.012159','49.628396'],['7.004246','49.631246'],['6.99715','49.628059'],['6.99074','49.6237'],['6.990277','49.630972'],['6.975988','49.635399'],['6.969098','49.631956'],['6.954768','49.627481'],['6.948255','49.63077'],['6.942284','49.635157'],['6.935488','49.632466'],['6.937593','49.625362'],['6.937484','49.618098'],['6.929105','49.617864'],['6.921878','49.616325'],['6.913373','49.616223'],['6.90626','49.614177'],['6.898398','49.614346'],['6.887507','49.613004'],['6.881353','49.608329'],['6.87669','49.602697'],['6.871176','49.607999'],['6.863237','49.607251'],['6.854634','49.602195'],['6.845624','49.591736'],['6.839977','49.587052'],['6.832749','49.584066'],['6.825355','49.587526'],['6.809414','49.590385'],['6.80134','49.587699'],['6.79496','49.583765'],['6.788999','49.579252'],['6.783963','49.573863'],['6.777334','49.569176'],['6.769375','49.567446'],['6.760393','49.563906'],['6.753951','49.56004'],['6.747179','49.557562'],['6.739343','49.557608'],['6.731884','49.559527'],['6.724852','49.556729'],['6.7105','49.553771'],['6.704914','49.548662'],['6.700736','49.542478'],['6.693708','49.539468'],['6.686784','49.541715'],['6.682728','49.547923'],['6.667313','49.543858'],['6.658395','49.543849'],['6.653887','49.550522'],['6.65118','49.543655'],['6.645411','49.538955'],['6.637174','49.541501'],['6.629399','49.539714'],['6.622383','49.536665'],['6.619193','49.529965'],['6.611327','49.528516'],['6.611232','49.52119'],['6.605544','49.516704'],['6.597634','49.518852'],['6.590287','49.517066'],['6.583668','49.520316'],['6.575715','49.532888'],['6.568873','49.537438'],['6.561777','49.539654'],['6.555047','49.536266'],['6.539968','49.53892'],['6.532237','49.535008'],['6.524305','49.529569'],['6.516927','49.52767'],['6.514764','49.534656'],['6.506841','49.534626'],['6.499999','49.530805'],['6.491955','49.531553'],['6.484423','49.535457'],['6.477393','49.541221'],['6.470332','49.543704'],['6.462823','49.542902'],['6.454778','49.539793'],['6.448458','49.544279'],['6.440334','49.544936'],['6.433169','49.547475'],['6.42568','49.547923'],['6.418517','49.544266'],['6.408341','49.547796'],['6.392804','49.547766'],['6.384769','49.549677'],['6.385091','49.549512'],['6.379702','49.55068'],['6.368102','49.540897'],['6.361427','49.537029'],['6.356625','49.531252'],['6.358858','49.524389'],['6.366463','49.50828'],['6.367456','49.501007'],['6.367389','49.493673'],['6.368622','49.484791'],['6.368006','49.475893'],['6.371517','49.466777'],['6.378506','49.464213'],['6.385612','49.465666'],['6.393536','49.464202'],['6.408592','49.467928'],['6.422429','49.475806'],['6.430241','49.475576'],['6.436125','49.469188'],['6.443233','49.468029'],['6.458122','49.463509'],['6.465245','49.465478'],['6.478444','49.45721'],['6.484854','49.452366'],['6.499396','49.450174'],['6.50629','49.446572'],['6.512565','49.441893'],['6.519287','49.438403'],['6.527933','49.43512'],['6.538145','49.432765'],['6.551866','49.424804'],['6.557103','49.419352'],['6.549876','49.41731'],['6.54312','49.414089'],['6.53747','49.408882'],['6.540264','49.401862'],['6.54778','49.399983'],['6.552435','49.394143'],['6.561833','49.39025'],['6.587906','49.383249'],['6.584862','49.376561'],['6.584869','49.368786'],['6.596139','49.370864'],['6.602323','49.367088'],['6.597728','49.360909'],['6.592727','49.3556'],['6.585989','49.35091'],['6.581344','49.356447'],['6.574319','49.358633'],['6.566481','49.357015'],['6.5651','49.349438'],['6.569971','49.343702'],['6.582286','49.334821'],['6.589626','49.33461'],['6.594527','49.328426'],['6.589881','49.321758'],['6.596258','49.316711'],['6.604431','49.311653'],['6.609582','49.306274'],['6.615433','49.301532'],['6.624058','49.296073'],['6.637119','49.296053'],['6.643428','49.290845'],['6.650316','49.288569'],['6.654469','49.281297'],['6.661914','49.282348'],['6.668021','49.277538'],['6.66708','49.269978'],['6.662755','49.264023'],['6.662805','49.256634'],['6.669892','49.255363'],['6.677132','49.255567'],['6.684257','49.252601'],['6.689249','49.247047'],['6.685072','49.241082'],['6.68923','49.234106'],['6.688981','49.226742'],['6.690938','49.219115'],['6.690785','49.211611'],['6.688365','49.200548'],['6.700115','49.195184'],['6.711191','49.188317'],['6.720423','49.175266'],['6.72778','49.171469'],['6.735807','49.165195'],['6.745136','49.165081'],['6.752554','49.16661'],['6.760606','49.164817'],['6.774924','49.167669'],['6.782318','49.16816'],['6.789943','49.166084'],['6.81309','49.158042'],['6.820791','49.15629'],['6.832511','49.15173'],['6.839919','49.153787'],['6.847696','49.157319'],['6.860245','49.158124'],['6.874292','49.165167'],['6.971752','49.209162'],['6.978893','49.207643'],['6.985413','49.204454'],['6.994228','49.19968'],['6.999257','49.194357'],['7.006747','49.194044'],['7.013492','49.188612'],['7.019378','49.192764'],['7.026578','49.190432'],['7.03408','49.189624'],['7.033813','49.182351'],['7.028938','49.176127'],['7.028262','49.168511'],['7.033392','49.162846'],['7.03312','49.155191'],['7.038817','49.148814'],['7.043526','49.142475'],['7.046786','49.134719'],['7.044842','49.126532'],['7.044893','49.118678'],['7.050383','49.113809'],['7.057322','49.11189'],['7.071863','49.106646'],['7.067715','49.115304'],['7.070473','49.122383'],['7.076935','49.126425'],['7.084295','49.128262'],['7.088832','49.134338'],['7.083895','49.140283'],['7.080921','49.146879'],['7.083972','49.153409'],['7.091244','49.151913'],['7.098013','49.155137'],['7.106187','49.155283'],['7.111264','49.149737'],['7.104327','49.146038'],['7.107523','49.139552'],['7.116179','49.140081'],['7.123619','49.14205'],['7.129231','49.137167'],['7.133433','49.131066'],['7.154925','49.122229'],['7.169432','49.127801'],['7.17735','49.128453'],['7.184217','49.131345'],['7.190496','49.127722'],['7.195613','49.122146'],['7.201431','49.117395'],['7.205505','49.123556'],['7.228087','49.126054'],['7.235021','49.128348'],['7.242159','49.129533'],['7.259912','49.12425'],['7.26726','49.123664'],['7.281971','49.124357'],['7.284519','49.116509'],['7.29315','49.114928'],['7.299999','49.11964'],['7.304761','49.125808'],['7.311372','49.131205'],['7.314612','49.138021'],['7.321699','49.14155'],['7.329805','49.144916'],['7.348377','49.143288'],['7.357055','49.143698'],['7.362994','49.148336'],['7.362442','49.156207'],['7.369084','49.161423'],['7.365802','49.164556'],['7.358406','49.161188'],['7.350225','49.162915'],['7.345764','49.168736'],['7.337751','49.174116'],['7.335687','49.181117'],['7.331244','49.187016'],['7.323963','49.188455'],['7.316878','49.191507'],['7.311436','49.196942'],['7.305367','49.201677'],['7.298506','49.20391'],['7.298303','49.211338'],['7.302797','49.217616'],['7.299999','49.224393'],['7.292741','49.227706'],['7.289078','49.236212'],['7.302005','49.243888'],['7.303207','49.25107'],['7.308815','49.256849'],['7.322787','49.247431'],['7.332245','49.260707'],['7.338896','49.263863'],['7.343533','49.269739'],['7.338856','49.275229'],['7.343514','49.281689'],['7.351796','49.282695'],['7.35883','49.279925'],['7.366059','49.282134'],['7.373528','49.28085'],['7.385373','49.291994'],['7.379777','49.298913'],['7.380556','49.306496'],['7.394144','49.314276'],['7.389917','49.3202'],['7.383002','49.317489'],['7.386996','49.324645'],['7.393871','49.329156'],['7.396699','49.335892'],['7.402783','49.340369'],['7.399728','49.347048'],['7.392319','49.349916'],['7.398215','49.354117'],['7.394245','49.361513'],['7.399914','49.366369'],['7.393686','49.370803'],['7.369825','49.363967'],['7.367606','49.371212'],['7.359432','49.374917'],['7.354087','49.379802'],['7.346091','49.380838'],['7.338765','49.380488'],['7.331375','49.378739'],['7.323499','49.380251'],['7.307974','49.384954'],['7.301919','49.38937'],['7.293844','49.389439'],['7.296788','49.397368'],['7.297199','49.404742'],['7.291417','49.410627'],['7.286568','49.417258'],['7.279212','49.419001'],['7.272781','49.424223'],['7.265167','49.424385'],['7.256835','49.425994'],['7.250268','49.435091'],['7.255358','49.440567'],['7.248019','49.443598'],['7.253089','49.448914'],['7.260433','49.450198'],['7.268163','49.45264'],['7.282867','49.455896'],['7.289707','49.461375'],['7.297719','49.464708'],['7.303514','49.471548'],['7.299786','49.477981'],['7.2948','49.483191'],['7.279509','49.483755'],['7.284963','49.49836'],['7.282512','49.505191'],['7.289719','49.51814'],['7.295568','49.522346'],['7.301361','49.518048'],['7.309918','49.522898'],['7.303493','49.527139'],['7.303025','49.534407'],['7.295191','49.535276'],['7.287772','49.534688'],['7.280867','49.537192'],['7.276316','49.543894'],['7.279141','49.550586'],['7.280321','49.550991']]],'type' => 'Polygon'},'regions' => ['DE-SL']},'homepage' => 'https://saarvv.de/','languages' => ['de','en','fr'],'mgate' => 'https://saarfahrplan.de/bin/mgate.exe','name' => "Saarl\x{e4}ndischer Verkehrsverbund",'productbits' => [['long-distance-train','long-distance train'],['long-distance-train','long-distance train'],['long-distance-train','long-distance train'],['regional-train','regional train'],['urban-train','urban train'],['bus','Bus'],['_',undef],['subway','subway'],['_',undef],['tram','tram'],['_',undef],['dial-a-ride','dial-a-ride']],'request' => {'auth' => {'aid' => '51XfsVqgbdA6oXzHrx75jhlocRg6Xe','type' => 'AID'},'client' => {'id' => 'ZPS-SAAR','name' => 'Saarfahrplan','os' => 'Android 9','type' => 'AND','v' => 1000070},'lang' => 'deu','ver' => '1.21'},'time_zone' => 'Europe/Berlin','tls_verify' => 1},'TPG' => {'coverage' => {'area' => {'coordinates' => [[['5.94566345214844','46.3502454017469'],['5.88592529296875','46.2230776469183'],['5.95733642578125','46.081328021386'],['6.1962890625','46.0765649911857'],['6.37687683105469','46.1983691071303'],['6.35696411132812','46.3350767123346'],['6.12693786621094','46.4241324972071'],['5.94566345214844','46.3502454017469']]],'type' => 'Polygon'},'regions' => ['CH-GE']},'homepage' => 'https://www.tpg.ch/','languages' => ['fr'],'mgate' => 'https://tpg.hafas.cloud/bin/mgate.exe','name' => 'Transports publics genevois','productbits' => [['tgv','TGV'],['intercity-train',"Intercit\x{e9}"],['ir','IR'],['train-direct','Train direct'],['watercraft','Bateau'],['regio-express','Regio Express'],['bus','Bus'],['gondola',"Transport \x{e0} c\x{e2}bles"],['tram','Tram'],['tram','Tram']],'request' => {'auth' => {'aid' => '9CZsdl5PqX8n5D6b','type' => 'AID'},'client' => {'id' => 'HAFAS','l' => 'vs_webapp','name' => 'webapp','type' => 'WEB'},'lang' => 'deu','ver' => '1.40'},'time_zone' => 'Europe/Zurich','tls_verify' => 1},'VBB' => {'coverage' => {'area' => {'coordinates' => [[['14.765478','51.611312'],['14.761913','51.60362'],['14.754235','51.599895'],['14.748988','51.594757'],['14.741341','51.592671'],['14.733784','51.586781'],['14.729518','51.579432'],['14.727236','51.575348'],['14.727157','51.582608'],['14.712911','51.594519'],['14.706989','51.59718'],['14.696636','51.596765'],['14.698264','51.589523'],['14.704164','51.582487'],['14.701759','51.575586'],['14.695135','51.572727'],['14.68891','51.559194'],['14.681238','51.553641'],['14.671947','51.551592'],['14.654868','51.55432'],['14.638695','51.554308'],['14.63105','51.550869'],['14.623445','51.550334'],['14.615881','51.550665'],['14.608791','51.552258'],['14.604385','51.558999'],['14.597004','51.57255'],['14.588022','51.574623'],['14.581935','51.578974'],['14.573673','51.580876'],['14.566412','51.580131'],['14.561435','51.574504'],['14.554219','51.572005'],['14.545392','51.573315'],['14.54637','51.566082'],['14.540741','51.560073'],['14.524453','51.558065'],['14.5177','51.554565'],['14.50859','51.558343'],['14.492108','51.558703'],['14.475125','51.557044'],['14.466813','51.557362'],['14.456374','51.556533'],['14.44851','51.554317'],['14.447418','51.543915'],['14.446317','51.542704'],['14.440122','51.544136'],['14.431379','51.543176'],['14.407442','51.537873'],['14.399999','51.54143'],['14.392685','51.541326'],['14.386259','51.536631'],['14.37114','51.530281'],['14.364616','51.526553'],['14.35647','51.52407'],['14.3482','51.52382'],['14.34194','51.51534'],['14.33398','51.50308'],['14.326108','51.509882'],['14.323926','51.517633'],['14.317183','51.521062'],['14.307369','51.52367'],['14.291603','51.525527'],['14.28312','51.529096'],['14.270533','51.532612'],['14.259885','51.532337'],['14.251553','51.529893'],['14.244232','51.532305'],['14.228643','51.532838'],['14.220328','51.538264'],['14.212273','51.539921'],['14.204847','51.539922'],['14.197687','51.538545'],['14.173428','51.53937'],['14.164725','51.540974'],['14.157461','51.540394'],['14.150174','51.541407'],['14.142781','51.544038'],['14.134937','51.541295'],['14.129608','51.534359'],['14.134151','51.527542'],['14.142299','51.522969'],['14.134706','51.521249'],['14.116654','51.523048'],['14.109376','51.522025'],['14.103634','51.517571'],['14.096877','51.501675'],['14.091334','51.496409'],['14.076342','51.48884'],['14.082642','51.48397'],['14.082472','51.47675'],['14.073352','51.47224'],['14.064522','51.47371'],['14.038622','51.48004'],['14.032744','51.475006'],['14.047721','51.465556'],['14.054859','51.457799'],['14.0551','51.44896'],['14.062489','51.445244'],['14.053897','51.442318'],['14.043766','51.439751'],['14.036878','51.434539'],['14.044938','51.431538'],['14.041696','51.42489'],['14.040949','51.417707'],['14.031073','51.413389'],['14.023152','51.408136'],['14.020145','51.401299'],['14.028122','51.396267'],['14.02094','51.397794'],['14.011174','51.398285'],['14.00817','51.391676'],['14.000786','51.386463'],['13.999364','51.379141'],['13.994851','51.372818'],['13.977708','51.37474'],['13.971281','51.379871'],['13.972337','51.38764'],['13.96951','51.39452'],['13.962129','51.396735'],['13.954162','51.397065'],['13.947469','51.394383'],['13.941054','51.389903'],['13.93389','51.388598'],['13.926392','51.386204'],['13.909801','51.383095'],['13.903675','51.377675'],['13.896362','51.377914'],['13.889185','51.377031'],['13.882186','51.374702'],['13.867419','51.37803'],['13.861187','51.381634'],['13.843446','51.38221'],['13.834261','51.383755'],['13.834796','51.376529'],['13.826318','51.374125'],['13.819263','51.369609'],['13.812164','51.371598'],['13.803196','51.372694'],['13.794074','51.37083'],['13.786394','51.370443'],['13.770079','51.361513'],['13.761693','51.363727'],['13.764732','51.370367'],['13.755132','51.371872'],['13.750666','51.365213'],['13.743069','51.361701'],['13.735881','51.362453'],['13.728792','51.364321'],['13.712584','51.363932'],['13.704545','51.36625'],['13.69643','51.370497'],['13.687172','51.37232'],['13.677061','51.370865'],['13.669012','51.375786'],['13.663793','51.370123'],['13.65612','51.36939'],['13.647655','51.369689'],['13.638836','51.368596'],['13.628504','51.369115'],['13.619882','51.370482'],['13.602865','51.369119'],['13.595532','51.374368'],['13.584784','51.384491'],['13.568128','51.384535'],['13.548383','51.375182'],['13.542854','51.36921'],['13.537612','51.377114'],['13.530621','51.380973'],['13.524558','51.385538'],['13.521694','51.393934'],['13.516594','51.40314'],['13.501509','51.404086'],['13.493962','51.405504'],['13.486574','51.408882'],['13.478774','51.410188'],['13.47038','51.410273'],['13.462764','51.415578'],['13.467213','51.42127'],['13.47506','51.418707'],['13.471115','51.425026'],['13.463481','51.426996'],['13.457555','51.422429'],['13.44994','51.422627'],['13.445795','51.430868'],['13.439338','51.427664'],['13.431261','51.4249'],['13.422867','51.424774'],['13.429543','51.428503'],['13.417805','51.438588'],['13.411479','51.442394'],['13.409115','51.449578'],['13.401978','51.453822'],['13.394551','51.450841'],['13.38896','51.44514'],['13.38381','51.43866'],['13.37724','51.43346'],['13.37962','51.42555'],['13.36474','51.43153'],['13.35486','51.43239'],['13.34446','51.43109'],['13.336109','51.430731'],['13.332618','51.437346'],['13.324261','51.434029'],['13.328068','51.426633'],['13.320777','51.424042'],['13.313454','51.423309'],['13.308776','51.417804'],['13.293004','51.413528'],['13.285639','51.407697'],['13.284852','51.39923'],['13.274355','51.399602'],['13.267063','51.400563'],['13.259428','51.399496'],['13.263747','51.390937'],['13.268684','51.384592'],['13.261965','51.388976'],['13.255144','51.392371'],['13.248041','51.394342'],['13.240684','51.394422'],['13.231707','51.395361'],['13.219571','51.394863'],['13.212819','51.398805'],['13.207748','51.404321'],['13.200107','51.411236'],['13.201508','51.420299'],['13.203733','51.428043'],['13.198896','51.433643'],['13.191964','51.43562'],['13.186651','51.430087'],['13.180171','51.42517'],['13.174788','51.431926'],['13.181004','51.436034'],['13.188003','51.43888'],['13.200932','51.448078'],['13.20374','51.454815'],['13.199193','51.461125'],['13.192144','51.463424'],['13.185391','51.467972'],['13.182498','51.475979'],['13.18612','51.482761'],['13.184458','51.490515'],['13.192219','51.488539'],['13.199999','51.49088'],['13.20676','51.505702'],['13.206584','51.515643'],['13.207664','51.524306'],['13.200499','51.525808'],['13.190406','51.539192'],['13.187245','51.548703'],['13.185566','51.557986'],['13.178019','51.557328'],['13.166413','51.558208'],['13.15889','51.561589'],['13.14695','51.563673'],['13.141902','51.569288'],['13.146149','51.576111'],['13.122074','51.595429'],['13.132648','51.607202'],['13.121573','51.617404'],['13.111441','51.61506'],['13.103996','51.616337'],['13.099262','51.610677'],['13.092412','51.606682'],['13.084933','51.609001'],['13.081413','51.616777'],['13.072911','51.626039'],['13.06618','51.631604'],['13.059238','51.639274'],['13.051362','51.646657'],['13.059825','51.651292'],['13.086989','51.660963'],['13.09477','51.664382'],['13.141175','51.681186'],['13.150444','51.685077'],['13.156344','51.689242'],['13.161382','51.695171'],['13.154601','51.709079'],['13.162119','51.71309'],['13.167975','51.708632'],['13.167767','51.716124'],['13.174789','51.717996'],['13.182263','51.716148'],['13.186187','51.722374'],['13.179492','51.729633'],['13.173478','51.733869'],['13.167309','51.737773'],['13.159053','51.74143'],['13.156214','51.748093'],['13.163103','51.751074'],['13.15817','51.756378'],['13.150677','51.759156'],['13.155814','51.764273'],['13.148186','51.766535'],['13.153946','51.771342'],['13.160383','51.775314'],['13.114046','51.779825'],['13.159197','51.782004'],['13.159931','51.789305'],['13.158744','51.797089'],['13.161561','51.803744'],['13.155061','51.812121'],['13.142805','51.822326'],['13.139546','51.828763'],['13.134719','51.834322'],['13.130261','51.842382'],['13.126034','51.848536'],['13.123394','51.85611'],['13.132943','51.857767'],['13.141567','51.858182'],['13.148739','51.859581'],['13.151235','51.868431'],['13.144591','51.872549'],['13.139595','51.877795'],['13.132357','51.879626'],['13.124215','51.882747'],['13.118992','51.876753'],['13.100565','51.873384'],['13.092643','51.873081'],['13.084804','51.873578'],['13.08717','51.85278'],['13.078419','51.867731'],['13.069551','51.868862'],['13.056193','51.869373'],['13.039897','51.870806'],['13.032511','51.875755'],['13.027137','51.880642'],['13.034354','51.880256'],['13.0383','51.888703'],['13.047391','51.891724'],['13.045863','51.898778'],['13.02927','51.902232'],['13.02213','51.9007'],['13.007156','51.903138'],['12.984011','51.903905'],['12.976996','51.902174'],['12.975101','51.910818'],['12.976286','51.918094'],['12.969038','51.921467'],['12.960987','51.922424'],['12.959295','51.93009'],['12.954361','51.935346'],['12.929182','51.937552'],['12.922126','51.939342'],['12.915869','51.934321'],['12.908934','51.93019'],['12.901717','51.928676'],['12.893805','51.928312'],['12.888802','51.93367'],['12.852238','51.935368'],['12.852228','51.943917'],['12.850265','51.958876'],['12.845321','51.964559'],['12.835545','51.967099'],['12.820409','51.962981'],['12.811298','51.962359'],['12.793586','51.962094'],['12.777428','51.964518'],['12.7762','51.971625'],['12.773893','51.978711'],['12.766285','51.979777'],['12.758886','51.982453'],['12.752059','51.986979'],['12.744676','51.988872'],['12.737409','51.989299'],['12.730005','51.988803'],['12.714848','51.995401'],['12.709109','52.000058'],['12.701561','52.00218'],['12.694258','52.003013'],['12.685166','52.002737'],['12.678266','52.005394'],['12.67332','52.011087'],['12.665458','52.013192'],['12.655848','52.012757'],['12.648241','52.00773'],['12.646233','52.000216'],['12.642264','51.994213'],['12.63458','51.99395'],['12.626556','51.992354'],['12.619242','51.992374'],['12.615265','51.98572'],['12.608766','51.982071'],['12.591679','51.981673'],['12.584536','51.982964'],['12.561543','51.983287'],['12.553704','51.984535'],['12.543777','51.98443'],['12.539946','51.99255'],['12.53492','52.000746'],['12.528004','52.004228'],['12.503667','52.007345'],['12.496744','52.010724'],['12.489774','52.014943'],['12.483818','52.019452'],['12.480687','52.028519'],['12.472743','52.034451'],['12.464109','52.034819'],['12.458181','52.030585'],['12.452671','52.025593'],['12.450788','52.018207'],['12.443546','52.0167'],['12.43525','52.017017'],['12.428017','52.018864'],['12.422272','52.023999'],['12.407267','52.030344'],['12.394264','52.039126'],['12.386707','52.0434'],['12.37751','52.045265'],['12.361274','52.046342'],['12.355236','52.05092'],['12.35002','52.056355'],['12.341992','52.061684'],['12.334991','52.064891'],['12.32872','52.070542'],['12.319691','52.085417'],['12.316164','52.092372'],['12.30897','52.094408'],['12.301288','52.095729'],['12.294988','52.099887'],['12.287532','52.10267'],['12.28039','52.104207'],['12.273652','52.108807'],['12.269492','52.116799'],['12.268599','52.124389'],['12.264965','52.130634'],['12.256663','52.134562'],['12.249225','52.136995'],['12.242849','52.140876'],['12.239215','52.147129'],['12.231949','52.154621'],['12.233964','52.162787'],['12.223898','52.165255'],['12.216509','52.170541'],['12.228267','52.185911'],['12.235661','52.183565'],['12.245041','52.183296'],['12.244296','52.190678'],['12.24841','52.199113'],['12.253971','52.205781'],['12.245917','52.206992'],['12.252182','52.213002'],['12.260258','52.216546'],['12.267615','52.214112'],['12.274983','52.215945'],['12.282476','52.219172'],['12.297346','52.228857'],['12.289718','52.229898'],['12.283283','52.234583'],['12.268488','52.234826'],['12.27549','52.236793'],['12.268035','52.240846'],['12.257823','52.243044'],['12.245924','52.249872'],['12.250327','52.257514'],['12.251523','52.264792'],['12.250976','52.272201'],['12.257584','52.285455'],['12.266084','52.298039'],['12.271588','52.302854'],['12.274711','52.309424'],['12.281462','52.31893'],['12.289609','52.3231'],['12.298267','52.334658'],['12.305295','52.342383'],['12.301199','52.348857'],['12.288247','52.361201'],['12.285031','52.367708'],['12.296669','52.37089'],['12.303807','52.374414'],['12.294784','52.38069'],['12.293619','52.388148'],['12.298927','52.394231'],['12.301593','52.400926'],['12.300181','52.408233'],['12.291354','52.407869'],['12.275469','52.412253'],['12.281499','52.418594'],['12.291718','52.422664'],['12.289413','52.430583'],['12.29911','52.432936'],['12.302657','52.439957'],['12.304863','52.447361'],['12.310876','52.452204'],['12.317353','52.455827'],['12.329721','52.477317'],['12.321754','52.475936'],['12.313841','52.476894'],['12.310134','52.483085'],['12.313236','52.49019'],['12.32399','52.491837'],['12.330216','52.496291'],['12.322205','52.49599'],['12.310927','52.490874'],['12.301188','52.495086'],['12.294289','52.492688'],['12.286214','52.492709'],['12.279896','52.488063'],['12.272322','52.487768'],['12.268172','52.493909'],['12.270436','52.500772'],['12.262511','52.503309'],['12.258267','52.511175'],['12.256748','52.518647'],['12.247088','52.518714'],['12.240419','52.522546'],['12.232528','52.522595'],['12.2301','52.514723'],['12.223794','52.511026'],['12.223574','52.503362'],['12.216972','52.499798'],['12.210118','52.502412'],['12.20414','52.497955'],['12.18122','52.499999'],['12.172444','52.505596'],['12.168025','52.512719'],['12.179606','52.523855'],['12.186364','52.527848'],['12.181611','52.533855'],['12.173945','52.538531'],['12.159165','52.534649'],['12.153719','52.529519'],['12.145087','52.529652'],['12.143677','52.536953'],['12.149672','52.541013'],['12.154016','52.548425'],['12.157832','52.558623'],['12.166241','52.565997'],['12.176174','52.571997'],['12.174402','52.579269'],['12.173565','52.587634'],['12.173411','52.595981'],['12.174532','52.603624'],['12.170712','52.610995'],['12.176586','52.617656'],['12.169452','52.616552'],['12.172532','52.625083'],['12.191587','52.620051'],['12.199999','52.618697'],['12.20629','52.622443'],['12.21305','52.625046'],['12.230133','52.62807'],['12.230723','52.63643'],['12.23644','52.640798'],['12.234915','52.648196'],['12.234804','52.657947'],['12.23549','52.66555'],['12.238922','52.67192'],['12.235288','52.678342'],['12.228253','52.681684'],['12.232397','52.687642'],['12.224763','52.688199'],['12.218916','52.694408'],['12.220737','52.701483'],['12.217249','52.707912'],['12.209515','52.70941'],['12.21052','52.716645'],['12.203709','52.719723'],['12.205228','52.727098'],['12.209103','52.734843'],['12.216561','52.735779'],['12.218613','52.751368'],['12.210364','52.752579'],['12.205848','52.760493'],['12.212458','52.764028'],['12.212537','52.772061'],['12.22004','52.773788'],['12.223351','52.783415'],['12.220011','52.789793'],['12.229055','52.790293'],['12.235811','52.787565'],['12.243596','52.786287'],['12.249171','52.791675'],['12.254077','52.797888'],['12.257729','52.804612'],['12.252954','52.810089'],['12.247106','52.815525'],['12.243274','52.822431'],['12.239844','52.831862'],['12.237382','52.840647'],['12.220944','52.848408'],['12.214518','52.853695'],['12.215083','52.862522'],['12.208437','52.865501'],['12.201216','52.870133'],['12.196568','52.877892'],['12.189924','52.875036'],['12.182988','52.870199'],['12.172376','52.865054'],['12.137694','52.857524'],['12.129005','52.854972'],['12.131365','52.864194'],['12.123495','52.872894'],['12.120273','52.880033'],['12.122109','52.888228'],['12.12901','52.893426'],['12.121748','52.891282'],['12.115878','52.88391'],['12.112334','52.875614'],['12.103081','52.877207'],['12.095862','52.877558'],['12.086661','52.876726'],['12.081638','52.882125'],['12.075891','52.886531'],['12.068813','52.883916'],['12.061329','52.887536'],['12.053467','52.888744'],['12.045212','52.889042'],['12.030739','52.888258'],['12.023331','52.890495'],['12.016321','52.888419'],['12.008547','52.887282'],['12.003113','52.881492'],['11.995636','52.881864'],['11.988075','52.879568'],['11.980072','52.876239'],['11.972791','52.878563'],['11.964026','52.880302'],['11.955871','52.883459'],['11.949005','52.887282'],['11.933324','52.891526'],['11.924524','52.892201'],['11.905766','52.892304'],['11.898036','52.893417'],['11.886131','52.898116'],['11.878894','52.905694'],['11.87131','52.908997'],['11.861934','52.909763'],['11.840888','52.909299'],['11.832406','52.910776'],['11.825625','52.915132'],['11.823735','52.922593'],['11.829316','52.929458'],['11.84651','52.940053'],['11.848895','52.947057'],['11.84242','52.953518'],['11.834455','52.955983'],['11.824851','52.957549'],['11.811826','52.957184'],['11.793443','52.959464'],['11.782131','52.962555'],['11.775728','52.969691'],['11.77163','52.976065'],['11.760908','52.983692'],['11.751603','52.987054'],['11.741299','52.989063'],['11.733112','52.988973'],['11.705759','52.979143'],['11.697371','52.977577'],['11.687998','52.980898'],['11.683765','52.986999'],['11.684079','52.997318'],['11.681188','53.004865'],['11.674391','53.0092'],['11.666161','53.009422'],['11.649361','53.005355'],['11.640118','53.005878'],['11.633028','53.007883'],['11.626824','53.011861'],['11.625521','53.019971'],['11.632666','53.025949'],['11.639377','53.03045'],['11.641149','53.037639'],['11.633871','53.040765'],['11.624002','53.041521'],['11.59659','53.036702'],['11.583138','53.035664'],['11.570149','53.038162'],['11.55866','53.045156'],['11.552832','53.050318'],['11.544951','53.053517'],['11.53529','53.051019'],['11.526837','53.048058'],['11.519079','53.047696'],['11.506148','53.049565'],['11.490462','53.058219'],['11.46796','53.073171'],['11.459182','53.077506'],['11.448951','53.079221'],['11.4362','53.078295'],['11.427973','53.075895'],['11.405507','53.07388'],['11.396499','53.07168'],['11.386812','53.066906'],['11.354274','53.056037'],['11.345089','53.055099'],['11.335636','53.057406'],['11.327657','53.06276'],['11.316084','53.074569'],['11.306097','53.080435'],['11.296978','53.083466'],['11.286311','53.089078'],['11.273544','53.098467'],['11.269034','53.105603'],['11.269873','53.113294'],['11.268721','53.120505'],['11.276731','53.120841'],['11.28548','53.120273'],['11.296066','53.117349'],['11.307779','53.115018'],['11.315112','53.116424'],['11.325838','53.117174'],['11.333013','53.116188'],['11.341785','53.112746'],['11.35787','53.114222'],['11.367747','53.114248'],['11.375085','53.112159'],['11.386373','53.112863'],['11.393711','53.109846'],['11.399999','53.113809'],['11.39484','53.124358'],['11.3923','53.131101'],['11.394806','53.138989'],['11.402884','53.136192'],['11.41407','53.135707'],['11.429967','53.138652'],['11.437946','53.137713'],['11.445578','53.13795'],['11.457152','53.139837'],['11.467595','53.13784'],['11.475174','53.134745'],['11.475492','53.127398'],['11.492428','53.129299'],['11.499999','53.128046'],['11.505231','53.123003'],['11.513524','53.126191'],['11.522133','53.12596'],['11.529614','53.127245'],['11.537661','53.129967'],['11.55446','53.132458'],['11.559418','53.140322'],['11.547424','53.14898'],['11.557308','53.151201'],['11.561619','53.159806'],['11.567491','53.164565'],['11.566656','53.172258'],['11.564565','53.179158'],['11.554386','53.181625'],['11.558132','53.188394'],['11.557087','53.196288'],['11.557764','53.203693'],['11.551248','53.207106'],['11.558065','53.210517'],['11.566683','53.21339'],['11.57395','53.212221'],['11.581818','53.213298'],['11.589688','53.216262'],['11.595093','53.221742'],['11.601096','53.225832'],['11.607623','53.228933'],['11.616396','53.23019'],['11.620988','53.238375'],['11.627513','53.241725'],['11.639857','53.238494'],['11.656246','53.239938'],['11.662835','53.243987'],['11.670173','53.24426'],['11.677433','53.242105'],['11.685447','53.242019'],['11.700581','53.243823'],['11.708739','53.237709'],['11.714796','53.231953'],['11.722783','53.232099'],['11.728498','53.216948'],['11.736103','53.216972'],['11.748435','53.219551'],['11.760285','53.224773'],['11.769864','53.227117'],['11.791033','53.22698'],['11.799999','53.225896'],['11.816222','53.232113'],['11.831538','53.232999'],['11.821627','53.240952'],['11.811089','53.245018'],['11.803643','53.245662'],['11.799877','53.252179'],['11.812478','53.253245'],['11.849023','53.25036'],['11.857969','53.248595'],['11.864657','53.251328'],['11.862234','53.261638'],['11.873549','53.26061'],['11.883962','53.264489'],['11.897585','53.278732'],['11.904841','53.275399'],['11.912061','53.274069'],['11.92046','53.273391'],['11.944374','53.274876'],['11.952171','53.27383'],['11.970662','53.290892'],['11.973481','53.297797'],['11.981879','53.298655'],['11.990732','53.295119'],['11.999849','53.296932'],['12.006565','53.299999'],['12.017758','53.299439'],['12.021113','53.309328'],['12.018668','53.316222'],['12.020735','53.323507'],['12.017145','53.330571'],['12.022152','53.336504'],['12.038119','53.344095'],['12.057094','53.349437'],['12.045683','53.370731'],['12.066604','53.369952'],['12.073919','53.369189'],['12.079599','53.36132'],['12.080735','53.351304'],['12.08839','53.345918'],['12.106482','53.343854'],['12.122225','53.349019'],['12.134647','53.34849'],['12.139597','53.35544'],['12.150139','53.360952'],['12.156008','53.354127'],['12.165123','53.341616'],['12.176958','53.340944'],['12.186396','53.343174'],['12.186967','53.351284'],['12.197523','53.352753'],['12.214996','53.354095'],['12.22141','53.357402'],['12.229969','53.358095'],['12.23224','53.35079'],['12.236421','53.342198'],['12.242693','53.337906'],['12.248144','53.332336'],['12.255103','53.330446'],['12.260036','53.323988'],['12.275478','53.325164'],['12.284737','53.328187'],['12.308027','53.327303'],['12.314552','53.323077'],['12.322617','53.321442'],['12.347964','53.313677'],['12.364969','53.306376'],['12.372409','53.306154'],['12.379474','53.303218'],['12.394232','53.301413'],['12.397871','53.294609'],['12.39346','53.288615'],['12.397332','53.281411'],['12.405404','53.279078'],['12.413077','53.278269'],['12.424841','53.275059'],['12.431288','53.270835'],['12.431788','53.262856'],['12.437591','53.256476'],['12.443586','53.252163'],['12.451376','53.251462'],['12.459533','53.254451'],['12.467106','53.256246'],['12.498769','53.255448'],['12.507971','53.262498'],['12.529792','53.264624'],['12.545578','53.262284'],['12.566023','53.255902'],['12.597103','53.24842'],['12.605343','53.24447'],['12.620056','53.251228'],['12.627077','53.252852'],['12.646673','53.254954'],['12.65424','53.255191'],['12.662517','53.253907'],['12.667483','53.248408'],['12.674906','53.248637'],['12.715891','53.238319'],['12.746824','53.225728'],['12.756596','53.224494'],['12.755331','53.215732'],['12.751418','53.208804'],['12.741656','53.2015'],['12.74887','53.196869'],['12.756735','53.195786'],['12.762201','53.191021'],['12.76936','53.188146'],['12.777108','53.188719'],['12.784299','53.187923'],['12.800498','53.193037'],['12.807022','53.196472'],['12.812769','53.191975'],['12.819926','53.193084'],['12.827361','53.195806'],['12.834893','53.197051'],['12.841956','53.199772'],['12.849583','53.199629'],['12.859751','53.187541'],['12.867208','53.1868'],['12.873175','53.182572'],['12.879719','53.179362'],['12.887699','53.181188'],['12.894178','53.188513'],['12.901637','53.189611'],['12.907719','53.193584'],['12.922747','53.195768'],['12.930257','53.193827'],['12.924386','53.18938'],['12.931307','53.18736'],['12.939289','53.185873'],['12.938489','53.193271'],['12.944818','53.196757'],['12.951706','53.199181'],['12.966617','53.199194'],['12.974782','53.197848'],['12.979296','53.192213'],['12.964709','53.186123'],['12.958868','53.18052'],['12.950451','53.178588'],['12.942955','53.174948'],['12.95108','53.17366'],['12.95769','53.176634'],['12.96506','53.175903'],['12.966643','53.168755'],['12.980444','53.162735'],['12.986205','53.167672'],['12.995772','53.168575'],['13.004664','53.167315'],['13.009313','53.173064'],['13.016913','53.174951'],['13.018916','53.183305'],['13.025837','53.185503'],['13.031438','53.190114'],['13.046422','53.197523'],['13.053563','53.200037'],['13.061489','53.20067'],['13.068249','53.203586'],['13.074976','53.200262'],['13.085964','53.213439'],['13.09346','53.217168'],['13.099999','53.213672'],['13.105035','53.218991'],['13.107831','53.225971'],['13.105004','53.233232'],['13.110205','53.238913'],['13.117302','53.240949'],['13.131433','53.237478'],['13.137319','53.243897'],['13.144464','53.246996'],['13.151106','53.250886'],['13.157955','53.247384'],['13.165472','53.250119'],['13.172671','53.249575'],['13.179879','53.250808'],['13.187515','53.246374'],['13.191068','53.239646'],['13.19355','53.232471'],['13.199351','53.227326'],['13.203489','53.221261'],['13.210948','53.220942'],['13.227526','53.21697'],['13.234189','53.222461'],['13.238257','53.229021'],['13.241341','53.236299'],['13.247811','53.242855'],['13.246625','53.250244'],['13.249381','53.257548'],['13.263009','53.264089'],['13.271356','53.264014'],['13.284211','53.275674'],['13.291905','53.276673'],['13.298262','53.280666'],['13.313567','53.278358'],['13.336797','53.273417'],['13.344274','53.277155'],['13.359438','53.277979'],['13.367084','53.272429'],['13.369949','53.265549'],['13.375136','53.258237'],['13.386425','53.244757'],['13.393501','53.242902'],['13.400422','53.245529'],['13.409123','53.257883'],['13.424594','53.274672'],['13.427895','53.281285'],['13.435186','53.283362'],['13.441783','53.286551'],['13.434235','53.28887'],['13.435647','53.295966'],['13.442713','53.298352'],['13.450875','53.298594'],['13.463899','53.289411'],['13.478763','53.291587'],['13.485988','53.293526'],['13.498025','53.302577'],['13.499','53.309972'],['13.504736','53.315057'],['13.503397','53.322942'],['13.510004','53.319658'],['13.519438','53.318571'],['13.523395','53.334822'],['13.522965','53.34204'],['13.525155','53.349901'],['13.516291','53.351845'],['13.525361','53.364758'],['13.533565','53.36506'],['13.543149','53.363619'],['13.546207','53.370231'],['13.552338','53.374468'],['13.553371','53.38166'],['13.555856','53.388603'],['13.548448','53.392745'],['13.552443','53.399436'],['13.560697','53.399549'],['13.567839','53.402892'],['13.573419','53.408126'],['13.581605','53.408562'],['13.589438','53.409722'],['13.596738','53.409413'],['13.604053','53.410743'],['13.612191','53.413473'],['13.619306','53.411646'],['13.626417','53.414986'],['13.63163','53.423137'],['13.627208','53.431202'],['13.634508','53.431376'],['13.640827','53.445011'],['13.648837','53.445659'],['13.658688','53.456359'],['13.666076','53.457533'],['13.673698','53.462591'],['13.681786','53.464745'],['13.689263','53.46981'],['13.696842','53.47169'],['13.71447','53.48273'],['13.722386','53.481771'],['13.731116','53.482522'],['13.747124','53.481982'],['13.758371','53.479188'],['13.769369','53.478171'],['13.776677','53.475831'],['13.787574','53.477327'],['13.807622','53.483441'],['13.804392','53.49095'],['13.8064','53.49872'],['13.798886','53.498601'],['13.78936','53.511138'],['13.782364','53.513812'],['13.778295','53.5199'],['13.777374','53.528111'],['13.778317','53.538812'],['13.783027','53.551528'],['13.793334','53.55788'],['13.80054','53.558816'],['13.802308','53.551412'],['13.801212','53.544059'],['13.815907','53.526317'],['13.819712','53.519612'],['13.838499','53.516278'],['13.847783','53.515629'],['13.881299','53.507368'],['13.876525','53.500915'],['13.874045','53.494148'],['13.875905','53.486829'],['13.883908','53.486374'],['13.881007','53.47953'],['13.875671','53.473978'],['13.888145','53.467334'],['13.915305','53.456629'],['13.941413','53.443283'],['13.934336','53.437129'],['13.911571','53.438559'],['13.905875','53.43382'],['13.908025','53.426168'],['13.916211','53.422584'],['13.945658','53.431014'],['13.961525','53.430513'],['13.994936','53.433905'],['14.002838','53.433038'],['14.01877','53.429666'],['14.045428','53.429575'],['14.047962','53.42031'],['14.051545','53.412845'],['14.058965','53.41225'],['14.071625','53.413826'],['14.081412','53.412561'],['14.097535','53.423259'],['14.106171','53.424007'],['14.112087','53.430097'],['14.12185','53.443013'],['14.134825','53.437792'],['14.147056','53.43571'],['14.166784','53.427941'],['14.176627','53.424845'],['14.18932','53.423149'],['14.199999','53.423457'],['14.209808','53.426385'],['14.217661','53.432096'],['14.227987','53.43149'],['14.235324','53.427777'],['14.23966','53.42135'],['14.235994','53.414838'],['14.24005','53.406516'],['14.241616','53.392813'],['14.231408','53.372658'],['14.221691','53.359046'],['14.212499','53.350599'],['14.203361','53.343426'],['14.17712','53.325161'],['14.171175','53.320223'],['14.159677','53.31278'],['14.150815','53.308766'],['14.13553','53.299999'],['14.108303','53.28118'],['14.103322','53.274862'],['14.101593','53.267085'],['14.11408','53.260831'],['14.122857','53.260536'],['14.130617','53.261807'],['14.145172','53.266028'],['14.161053','53.267748'],['14.176472','53.262238'],['14.192715','53.260997'],['14.199999','53.261809'],['14.206505','53.258438'],['14.21497','53.25553'],['14.223217','53.256435'],['14.247622','53.257132'],['14.264743','53.259315'],['14.265774','53.266579'],['14.261333','53.27633'],['14.279446','53.281353'],['14.297462','53.284872'],['14.309145','53.297731'],['14.313538','53.30373'],['14.316381','53.310508'],['14.323521','53.311676'],['14.347233','53.309868'],['14.364547','53.317256'],['14.372521','53.315371'],['14.380047','53.319754'],['14.385703','53.324784'],['14.393421','53.328193'],['14.40219','53.329972'],['14.410718','53.329098'],['14.413396','53.320619'],['14.409713','53.314369'],['14.408866','53.306449'],['14.414673','53.301894'],['14.416969','53.289484'],['14.42103','53.276234'],['14.437792','53.275389'],['14.443954','53.270961'],['14.448916','53.265139'],['14.446488','53.257946'],['14.438981','53.252191'],['14.430297','53.238922'],['14.422415','53.235088'],['14.416465','53.230726'],['14.410096','53.225059'],['14.407316','53.213084'],['14.401317','53.207599'],['14.394325','53.205795'],['14.386354','53.205145'],['14.377249','53.201568'],['14.373289','53.185676'],['14.369295','53.177805'],['14.367132','53.170786'],['14.369899','53.16395'],['14.372322','53.15553'],['14.379077','53.149851'],['14.384588','53.144234'],['14.381114','53.122576'],['14.379469','53.115192'],['14.370239','53.104919'],['14.371078','53.097067'],['14.367696','53.083045'],['14.359863','53.073228'],['14.353406','53.060001'],['14.3485','53.054625'],['14.339836','53.0477'],['14.332814','53.044634'],['14.322287','53.041243'],['14.313094','53.036056'],['14.308191','53.030755'],['14.299999','53.026315'],['14.294175','53.021502'],['14.273435','53.012371'],['14.265005','53.007775'],['14.258213','53.002817'],['14.250093','53.00055'],['14.242088','52.995791'],['14.235344','52.992985'],['14.228095','52.992101'],['14.220036','52.988733'],['14.205188','52.986703'],['14.198378','52.984148'],['14.189919','52.979622'],['14.182811','52.977267'],['14.175374','52.976027'],['14.16837','52.972989'],['14.163757','52.965961'],['14.1477','52.962826'],['14.143036','52.957321'],['14.138786','52.951198'],['14.14423','52.944423'],['14.142129','52.936818'],['14.145312','52.928806'],['14.146867','52.920619'],['14.150873','52.914366'],['14.1536','52.898215'],['14.159656','52.89159'],['14.158714','52.8754'],['14.146945','52.864771'],['14.139631','52.860555'],['14.13413','52.855123'],['14.128134','52.850535'],['14.123459','52.844191'],['14.123228','52.836462'],['14.128449','52.829883'],['14.134999','52.826415'],['14.142264','52.823805'],['14.150888','52.823938'],['14.159433','52.822203'],['14.168504','52.821272'],['14.176512','52.821271'],['14.184705','52.820106'],['14.210039','52.818705'],['14.217122','52.816676'],['14.22482','52.810858'],['14.230571','52.804505'],['14.238398','52.800821'],['14.256349','52.787342'],['14.27029','52.780315'],['14.2763','52.775984'],['14.299999','52.767235'],['14.315659','52.763149'],['14.323243','52.761978'],['14.330632','52.759209'],['14.337106','52.755377'],['14.345247','52.753453'],['14.352035','52.750977'],['14.35723','52.744644'],['14.363572','52.73948'],['14.372596','52.73733'],['14.383783','52.72566'],['14.397159','52.717297'],['14.403074','52.712487'],['14.413956','52.700735'],['14.420856','52.697476'],['14.428516','52.691215'],['14.431007','52.683511'],['14.437979','52.680231'],['14.453526','52.677055'],['14.459368','52.672182'],['14.461284','52.664499'],['14.467389','52.660287'],['14.482644','52.653566'],['14.491294','52.650649'],['14.498013','52.64754'],['14.50422','52.643558'],['14.511206','52.641'],['14.526549','52.637285'],['14.533469','52.633791'],['14.540976','52.630831'],['14.548643','52.629105'],['14.556252','52.625911'],['14.563569','52.624839'],['14.570982','52.622334'],['14.577614','52.618076'],['14.584969','52.614497'],['14.591714','52.611989'],['14.598841','52.608023'],['14.605649','52.602231'],['14.609571','52.596041'],['14.612367','52.587998'],['14.618889','52.582978'],['14.634615','52.576677'],['14.639708','52.570984'],['14.63499','52.565055'],['14.622897','52.559496'],['14.615381','52.55407'],['14.614237','52.546072'],['14.604177','52.533142'],['14.606934','52.524586'],['14.610899','52.516522'],['14.613567','52.509498'],['14.6206','52.506451'],['14.628738','52.50391'],['14.634336','52.498672'],['14.633925','52.491485'],['14.628377','52.48552'],['14.621832','52.481029'],['14.614441','52.478032'],['14.607678','52.463293'],['14.600975','52.459804'],['14.595583','52.453893'],['14.58822','52.450004'],['14.581803','52.444187'],['14.574441','52.440165'],['14.566145','52.440133'],['14.557547','52.438398'],['14.549746','52.433751'],['14.545053','52.428165'],['14.544991','52.419607'],['14.545866','52.411217'],['14.535466','52.400636'],['14.535216','52.393046'],['14.541871','52.385757'],['14.548235','52.379953'],['14.552173','52.373303'],['14.552958','52.351117'],['14.561617','52.354005'],['14.570096','52.355478'],['14.57523','52.348732'],['14.559284','52.345073'],['14.563247','52.337862'],['14.564026','52.326111'],['14.571663','52.324302'],['14.577766','52.319379'],['14.57888','52.312158'],['14.584678','52.30679'],['14.580737','52.299999'],['14.574781','52.295709'],['14.575723','52.288575'],['14.582744','52.285698'],['14.589043','52.281665'],['14.592825','52.274535'],['14.599999','52.272216'],['14.610578','52.27202'],['14.618107','52.271251'],['14.636252','52.265134'],['14.644125','52.263054'],['14.660049','52.262213'],['14.679682','52.257662'],['14.687975','52.257064'],['14.696517','52.253775'],['14.703837','52.245181'],['14.712026','52.238548'],['14.714877','52.231719'],['14.709508','52.214435'],['14.704312','52.207546'],['14.692179','52.200921'],['14.685971','52.19629'],['14.687939','52.189298'],['14.695006','52.185197'],['14.700903','52.180659'],['14.704874','52.174481'],['14.704699','52.1666'],['14.694007','52.156151'],['14.68371','52.149443'],['14.679105','52.143889'],['14.682712','52.128943'],['14.682557','52.120823'],['14.683193','52.112424'],['14.689009','52.106251'],['14.69714','52.099999'],['14.70559','52.096638'],['14.715038','52.095696'],['14.722141','52.094217'],['14.730883','52.090705'],['14.738657','52.086584'],['14.744762','52.082391'],['14.749926','52.074803'],['14.756568','52.069771'],['14.75849','52.061337'],['14.748756','52.056362'],['14.747283','52.048803'],['14.750362','52.042117'],['14.748565','52.03411'],['14.742259','52.029554'],['14.740133','52.02182'],['14.727355','52.013869'],['14.722405','52.006367'],['14.715134','52.004731'],['14.721288','51.996285'],['14.71761','51.988771'],['14.714586','51.980759'],['14.707049','51.979352'],['14.707299','51.971955'],['14.709561','51.96311'],['14.714264','51.957218'],['14.721034','51.953364'],['14.719589','51.945631'],['14.716366','51.939158'],['14.708301','51.935714'],['14.704353','51.92967'],['14.70501','51.922406'],['14.700574','51.91519'],['14.694695','51.910961'],['14.69484','51.903544'],['14.680549','51.894845'],['14.674794','51.88948'],['14.666777','51.890393'],['14.66044','51.886019'],['14.654657','51.881008'],['14.652516','51.873657'],['14.645764','51.869215'],['14.635794','51.865584'],['14.6289','51.860464'],['14.621595','51.857316'],['14.612648','51.857444'],['14.607778','51.85192'],['14.61306','51.846669'],['14.605339','51.847901'],['14.605886','51.840451'],['14.598396','51.841146'],['14.590701','51.838427'],['14.593382','51.830952'],['14.591062','51.823833'],['14.600835','51.813099'],['14.604146','51.806282'],['14.612831','51.804479'],['14.619715','51.80225'],['14.628441','51.801851'],['14.635416','51.799999'],['14.642245','51.797348'],['14.652809','51.785522'],['14.65496','51.770935'],['14.651419','51.764511'],['14.66269','51.758653'],['14.657306','51.752115'],['14.658107','51.743911'],['14.657485','51.735874'],['14.664507','51.732788'],['14.668793','51.725706'],['14.678066','51.722914'],['14.687893','51.712101'],['14.696457','51.706526'],['14.716417','51.696471'],['14.722575','51.692084'],['14.730171','51.688357'],['14.738976','51.685849'],['14.738621','51.678386'],['14.747628','51.675949'],['14.757138','51.66222'],['14.754345','51.654811'],['14.755624','51.643538'],['14.753199','51.62798'],['14.761238','51.62135'],['14.765478','51.611312']]],'type' => 'Polygon'},'regions' => ['DE-BE','DE-BB']},'homepage' => 'https://www.vbb.de/','languages' => ['de','en'],'mgate' => 'https://fahrinfo.vbb.de/bin/mgate.exe','name' => 'Verkehrsverbund Berlin-Brandenburg','productbits' => [['suburban','S-Bahn'],['subway','U-Bahn'],['tram','Tram'],['bus','Bus'],['ferry',"F\x{e4}hre"],['express','IC/ICE'],['regional','RB/RE']],'request' => {'auth' => {'aid' => 'hafas-vbb-webapp','type' => 'AID'},'client' => {'id' => 'VBB','l' => 'vs_webapp_vbb','name' => 'VBB WebApp','type' => 'WEB'},'ext' => 'VBB.1','lang' => 'deu','ver' => '1.33'},'stopfinder' => 'https://fahrinfo.vbb.de/bin/ajax-getstop.exe','time_zone' => 'Europe/Berlin','tls_verify' => 1},'VBN' => {'coverage' => {'area' => {'coordinates' => [[['7.60466','53.05803'],['7.70495','53.01354'],['7.71499','52.97489'],['7.7078','52.96804'],['7.73606','52.9418'],['7.8231','52.9189'],['7.77936','52.87676'],['7.70596','52.85224'],['7.67428','52.79729'],['7.70472','52.76856'],['7.64297','52.74192'],['7.62865','52.72366'],['7.68749','52.67481'],['7.76567','52.67306'],['7.80689','52.69629'],['7.85379','52.7046'],['7.91636','52.67539'],['7.97584','52.69126'],['8.02005','52.67705'],['8.07705','52.62125'],['8.06577','52.60061'],['8.03418','52.58978'],['8.02867','52.53684'],['8.00627','52.53282'],['8.05067','52.50236'],['8.05363','52.44222'],['8.12888','52.43967'],['8.15851','52.4286'],['8.20709','52.47444'],['8.24771','52.47555'],['8.3005','52.49429'],['8.29327','52.45261'],['8.36274','52.43836'],['8.41803','52.44002'],['8.46024','52.45832'],['8.46743','52.49024'],['8.50819','52.50828'],['8.55867','52.49465'],['8.65084','52.52588'],['8.70422','52.49586'],['8.78022','52.52822'],['8.81556','52.52623'],['8.83645','52.54032'],['8.85547','52.52938'],['8.90767','52.55849'],['8.90803','52.59828'],['8.88216','52.6083'],['8.88815','52.62568'],['8.93598','52.62691'],['9.00789','52.64773'],['9.02695','52.66331'],['9.03675','52.69593'],['9.01616','52.71109'],['9.05823','52.72657'],['9.06246','52.75796'],['9.07157','52.76221'],['9.05755','52.78682'],['9.07502','52.80574'],['9.05825','52.81224'],['9.06758','52.82778'],['9.05285','52.8373'],['9.11593','52.86066'],['9.11166','52.87742'],['9.12277','52.89199'],['9.16829','52.89206'],['9.20344','52.87266'],['9.17276','52.86046'],['9.20945','52.84709'],['9.19325','52.84074'],['9.18834','52.81226'],['9.22895','52.81422'],['9.25625','52.79537'],['9.28147','52.81153'],['9.29504','52.80878'],['9.29771','52.77272'],['9.33282','52.76127'],['9.35588','52.77627'],['9.36781','52.80139'],['9.34941','52.82174'],['9.36959','52.81705'],['9.39665','52.8305'],['9.40039','52.83824'],['9.3846','52.85126'],['9.42018','52.87725'],['9.42227','52.89721'],['9.45819','52.90946'],['9.46448','52.92914'],['9.45331','52.9457'],['9.4714','52.95877'],['9.46475','52.99058'],['9.44049','53.00702'],['9.37354','52.98856'],['9.34365','52.99219'],['9.35768','53.00385'],['9.3443','53.0186'],['9.19467','53.04974'],['9.19297','53.065'],['9.17165','53.07736'],['9.1635','53.09657'],['9.18985','53.11624'],['9.18248','53.12776'],['9.20099','53.14666'],['9.19296','53.16311'],['9.20104','53.17451'],['9.17428','53.18891'],['9.12704','53.17056'],['9.10453','53.14965'],['9.07745','53.15473'],['9.03686','53.19807'],['9.03216','53.24928'],['9.00057','53.2729'],['9.01995','53.29993'],['8.99966','53.30832'],['9.00381','53.32523'],['8.94978','53.34363'],['8.94651','53.36855'],['8.91652','53.37677'],['8.96199','53.41092'],['8.92186','53.44099'],['8.97099','53.4518'],['8.98073','53.46886'],['8.96364','53.47789'],['8.96768','53.50963'],['8.91233','53.52232'],['8.97035','53.52664'],['8.99302','53.53752'],['8.98664','53.55224'],['9.02748','53.55047'],['9.06628','53.56832'],['9.11193','53.54888'],['9.16325','53.60224'],['9.26332','53.62602'],['9.26264','53.63704'],['9.28708','53.64424'],['9.27926','53.65404'],['9.28637','53.67023'],['9.21928','53.68034'],['9.30538','53.73137'],['9.26645','53.77204'],['9.22483','53.76139'],['9.17994','53.78989'],['9.13081','53.80277'],['9.12249','53.81567'],['9.11006','53.80893'],['9.04285','53.81914'],['9.02661','53.83696'],['8.98801','53.84555'],['8.90553','53.83417'],['8.7889','53.84027'],['8.69485','53.88191'],['8.68666','53.89674'],['8.60252','53.8814'],['8.55954','53.8483'],['8.53409','53.80808'],['8.51228','53.74823'],['8.47476','53.68933'],['8.47564','53.6548'],['8.51038','53.60941'],['8.47544','53.60027'],['8.49052','53.58052'],['8.48517','53.57427'],['8.50785','53.55796'],['8.46554','53.55698'],['8.40216','53.57368'],['8.32578','53.62216'],['8.26754','53.61337'],['8.24281','53.59282'],['8.21866','53.51862'],['8.3','53.52053'],['8.30938','53.48964'],['8.30647','53.45926'],['8.28953','53.43137'],['8.24851','53.40397'],['8.20711','53.40974'],['8.15299','53.45532'],['8.10061','53.45172'],['8.074','53.47435'],['8.06839','53.49974'],['8.1572','53.50958'],['8.17852','53.54129'],['8.15003','53.57776'],['8.16315','53.58503'],['8.1558','53.60451'],['8.12787','53.60361'],['8.09047','53.64769'],['8.04873','53.64523'],['8.0361','53.66355'],['8.03365','53.70693'],['7.94757','53.71988'],['7.80434','53.71307'],['7.82973','53.64377'],['7.81314','53.63069'],['7.8513','53.61364'],['7.83692','53.59267'],['7.84239','53.58077'],['7.81743','53.5522'],['7.82331','53.54045'],['7.80769','53.52029'],['7.81431','53.4996'],['7.92907','53.50801'],['7.92212','53.47935'],['7.96224','53.46238'],['7.95631','53.44672'],['7.85151','53.40027'],['7.87754','53.35212'],['7.84383','53.2965'],['7.75641','53.24561'],['7.69595','53.22559'],['7.69175','53.20763'],['7.70759','53.18432'],['7.63953','53.18519'],['7.63045','53.11894'],['7.62002','53.116'],['7.60466','53.05803']],[['9.19526','53.61824'],['9.19545','53.61824'],['9.19555','53.61804'],['9.19526','53.61824']]],'type' => 'Polygon'},'regions' => ['DE-NI','DE-HB']},'homepage' => 'https://www.vbn.de/','languages' => ['de','en'],'mgate' => 'https://fahrplaner.vbn.de/bin/mgate.exe','micmac' => 1,'name' => 'Verkehrsverbund Bremen/Niedersachsen','productbits' => [['express-train','InterCityExpress'],['national-train','InterCity, EuroCity, CityNightLine, InterRegio'],['national-train','InterCity, EuroCity, CityNightLine, InterRegio'],['local-train','Nahverkehr'],['suburban','S-Bahn'],['bus','Bus'],['watercraft','Schiff'],['subway','U-Bahn'],['tram','Tram'],['dial-a-ride','Anrufverkehr']],'request' => {'auth' => {'aid' => 'kaoxIXLn03zCr2KR','type' => 'AID'},'client' => {'id' => 'VBN','name' => 'vbn','type' => 'IPH','v' => '6000000'},'lang' => 'deu','ver' => '1.42'},'salt' => 'SP31mBufSyCLmNxp','stopfinder' => 'https://fahrplaner.vbn.de/hafas/ajax-getstop.exe','time_zone' => 'Europe/Berlin','tls_verify' => 1},'VMT' => {'coverage' => {'area' => {'coordinates' => [[[['10.1686','50.9896'],['10.1825','50.9653'],['10.2426','50.962'],['10.2443','50.9509'],['10.3183','50.9263'],['10.341','50.9446'],['10.3835','50.9563'],['10.3986',51],['10.3843','51.0063'],['10.3908','51.0164'],['10.3814','51.0407'],['10.3196','51.0569'],['10.3035','51.0464'],['10.3096','51.0338'],['10.2725','51.0242'],['10.273','51.0029'],['10.2028','51.016'],['10.1686','50.9896']]],[[['10.3945','50.8634'],['10.4218','50.8392'],['10.4653','50.8459'],['10.5332','50.823'],['10.5318','50.7806'],['10.5562','50.7792'],['10.5583','50.7545'],['10.581','50.7325'],['10.6127','50.7331'],['10.6498','50.7112'],['10.6659','50.7189'],['10.707','50.7118'],['10.7213','50.7306'],['10.7508','50.7134'],['10.7739','50.762'],['10.8087','50.7629'],['10.8311','50.7781'],['10.845','50.8048'],['10.8401','50.8162'],['10.867','50.835'],['10.8434','50.8437'],['10.8466','50.8507'],['10.8715','50.8535'],['10.8777','50.8729'],['10.9056','50.8932'],['10.9765','50.886'],['10.9949','50.9023'],['11.1042','50.9088'],['11.1077','50.8948'],['11.1243','50.8953'],['11.1177','50.887'],['11.1258','50.8721'],['11.154','50.8692'],['11.1646','50.853'],['11.1491','50.8462'],['11.1502','50.8266'],['11.1926','50.8062'],['11.1681','50.7719'],['11.1829','50.7389'],['11.1367','50.7304'],['11.1081','50.7371'],['11.0906','50.7299'],['11.0854','50.7013'],['11.0701','50.7239'],['11.0462','50.7098'],['11.0498','50.692'],['11.0066','50.6935'],['11.0023','50.686'],['11.0202','50.665'],['11.0493','50.6724'],['11.0572','50.6576'],['11.0512','50.6254'],['11.0815','50.6083'],['11.0618','50.5676'],['11.0392','50.5568'],['10.966','50.5571'],['10.9615','50.5369'],['10.9892','50.5228'],['11.0603','50.5192'],['11.0856','50.5057'],['11.0999','50.5132'],['11.0996','50.5273'],['11.138','50.5268'],['11.172','50.5603'],['11.1874','50.5576'],['11.197','50.5515'],['11.1906','50.5408'],['11.1988','50.5246'],['11.2619','50.4964'],['11.2607','50.4758'],['11.2905','50.4707'],['11.3261','50.4859'],['11.329','50.5052'],['11.3534','50.5158'],['11.4211','50.5115'],['11.4332','50.4991'],['11.4117','50.4939'],['11.4139','50.4419'],['11.4428','50.43'],['11.4407','50.4166'],['11.4737','50.4272'],['11.4809','50.4158'],['11.4722','50.3986'],['11.5112','50.3915'],['11.5127','50.3727'],['11.5222','50.3695'],['11.5637','50.3802'],['11.5752','50.3952'],['11.6257','50.3823'],['11.7633','50.4008'],['11.7809','50.4117'],['11.8254','50.3853'],['11.93','50.4238'],['11.9331','50.4361'],['11.9017','50.4467'],['11.9554','50.4505'],['11.9505','50.4746'],['11.9712','50.4874'],['11.9399','50.509'],['11.9301','50.5297'],['11.8903','50.5226'],['11.8802','50.5392'],['11.9316','50.5544'],['11.9406','50.5685'],['11.9337','50.5828'],['11.951','50.5944'],['11.8957','50.6236'],['11.8941','50.6653'],['11.8738','50.6675'],['11.8826','50.6793'],['11.8756','50.7025'],['11.8842','50.72'],['11.9096','50.726'],['11.905','50.7407'],['11.9256','50.744'],['11.951','50.7668'],['11.9009','50.7924'],['11.8684','50.7954'],['11.9063','50.8059'],['11.9168','50.8273'],['11.8996','50.8447'],['11.928','50.8588'],['11.8834','50.8838'],['11.9233','50.8889'],['11.932','50.9099'],['11.9584','50.9131'],['11.9742','50.9338'],['11.9663','50.9423'],['11.9863','50.9493'],['12.0254','50.9413'],['12.0374','50.9335'],['12.011','50.9155'],['12.0174','50.9023'],['11.9911','50.8743'],['12.0056','50.8626'],['11.9913','50.8491'],['12.0092','50.8274'],['12.042','50.8146'],['12.093','50.8188'],['12.123','50.7949'],['12.148','50.7972'],['12.1608','50.8108'],['12.1413','50.8229'],['12.1447','50.8383'],['12.1348','50.8476'],['12.1632','50.8734'],['12.1401','50.9078'],['12.1441','50.9234'],['12.1745','50.932'],['12.1766','50.944'],['12.1627','50.9666'],['12.107','50.9782'],['12.0237','50.9746'],['12.011','50.9946'],['11.9803','50.9961'],['11.9823','51.0193'],['11.9451','51.037'],['11.9215','51.031'],['11.9172','51.0469'],['11.8925','51.0594'],['11.758','51.0527'],['11.7362','51.072'],['11.7091','51.0738'],['11.6988','51.1019'],['11.6691','51.1149'],['11.6234','51.109'],['11.5708','51.125'],['11.5395','51.1074'],['11.4782','51.1092'],['11.4362','51.0949'],['11.4349','51.1058'],['11.4144','51.1138'],['11.3957','51.102'],['11.1947','51.1086'],['11.1849','51.0794'],['11.1992','51.0341'],['11.1328','51.0144'],['11.1076','51.0384'],['11.0979','51.0674'],['11.0695','51.0837'],['11.04','51.0839'],['11.0342','51.0698'],['11.0149','51.0642'],['10.9712','51.0685'],['10.9785','51.0469'],['10.9277','51.0341'],['10.9184','51.0198'],['10.8774','51.0324'],['10.8779','51.0601'],['10.8983','51.0716'],['10.8848','51.1015'],['10.7763','51.0986'],['10.7681','51.1092'],['10.7308','51.1158'],['10.696','51.0997'],['10.6877','51.0798'],['10.7029','51.0557'],['10.6904','51.0492'],['10.6112','51.0434'],['10.5884','51.028'],['10.4756','50.9969'],['10.4801','50.9694'],['10.506','50.9617'],['10.4923','50.9503'],['10.4939','50.9372'],['10.4718','50.9164'],['10.4328','50.9096'],['10.3945','50.8634']],[['10.4869','50.9007'],['10.4889','50.9033'],['10.49','50.9014'],['10.4869','50.9007']],[['11.912','50.4178'],['11.912','50.4178'],['11.912','50.4178'],['11.912','50.4178']]]],'type' => 'MultiPolygon'},'regions' => ['DE-TH']},'homepage' => 'https://www.vmt-thueringen.de/','languages' => ['de'],'mgate' => 'https://vmt.hafas.de/bin/ticketing/mgate.exe','micmac' => 1,'name' => "Verkehrsverbund Mittelthüringen",'productbits' => [['long-distance-train','long-distance train'],['long-distance-train','long-distance train'],['long-distance-train','long-distance train'],['regional-train','regional train'],['regional-train','regional train'],['tram','tram'],['_',undef],['_',undef],['bus','bus']],'request' => {'auth' => {'aid' => 't2h7u1e6r4i8n3g7e0n','type' => 'AID'},'client' => {'id' => 'HAFAS','name' => 'VMT','type' => 'IPH','v' => '2040100'},'lang' => 'deu','ver' => '1.34'},'salt' => '7x8d3n2a5m1b3c6z','time_zone' => 'Europe/Berlin','tls_verify' => 1},'VOS' => {'coverage' => {'area' => {'coordinates' => [[['7.5971','52.4971'],['7.6054','52.4692'],['7.6819','52.4514'],['7.7092','52.3974'],['7.8054','52.367'],['7.8928','52.3745'],['7.9338','52.3576'],['7.942','52.3332'],['7.9722','52.3091'],['7.9255','52.3036'],['7.9244','52.2845'],['7.9476','52.2724'],['7.9176','52.2643'],['7.9192','52.2282'],['7.8926','52.2062'],['7.9071','52.1824'],['7.9299','52.1729'],['8.0083','52.1702'],['7.99','52.1545'],['7.9998','52.1199'],['7.9685','52.1201'],['7.8795','52.0873'],['7.9136','52.0478'],['7.9822','52.0314'],['8.0304','52.0609'],['8.0967','52.0526'],['8.1384','52.0686'],['8.1959','52.0683'],['8.2175','52.0956'],['8.2772','52.1267'],['8.3966','52.1043'],['8.4175','52.1133'],['8.4202','52.136'],['8.4855','52.1561'],['8.5244','52.1841'],['8.4535','52.2134'],['8.4758','52.2473'],['8.4663','52.2931'],['8.4781','52.3156'],['8.4482','52.3638'],['8.3263','52.405'],['8.3289','52.4275'],['8.3045','52.4558'],['8.319','52.4936'],['8.3129','52.5027'],['8.1988','52.484'],['8.1563','52.4388'],['8.1328','52.449'],['8.0658','52.4498'],['8.0691','52.5038'],['8.0238','52.528'],['8.0433','52.5302'],['8.0485','52.5851'],['8.0777','52.5945'],['8.0948','52.6238'],['8.0782','52.6478'],['8.0216','52.6879'],['7.9743','52.7011'],['7.9188','52.6852'],['7.8545','52.714'],['7.7993','52.7042'],['7.7618','52.6818'],['7.6829','52.6825'],['7.6857','52.6661'],['7.6003','52.6186'],['7.6128','52.5879'],['7.612','52.5369'],['7.5971','52.4971']]],'type' => 'Polygon'},'regions' => ['DE-NI']},'homepage' => 'https://vos.info/','languages' => ['de'],'mgate' => 'https://fahrplan.vos.info/bin/mgate.exe','name' => "Verkehrsgemeinschaft Osnabrück",'productbits' => [['ice','ICE'],['national-train','IC/EC'],['express-train','IR, sonstiger Schnellzug'],['local-train','Nahverkehr'],['suburban-train','S-Bahn'],['bus','Bus'],['ferry','Schiff'],['subway','U-Bahn'],['tram','Tram'],['on-call','Anrufverkehr']],'request' => {'auth' => {'aid' => 'PnYowCQP7Tp1V','type' => 'AID'},'client' => {'id' => 'SWO','l' => 'vs_swo','name' => 'webapp','type' => 'WEB'},'lang' => 'deu','ver' => '1.72'},'stopfinder' => 'https://fahrplan.vos.info/bin/ajax-getstop.exe','time_zone' => 'Europe/Berlin','tls_verify' => 1},'ZVV' => {'coverage' => {'area' => {'coordinates' => [[['8.35202583707834','47.5001946155509'],['8.35711930960682','47.4791305258738'],['8.36717320760818','47.4766185045161'],['8.35946680883456','47.4645977247785'],['8.37739905109845','47.4520789483139'],['8.36862653015477','47.4295573439027'],['8.38381185702575','47.4225171624042'],['8.35630153626058','47.4005176857785'],['8.38750446511417','47.3904249131588'],['8.39899260939458','47.3661393093779'],['8.39743099312266','47.345454843663'],['8.40926120127301','47.3341359371962'],['8.40679813184773','47.3247199676029'],['8.4355983642263','47.3208630705343'],['8.42292647956018','47.3035465061848'],['8.38219317976987','47.2889678455238'],['8.41338528771236','47.223339458811'],['8.47020626097956','47.2045490358631'],['8.54146213450429','47.2177664995563'],['8.56962131403426','47.2139324452932'],['8.59000891127556','47.2071512330336'],['8.59563220910437','47.1975547232655'],['8.6072104504622','47.1989498648056'],['8.62024024549193','47.16944865253'],['8.67744707535648','47.1552735914541'],['8.6985755362268','47.1622178100448'],['8.68727023038731','47.179552380212'],['8.69824886939886','47.1921274328236'],['8.74302311026567','47.2074085875952'],['8.8132400941314','47.2170064927356'],['8.80334137412544','47.2385940566178'],['8.80859279346149','47.243073567891'],['8.86108674017138','47.2387757260636'],['8.93710213384953','47.2553058388189'],['8.95396351806477','47.2745473814348'],['8.95467568106031','47.2830480161951'],['8.94663820506402','47.2864757446829'],['8.99130336555281','47.3181188714751'],['8.97802713228386','47.3540897740238'],['8.96237074440835','47.3625500016409'],['8.94882304690765','47.3883441570116'],['8.91386575398138','47.4056826641717'],['8.92119849478567','47.4282521661488'],['8.93967945368972','47.4348076098066'],['8.91317199903999','47.4412263774492'],['8.91496668280852','47.4500282911624'],['8.89133881129825','47.4737586453556'],['8.90421816319347','47.4842305751913'],['8.90401878443736','47.5265145102701'],['8.84774330082721','47.5358522039576'],['8.83729126947171','47.5527974123987'],['8.85639604300941','47.5580784756928'],['8.85581405642031','47.5666956183338'],['8.8338651209409','47.5775265972623'],['8.81429411173503','47.5759370645302'],['8.80822058854403','47.5873983386321'],['8.75430311873462','47.5972930354606'],['8.74891061390732','47.605965330043'],['8.76095862023161','47.6134139273311'],['8.78597229086122','47.5993618987626'],['8.80864162387758','47.5989535444301'],['8.83445529176765','47.640580167683'],['8.83124493150634','47.6498802101373'],['8.81159238663683','47.6559721839419'],['8.80658347717547','47.6692731243539'],['8.78515407608729','47.669243688687'],['8.77762482252654','47.6556216290958'],['8.75214217139475','47.6468849700764'],['8.70824790775427','47.6476868064812'],['8.68627147451289','47.6609547690761'],['8.67386029258804','47.6882514671193'],['8.64382163931679','47.6988543429518'],['8.62163411376238','47.6955150841123'],['8.62004661394945','47.6813443297183'],['8.60881859542899','47.6816875260375'],['8.59946463630408','47.6691512891456'],['8.62219979219682','47.6502699207607'],['8.60475453980588','47.656861284698'],['8.58967588111945','47.644985930206'],['8.59832324712067','47.6141458902112'],['8.57218252381505','47.5910772123195'],['8.55714561370511','47.5594699631421'],['8.54327258288281','47.5850986730681'],['8.56853014297827','47.5968714932198'],['8.58039218453463','47.6142520785063'],['8.56158875630067','47.6281952190708'],['8.51458744182197','47.6383910683981'],['8.50146340310682','47.6216115186235'],['8.47581332742102','47.6191058086349'],['8.4511808519982','47.6048760998807'],['8.45461610085945','47.5862942923268'],['8.468797833312','47.5794483521079'],['8.41432536558346','47.568533097564'],['8.40851769528006','47.5502192854426'],['8.37796175873961','47.5301614155662'],['8.37267579109182','47.5164627279986'],['8.35632665569693','47.5131495420497'],['8.35202583707834','47.5001946155509']]],'type' => 'Polygon'},'regions' => ['CH-ZH']},'homepage' => 'https://zvv.ch/','languages' => ['de','en','fr','it'],'mgate' => 'https://online.fahrplan.zvv.ch/gate','name' => "Züricher Verkehrsverbund",'productbits' => ['high-speed-train','high-speed-train','high-speed-train','high-speed-train',['boat','Boat'],['urban-train','Urban Train'],['bus','Bus'],['cable-car','Cable Car'],['night-train','Night Train'],['tram','Tram']],'request' => {'auth' => {'aid' => 'hf7mcf9bv3nv8g5f','type' => 'AID'},'client' => {'id' => 'ZVV','name' => 'zvvPROD-STORE','type' => 'IPH','v' => '6000400'},'ext' => 'ZVV.2','lang' => 'deu','ver' => '1.24'},'time_zone' => 'Europe/Zurich','tls_verify' => 1},'mobiliteit' => {'coverage' => {'area' => undef,'regions' => ['LU']},'homepage' => 'https://www.mobiliteit.lu/','languages' => ['de','en','fr'],'mgate' => 'https://cdt.hafas.de/gate','name' => "mobilit\x{e9}its zentral",'productbits' => [['express-train','local train (TGV/ICE)'],['national-train-1','national train (IC/RE/IRE)'],['national-train-2','national train (IC/RE/IRE)'],['local-train','local train (RB/TER)'],['_',undef],['bus','Bus'],['_',undef],['_',undef],['_',undef],['tram','Tram']],'request' => {'auth' => {'aid' => 'SkC81GuwuzL4e0','type' => 'AID'},'client' => {'id' => 'MMILUX','l' => 'vs_webapp','name' => 'webapp','type' => 'WEB'},'lang' => 'deu','ver' => '1.25'},'time_zone' => 'Europe/Berlin','tls_verify' => 1},"ÖBB" => {'coverage' => {'area' => {'coordinates' => [[[['15.06','46.58'],['15.47','46.55'],['15.48','46.54'],['15.84','46.65'],['16.01','46.6'],['16.05','46.58'],['16.11','46.63'],['16.07','46.8'],['16.31','46.95'],['16.51','46.93'],['16.57','46.93'],['16.59','47.04'],['16.55','47.06'],['16.56','47.06'],['16.59','47.07'],['16.6','47.16'],['16.49','47.23'],['16.5','47.34'],['16.58','47.34'],['16.61','47.35'],['16.78','47.51'],['16.78','47.56'],['16.74','47.61'],['17.1','47.64'],['17.2','47.65'],['17.09','47.85'],['17.21','47.96'],['17.25','48.01'],['16.93','48.36'],['17.02','48.52'],['17.02','48.55'],['16.96','48.76'],['16.92','48.78'],['16.7','48.79'],['16.57','48.88'],['16.53','48.88'],['16.36','48.8'],['16.11','48.81'],['15.87','48.94'],['15.85','48.95'],['15.7','48.92'],['15.3','49.06'],['15.27','49.06'],['15.16','49.02'],['15.04','49.09'],['14.96','49.09'],['14.92','48.84'],['14.8','48.85'],['14.76','48.83'],['14.67','48.66'],['14.48','48.71'],['14.45','48.72'],['14.32','48.62'],['14.13','48.65'],['14.16','48.7'],['13.86','48.84'],['13.8','48.84'],['13.69','48.6'],['13.51','48.66'],['13.47','48.65'],['13.29','48.38'],['12.73','48.19'],['12.65','48.14'],['12.92','47.85'],['12.83','47.74'],['12.84','47.71'],['12.8','47.75'],['12.53','47.7'],['12.47','47.76'],['12.33','47.75'],['12.33','47.77'],['12.27','47.82'],['12.15','47.77'],['12.06','47.77'],['12.1','47.67'],['11.63','47.66'],['11.62','47.66'],['11.25','47.46'],['11.01','47.47'],['10.94','47.58'],['10.92','47.6'],['10.55','47.62'],['10.55','47.65'],['10.42','47.65'],['10.4','47.66'],['10.4','47.65'],['10.36','47.65'],['10.36','47.49'],['10.38','47.49'],['10.37','47.42'],['10.3','47.38'],['10.3','47.4'],['10.27','47.46'],['10.13','47.43'],['10.01','47.6'],['9.99','47.61'],['9.81','47.66'],['9.79','47.66'],['9.56','47.6'],['9.51','47.61'],['9.47','47.53'],['9.58','47.4'],['9.48','47.31'],['9.46','47.27'],['9.54','47.04'],['9.55','47'],['9.81','46.96'],['9.81','46.92'],['9.83','46.88'],['10.08','46.78'],['10.11','46.77'],['10.36','46.91'],['10.41','46.83'],['10.42','46.78'],['10.64','46.8'],['10.69','46.73'],['10.71','46.72'],['11','46.7'],['11.05','46.7'],['11.2','46.9'],['11.62','46.95'],['11.71','46.91'],['11.73','46.89'],['12.09','47'],['12.08','46.95'],['12.03','46.91'],['12.51','46.6'],['12.52','46.59'],['13.9','46.46'],['14.55','46.31'],['14.58','46.3'],['15.06','46.58']]]],'type' => 'MultiPolygon'},'regions' => ['AT']},'homepage' => 'https://www.oebb.at/','languages' => ['de'],'mgate' => 'https://fahrplan.oebb.at/bin/mgate.exe','name' => "Österreichische Bundesbahnen",'productbits' => [['express-train','InterCityExpress & RailJet'],['long-distance-train-1','InterCity & EuroCity'],['long-distance-train-2','InterCity & EuroCity'],['long-distance-train-3','Durchgangszug & EuroNight'],['regional-train','Regional & RegionalExpress'],['suburban','S-Bahn'],['bus','Bus'],['ferry','Ferry'],['subway','U-Bahn'],['tram','Tram'],['_',undef],['on-call','on-call transit, lifts, etc'],['_',undef],['long-distance-train-4','Durchgangszug & EuroNight']],'request' => {'auth' => {'aid' => 'OWDL4fE4ixNiPBBm','type' => 'AID'},'client' => {'id' => 'OEBB','name' => 'oebbPROD-ADHOC','type' => 'IPH','v' => '6030600'},'lang' => 'deu','ver' => '1.57'},'stopfinder' => 'https://fahrplan.oebb.at/bin/ajax-getstop.exe','time_zone' => 'Europe/Vienna','tls_verify' => 1}};
sub get_service_ref {
	return $hafas_instance;
}

sub get_service_map {
	return %{$hafas_instance};
}

1;
