use strict;
use warnings;
use ExtUtils::MakeMaker;

# buffering will ruin your day!
select STDERR; $|=1;
select STDOUT; $|=1;

# prereqs
my $EX_version   = 0;      # Exporter
my $DL_version   = 0;      # DynaLoader
my $EUMM_version = '6.64'; # ExtUtils::MakeMaker
my $TM_version   = 0;      # Test::More

my $UUID_version = get_uuidpm_version();

WriteMakefile1(
    'NAME'             => 'UUID',
    'AUTHOR'           => 'Rick Myers <jrm@cpan.org>',
    'VERSION_FROM'     => 'UUID.pm',
    'ABSTRACT_FROM'    => 'UUID.pm',
    'LICENSE'          => 'artistic_2',
    'MIN_PERL_VERSION' => '5.005',
    'LIBS'             => '',
    'NO_MYMETA'        => 1,
    'INC'              => '-Iulib',
    'OBJECT'           => '$(O_FILES)',
    'LDFROM'           => join( ' ', qw{
        ulib/uuid/clear.o ulib/uuid/compare.o ulib/uuid/copy.o
        ulib/uuid/gen_uuid.o ulib/uuid/isnull.o ulib/uuid/pack.o
        ulib/uuid/parse.o ulib/uuid/unpack.o ulib/uuid/unparse.o
        ulib/uuid/uuid_time.o UUID.o
    }),
    'C' => [qw{
        ulib/uuid/clear.c ulib/uuid/compare.c ulib/uuid/copy.c
        ulib/uuid/gen_uuid.c ulib/uuid/isnull.c ulib/uuid/pack.c
        ulib/uuid/parse.c ulib/uuid/unpack.c ulib/uuid/unparse.c
        ulib/uuid/uuid_time.c UUID.c
    }],
    'H' => [qw{
        ulib/EUMM.h ulib/config.h ulib/dirpaths.h ulib/uuid/uuid.h
        ulib/uuid/uuid_types.h
    }],
    'PREREQ_PM'          => {
        'DynaLoader' => $DL_version,
        'Exporter'   => $EX_version,
        'strict'     => 0,
        'vars'       => 0,
        'warnings'   => 0,
    },
    'CONFIGURE_REQUIRES' => {
        'Config'              => 0,
        'Devel::CheckLib'     => 0,
        'ExtUtils::MakeMaker' => $EUMM_version,
        'File::Path'          => 0,
        'strict'              => 0,
        'warnings'            => 0,
    },
    'BUILD_REQUIRES' => {
        'ExtUtils::MakeMaker' => $EUMM_version,
        'File::Spec'          => 0,
        'strict'              => 0,
        'warnings'            => 0,
    },
    'TEST_REQUIRES' => {
        'CPAN::Meta'         => 0,
        'DynaLoader'         => $DL_version,
        'Exporter'           => $EX_version,
        'ExtUtils::Manifest' => 0,
        'Test::More'         => $TM_version,
        'lib'                => 0,
        'strict'             => 0,
        'vars'               => 0,
        'warnings'           => 0,
    },
    'META_MERGE' => {
        'dynamic_config' => 0,
        'provides' => {
            'UUID' => {
                'file'    => 'UUID.pm',
                'version' => $UUID_version,
            },
        },
    },
    'realclean' => {
        'FILES' => join( ' ', qw{
            ulib perl.exe.stackdump
        }),
    },
);

exit 0;

sub WriteMakefile1 {  #Written by Alexandr Ciornii, version 0.21. Added by eumm-upgrade.
    my %params=@_;
    my $eumm_version=$ExtUtils::MakeMaker::VERSION;
    $eumm_version=eval $eumm_version;
    die "EXTRA_META is deprecated" if exists $params{EXTRA_META};
    die "LICENSE not specified" if not exists $params{LICENSE};
    if ($params{BUILD_REQUIRES} and $eumm_version < 6.5503) {
        #EUMM 6.5502 has problems with BUILD_REQUIRES
        $params{PREREQ_PM}={ %{$params{PREREQ_PM} || {}} , %{$params{BUILD_REQUIRES}} };
        delete $params{BUILD_REQUIRES};
    }
    delete $params{TEST_REQUIRES} if $eumm_version < 6.64;
    delete $params{CONFIGURE_REQUIRES} if $eumm_version < 6.52;
    delete $params{MIN_PERL_VERSION} if $eumm_version < 6.48;
    delete $params{META_MERGE} if $eumm_version < 6.46;
    delete $params{META_ADD} if $eumm_version < 6.46;
    delete $params{LICENSE} if $eumm_version < 6.31;
    delete $params{NO_MYMETA} if $eumm_version < 6.58;
    delete $params{AUTHOR} if $] < 5.005;
    delete $params{ABSTRACT_FROM} if $] < 5.005;
    delete $params{BINARY_LOCATION} if $] < 5.005;

    WriteMakefile(%params);
}

sub get_uuidpm_version {
    open my $fh, '<', 'UUID.pm' or die "open: UUID.pm: $!";
    while (<$fh>) {
        # $VERSION = '0.30_02';
        return $1
            if /^\$VERSION = '([\d\.\_]+)';$/;
    }
    return undef;
}


package MY;


#
# silence "cp_nonempty" bootstrap.
# silence chmod bootstrap.
#
sub dynamic_bs {
    my $t = shift->SUPER::dynamic_bs(@_);
    $t =~ s{^\t-}{\t-\$(NOECHO)}m;
    $t =~ s{CHMOD}{NOECHO) \$(CHMOD}s;
    $t;
}


#
# dont manifypods every.single.time.
#
sub manifypods {
    my $t = shift->SUPER::manifypods(@_);
    return $t if $t =~ /NOOP/;
    $t =~ s{\\$}{\\\n\t\$(INST_MAN3DIR)/UUID.\$(MAN3EXT)\n\n\$(INST_MAN3DIR)/UUID.\$(MAN3EXT): \\}ms;
    $t;
}


#
# add distlicense and distreadme prereqs.
# silence manicopy step during config.
#
sub distdir {
    my $t = shift->SUPER::distdir(@_);
    $t =~ s{^(distdir :.*?)\s*$}{$1 distlicense distreadme}m;
    $t =~ s{PERLRUN}{NOECHO) \$(PERLRUN};
    $t;
}


#
# remove metafile comments in manifest.
# make metafiles authoritative to cpan.
#@
sub distmeta {
    my $t = <<'EOS';
distmeta : create_distdir metafile
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd -e 'exit unless -e q{META.yml};' \
	  -e 'eval { maniadd({ q{META.yml} => q{} }) }' \
	  -e '    or die "Could not add META.yml to MANIFEST: $${'\''@'\''}"' --
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd -e 'exit unless -f q{META.json};' \
	  -e 'eval { maniadd({ q{META.json} => q{} }) }' \
	  -e '    or die "Could not add META.json to MANIFEST: $${'\''@'\''}"' --
EOS
    $t;
}


#
# add UUID_DISTTEST flag to 'make disttest'
#
sub dist_test {
    my $t = shift->SUPER::dist_test(@_);
    $t =~ s{ test }{ test UUID_DISTTEST=1 };
    $t;
}


#
# make TEST_VERBOSE=1 when AUTOMATED_TESTING=1
#
sub test {
    my $t = shift->SUPER::test(@_);
    if ( $ENV{AUTOMATED_TESTING}
        or $ENV{NONINTERACTIVE_TESTING}
        or $ENV{PERL_CPAN_REPORTER_CONFIG}
    ) {
        $t =~ s{TEST_VERBOSE=0}{TEST_VERBOSE=1}msg;
    }
    $t;
}


#
# add distlicense and distreadme targets.
# add autoconf generated targets.
# add explicit object rules.
#
sub postamble {
    return <<'EOP';
license: create_distdir
	$(NOECHO) $(ECHO) Generating LICENSE
	$(NOECHO) $(RM_F) LICENSE_new
	$(NOECHO) $(ABSPERLRUN) -MSoftware::License::Artistic_2_0 \
	  -e 'print Software::License::Artistic_2_0->new({holder => q{Rick Myers}, year => sprintf(qq{2014-%04d}, 1900+(localtime(time))[5])})->fulltext' \
	  > LICENSE_new
	$(NOECHO) $(MV) LICENSE_new $(DISTVNAME)/LICENSE

distlicense: create_distdir license
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd -e 'exit unless -e q{LICENSE};' \
	  -e 'eval { maniadd({ q{LICENSE} => q{} }) }' \
	  -e '    or die "Could not add LICENSE to MANIFEST: $${'\''@'\''}"' --
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -e 'print sort <>' MANIFEST > MANIFEST_new
	$(NOECHO) $(MV) $(DISTVNAME)/MANIFEST_new $(DISTVNAME)/MANIFEST

readme: create_distdir
	$(NOECHO) $(ECHO) Generating README
	$(NOECHO) $(RM_F) README_new
	$(NOECHO) pod2text UUID.pm README_new
	$(NOECHO) $(ABSPERLRUN) -i -pe's{\*(\S+)\*}{\1}g' README_new
	$(NOECHO) $(MV) README_new $(DISTVNAME)/README

distreadme: create_distdir readme
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd -e 'exit unless -e q{README};' \
	  -e 'eval { maniadd({ q{README} => q{} }) }' \
	  -e '    or die "Could not add README to MANIFEST: $${'\''@'\''}"' --
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -e 'print sort <>' MANIFEST > MANIFEST_new
	$(NOECHO) $(MV) $(DISTVNAME)/MANIFEST_new $(DISTVNAME)/MANIFEST

ulib/.exists:
	$(NOECHO) $(MKPATH) ulib$(DFSEP)uuid$(DFSEP)
	$(NOECHO) $(TOUCH) ulib$(DFSEP).exists

ulib/EUMM.h: $(FIRST_MAKEFILE) bin/configure.pl
	$(NOECHO) $(ECHO) Generating EUMM.h
	$(NOECHO) $(ABSPERLRUN) bin$(DFSEP)configure.pl

ulib/config.h: ulib/.exists usrc/config.h.in bin/subst.pl
	$(NOECHO) $(ECHO) Generating config.h
	$(NOECHO) $(ABSPERLRUN) bin$(DFSEP)subst.pl config.h
	$(NOECHO) $(ECHO) '#include <EUMM.h>' >> ulib$(DFSEP)config.h

ulib/dirpaths.h: ulib/.exists usrc/dirpaths.h.in bin/subst.pl
	$(NOECHO) $(ECHO) Generating dirpaths.h
	$(NOECHO) $(ABSPERLRUN) bin$(DFSEP)subst.pl dirpaths.h

ulib/uuid/uuid.h: ulib/.exists usrc/uuid/uuid.h.in bin/subst.pl
	$(NOECHO) $(ECHO) Generating uuid.h
	$(NOECHO) $(ABSPERLRUN) bin$(DFSEP)subst.pl uuid$(DFSEP)uuid.h

ulib/uuid/uuid_types.h: ulib/.exists usrc/uuid/uuid_types.h.in bin/subst.pl
	$(NOECHO) $(ECHO) Generating uuid_types.h
	$(NOECHO) $(ABSPERLRUN) bin$(DFSEP)subst.pl uuid$(DFSEP)uuid_types.h

config :: $(H_FILES)
	$(NOECHO) $(NOOP)

ulib/uuid/clear.o : usrc/uuid/clear.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o $@ $<

ulib/uuid/compare.o : usrc/uuid/compare.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o $@ $<

ulib/uuid/copy.o : usrc/uuid/copy.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o $@ $<

ulib/uuid/gen_uuid.o : usrc/uuid/gen_uuid.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o $@ $<

ulib/uuid/isnull.o : usrc/uuid/isnull.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o $@ $<

ulib/uuid/pack.o : usrc/uuid/pack.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o $@ $<

ulib/uuid/parse.o : usrc/uuid/parse.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o $@ $<

ulib/uuid/unpack.o : usrc/uuid/unpack.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o $@ $<

ulib/uuid/unparse.o : usrc/uuid/unparse.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o $@ $<

ulib/uuid/uuid_time.o : usrc/uuid/uuid_time.c
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o $@ $<

EOP
}
