#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patching types in uuidP.h.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
diff -aurN usrcP/uuid/uuidP.h usrcP.targ/uuid/uuidP.h
--- usrcP/uuid/uuidP.h	2023-12-02 17:58:13.894670000 +0200
+++ usrcP.targ/uuid/uuidP.h	2023-12-02 15:14:19.716523000 +0200
@@ -32,11 +32,7 @@
  * %End-Header%
  */
 
-#ifdef HAVE_INTTYPES_H
-#include <inttypes.h>
-#else
 #include <uuid/uuid_types.h>
-#endif
 #include <sys/types.h>
 
 #include <uuid/uuid.h>
@@ -48,11 +44,11 @@
 #define TIME_OFFSET_LOW  0x13814000
 
 struct uuid {
-	uint32_t	time_low;
-	uint16_t	time_mid;
-	uint16_t	time_hi_and_version;
-	uint16_t	clock_seq;
-	uint8_t	node[6];
+	myuint32_t	time_low;
+	myuint16_t	time_mid;
+	myuint16_t	time_hi_and_version;
+	myuint16_t	clock_seq;
+	myuint8_t	node[6];
 };
 
 #ifndef __GNUC_PREREQ
