/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.security.AccessControlException;
import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.VBucketStore;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryGetCommand;
import org.couchbase.mock.memcached.protocol.BinaryGetResponse;
import org.couchbase.mock.memcached.protocol.CommandCode;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class GetCommandExecutor
implements CommandExecutor {
    static final int DEFAULT_EXPIRY_TIME = 15;
    static final int MAXIMUM_EXPIRY_TIME = 29;

    @Override
    public void execute(BinaryCommand command, MemcachedServer server, MemcachedConnection client) {
        Item item;
        VBucketStore cache;
        BinaryGetCommand cmd = (BinaryGetCommand)command;
        CommandCode cc = cmd.getComCode();
        if (cc == CommandCode.GET_REPLICA) {
            cache = server.getStorage().getCache(cmd.getVBucketId());
            if (!server.getStorage().getVBucketInfo(cmd.getVBucketId()).hasAccess(server)) {
                throw new AccessControlException("we're not a master or replica");
            }
        } else {
            cache = server.getStorage().getCache(server, cmd.getVBucketId());
        }
        if ((item = cache.get(cmd.getKeySpec())) == null) {
            if (cc != CommandCode.GETKQ && cc != CommandCode.GETQ && cc != CommandCode.GATQ) {
                client.sendResponse(new BinaryGetResponse((BinaryCommand)cmd, ErrorCode.KEY_ENOENT));
            }
            return;
        }
        if (cc == CommandCode.GETL) {
            if (item.isLocked()) {
                client.sendResponse(new BinaryGetResponse((BinaryCommand)cmd, ErrorCode.ETMPFAIL));
                return;
            }
            int lockExpiryTime = cmd.getExpiration();
            if (lockExpiryTime == 0 || lockExpiryTime > 29) {
                lockExpiryTime = 15;
            }
            item.setLockExpiryTime(lockExpiryTime);
            cache.onItemMutated.onAction(cache, item);
        } else if (cc == CommandCode.TOUCH || cc == CommandCode.GAT || cc == CommandCode.GATQ) {
            item.setExpiryTime(cmd.getExpiration());
            cache.onItemMutated.onAction(cache, item);
        }
        if (cc == CommandCode.TOUCH) {
            client.sendResponse(new BinaryGetResponse((BinaryCommand)cmd, ErrorCode.SUCCESS));
        } else {
            client.sendResponse(new BinaryGetResponse((BinaryCommand)cmd, item));
        }
    }
}

