# This Makefile.PL for  was generated by Dist::Zilla.
# Don't edit it but the dist.ini used to construct it.

use strict;
use warnings;

use 5.006;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "The module to work with binary data effectively",
  "AUTHOR" => "Vladimir Timofeev <vovkasm\@gmail.com>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::CBuilder" => 0,
    "ExtUtils::MakeMaker" => "6.30",
    "File::Spec" => 0
  },
  "DISTNAME" => "Data-BinaryBuffer",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.006",
  "NAME" => "Data::BinaryBuffer",
  "PREREQ_PM" => {
    "XSLoader" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Capture::Tiny" => 0,
    "ExtUtils::MakeMaker" => 0,
    "File::Spec::Functions" => 0,
    "File::Temp" => 0,
    "List::Util" => 0,
    "Test::More" => "0.88",
    "blib" => 0
  },
  "VERSION" => "0.005",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  my $tr = delete $WriteMakefileArgs{TEST_REQUIRES};
  my $br = $WriteMakefileArgs{BUILD_REQUIRES};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

use Config ();
use Text::ParseWords 'shellwords';
use inc::CConf;

$WriteMakefileArgs{CONFIGURE} = sub {
    my %args;

    my $c = inc::CConf->new(config_file=>'binarybuffer-config.h');

    $c->need_cplusplus;
    $c->need_stl;

    my $test_sys_endian_h = <<"ENDCODE";
#include <sys/endian.h>
int main() { return 0; }
ENDCODE
    my $test_endian_h = <<"ENDCODE";
#include <endian.h>
int main() { return 0; }
ENDCODE

    $c->try_build(
        on_error => sub { die "Can't find hto* funtions on this platform" },
        try => [
            {
                code => $test_sys_endian_h,
                defs => { HAS_SYS_ENDIAN_H => 1 },
            },
            {
                code => $test_endian_h,
                defs => { HAS_ENDIAN_H => 1 },
            }
        ]
    );

    my $test_original_endian_macros = <<"ENDCODE";
#include "binarybuffer-config.h"
#if defined(HAS_ENDIAN_H)
    #include <endian.h>
#elif defined(HAS_SYS_ENDIAN_H)
    #include <sys/endian.h>
#endif
int main() {
    int val = betoh32(htobe32(0x11223344));
    return 0;
}
ENDCODE
    $c->try_build(
        on_error => sub { },
        try => [
            {
                code => $test_original_endian_macros,
                defs => { HAS_ORIGINAL_ENDIAN_MACROS => 1 },
            }
        ]
    );

    $c->generate_config_file;

    %args = $c->makemaker_args;

    $args{TYPEMAPS} = ['perlobject.map'];

    return \%args;
};

WriteMakefile(%WriteMakefileArgs);



