# Generated by default/object.tt
package Paws::Kendra::SortingConfiguration;
  use Moose;
  has DocumentAttributeKey => (is => 'ro', isa => 'Str', required => 1);
  has SortOrder => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::SortingConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::SortingConfiguration object:

  $service_obj->Method(Att1 => { DocumentAttributeKey => $value, ..., SortOrder => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::SortingConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->DocumentAttributeKey

=head1 DESCRIPTION

Specifies the document attribute to use to sort the response to a
Amazon Kendra query. You can specify a single attribute for sorting.
The attribute must have the C<Sortable> flag set to C<true>, otherwise
Amazon Kendra returns an exception.

You can sort attributes of the following types.

=over

=item *

Date value

=item *

Long value

=item *

String value

=back

You can't sort attributes of the following type.

=over

=item *

String list value

=back


=head1 ATTRIBUTES


=head2 B<REQUIRED> DocumentAttributeKey => Str

The name of the document attribute used to sort the response. You can
use any field that has the C<Sortable> flag set to true.

You can also sort by any of the following built-in attributes:

=over

=item *

_category

=item *

_created_at

=item *

_last_updated_at

=item *

_version

=item *

_view_count

=back



=head2 B<REQUIRED> SortOrder => Str

The order that the results should be returned in. In case of ties, the
relevance assigned to the result by Amazon Kendra is used as the
tie-breaker.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

