// Generated by CoffeeScript 1.12.8

/*
LemonLDAP::NG 2F registration script
 */

(function() {
  var delete2F, displayError, setMsg;

  setMsg = function(msg, level) {
    $('#msg').attr('trspan', msg);
    $('#msg').html(window.translate(msg));
    $('#color').removeClass('message-positive message-warning alert-success alert-warning');
    $('#color').addClass("message-" + level);
    if (level === 'positive') {
      level = 'success';
    }
    $('#color').addClass("alert-" + level);
    return $('#color').attr("role", "status");
  };

  displayError = function(j, status, err) {
    var res;
    console.log('Error', err);
    res = JSON.parse(j.responseText);
    if (res && res.error) {
      res = res.error.replace(/.* /, '');
      console.log('Returned error', res);
      if (res.match(/module/)) {
        return setMsg('notAuthorized', 'warning');
      } else {
        return setMsg(res, 'warning');
      }
    }
  };

  delete2F = function(device, epoch) {
    if (device === 'U2F') {
      device = 'u';
    } else if (device === 'UBK') {
      device = 'yubikey';
    } else if (device === 'TOTP') {
      device = 'totp';
    } else if (device === 'WebAuthn') {
      device = 'webauthn';
    } else {
      setMsg('u2fFailed', 'warning');
    }
    return $.ajax({
      type: "POST",
      url: portal + "2fregisters/" + device + "/delete",
      data: {
        epoch: epoch
      },
      dataType: 'json',
      error: displayError,
      success: function(resp) {
        if (resp.error) {
          if (resp.error.match(/notAuthorized/)) {
            return setMsg('notAuthorized', 'warning');
          } else {
            return setMsg('unknownAction', 'warning');
          }
        } else if (resp.result) {
          $("#delete-" + epoch).hide();
          $(document).trigger("mfaDeleted", [
            {
              "type": device,
              "epoch": epoch
            }
          ]);
          return setMsg('yourKeyIsUnregistered', 'positive');
        }
      },
      error: displayError
    });
  };

  $(document).ready(function() {
    $('body').on('click', '.remove2f', function() {
      return delete2F($(this).attr('device'), $(this).attr('epoch'));
    });
    $('#goback').attr('href', portal);
    return $(".data-epoch").each(function() {
      var myDate;
      myDate = new Date($(this).text() * 1000);
      return $(this).text(myDate.toLocaleString());
    });
  });

}).call(this);
