/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.Collection;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.StandardOutputResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryLibrary;
import net.sf.saxon.trans.packages.PackageLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerInfo {
    private Configuration config;
    private transient URIResolver uriResolver;
    private transient OutputURIResolver outputURIResolver = StandardOutputResolver.getInstance();
    private transient ErrorListener errorListener;
    private CodeInjector codeInjector;
    private int recoveryPolicy = 1;
    private boolean schemaAware;
    private String messageReceiverClassName = "net.sf.saxon.serialize.MessageEmitter";
    private StructuredQName defaultInitialMode;
    private StructuredQName defaultInitialTemplate;
    private FunctionLibrary extensionFunctionLibrary;
    private GlobalParameterSet suppliedParameters = new GlobalParameterSet();
    private String defaultCollation;
    private PackageLibrary packageLibrary;
    private boolean generateByteCode = false;
    private boolean assertionsEnabled = false;
    private String targetEdition = "HE";
    private boolean jitFlag = false;
    private boolean relocatable = false;
    private Collection<QueryLibrary> queryLibraries;

    public CompilerInfo(Configuration config) {
        this.config = config;
        this.packageLibrary = new PackageLibrary(this);
    }

    public CompilerInfo(CompilerInfo info) {
        this.copyFrom(info);
    }

    public void copyFrom(CompilerInfo info) {
        this.config = info.config;
        this.uriResolver = info.uriResolver;
        this.outputURIResolver = info.outputURIResolver;
        this.errorListener = info.errorListener;
        this.codeInjector = info.codeInjector;
        this.recoveryPolicy = info.recoveryPolicy;
        this.schemaAware = info.schemaAware;
        this.messageReceiverClassName = info.messageReceiverClassName;
        this.defaultInitialMode = info.defaultInitialMode;
        this.defaultInitialTemplate = info.defaultInitialTemplate;
        this.generateByteCode = info.generateByteCode;
        this.extensionFunctionLibrary = info.extensionFunctionLibrary;
        this.suppliedParameters = new GlobalParameterSet(info.suppliedParameters);
        this.defaultCollation = info.defaultCollation;
        this.assertionsEnabled = info.assertionsEnabled;
        this.targetEdition = info.targetEdition;
        this.packageLibrary = new PackageLibrary(info.packageLibrary);
        this.jitFlag = info.jitFlag;
        this.relocatable = info.relocatable;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setJustInTimeCompilation(boolean jit) {
        this.jitFlag = jit;
    }

    public boolean isJustInTimeCompilation() {
        return this.jitFlag;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public void setParameter(StructuredQName name, Sequence seq) {
        this.suppliedParameters.put(name, seq);
    }

    public GlobalParameterSet getParameters() {
        return this.suppliedParameters;
    }

    public void clearParameters() {
        this.suppliedParameters.clear();
    }

    public void setTargetEdition(String edition) {
        this.targetEdition = edition;
    }

    public String getTargetEdition() {
        return this.targetEdition;
    }

    public boolean isRelocatable() {
        return this.relocatable;
    }

    public void setRelocatable(boolean relocatable) {
        this.relocatable = relocatable;
    }

    public void setPackageLibrary(PackageLibrary library) {
        this.packageLibrary = library;
    }

    public PackageLibrary getPackageLibrary() {
        return this.packageLibrary;
    }

    public boolean isAssertionsEnabled() {
        return this.assertionsEnabled;
    }

    public void setAssertionsEnabled(boolean enabled) {
        this.assertionsEnabled = enabled;
    }

    public void setGenerateByteCode(boolean option) {
        this.generateByteCode = option;
    }

    public boolean isGenerateByteCode() {
        return this.generateByteCode;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.outputURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public String getMessageReceiverClassName() {
        return this.messageReceiverClassName;
    }

    public void setMessageReceiverClassName(String messageReceiverClassName) {
        this.messageReceiverClassName = messageReceiverClassName;
    }

    public void setDefaultCollation(String collation) {
        this.defaultCollation = collation;
    }

    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    public void setCodeInjector(CodeInjector injector) {
        this.codeInjector = injector;
    }

    public CodeInjector getCodeInjector() {
        return this.codeInjector;
    }

    public boolean isCompileWithTracing() {
        return this.codeInjector != null;
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public boolean isVersionWarning() {
        return false;
    }

    public void setVersionWarning(boolean warn) {
    }

    public void setSchemaAware(boolean schemaAware) {
        this.schemaAware = schemaAware;
    }

    public boolean isSchemaAware() {
        return this.schemaAware;
    }

    public void setDefaultInitialTemplate(StructuredQName initialTemplate) {
        this.defaultInitialTemplate = initialTemplate;
    }

    public StructuredQName getDefaultInitialTemplate() {
        return this.defaultInitialTemplate;
    }

    public void setDefaultInitialMode(StructuredQName initialMode) {
        this.defaultInitialMode = initialMode;
    }

    public StructuredQName getDefaultInitialMode() {
        return this.defaultInitialMode;
    }

    public void setXsltVersion(int version) {
    }

    public int getXsltVersion() {
        return 30;
    }

    public void setExtensionFunctionLibrary(FunctionLibrary library) {
        this.extensionFunctionLibrary = library;
    }

    public FunctionLibrary getExtensionFunctionLibrary() {
        return this.extensionFunctionLibrary;
    }

    public void setXQueryLibraries(Collection<QueryLibrary> libraries) {
        this.queryLibraries = libraries;
    }

    public Collection<QueryLibrary> getQueryLibraries() {
        return this.queryLibraries;
    }
}

