#!perl -T

use 5.006;
use strict;
use warnings;
use Test::More;

plan tests => 52;

use Math::AnyNum qw(:trig float complex);

like(sin(2), qr/^0\.909297426825681695396019865911744\d*\z/);
like(cos(2), qr/^-0\.41614683654714238699756822950076\d*\z/);
like(tan(2), qr/^-2\.18503986326151899164330610231368\d*\z/);
like(sec(2), qr/^-2\.40299796172238098975460040142006\d*\z/);
like(csc(2), qr/^1\.099750170294616466756697397026312\d*\z/);
like(cot(2), qr/^-0\.45765755436028576375027741043204\d*\z/);

like(asin(2), qr/^1\.5707963267948966192313216916\d*\+1\.3169578969248167086250463473079684\d*i\z/);
like(acos(2), qr/^-1\.3169578969248167086250463473079\d*i\z/);
like(atan(2), qr/^1\.107148717794090503017065460178537\d*\z/);
like(asec(2), qr/^1\.047197551196597746154214461093167\d*\z/);
like(acsc(2), qr/^0\.523598775598298873077107230546583\d*\z/);
like(acot(2), qr/^0\.463647609000806116214256231461214\d*\z/);

is(asin('1/2'), acsc('2/1'));
is(acos('1/2'), asec('2/1'));

like(acot(0.5), qr/^1\.10714871779409050301706546017853\d*\z/);
like(acsc(0.5), qr/^1\.570796326794896619231321691639751\d*\+1\.3169578969248167086250463473079\d*i\z/);
like(asec(0.5), qr/^-1\.31695789692481670862504634730796\d*i\z/);

is(asin(complex('1/2')), acsc(complex('2/1')));
is(acos(complex('1/2')), asec(complex('2/1')));

like(acosh('1/2'),   qr/^1\.04719755119659774615421446109316762\d*i\z/);
like(acosh('-1.23'), qr/^0\.665863529156554832728774668615054\d*\+3\.141592653589793238462643383279\d*i\z/);

like(acosh(complex('1/2')),   qr/^1\.04719755119659774615421446109316762\d*i\z/);
like(acosh(complex('-1.23')), qr/^0\.665863529156554832728774668615054\d*\+3\.141592653589793238462643383279\d*i\z/);

like(asinh('1/2'),  qr/^0\.481211825059603447497758913424368423\d*\z/);
like(asinh('-3.4'), qr/^-1\.9378792776645006058489872118142060\d*\z/);

like(asinh(complex('1/2')),  qr/^0\.481211825059603447497758913424368423\d*\z/);
like(asinh(complex('-3.4')), qr/^-1\.9378792776645006058489872118142060\d*\z/);

like(asec('3+4i'), qr/^1\.45204559548748486502906471211\d*\+0\.16044553377450493239983442886234\d*i\z/);
like(acot('3+4i'), qr/^0\.12248933156343207708604124060\d*\-0\.15899719167999917436476103600701\d*i\z/);
like(acoth(0.5),   qr/^0\.54930614433405484569762261846\d*\+1\.57079632679489661923132169163975\d*i\z/);
like(acoth('1/2'), qr/^0\.54930614433405484569762261846\d*\+1\.57079632679489661923132169163975\d*i\z/);
like(acsc(0.5),    qr/^1\.57079632679489661923132169163\d*\+1\.31695789692481670862504634730796\d*i\z/);

like(asin('1/2'), qr/^0\.5235987755982988730771072305465838\d*\z/);
like(acot(42),    qr/^0\.023805026185069943453868055357790764\d*\z/);
like(acsc(42),    qr/^0\.0238117739606687425673014602053926\d*\z/);
like(acoth(42),   qr/^0\.023814024494627309803039570154219\d*\z/);
like(atan2(3, 4), qr/^0\.64350110879328438680280922871732\d*\z/);

like(atanh(3.5),    qr/^0\.293893332451059504094865570\d*\+1\.5707963267948966192313\d*i\z/);
like(atanh('1/2'),  qr/^0\.549306144334054845697622618\d*\z/);
like(atanh(-4),     qr/^-0\.25541281188299534160275704\d*\+1\.5707963267948966192313\d*i\z/);
like(atanh('3+4i'), qr/^0\.117500907311433888412734257\d*\+1\.4099210495965755225306\d*i\z/);

is(atanh(-1),    '-Inf');
is(atanh(0),     '0');
is(atanh('+1'),  'Inf');
is(atanh('NaN'), 'NaN');

like(rad2deg(2),          qr/^114\.591559026164641753596309628210340\d*/);
like(rad2deg(complex(2)), qr/^114\.591559026164641753596309628210340\d*/);
like(rad2deg(float(2)),   qr/^114\.591559026164641753596309628210340\d*/);
like(rad2deg('1/2'),      qr/^28\.6478897565411604383990774070525851662\d*/);
like(rad2deg('3+4i'),     qr/^171\.88733853924696263039446444231551099\d*\+229\.1831180523292835071926192564206\d*i\d*/);

like(deg2rad(13),     qr/^0\.22689280275926284500007979990351965\d*/);
like(deg2rad('3+4i'), qr/^0\.05235987755982988730771072305465\d*\+0\.069813170079773183076947630739544508\d*i\d*/);
