#!/usr/bin/perl -w

use strict;

use Test::More tests => 11;

BEGIN { use_ok 'Class::Fields::Fuxor' }

package Foo;

package Bar;

use Class::Fields::Attribs;
use Class::Fields::Fuxor;

BEGIN {
    add_fields('Yar', PUBLIC,       qw(Pub Pants));
    add_fields('Yar', PRIVATE,      qw(_Priv _Pantaloons));
    add_fields('Yar', PROTECTED,    qw(_Prot Armoured));
}

::is_deeply( get_fields('Yar'), \%Yar::FIELDS,           'get_fields()'  );
::is_deeply( get_attr('Yar'), $fields::attr{Yar},        'get_attr()'    );
::is_deeply([sort keys %{get_fields('Yar')}],
            [sort qw(Pub Pants _Priv _Pantaloons _Prot Armoured)],
            'add_fields()'
);

::ok( has_fields('Yar'),                    'has_fields(), true'    );
::ok( !has_fields('I::have::no::fields'),   'has_fields(), false'   );
::is( keys %{get_fields('I::have::no::fields')}, 0,
                                            'get_fields(), no fields' );
::ok( has_fields('I::have::no::fields'),    
                                            'has_fields(), autogenerated' );

# Make sure that has_fields() tests for just %FIELDS and not *FIELDS.
@Tricky::FIELDS = ();  () = @Tricky::FIELDS;
::ok( !has_fields('Tricky'),                    'has_fields(), trick'   );

my Yar $yar = [];

eval {
    $yar->{Pub}     = "Foo";
    $yar->{_Priv}   = "Bar";
    $yar->{Armoured}    = "Hey";
};
::ok($@ eq '' or $@ !~ /no such field/i) or diag $@;


# Test out all the functions as class methods.
package As::Meths;

use base qw( Class::Fields::Fuxor );
use Class::Fields::Attribs;
::ok( !As::Meths->has_fields,        'has_fields() false as method' );
As::Meths->add_fields( PUBLIC, qw(this that) );





