#! /usr/bin/env perl6

use v6.c;

use Ops::SI;
use Test;

my %prefixes = %(
	"decy"   => ((1d, 10¯¹,  "1d"), (0.1d, 10¯²,  "0.1d"), ((1/10)d, 10¯²,  "1/10th d")),
	"centy"  => ((1c, 10¯²,  "1c"), (0.1c, 10¯³,  "0.1c"), ((1/10)c, 10¯³,  "1/10th c")),
	"milli"  => ((1m, 10¯³,  "1m"), (0.1m, 10¯⁴,  "0.1m"), ((1/10)m, 10¯⁴,  "1/10th m")),
	"mikro"  => ((1µ, 10¯⁶,  "1µ"), (0.1µ, 10¯⁷,  "0.1µ"), ((1/10)µ, 10¯⁷,  "1/10th µ")),
	"nano"   => ((1n, 10¯⁹,  "1n"), (0.1n, 10¯¹⁰, "0.1n"), ((1/10)n, 10¯¹⁰, "1/10th n")),
	"pico"   => ((1p, 10¯¹², "1p"), (0.1p, 10¯¹³, "0.1p"), ((1/10)p, 10¯¹³, "1/10th p")),
	"femto"  => ((1f, 10¯¹⁵, "1f"), (0.1f, 10¯¹⁶, "0.1f"), ((1/10)f, 10¯¹⁶, "1/10th f")),
	"atto"   => ((1a, 10¯¹⁸, "1a"), (0.1a, 10¯¹⁹, "0.1a"), ((1/10)a, 10¯¹⁹, "1/10th a")),
	"zepto"  => ((1z, 10¯²¹, "1z"), (0.1z, 10¯²², "0.1z"), ((1/10)z, 10¯²², "1/10th z")),
	"yokto"  => ((1y, 10¯²⁴, "1y"), (0.1y, 10¯²⁵, "0.1y"), ((1/10)y, 10¯²⁵, "1/10th y")),
);

plan %prefixes.elems;

for %prefixes.kv -> $prefix, @tests {
	subtest $prefix => {
		plan @tests.elems;

		for @tests -> @case {
			is |@case;
		}
	}
}

# vim: ft=perl6 noet
