use strict;
use warnings;
use utf8;

use FindBin;
use lib ("lib", "$FindBin::Bin/../blib/lib", "$FindBin::Bin/../blib/arch");

use Lingua::RU::Money::XS qw(rur2words);
use Test::Spec;

describe "Convert rubles to word, amount: " => sub {
	it "1000000000.00" => sub { is rur2words(1000000000.00), "один миллиард рублей 00 копеек"; };
	it "2000000000.00" => sub { is rur2words(2000000000.00), "два миллиарда рублей 00 копеек"; };
	it "3000000000.00" => sub { is rur2words(3000000000.00), "три миллиарда рублей 00 копеек"; };
	it "4000000000.00" => sub { is rur2words(4000000000.00), "четыре миллиарда рублей 00 копеек"; };
	it "5000000000.00" => sub { is rur2words(5000000000.00), "пять миллиардов рублей 00 копеек"; };
	it "6000000000.00" => sub { is rur2words(6000000000.00), "шесть миллиардов рублей 00 копеек"; };
	it "7000000000.00" => sub { is rur2words(7000000000.00), "семь миллиардов рублей 00 копеек"; };
	it "8000000000.00" => sub { is rur2words(8000000000.00), "восемь миллиардов рублей 00 копеек"; };
	it "9000000000.00" => sub { is rur2words(9000000000.00), "девять миллиардов рублей 00 копеек"; };
	it "10000000000.00" => sub { is rur2words(10000000000.00), "десять миллиардов рублей 00 копеек"; };
	it "11000000000.00" => sub { is rur2words(11000000000.00), "одиннадцать миллиардов рублей 00 копеек"; };
	it "12000000000.00" => sub { is rur2words(12000000000.00), "двенадцать миллиардов рублей 00 копеек"; };
	it "13000000000.00" => sub { is rur2words(13000000000.00), "тринадцать миллиардов рублей 00 копеек"; };
	it "14000000000.00" => sub { is rur2words(14000000000.00), "четырнадцать миллиардов рублей 00 копеек"; };
	it "15000000000.00" => sub { is rur2words(15000000000.00), "пятнадцать миллиардов рублей 00 копеек"; };
	it "16000000000.00" => sub { is rur2words(16000000000.00), "шестнадцать миллиардов рублей 00 копеек"; };
	it "17000000000.00" => sub { is rur2words(17000000000.00), "семнадцать миллиардов рублей 00 копеек"; };
	it "18000000000.00" => sub { is rur2words(18000000000.00), "восемнадцать миллиардов рублей 00 копеек"; };
	it "19000000000.00" => sub { is rur2words(19000000000.00), "девятнадцать миллиардов рублей 00 копеек"; };
	it "20000000000.00" => sub { is rur2words(20000000000.00), "двадцать миллиардов рублей 00 копеек"; };
	it "21000000000.00" => sub { is rur2words(21000000000.00), "двадцать один миллиард рублей 00 копеек"; };
	it "22000000000.00" => sub { is rur2words(22000000000.00), "двадцать два миллиарда рублей 00 копеек"; };
	it "23000000000.00" => sub { is rur2words(23000000000.00), "двадцать три миллиарда рублей 00 копеек"; };
	it "24000000000.00" => sub { is rur2words(24000000000.00), "двадцать четыре миллиарда рублей 00 копеек"; };
	it "25000000000.00" => sub { is rur2words(25000000000.00), "двадцать пять миллиардов рублей 00 копеек"; };
	it "26000000000.00" => sub { is rur2words(26000000000.00), "двадцать шесть миллиардов рублей 00 копеек"; };
	it "27000000000.00" => sub { is rur2words(27000000000.00), "двадцать семь миллиардов рублей 00 копеек"; };
	it "28000000000.00" => sub { is rur2words(28000000000.00), "двадцать восемь миллиардов рублей 00 копеек"; };
	it "29000000000.00" => sub { is rur2words(29000000000.00), "двадцать девять миллиардов рублей 00 копеек"; };
	it "30000000000.00" => sub { is rur2words(30000000000.00), "тридцать миллиардов рублей 00 копеек"; };
	it "31000000000.00" => sub { is rur2words(31000000000.00), "тридцать один миллиард рублей 00 копеек"; };
	it "32000000000.00" => sub { is rur2words(32000000000.00), "тридцать два миллиарда рублей 00 копеек"; };
	it "33000000000.00" => sub { is rur2words(33000000000.00), "тридцать три миллиарда рублей 00 копеек"; };
	it "34000000000.00" => sub { is rur2words(34000000000.00), "тридцать четыре миллиарда рублей 00 копеек"; };
	it "35000000000.00" => sub { is rur2words(35000000000.00), "тридцать пять миллиардов рублей 00 копеек"; };
	it "36000000000.00" => sub { is rur2words(36000000000.00), "тридцать шесть миллиардов рублей 00 копеек"; };
	it "37000000000.00" => sub { is rur2words(37000000000.00), "тридцать семь миллиардов рублей 00 копеек"; };
	it "38000000000.00" => sub { is rur2words(38000000000.00), "тридцать восемь миллиардов рублей 00 копеек"; };
	it "39000000000.00" => sub { is rur2words(39000000000.00), "тридцать девять миллиардов рублей 00 копеек"; };
	it "40000000000.00" => sub { is rur2words(40000000000.00), "сорок миллиардов рублей 00 копеек"; };
	it "41000000000.00" => sub { is rur2words(41000000000.00), "сорок один миллиард рублей 00 копеек"; };
	it "42000000000.00" => sub { is rur2words(42000000000.00), "сорок два миллиарда рублей 00 копеек"; };
	it "43000000000.00" => sub { is rur2words(43000000000.00), "сорок три миллиарда рублей 00 копеек"; };
	it "44000000000.00" => sub { is rur2words(44000000000.00), "сорок четыре миллиарда рублей 00 копеек"; };
	it "45000000000.00" => sub { is rur2words(45000000000.00), "сорок пять миллиардов рублей 00 копеек"; };
	it "46000000000.00" => sub { is rur2words(46000000000.00), "сорок шесть миллиардов рублей 00 копеек"; };
	it "47000000000.00" => sub { is rur2words(47000000000.00), "сорок семь миллиардов рублей 00 копеек"; };
	it "48000000000.00" => sub { is rur2words(48000000000.00), "сорок восемь миллиардов рублей 00 копеек"; };
	it "49000000000.00" => sub { is rur2words(49000000000.00), "сорок девять миллиардов рублей 00 копеек"; };
	it "50000000000.00" => sub { is rur2words(50000000000.00), "пятьдесят миллиардов рублей 00 копеек"; };
	it "51000000000.00" => sub { is rur2words(51000000000.00), "пятьдесят один миллиард рублей 00 копеек"; };
	it "52000000000.00" => sub { is rur2words(52000000000.00), "пятьдесят два миллиарда рублей 00 копеек"; };
	it "53000000000.00" => sub { is rur2words(53000000000.00), "пятьдесят три миллиарда рублей 00 копеек"; };
	it "54000000000.00" => sub { is rur2words(54000000000.00), "пятьдесят четыре миллиарда рублей 00 копеек"; };
	it "55000000000.00" => sub { is rur2words(55000000000.00), "пятьдесят пять миллиардов рублей 00 копеек"; };
	it "56000000000.00" => sub { is rur2words(56000000000.00), "пятьдесят шесть миллиардов рублей 00 копеек"; };
	it "57000000000.00" => sub { is rur2words(57000000000.00), "пятьдесят семь миллиардов рублей 00 копеек"; };
	it "58000000000.00" => sub { is rur2words(58000000000.00), "пятьдесят восемь миллиардов рублей 00 копеек"; };
	it "59000000000.00" => sub { is rur2words(59000000000.00), "пятьдесят девять миллиардов рублей 00 копеек"; };
	it "60000000000.00" => sub { is rur2words(60000000000.00), "шестьдесят миллиардов рублей 00 копеек"; };
	it "61000000000.00" => sub { is rur2words(61000000000.00), "шестьдесят один миллиард рублей 00 копеек"; };
	it "62000000000.00" => sub { is rur2words(62000000000.00), "шестьдесят два миллиарда рублей 00 копеек"; };
	it "63000000000.00" => sub { is rur2words(63000000000.00), "шестьдесят три миллиарда рублей 00 копеек"; };
	it "64000000000.00" => sub { is rur2words(64000000000.00), "шестьдесят четыре миллиарда рублей 00 копеек"; };
	it "65000000000.00" => sub { is rur2words(65000000000.00), "шестьдесят пять миллиардов рублей 00 копеек"; };
	it "66000000000.00" => sub { is rur2words(66000000000.00), "шестьдесят шесть миллиардов рублей 00 копеек"; };
	it "67000000000.00" => sub { is rur2words(67000000000.00), "шестьдесят семь миллиардов рублей 00 копеек"; };
	it "68000000000.00" => sub { is rur2words(68000000000.00), "шестьдесят восемь миллиардов рублей 00 копеек"; };
	it "69000000000.00" => sub { is rur2words(69000000000.00), "шестьдесят девять миллиардов рублей 00 копеек"; };
	it "70000000000.00" => sub { is rur2words(70000000000.00), "семьдесят миллиардов рублей 00 копеек"; };
	it "71000000000.00" => sub { is rur2words(71000000000.00), "семьдесят один миллиард рублей 00 копеек"; };
	it "72000000000.00" => sub { is rur2words(72000000000.00), "семьдесят два миллиарда рублей 00 копеек"; };
	it "73000000000.00" => sub { is rur2words(73000000000.00), "семьдесят три миллиарда рублей 00 копеек"; };
	it "74000000000.00" => sub { is rur2words(74000000000.00), "семьдесят четыре миллиарда рублей 00 копеек"; };
	it "75000000000.00" => sub { is rur2words(75000000000.00), "семьдесят пять миллиардов рублей 00 копеек"; };
	it "76000000000.00" => sub { is rur2words(76000000000.00), "семьдесят шесть миллиардов рублей 00 копеек"; };
	it "77000000000.00" => sub { is rur2words(77000000000.00), "семьдесят семь миллиардов рублей 00 копеек"; };
	it "78000000000.00" => sub { is rur2words(78000000000.00), "семьдесят восемь миллиардов рублей 00 копеек"; };
	it "79000000000.00" => sub { is rur2words(79000000000.00), "семьдесят девять миллиардов рублей 00 копеек"; };
	it "80000000000.00" => sub { is rur2words(80000000000.00), "восемьдесят миллиардов рублей 00 копеек"; };
	it "81000000000.00" => sub { is rur2words(81000000000.00), "восемьдесят один миллиард рублей 00 копеек"; };
	it "82000000000.00" => sub { is rur2words(82000000000.00), "восемьдесят два миллиарда рублей 00 копеек"; };
	it "83000000000.00" => sub { is rur2words(83000000000.00), "восемьдесят три миллиарда рублей 00 копеек"; };
	it "84000000000.00" => sub { is rur2words(84000000000.00), "восемьдесят четыре миллиарда рублей 00 копеек"; };
	it "85000000000.00" => sub { is rur2words(85000000000.00), "восемьдесят пять миллиардов рублей 00 копеек"; };
	it "86000000000.00" => sub { is rur2words(86000000000.00), "восемьдесят шесть миллиардов рублей 00 копеек"; };
	it "87000000000.00" => sub { is rur2words(87000000000.00), "восемьдесят семь миллиардов рублей 00 копеек"; };
	it "88000000000.00" => sub { is rur2words(88000000000.00), "восемьдесят восемь миллиардов рублей 00 копеек"; };
	it "89000000000.00" => sub { is rur2words(89000000000.00), "восемьдесят девять миллиардов рублей 00 копеек"; };
	it "90000000000.00" => sub { is rur2words(90000000000.00), "девяносто миллиардов рублей 00 копеек"; };
	it "91000000000.00" => sub { is rur2words(91000000000.00), "девяносто один миллиард рублей 00 копеек"; };
	it "92000000000.00" => sub { is rur2words(92000000000.00), "девяносто два миллиарда рублей 00 копеек"; };
	it "93000000000.00" => sub { is rur2words(93000000000.00), "девяносто три миллиарда рублей 00 копеек"; };
	it "94000000000.00" => sub { is rur2words(94000000000.00), "девяносто четыре миллиарда рублей 00 копеек"; };
	it "95000000000.00" => sub { is rur2words(95000000000.00), "девяносто пять миллиардов рублей 00 копеек"; };
	it "96000000000.00" => sub { is rur2words(96000000000.00), "девяносто шесть миллиардов рублей 00 копеек"; };
	it "97000000000.00" => sub { is rur2words(97000000000.00), "девяносто семь миллиардов рублей 00 копеек"; };
	it "98000000000.00" => sub { is rur2words(98000000000.00), "девяносто восемь миллиардов рублей 00 копеек"; };
	it "99000000000.00" => sub { is rur2words(99000000000.00), "девяносто девять миллиардов рублей 00 копеек"; };
	it "100000000000.00" => sub { is rur2words(100000000000.00), "сто миллиардов рублей 00 копеек"; };
	it "101000000000.00" => sub { is rur2words(101000000000.00), "сто один миллиард рублей 00 копеек"; };
	it "102000000000.00" => sub { is rur2words(102000000000.00), "сто два миллиарда рублей 00 копеек"; };
	it "103000000000.00" => sub { is rur2words(103000000000.00), "сто три миллиарда рублей 00 копеек"; };
	it "104000000000.00" => sub { is rur2words(104000000000.00), "сто четыре миллиарда рублей 00 копеек"; };
	it "105000000000.00" => sub { is rur2words(105000000000.00), "сто пять миллиардов рублей 00 копеек"; };
	it "106000000000.00" => sub { is rur2words(106000000000.00), "сто шесть миллиардов рублей 00 копеек"; };
	it "107000000000.00" => sub { is rur2words(107000000000.00), "сто семь миллиардов рублей 00 копеек"; };
	it "108000000000.00" => sub { is rur2words(108000000000.00), "сто восемь миллиардов рублей 00 копеек"; };
	it "109000000000.00" => sub { is rur2words(109000000000.00), "сто девять миллиардов рублей 00 копеек"; };
	it "110000000000.00" => sub { is rur2words(110000000000.00), "сто десять миллиардов рублей 00 копеек"; };
	it "111000000000.00" => sub { is rur2words(111000000000.00), "сто одиннадцать миллиардов рублей 00 копеек"; };
	it "112000000000.00" => sub { is rur2words(112000000000.00), "сто двенадцать миллиардов рублей 00 копеек"; };
	it "113000000000.00" => sub { is rur2words(113000000000.00), "сто тринадцать миллиардов рублей 00 копеек"; };
	it "114000000000.00" => sub { is rur2words(114000000000.00), "сто четырнадцать миллиардов рублей 00 копеек"; };
	it "115000000000.00" => sub { is rur2words(115000000000.00), "сто пятнадцать миллиардов рублей 00 копеек"; };
	it "116000000000.00" => sub { is rur2words(116000000000.00), "сто шестнадцать миллиардов рублей 00 копеек"; };
	it "117000000000.00" => sub { is rur2words(117000000000.00), "сто семнадцать миллиардов рублей 00 копеек"; };
	it "118000000000.00" => sub { is rur2words(118000000000.00), "сто восемнадцать миллиардов рублей 00 копеек"; };
	it "119000000000.00" => sub { is rur2words(119000000000.00), "сто девятнадцать миллиардов рублей 00 копеек"; };
	it "120000000000.00" => sub { is rur2words(120000000000.00), "сто двадцать миллиардов рублей 00 копеек"; };
	it "121000000000.00" => sub { is rur2words(121000000000.00), "сто двадцать один миллиард рублей 00 копеек"; };
	it "122000000000.00" => sub { is rur2words(122000000000.00), "сто двадцать два миллиарда рублей 00 копеек"; };
	it "123000000000.00" => sub { is rur2words(123000000000.00), "сто двадцать три миллиарда рублей 00 копеек"; };
	it "124000000000.00" => sub { is rur2words(124000000000.00), "сто двадцать четыре миллиарда рублей 00 копеек"; };
	it "125000000000.00" => sub { is rur2words(125000000000.00), "сто двадцать пять миллиардов рублей 00 копеек"; };
	it "126000000000.00" => sub { is rur2words(126000000000.00), "сто двадцать шесть миллиардов рублей 00 копеек"; };
	it "127000000000.00" => sub { is rur2words(127000000000.00), "сто двадцать семь миллиардов рублей 00 копеек"; };
	it "128000000000.00" => sub { is rur2words(128000000000.00), "сто двадцать восемь миллиардов рублей 00 копеек"; };
	it "129000000000.00" => sub { is rur2words(129000000000.00), "сто двадцать девять миллиардов рублей 00 копеек"; };
	it "130000000000.00" => sub { is rur2words(130000000000.00), "сто тридцать миллиардов рублей 00 копеек"; };
	it "131000000000.00" => sub { is rur2words(131000000000.00), "сто тридцать один миллиард рублей 00 копеек"; };
	it "132000000000.00" => sub { is rur2words(132000000000.00), "сто тридцать два миллиарда рублей 00 копеек"; };
	it "133000000000.00" => sub { is rur2words(133000000000.00), "сто тридцать три миллиарда рублей 00 копеек"; };
	it "134000000000.00" => sub { is rur2words(134000000000.00), "сто тридцать четыре миллиарда рублей 00 копеек"; };
	it "135000000000.00" => sub { is rur2words(135000000000.00), "сто тридцать пять миллиардов рублей 00 копеек"; };
	it "136000000000.00" => sub { is rur2words(136000000000.00), "сто тридцать шесть миллиардов рублей 00 копеек"; };
	it "137000000000.00" => sub { is rur2words(137000000000.00), "сто тридцать семь миллиардов рублей 00 копеек"; };
	it "138000000000.00" => sub { is rur2words(138000000000.00), "сто тридцать восемь миллиардов рублей 00 копеек"; };
	it "139000000000.00" => sub { is rur2words(139000000000.00), "сто тридцать девять миллиардов рублей 00 копеек"; };
	it "140000000000.00" => sub { is rur2words(140000000000.00), "сто сорок миллиардов рублей 00 копеек"; };
	it "141000000000.00" => sub { is rur2words(141000000000.00), "сто сорок один миллиард рублей 00 копеек"; };
	it "142000000000.00" => sub { is rur2words(142000000000.00), "сто сорок два миллиарда рублей 00 копеек"; };
	it "143000000000.00" => sub { is rur2words(143000000000.00), "сто сорок три миллиарда рублей 00 копеек"; };
	it "144000000000.00" => sub { is rur2words(144000000000.00), "сто сорок четыре миллиарда рублей 00 копеек"; };
	it "145000000000.00" => sub { is rur2words(145000000000.00), "сто сорок пять миллиардов рублей 00 копеек"; };
	it "146000000000.00" => sub { is rur2words(146000000000.00), "сто сорок шесть миллиардов рублей 00 копеек"; };
	it "147000000000.00" => sub { is rur2words(147000000000.00), "сто сорок семь миллиардов рублей 00 копеек"; };
	it "148000000000.00" => sub { is rur2words(148000000000.00), "сто сорок восемь миллиардов рублей 00 копеек"; };
	it "149000000000.00" => sub { is rur2words(149000000000.00), "сто сорок девять миллиардов рублей 00 копеек"; };
	it "150000000000.00" => sub { is rur2words(150000000000.00), "сто пятьдесят миллиардов рублей 00 копеек"; };
	it "151000000000.00" => sub { is rur2words(151000000000.00), "сто пятьдесят один миллиард рублей 00 копеек"; };
	it "152000000000.00" => sub { is rur2words(152000000000.00), "сто пятьдесят два миллиарда рублей 00 копеек"; };
	it "153000000000.00" => sub { is rur2words(153000000000.00), "сто пятьдесят три миллиарда рублей 00 копеек"; };
	it "154000000000.00" => sub { is rur2words(154000000000.00), "сто пятьдесят четыре миллиарда рублей 00 копеек"; };
	it "155000000000.00" => sub { is rur2words(155000000000.00), "сто пятьдесят пять миллиардов рублей 00 копеек"; };
	it "156000000000.00" => sub { is rur2words(156000000000.00), "сто пятьдесят шесть миллиардов рублей 00 копеек"; };
	it "157000000000.00" => sub { is rur2words(157000000000.00), "сто пятьдесят семь миллиардов рублей 00 копеек"; };
	it "158000000000.00" => sub { is rur2words(158000000000.00), "сто пятьдесят восемь миллиардов рублей 00 копеек"; };
	it "159000000000.00" => sub { is rur2words(159000000000.00), "сто пятьдесят девять миллиардов рублей 00 копеек"; };
	it "160000000000.00" => sub { is rur2words(160000000000.00), "сто шестьдесят миллиардов рублей 00 копеек"; };
	it "161000000000.00" => sub { is rur2words(161000000000.00), "сто шестьдесят один миллиард рублей 00 копеек"; };
	it "162000000000.00" => sub { is rur2words(162000000000.00), "сто шестьдесят два миллиарда рублей 00 копеек"; };
	it "163000000000.00" => sub { is rur2words(163000000000.00), "сто шестьдесят три миллиарда рублей 00 копеек"; };
	it "164000000000.00" => sub { is rur2words(164000000000.00), "сто шестьдесят четыре миллиарда рублей 00 копеек"; };
	it "165000000000.00" => sub { is rur2words(165000000000.00), "сто шестьдесят пять миллиардов рублей 00 копеек"; };
	it "166000000000.00" => sub { is rur2words(166000000000.00), "сто шестьдесят шесть миллиардов рублей 00 копеек"; };
	it "167000000000.00" => sub { is rur2words(167000000000.00), "сто шестьдесят семь миллиардов рублей 00 копеек"; };
	it "168000000000.00" => sub { is rur2words(168000000000.00), "сто шестьдесят восемь миллиардов рублей 00 копеек"; };
	it "169000000000.00" => sub { is rur2words(169000000000.00), "сто шестьдесят девять миллиардов рублей 00 копеек"; };
	it "170000000000.00" => sub { is rur2words(170000000000.00), "сто семьдесят миллиардов рублей 00 копеек"; };
	it "171000000000.00" => sub { is rur2words(171000000000.00), "сто семьдесят один миллиард рублей 00 копеек"; };
	it "172000000000.00" => sub { is rur2words(172000000000.00), "сто семьдесят два миллиарда рублей 00 копеек"; };
	it "173000000000.00" => sub { is rur2words(173000000000.00), "сто семьдесят три миллиарда рублей 00 копеек"; };
	it "174000000000.00" => sub { is rur2words(174000000000.00), "сто семьдесят четыре миллиарда рублей 00 копеек"; };
	it "175000000000.00" => sub { is rur2words(175000000000.00), "сто семьдесят пять миллиардов рублей 00 копеек"; };
	it "176000000000.00" => sub { is rur2words(176000000000.00), "сто семьдесят шесть миллиардов рублей 00 копеек"; };
	it "177000000000.00" => sub { is rur2words(177000000000.00), "сто семьдесят семь миллиардов рублей 00 копеек"; };
	it "178000000000.00" => sub { is rur2words(178000000000.00), "сто семьдесят восемь миллиардов рублей 00 копеек"; };
	it "179000000000.00" => sub { is rur2words(179000000000.00), "сто семьдесят девять миллиардов рублей 00 копеек"; };
	it "180000000000.00" => sub { is rur2words(180000000000.00), "сто восемьдесят миллиардов рублей 00 копеек"; };
	it "181000000000.00" => sub { is rur2words(181000000000.00), "сто восемьдесят один миллиард рублей 00 копеек"; };
	it "182000000000.00" => sub { is rur2words(182000000000.00), "сто восемьдесят два миллиарда рублей 00 копеек"; };
	it "183000000000.00" => sub { is rur2words(183000000000.00), "сто восемьдесят три миллиарда рублей 00 копеек"; };
	it "184000000000.00" => sub { is rur2words(184000000000.00), "сто восемьдесят четыре миллиарда рублей 00 копеек"; };
	it "185000000000.00" => sub { is rur2words(185000000000.00), "сто восемьдесят пять миллиардов рублей 00 копеек"; };
	it "186000000000.00" => sub { is rur2words(186000000000.00), "сто восемьдесят шесть миллиардов рублей 00 копеек"; };
	it "187000000000.00" => sub { is rur2words(187000000000.00), "сто восемьдесят семь миллиардов рублей 00 копеек"; };
	it "188000000000.00" => sub { is rur2words(188000000000.00), "сто восемьдесят восемь миллиардов рублей 00 копеек"; };
	it "189000000000.00" => sub { is rur2words(189000000000.00), "сто восемьдесят девять миллиардов рублей 00 копеек"; };
	it "190000000000.00" => sub { is rur2words(190000000000.00), "сто девяносто миллиардов рублей 00 копеек"; };
	it "191000000000.00" => sub { is rur2words(191000000000.00), "сто девяносто один миллиард рублей 00 копеек"; };
	it "192000000000.00" => sub { is rur2words(192000000000.00), "сто девяносто два миллиарда рублей 00 копеек"; };
	it "193000000000.00" => sub { is rur2words(193000000000.00), "сто девяносто три миллиарда рублей 00 копеек"; };
	it "194000000000.00" => sub { is rur2words(194000000000.00), "сто девяносто четыре миллиарда рублей 00 копеек"; };
	it "195000000000.00" => sub { is rur2words(195000000000.00), "сто девяносто пять миллиардов рублей 00 копеек"; };
	it "196000000000.00" => sub { is rur2words(196000000000.00), "сто девяносто шесть миллиардов рублей 00 копеек"; };
	it "197000000000.00" => sub { is rur2words(197000000000.00), "сто девяносто семь миллиардов рублей 00 копеек"; };
	it "198000000000.00" => sub { is rur2words(198000000000.00), "сто девяносто восемь миллиардов рублей 00 копеек"; };
	it "199000000000.00" => sub { is rur2words(199000000000.00), "сто девяносто девять миллиардов рублей 00 копеек"; };
	it "200000000000.00" => sub { is rur2words(200000000000.00), "двести миллиардов рублей 00 копеек"; };
	it "201000000000.00" => sub { is rur2words(201000000000.00), "двести один миллиард рублей 00 копеек"; };
	it "202000000000.00" => sub { is rur2words(202000000000.00), "двести два миллиарда рублей 00 копеек"; };
	it "203000000000.00" => sub { is rur2words(203000000000.00), "двести три миллиарда рублей 00 копеек"; };
	it "204000000000.00" => sub { is rur2words(204000000000.00), "двести четыре миллиарда рублей 00 копеек"; };
	it "205000000000.00" => sub { is rur2words(205000000000.00), "двести пять миллиардов рублей 00 копеек"; };
	it "206000000000.00" => sub { is rur2words(206000000000.00), "двести шесть миллиардов рублей 00 копеек"; };
	it "207000000000.00" => sub { is rur2words(207000000000.00), "двести семь миллиардов рублей 00 копеек"; };
	it "208000000000.00" => sub { is rur2words(208000000000.00), "двести восемь миллиардов рублей 00 копеек"; };
	it "209000000000.00" => sub { is rur2words(209000000000.00), "двести девять миллиардов рублей 00 копеек"; };
	it "210000000000.00" => sub { is rur2words(210000000000.00), "двести десять миллиардов рублей 00 копеек"; };
	it "211000000000.00" => sub { is rur2words(211000000000.00), "двести одиннадцать миллиардов рублей 00 копеек"; };
	it "212000000000.00" => sub { is rur2words(212000000000.00), "двести двенадцать миллиардов рублей 00 копеек"; };
	it "213000000000.00" => sub { is rur2words(213000000000.00), "двести тринадцать миллиардов рублей 00 копеек"; };
	it "214000000000.00" => sub { is rur2words(214000000000.00), "двести четырнадцать миллиардов рублей 00 копеек"; };
	it "215000000000.00" => sub { is rur2words(215000000000.00), "двести пятнадцать миллиардов рублей 00 копеек"; };
	it "216000000000.00" => sub { is rur2words(216000000000.00), "двести шестнадцать миллиардов рублей 00 копеек"; };
	it "217000000000.00" => sub { is rur2words(217000000000.00), "двести семнадцать миллиардов рублей 00 копеек"; };
	it "218000000000.00" => sub { is rur2words(218000000000.00), "двести восемнадцать миллиардов рублей 00 копеек"; };
	it "219000000000.00" => sub { is rur2words(219000000000.00), "двести девятнадцать миллиардов рублей 00 копеек"; };
	it "220000000000.00" => sub { is rur2words(220000000000.00), "двести двадцать миллиардов рублей 00 копеек"; };
	it "221000000000.00" => sub { is rur2words(221000000000.00), "двести двадцать один миллиард рублей 00 копеек"; };
	it "222000000000.00" => sub { is rur2words(222000000000.00), "двести двадцать два миллиарда рублей 00 копеек"; };
	it "223000000000.00" => sub { is rur2words(223000000000.00), "двести двадцать три миллиарда рублей 00 копеек"; };
	it "224000000000.00" => sub { is rur2words(224000000000.00), "двести двадцать четыре миллиарда рублей 00 копеек"; };
	it "225000000000.00" => sub { is rur2words(225000000000.00), "двести двадцать пять миллиардов рублей 00 копеек"; };
	it "226000000000.00" => sub { is rur2words(226000000000.00), "двести двадцать шесть миллиардов рублей 00 копеек"; };
	it "227000000000.00" => sub { is rur2words(227000000000.00), "двести двадцать семь миллиардов рублей 00 копеек"; };
	it "228000000000.00" => sub { is rur2words(228000000000.00), "двести двадцать восемь миллиардов рублей 00 копеек"; };
	it "229000000000.00" => sub { is rur2words(229000000000.00), "двести двадцать девять миллиардов рублей 00 копеек"; };
	it "230000000000.00" => sub { is rur2words(230000000000.00), "двести тридцать миллиардов рублей 00 копеек"; };
	it "231000000000.00" => sub { is rur2words(231000000000.00), "двести тридцать один миллиард рублей 00 копеек"; };
	it "232000000000.00" => sub { is rur2words(232000000000.00), "двести тридцать два миллиарда рублей 00 копеек"; };
	it "233000000000.00" => sub { is rur2words(233000000000.00), "двести тридцать три миллиарда рублей 00 копеек"; };
	it "234000000000.00" => sub { is rur2words(234000000000.00), "двести тридцать четыре миллиарда рублей 00 копеек"; };
	it "235000000000.00" => sub { is rur2words(235000000000.00), "двести тридцать пять миллиардов рублей 00 копеек"; };
	it "236000000000.00" => sub { is rur2words(236000000000.00), "двести тридцать шесть миллиардов рублей 00 копеек"; };
	it "237000000000.00" => sub { is rur2words(237000000000.00), "двести тридцать семь миллиардов рублей 00 копеек"; };
	it "238000000000.00" => sub { is rur2words(238000000000.00), "двести тридцать восемь миллиардов рублей 00 копеек"; };
	it "239000000000.00" => sub { is rur2words(239000000000.00), "двести тридцать девять миллиардов рублей 00 копеек"; };
	it "240000000000.00" => sub { is rur2words(240000000000.00), "двести сорок миллиардов рублей 00 копеек"; };
	it "241000000000.00" => sub { is rur2words(241000000000.00), "двести сорок один миллиард рублей 00 копеек"; };
	it "242000000000.00" => sub { is rur2words(242000000000.00), "двести сорок два миллиарда рублей 00 копеек"; };
	it "243000000000.00" => sub { is rur2words(243000000000.00), "двести сорок три миллиарда рублей 00 копеек"; };
	it "244000000000.00" => sub { is rur2words(244000000000.00), "двести сорок четыре миллиарда рублей 00 копеек"; };
	it "245000000000.00" => sub { is rur2words(245000000000.00), "двести сорок пять миллиардов рублей 00 копеек"; };
	it "246000000000.00" => sub { is rur2words(246000000000.00), "двести сорок шесть миллиардов рублей 00 копеек"; };
	it "247000000000.00" => sub { is rur2words(247000000000.00), "двести сорок семь миллиардов рублей 00 копеек"; };
	it "248000000000.00" => sub { is rur2words(248000000000.00), "двести сорок восемь миллиардов рублей 00 копеек"; };
	it "249000000000.00" => sub { is rur2words(249000000000.00), "двести сорок девять миллиардов рублей 00 копеек"; };
	it "250000000000.00" => sub { is rur2words(250000000000.00), "двести пятьдесят миллиардов рублей 00 копеек"; };
	it "251000000000.00" => sub { is rur2words(251000000000.00), "двести пятьдесят один миллиард рублей 00 копеек"; };
	it "252000000000.00" => sub { is rur2words(252000000000.00), "двести пятьдесят два миллиарда рублей 00 копеек"; };
	it "253000000000.00" => sub { is rur2words(253000000000.00), "двести пятьдесят три миллиарда рублей 00 копеек"; };
	it "254000000000.00" => sub { is rur2words(254000000000.00), "двести пятьдесят четыре миллиарда рублей 00 копеек"; };
	it "255000000000.00" => sub { is rur2words(255000000000.00), "двести пятьдесят пять миллиардов рублей 00 копеек"; };
	it "256000000000.00" => sub { is rur2words(256000000000.00), "двести пятьдесят шесть миллиардов рублей 00 копеек"; };
	it "257000000000.00" => sub { is rur2words(257000000000.00), "двести пятьдесят семь миллиардов рублей 00 копеек"; };
	it "258000000000.00" => sub { is rur2words(258000000000.00), "двести пятьдесят восемь миллиардов рублей 00 копеек"; };
	it "259000000000.00" => sub { is rur2words(259000000000.00), "двести пятьдесят девять миллиардов рублей 00 копеек"; };
	it "260000000000.00" => sub { is rur2words(260000000000.00), "двести шестьдесят миллиардов рублей 00 копеек"; };
	it "261000000000.00" => sub { is rur2words(261000000000.00), "двести шестьдесят один миллиард рублей 00 копеек"; };
	it "262000000000.00" => sub { is rur2words(262000000000.00), "двести шестьдесят два миллиарда рублей 00 копеек"; };
	it "263000000000.00" => sub { is rur2words(263000000000.00), "двести шестьдесят три миллиарда рублей 00 копеек"; };
	it "264000000000.00" => sub { is rur2words(264000000000.00), "двести шестьдесят четыре миллиарда рублей 00 копеек"; };
	it "265000000000.00" => sub { is rur2words(265000000000.00), "двести шестьдесят пять миллиардов рублей 00 копеек"; };
	it "266000000000.00" => sub { is rur2words(266000000000.00), "двести шестьдесят шесть миллиардов рублей 00 копеек"; };
	it "267000000000.00" => sub { is rur2words(267000000000.00), "двести шестьдесят семь миллиардов рублей 00 копеек"; };
	it "268000000000.00" => sub { is rur2words(268000000000.00), "двести шестьдесят восемь миллиардов рублей 00 копеек"; };
	it "269000000000.00" => sub { is rur2words(269000000000.00), "двести шестьдесят девять миллиардов рублей 00 копеек"; };
	it "270000000000.00" => sub { is rur2words(270000000000.00), "двести семьдесят миллиардов рублей 00 копеек"; };
	it "271000000000.00" => sub { is rur2words(271000000000.00), "двести семьдесят один миллиард рублей 00 копеек"; };
	it "272000000000.00" => sub { is rur2words(272000000000.00), "двести семьдесят два миллиарда рублей 00 копеек"; };
	it "273000000000.00" => sub { is rur2words(273000000000.00), "двести семьдесят три миллиарда рублей 00 копеек"; };
	it "274000000000.00" => sub { is rur2words(274000000000.00), "двести семьдесят четыре миллиарда рублей 00 копеек"; };
	it "275000000000.00" => sub { is rur2words(275000000000.00), "двести семьдесят пять миллиардов рублей 00 копеек"; };
	it "276000000000.00" => sub { is rur2words(276000000000.00), "двести семьдесят шесть миллиардов рублей 00 копеек"; };
	it "277000000000.00" => sub { is rur2words(277000000000.00), "двести семьдесят семь миллиардов рублей 00 копеек"; };
	it "278000000000.00" => sub { is rur2words(278000000000.00), "двести семьдесят восемь миллиардов рублей 00 копеек"; };
	it "279000000000.00" => sub { is rur2words(279000000000.00), "двести семьдесят девять миллиардов рублей 00 копеек"; };
	it "280000000000.00" => sub { is rur2words(280000000000.00), "двести восемьдесят миллиардов рублей 00 копеек"; };
	it "281000000000.00" => sub { is rur2words(281000000000.00), "двести восемьдесят один миллиард рублей 00 копеек"; };
	it "282000000000.00" => sub { is rur2words(282000000000.00), "двести восемьдесят два миллиарда рублей 00 копеек"; };
	it "283000000000.00" => sub { is rur2words(283000000000.00), "двести восемьдесят три миллиарда рублей 00 копеек"; };
	it "284000000000.00" => sub { is rur2words(284000000000.00), "двести восемьдесят четыре миллиарда рублей 00 копеек"; };
	it "285000000000.00" => sub { is rur2words(285000000000.00), "двести восемьдесят пять миллиардов рублей 00 копеек"; };
	it "286000000000.00" => sub { is rur2words(286000000000.00), "двести восемьдесят шесть миллиардов рублей 00 копеек"; };
	it "287000000000.00" => sub { is rur2words(287000000000.00), "двести восемьдесят семь миллиардов рублей 00 копеек"; };
	it "288000000000.00" => sub { is rur2words(288000000000.00), "двести восемьдесят восемь миллиардов рублей 00 копеек"; };
	it "289000000000.00" => sub { is rur2words(289000000000.00), "двести восемьдесят девять миллиардов рублей 00 копеек"; };
	it "290000000000.00" => sub { is rur2words(290000000000.00), "двести девяносто миллиардов рублей 00 копеек"; };
	it "291000000000.00" => sub { is rur2words(291000000000.00), "двести девяносто один миллиард рублей 00 копеек"; };
	it "292000000000.00" => sub { is rur2words(292000000000.00), "двести девяносто два миллиарда рублей 00 копеек"; };
	it "293000000000.00" => sub { is rur2words(293000000000.00), "двести девяносто три миллиарда рублей 00 копеек"; };
	it "294000000000.00" => sub { is rur2words(294000000000.00), "двести девяносто четыре миллиарда рублей 00 копеек"; };
	it "295000000000.00" => sub { is rur2words(295000000000.00), "двести девяносто пять миллиардов рублей 00 копеек"; };
	it "296000000000.00" => sub { is rur2words(296000000000.00), "двести девяносто шесть миллиардов рублей 00 копеек"; };
	it "297000000000.00" => sub { is rur2words(297000000000.00), "двести девяносто семь миллиардов рублей 00 копеек"; };
	it "298000000000.00" => sub { is rur2words(298000000000.00), "двести девяносто восемь миллиардов рублей 00 копеек"; };
	it "299000000000.00" => sub { is rur2words(299000000000.00), "двести девяносто девять миллиардов рублей 00 копеек"; };
	it "300000000000.00" => sub { is rur2words(300000000000.00), "триста миллиардов рублей 00 копеек"; };
	it "301000000000.00" => sub { is rur2words(301000000000.00), "триста один миллиард рублей 00 копеек"; };
	it "302000000000.00" => sub { is rur2words(302000000000.00), "триста два миллиарда рублей 00 копеек"; };
	it "303000000000.00" => sub { is rur2words(303000000000.00), "триста три миллиарда рублей 00 копеек"; };
	it "304000000000.00" => sub { is rur2words(304000000000.00), "триста четыре миллиарда рублей 00 копеек"; };
	it "305000000000.00" => sub { is rur2words(305000000000.00), "триста пять миллиардов рублей 00 копеек"; };
	it "306000000000.00" => sub { is rur2words(306000000000.00), "триста шесть миллиардов рублей 00 копеек"; };
	it "307000000000.00" => sub { is rur2words(307000000000.00), "триста семь миллиардов рублей 00 копеек"; };
	it "308000000000.00" => sub { is rur2words(308000000000.00), "триста восемь миллиардов рублей 00 копеек"; };
	it "309000000000.00" => sub { is rur2words(309000000000.00), "триста девять миллиардов рублей 00 копеек"; };
	it "310000000000.00" => sub { is rur2words(310000000000.00), "триста десять миллиардов рублей 00 копеек"; };
	it "311000000000.00" => sub { is rur2words(311000000000.00), "триста одиннадцать миллиардов рублей 00 копеек"; };
	it "312000000000.00" => sub { is rur2words(312000000000.00), "триста двенадцать миллиардов рублей 00 копеек"; };
	it "313000000000.00" => sub { is rur2words(313000000000.00), "триста тринадцать миллиардов рублей 00 копеек"; };
	it "314000000000.00" => sub { is rur2words(314000000000.00), "триста четырнадцать миллиардов рублей 00 копеек"; };
	it "315000000000.00" => sub { is rur2words(315000000000.00), "триста пятнадцать миллиардов рублей 00 копеек"; };
	it "316000000000.00" => sub { is rur2words(316000000000.00), "триста шестнадцать миллиардов рублей 00 копеек"; };
	it "317000000000.00" => sub { is rur2words(317000000000.00), "триста семнадцать миллиардов рублей 00 копеек"; };
	it "318000000000.00" => sub { is rur2words(318000000000.00), "триста восемнадцать миллиардов рублей 00 копеек"; };
	it "319000000000.00" => sub { is rur2words(319000000000.00), "триста девятнадцать миллиардов рублей 00 копеек"; };
	it "320000000000.00" => sub { is rur2words(320000000000.00), "триста двадцать миллиардов рублей 00 копеек"; };
	it "321000000000.00" => sub { is rur2words(321000000000.00), "триста двадцать один миллиард рублей 00 копеек"; };
	it "322000000000.00" => sub { is rur2words(322000000000.00), "триста двадцать два миллиарда рублей 00 копеек"; };
	it "323000000000.00" => sub { is rur2words(323000000000.00), "триста двадцать три миллиарда рублей 00 копеек"; };
	it "324000000000.00" => sub { is rur2words(324000000000.00), "триста двадцать четыре миллиарда рублей 00 копеек"; };
	it "325000000000.00" => sub { is rur2words(325000000000.00), "триста двадцать пять миллиардов рублей 00 копеек"; };
	it "326000000000.00" => sub { is rur2words(326000000000.00), "триста двадцать шесть миллиардов рублей 00 копеек"; };
	it "327000000000.00" => sub { is rur2words(327000000000.00), "триста двадцать семь миллиардов рублей 00 копеек"; };
	it "328000000000.00" => sub { is rur2words(328000000000.00), "триста двадцать восемь миллиардов рублей 00 копеек"; };
	it "329000000000.00" => sub { is rur2words(329000000000.00), "триста двадцать девять миллиардов рублей 00 копеек"; };
	it "330000000000.00" => sub { is rur2words(330000000000.00), "триста тридцать миллиардов рублей 00 копеек"; };
	it "331000000000.00" => sub { is rur2words(331000000000.00), "триста тридцать один миллиард рублей 00 копеек"; };
	it "332000000000.00" => sub { is rur2words(332000000000.00), "триста тридцать два миллиарда рублей 00 копеек"; };
	it "333000000000.00" => sub { is rur2words(333000000000.00), "триста тридцать три миллиарда рублей 00 копеек"; };
	it "334000000000.00" => sub { is rur2words(334000000000.00), "триста тридцать четыре миллиарда рублей 00 копеек"; };
	it "335000000000.00" => sub { is rur2words(335000000000.00), "триста тридцать пять миллиардов рублей 00 копеек"; };
	it "336000000000.00" => sub { is rur2words(336000000000.00), "триста тридцать шесть миллиардов рублей 00 копеек"; };
	it "337000000000.00" => sub { is rur2words(337000000000.00), "триста тридцать семь миллиардов рублей 00 копеек"; };
	it "338000000000.00" => sub { is rur2words(338000000000.00), "триста тридцать восемь миллиардов рублей 00 копеек"; };
	it "339000000000.00" => sub { is rur2words(339000000000.00), "триста тридцать девять миллиардов рублей 00 копеек"; };
	it "340000000000.00" => sub { is rur2words(340000000000.00), "триста сорок миллиардов рублей 00 копеек"; };
	it "341000000000.00" => sub { is rur2words(341000000000.00), "триста сорок один миллиард рублей 00 копеек"; };
	it "342000000000.00" => sub { is rur2words(342000000000.00), "триста сорок два миллиарда рублей 00 копеек"; };
	it "343000000000.00" => sub { is rur2words(343000000000.00), "триста сорок три миллиарда рублей 00 копеек"; };
	it "344000000000.00" => sub { is rur2words(344000000000.00), "триста сорок четыре миллиарда рублей 00 копеек"; };
	it "345000000000.00" => sub { is rur2words(345000000000.00), "триста сорок пять миллиардов рублей 00 копеек"; };
	it "346000000000.00" => sub { is rur2words(346000000000.00), "триста сорок шесть миллиардов рублей 00 копеек"; };
	it "347000000000.00" => sub { is rur2words(347000000000.00), "триста сорок семь миллиардов рублей 00 копеек"; };
	it "348000000000.00" => sub { is rur2words(348000000000.00), "триста сорок восемь миллиардов рублей 00 копеек"; };
	it "349000000000.00" => sub { is rur2words(349000000000.00), "триста сорок девять миллиардов рублей 00 копеек"; };
	it "350000000000.00" => sub { is rur2words(350000000000.00), "триста пятьдесят миллиардов рублей 00 копеек"; };
	it "351000000000.00" => sub { is rur2words(351000000000.00), "триста пятьдесят один миллиард рублей 00 копеек"; };
	it "352000000000.00" => sub { is rur2words(352000000000.00), "триста пятьдесят два миллиарда рублей 00 копеек"; };
	it "353000000000.00" => sub { is rur2words(353000000000.00), "триста пятьдесят три миллиарда рублей 00 копеек"; };
	it "354000000000.00" => sub { is rur2words(354000000000.00), "триста пятьдесят четыре миллиарда рублей 00 копеек"; };
	it "355000000000.00" => sub { is rur2words(355000000000.00), "триста пятьдесят пять миллиардов рублей 00 копеек"; };
	it "356000000000.00" => sub { is rur2words(356000000000.00), "триста пятьдесят шесть миллиардов рублей 00 копеек"; };
	it "357000000000.00" => sub { is rur2words(357000000000.00), "триста пятьдесят семь миллиардов рублей 00 копеек"; };
	it "358000000000.00" => sub { is rur2words(358000000000.00), "триста пятьдесят восемь миллиардов рублей 00 копеек"; };
	it "359000000000.00" => sub { is rur2words(359000000000.00), "триста пятьдесят девять миллиардов рублей 00 копеек"; };
	it "360000000000.00" => sub { is rur2words(360000000000.00), "триста шестьдесят миллиардов рублей 00 копеек"; };
	it "361000000000.00" => sub { is rur2words(361000000000.00), "триста шестьдесят один миллиард рублей 00 копеек"; };
	it "362000000000.00" => sub { is rur2words(362000000000.00), "триста шестьдесят два миллиарда рублей 00 копеек"; };
	it "363000000000.00" => sub { is rur2words(363000000000.00), "триста шестьдесят три миллиарда рублей 00 копеек"; };
	it "364000000000.00" => sub { is rur2words(364000000000.00), "триста шестьдесят четыре миллиарда рублей 00 копеек"; };
	it "365000000000.00" => sub { is rur2words(365000000000.00), "триста шестьдесят пять миллиардов рублей 00 копеек"; };
	it "366000000000.00" => sub { is rur2words(366000000000.00), "триста шестьдесят шесть миллиардов рублей 00 копеек"; };
	it "367000000000.00" => sub { is rur2words(367000000000.00), "триста шестьдесят семь миллиардов рублей 00 копеек"; };
	it "368000000000.00" => sub { is rur2words(368000000000.00), "триста шестьдесят восемь миллиардов рублей 00 копеек"; };
	it "369000000000.00" => sub { is rur2words(369000000000.00), "триста шестьдесят девять миллиардов рублей 00 копеек"; };
	it "370000000000.00" => sub { is rur2words(370000000000.00), "триста семьдесят миллиардов рублей 00 копеек"; };
	it "371000000000.00" => sub { is rur2words(371000000000.00), "триста семьдесят один миллиард рублей 00 копеек"; };
	it "372000000000.00" => sub { is rur2words(372000000000.00), "триста семьдесят два миллиарда рублей 00 копеек"; };
	it "373000000000.00" => sub { is rur2words(373000000000.00), "триста семьдесят три миллиарда рублей 00 копеек"; };
	it "374000000000.00" => sub { is rur2words(374000000000.00), "триста семьдесят четыре миллиарда рублей 00 копеек"; };
	it "375000000000.00" => sub { is rur2words(375000000000.00), "триста семьдесят пять миллиардов рублей 00 копеек"; };
	it "376000000000.00" => sub { is rur2words(376000000000.00), "триста семьдесят шесть миллиардов рублей 00 копеек"; };
	it "377000000000.00" => sub { is rur2words(377000000000.00), "триста семьдесят семь миллиардов рублей 00 копеек"; };
	it "378000000000.00" => sub { is rur2words(378000000000.00), "триста семьдесят восемь миллиардов рублей 00 копеек"; };
	it "379000000000.00" => sub { is rur2words(379000000000.00), "триста семьдесят девять миллиардов рублей 00 копеек"; };
	it "380000000000.00" => sub { is rur2words(380000000000.00), "триста восемьдесят миллиардов рублей 00 копеек"; };
	it "381000000000.00" => sub { is rur2words(381000000000.00), "триста восемьдесят один миллиард рублей 00 копеек"; };
	it "382000000000.00" => sub { is rur2words(382000000000.00), "триста восемьдесят два миллиарда рублей 00 копеек"; };
	it "383000000000.00" => sub { is rur2words(383000000000.00), "триста восемьдесят три миллиарда рублей 00 копеек"; };
	it "384000000000.00" => sub { is rur2words(384000000000.00), "триста восемьдесят четыре миллиарда рублей 00 копеек"; };
	it "385000000000.00" => sub { is rur2words(385000000000.00), "триста восемьдесят пять миллиардов рублей 00 копеек"; };
	it "386000000000.00" => sub { is rur2words(386000000000.00), "триста восемьдесят шесть миллиардов рублей 00 копеек"; };
	it "387000000000.00" => sub { is rur2words(387000000000.00), "триста восемьдесят семь миллиардов рублей 00 копеек"; };
	it "388000000000.00" => sub { is rur2words(388000000000.00), "триста восемьдесят восемь миллиардов рублей 00 копеек"; };
	it "389000000000.00" => sub { is rur2words(389000000000.00), "триста восемьдесят девять миллиардов рублей 00 копеек"; };
	it "390000000000.00" => sub { is rur2words(390000000000.00), "триста девяносто миллиардов рублей 00 копеек"; };
	it "391000000000.00" => sub { is rur2words(391000000000.00), "триста девяносто один миллиард рублей 00 копеек"; };
	it "392000000000.00" => sub { is rur2words(392000000000.00), "триста девяносто два миллиарда рублей 00 копеек"; };
	it "393000000000.00" => sub { is rur2words(393000000000.00), "триста девяносто три миллиарда рублей 00 копеек"; };
	it "394000000000.00" => sub { is rur2words(394000000000.00), "триста девяносто четыре миллиарда рублей 00 копеек"; };
	it "395000000000.00" => sub { is rur2words(395000000000.00), "триста девяносто пять миллиардов рублей 00 копеек"; };
	it "396000000000.00" => sub { is rur2words(396000000000.00), "триста девяносто шесть миллиардов рублей 00 копеек"; };
	it "397000000000.00" => sub { is rur2words(397000000000.00), "триста девяносто семь миллиардов рублей 00 копеек"; };
	it "398000000000.00" => sub { is rur2words(398000000000.00), "триста девяносто восемь миллиардов рублей 00 копеек"; };
	it "399000000000.00" => sub { is rur2words(399000000000.00), "триста девяносто девять миллиардов рублей 00 копеек"; };
	it "400000000000.00" => sub { is rur2words(400000000000.00), "четыреста миллиардов рублей 00 копеек"; };
	it "401000000000.00" => sub { is rur2words(401000000000.00), "четыреста один миллиард рублей 00 копеек"; };
	it "402000000000.00" => sub { is rur2words(402000000000.00), "четыреста два миллиарда рублей 00 копеек"; };
	it "403000000000.00" => sub { is rur2words(403000000000.00), "четыреста три миллиарда рублей 00 копеек"; };
	it "404000000000.00" => sub { is rur2words(404000000000.00), "четыреста четыре миллиарда рублей 00 копеек"; };
	it "405000000000.00" => sub { is rur2words(405000000000.00), "четыреста пять миллиардов рублей 00 копеек"; };
	it "406000000000.00" => sub { is rur2words(406000000000.00), "четыреста шесть миллиардов рублей 00 копеек"; };
	it "407000000000.00" => sub { is rur2words(407000000000.00), "четыреста семь миллиардов рублей 00 копеек"; };
	it "408000000000.00" => sub { is rur2words(408000000000.00), "четыреста восемь миллиардов рублей 00 копеек"; };
	it "409000000000.00" => sub { is rur2words(409000000000.00), "четыреста девять миллиардов рублей 00 копеек"; };
	it "410000000000.00" => sub { is rur2words(410000000000.00), "четыреста десять миллиардов рублей 00 копеек"; };
	it "411000000000.00" => sub { is rur2words(411000000000.00), "четыреста одиннадцать миллиардов рублей 00 копеек"; };
	it "412000000000.00" => sub { is rur2words(412000000000.00), "четыреста двенадцать миллиардов рублей 00 копеек"; };
	it "413000000000.00" => sub { is rur2words(413000000000.00), "четыреста тринадцать миллиардов рублей 00 копеек"; };
	it "414000000000.00" => sub { is rur2words(414000000000.00), "четыреста четырнадцать миллиардов рублей 00 копеек"; };
	it "415000000000.00" => sub { is rur2words(415000000000.00), "четыреста пятнадцать миллиардов рублей 00 копеек"; };
	it "416000000000.00" => sub { is rur2words(416000000000.00), "четыреста шестнадцать миллиардов рублей 00 копеек"; };
	it "417000000000.00" => sub { is rur2words(417000000000.00), "четыреста семнадцать миллиардов рублей 00 копеек"; };
	it "418000000000.00" => sub { is rur2words(418000000000.00), "четыреста восемнадцать миллиардов рублей 00 копеек"; };
	it "419000000000.00" => sub { is rur2words(419000000000.00), "четыреста девятнадцать миллиардов рублей 00 копеек"; };
	it "420000000000.00" => sub { is rur2words(420000000000.00), "четыреста двадцать миллиардов рублей 00 копеек"; };
	it "421000000000.00" => sub { is rur2words(421000000000.00), "четыреста двадцать один миллиард рублей 00 копеек"; };
	it "422000000000.00" => sub { is rur2words(422000000000.00), "четыреста двадцать два миллиарда рублей 00 копеек"; };
	it "423000000000.00" => sub { is rur2words(423000000000.00), "четыреста двадцать три миллиарда рублей 00 копеек"; };
	it "424000000000.00" => sub { is rur2words(424000000000.00), "четыреста двадцать четыре миллиарда рублей 00 копеек"; };
	it "425000000000.00" => sub { is rur2words(425000000000.00), "четыреста двадцать пять миллиардов рублей 00 копеек"; };
	it "426000000000.00" => sub { is rur2words(426000000000.00), "четыреста двадцать шесть миллиардов рублей 00 копеек"; };
	it "427000000000.00" => sub { is rur2words(427000000000.00), "четыреста двадцать семь миллиардов рублей 00 копеек"; };
	it "428000000000.00" => sub { is rur2words(428000000000.00), "четыреста двадцать восемь миллиардов рублей 00 копеек"; };
	it "429000000000.00" => sub { is rur2words(429000000000.00), "четыреста двадцать девять миллиардов рублей 00 копеек"; };
	it "430000000000.00" => sub { is rur2words(430000000000.00), "четыреста тридцать миллиардов рублей 00 копеек"; };
	it "431000000000.00" => sub { is rur2words(431000000000.00), "четыреста тридцать один миллиард рублей 00 копеек"; };
	it "432000000000.00" => sub { is rur2words(432000000000.00), "четыреста тридцать два миллиарда рублей 00 копеек"; };
	it "433000000000.00" => sub { is rur2words(433000000000.00), "четыреста тридцать три миллиарда рублей 00 копеек"; };
	it "434000000000.00" => sub { is rur2words(434000000000.00), "четыреста тридцать четыре миллиарда рублей 00 копеек"; };
	it "435000000000.00" => sub { is rur2words(435000000000.00), "четыреста тридцать пять миллиардов рублей 00 копеек"; };
	it "436000000000.00" => sub { is rur2words(436000000000.00), "четыреста тридцать шесть миллиардов рублей 00 копеек"; };
	it "437000000000.00" => sub { is rur2words(437000000000.00), "четыреста тридцать семь миллиардов рублей 00 копеек"; };
	it "438000000000.00" => sub { is rur2words(438000000000.00), "четыреста тридцать восемь миллиардов рублей 00 копеек"; };
	it "439000000000.00" => sub { is rur2words(439000000000.00), "четыреста тридцать девять миллиардов рублей 00 копеек"; };
	it "440000000000.00" => sub { is rur2words(440000000000.00), "четыреста сорок миллиардов рублей 00 копеек"; };
	it "441000000000.00" => sub { is rur2words(441000000000.00), "четыреста сорок один миллиард рублей 00 копеек"; };
	it "442000000000.00" => sub { is rur2words(442000000000.00), "четыреста сорок два миллиарда рублей 00 копеек"; };
	it "443000000000.00" => sub { is rur2words(443000000000.00), "четыреста сорок три миллиарда рублей 00 копеек"; };
	it "444000000000.00" => sub { is rur2words(444000000000.00), "четыреста сорок четыре миллиарда рублей 00 копеек"; };
	it "445000000000.00" => sub { is rur2words(445000000000.00), "четыреста сорок пять миллиардов рублей 00 копеек"; };
	it "446000000000.00" => sub { is rur2words(446000000000.00), "четыреста сорок шесть миллиардов рублей 00 копеек"; };
	it "447000000000.00" => sub { is rur2words(447000000000.00), "четыреста сорок семь миллиардов рублей 00 копеек"; };
	it "448000000000.00" => sub { is rur2words(448000000000.00), "четыреста сорок восемь миллиардов рублей 00 копеек"; };
	it "449000000000.00" => sub { is rur2words(449000000000.00), "четыреста сорок девять миллиардов рублей 00 копеек"; };
	it "450000000000.00" => sub { is rur2words(450000000000.00), "четыреста пятьдесят миллиардов рублей 00 копеек"; };
	it "451000000000.00" => sub { is rur2words(451000000000.00), "четыреста пятьдесят один миллиард рублей 00 копеек"; };
	it "452000000000.00" => sub { is rur2words(452000000000.00), "четыреста пятьдесят два миллиарда рублей 00 копеек"; };
	it "453000000000.00" => sub { is rur2words(453000000000.00), "четыреста пятьдесят три миллиарда рублей 00 копеек"; };
	it "454000000000.00" => sub { is rur2words(454000000000.00), "четыреста пятьдесят четыре миллиарда рублей 00 копеек"; };
	it "455000000000.00" => sub { is rur2words(455000000000.00), "четыреста пятьдесят пять миллиардов рублей 00 копеек"; };
	it "456000000000.00" => sub { is rur2words(456000000000.00), "четыреста пятьдесят шесть миллиардов рублей 00 копеек"; };
	it "457000000000.00" => sub { is rur2words(457000000000.00), "четыреста пятьдесят семь миллиардов рублей 00 копеек"; };
	it "458000000000.00" => sub { is rur2words(458000000000.00), "четыреста пятьдесят восемь миллиардов рублей 00 копеек"; };
	it "459000000000.00" => sub { is rur2words(459000000000.00), "четыреста пятьдесят девять миллиардов рублей 00 копеек"; };
	it "460000000000.00" => sub { is rur2words(460000000000.00), "четыреста шестьдесят миллиардов рублей 00 копеек"; };
	it "461000000000.00" => sub { is rur2words(461000000000.00), "четыреста шестьдесят один миллиард рублей 00 копеек"; };
	it "462000000000.00" => sub { is rur2words(462000000000.00), "четыреста шестьдесят два миллиарда рублей 00 копеек"; };
	it "463000000000.00" => sub { is rur2words(463000000000.00), "четыреста шестьдесят три миллиарда рублей 00 копеек"; };
	it "464000000000.00" => sub { is rur2words(464000000000.00), "четыреста шестьдесят четыре миллиарда рублей 00 копеек"; };
	it "465000000000.00" => sub { is rur2words(465000000000.00), "четыреста шестьдесят пять миллиардов рублей 00 копеек"; };
	it "466000000000.00" => sub { is rur2words(466000000000.00), "четыреста шестьдесят шесть миллиардов рублей 00 копеек"; };
	it "467000000000.00" => sub { is rur2words(467000000000.00), "четыреста шестьдесят семь миллиардов рублей 00 копеек"; };
	it "468000000000.00" => sub { is rur2words(468000000000.00), "четыреста шестьдесят восемь миллиардов рублей 00 копеек"; };
	it "469000000000.00" => sub { is rur2words(469000000000.00), "четыреста шестьдесят девять миллиардов рублей 00 копеек"; };
	it "470000000000.00" => sub { is rur2words(470000000000.00), "четыреста семьдесят миллиардов рублей 00 копеек"; };
	it "471000000000.00" => sub { is rur2words(471000000000.00), "четыреста семьдесят один миллиард рублей 00 копеек"; };
	it "472000000000.00" => sub { is rur2words(472000000000.00), "четыреста семьдесят два миллиарда рублей 00 копеек"; };
	it "473000000000.00" => sub { is rur2words(473000000000.00), "четыреста семьдесят три миллиарда рублей 00 копеек"; };
	it "474000000000.00" => sub { is rur2words(474000000000.00), "четыреста семьдесят четыре миллиарда рублей 00 копеек"; };
	it "475000000000.00" => sub { is rur2words(475000000000.00), "четыреста семьдесят пять миллиардов рублей 00 копеек"; };
	it "476000000000.00" => sub { is rur2words(476000000000.00), "четыреста семьдесят шесть миллиардов рублей 00 копеек"; };
	it "477000000000.00" => sub { is rur2words(477000000000.00), "четыреста семьдесят семь миллиардов рублей 00 копеек"; };
	it "478000000000.00" => sub { is rur2words(478000000000.00), "четыреста семьдесят восемь миллиардов рублей 00 копеек"; };
	it "479000000000.00" => sub { is rur2words(479000000000.00), "четыреста семьдесят девять миллиардов рублей 00 копеек"; };
	it "480000000000.00" => sub { is rur2words(480000000000.00), "четыреста восемьдесят миллиардов рублей 00 копеек"; };
	it "481000000000.00" => sub { is rur2words(481000000000.00), "четыреста восемьдесят один миллиард рублей 00 копеек"; };
	it "482000000000.00" => sub { is rur2words(482000000000.00), "четыреста восемьдесят два миллиарда рублей 00 копеек"; };
	it "483000000000.00" => sub { is rur2words(483000000000.00), "четыреста восемьдесят три миллиарда рублей 00 копеек"; };
	it "484000000000.00" => sub { is rur2words(484000000000.00), "четыреста восемьдесят четыре миллиарда рублей 00 копеек"; };
	it "485000000000.00" => sub { is rur2words(485000000000.00), "четыреста восемьдесят пять миллиардов рублей 00 копеек"; };
	it "486000000000.00" => sub { is rur2words(486000000000.00), "четыреста восемьдесят шесть миллиардов рублей 00 копеек"; };
	it "487000000000.00" => sub { is rur2words(487000000000.00), "четыреста восемьдесят семь миллиардов рублей 00 копеек"; };
	it "488000000000.00" => sub { is rur2words(488000000000.00), "четыреста восемьдесят восемь миллиардов рублей 00 копеек"; };
	it "489000000000.00" => sub { is rur2words(489000000000.00), "четыреста восемьдесят девять миллиардов рублей 00 копеек"; };
	it "490000000000.00" => sub { is rur2words(490000000000.00), "четыреста девяносто миллиардов рублей 00 копеек"; };
	it "491000000000.00" => sub { is rur2words(491000000000.00), "четыреста девяносто один миллиард рублей 00 копеек"; };
	it "492000000000.00" => sub { is rur2words(492000000000.00), "четыреста девяносто два миллиарда рублей 00 копеек"; };
	it "493000000000.00" => sub { is rur2words(493000000000.00), "четыреста девяносто три миллиарда рублей 00 копеек"; };
	it "494000000000.00" => sub { is rur2words(494000000000.00), "четыреста девяносто четыре миллиарда рублей 00 копеек"; };
	it "495000000000.00" => sub { is rur2words(495000000000.00), "четыреста девяносто пять миллиардов рублей 00 копеек"; };
	it "496000000000.00" => sub { is rur2words(496000000000.00), "четыреста девяносто шесть миллиардов рублей 00 копеек"; };
	it "497000000000.00" => sub { is rur2words(497000000000.00), "четыреста девяносто семь миллиардов рублей 00 копеек"; };
	it "498000000000.00" => sub { is rur2words(498000000000.00), "четыреста девяносто восемь миллиардов рублей 00 копеек"; };
	it "499000000000.00" => sub { is rur2words(499000000000.00), "четыреста девяносто девять миллиардов рублей 00 копеек"; };
	it "500000000000.00" => sub { is rur2words(500000000000.00), "пятьсот миллиардов рублей 00 копеек"; };
	it "501000000000.00" => sub { is rur2words(501000000000.00), "пятьсот один миллиард рублей 00 копеек"; };
	it "502000000000.00" => sub { is rur2words(502000000000.00), "пятьсот два миллиарда рублей 00 копеек"; };
	it "503000000000.00" => sub { is rur2words(503000000000.00), "пятьсот три миллиарда рублей 00 копеек"; };
	it "504000000000.00" => sub { is rur2words(504000000000.00), "пятьсот четыре миллиарда рублей 00 копеек"; };
	it "505000000000.00" => sub { is rur2words(505000000000.00), "пятьсот пять миллиардов рублей 00 копеек"; };
	it "506000000000.00" => sub { is rur2words(506000000000.00), "пятьсот шесть миллиардов рублей 00 копеек"; };
	it "507000000000.00" => sub { is rur2words(507000000000.00), "пятьсот семь миллиардов рублей 00 копеек"; };
	it "508000000000.00" => sub { is rur2words(508000000000.00), "пятьсот восемь миллиардов рублей 00 копеек"; };
	it "509000000000.00" => sub { is rur2words(509000000000.00), "пятьсот девять миллиардов рублей 00 копеек"; };
	it "510000000000.00" => sub { is rur2words(510000000000.00), "пятьсот десять миллиардов рублей 00 копеек"; };
	it "511000000000.00" => sub { is rur2words(511000000000.00), "пятьсот одиннадцать миллиардов рублей 00 копеек"; };
	it "512000000000.00" => sub { is rur2words(512000000000.00), "пятьсот двенадцать миллиардов рублей 00 копеек"; };
	it "513000000000.00" => sub { is rur2words(513000000000.00), "пятьсот тринадцать миллиардов рублей 00 копеек"; };
	it "514000000000.00" => sub { is rur2words(514000000000.00), "пятьсот четырнадцать миллиардов рублей 00 копеек"; };
	it "515000000000.00" => sub { is rur2words(515000000000.00), "пятьсот пятнадцать миллиардов рублей 00 копеек"; };
	it "516000000000.00" => sub { is rur2words(516000000000.00), "пятьсот шестнадцать миллиардов рублей 00 копеек"; };
	it "517000000000.00" => sub { is rur2words(517000000000.00), "пятьсот семнадцать миллиардов рублей 00 копеек"; };
	it "518000000000.00" => sub { is rur2words(518000000000.00), "пятьсот восемнадцать миллиардов рублей 00 копеек"; };
	it "519000000000.00" => sub { is rur2words(519000000000.00), "пятьсот девятнадцать миллиардов рублей 00 копеек"; };
	it "520000000000.00" => sub { is rur2words(520000000000.00), "пятьсот двадцать миллиардов рублей 00 копеек"; };
	it "521000000000.00" => sub { is rur2words(521000000000.00), "пятьсот двадцать один миллиард рублей 00 копеек"; };
	it "522000000000.00" => sub { is rur2words(522000000000.00), "пятьсот двадцать два миллиарда рублей 00 копеек"; };
	it "523000000000.00" => sub { is rur2words(523000000000.00), "пятьсот двадцать три миллиарда рублей 00 копеек"; };
	it "524000000000.00" => sub { is rur2words(524000000000.00), "пятьсот двадцать четыре миллиарда рублей 00 копеек"; };
	it "525000000000.00" => sub { is rur2words(525000000000.00), "пятьсот двадцать пять миллиардов рублей 00 копеек"; };
	it "526000000000.00" => sub { is rur2words(526000000000.00), "пятьсот двадцать шесть миллиардов рублей 00 копеек"; };
	it "527000000000.00" => sub { is rur2words(527000000000.00), "пятьсот двадцать семь миллиардов рублей 00 копеек"; };
	it "528000000000.00" => sub { is rur2words(528000000000.00), "пятьсот двадцать восемь миллиардов рублей 00 копеек"; };
	it "529000000000.00" => sub { is rur2words(529000000000.00), "пятьсот двадцать девять миллиардов рублей 00 копеек"; };
	it "530000000000.00" => sub { is rur2words(530000000000.00), "пятьсот тридцать миллиардов рублей 00 копеек"; };
	it "531000000000.00" => sub { is rur2words(531000000000.00), "пятьсот тридцать один миллиард рублей 00 копеек"; };
	it "532000000000.00" => sub { is rur2words(532000000000.00), "пятьсот тридцать два миллиарда рублей 00 копеек"; };
	it "533000000000.00" => sub { is rur2words(533000000000.00), "пятьсот тридцать три миллиарда рублей 00 копеек"; };
	it "534000000000.00" => sub { is rur2words(534000000000.00), "пятьсот тридцать четыре миллиарда рублей 00 копеек"; };
	it "535000000000.00" => sub { is rur2words(535000000000.00), "пятьсот тридцать пять миллиардов рублей 00 копеек"; };
	it "536000000000.00" => sub { is rur2words(536000000000.00), "пятьсот тридцать шесть миллиардов рублей 00 копеек"; };
	it "537000000000.00" => sub { is rur2words(537000000000.00), "пятьсот тридцать семь миллиардов рублей 00 копеек"; };
	it "538000000000.00" => sub { is rur2words(538000000000.00), "пятьсот тридцать восемь миллиардов рублей 00 копеек"; };
	it "539000000000.00" => sub { is rur2words(539000000000.00), "пятьсот тридцать девять миллиардов рублей 00 копеек"; };
	it "540000000000.00" => sub { is rur2words(540000000000.00), "пятьсот сорок миллиардов рублей 00 копеек"; };
	it "541000000000.00" => sub { is rur2words(541000000000.00), "пятьсот сорок один миллиард рублей 00 копеек"; };
	it "542000000000.00" => sub { is rur2words(542000000000.00), "пятьсот сорок два миллиарда рублей 00 копеек"; };
	it "543000000000.00" => sub { is rur2words(543000000000.00), "пятьсот сорок три миллиарда рублей 00 копеек"; };
	it "544000000000.00" => sub { is rur2words(544000000000.00), "пятьсот сорок четыре миллиарда рублей 00 копеек"; };
	it "545000000000.00" => sub { is rur2words(545000000000.00), "пятьсот сорок пять миллиардов рублей 00 копеек"; };
	it "546000000000.00" => sub { is rur2words(546000000000.00), "пятьсот сорок шесть миллиардов рублей 00 копеек"; };
	it "547000000000.00" => sub { is rur2words(547000000000.00), "пятьсот сорок семь миллиардов рублей 00 копеек"; };
	it "548000000000.00" => sub { is rur2words(548000000000.00), "пятьсот сорок восемь миллиардов рублей 00 копеек"; };
	it "549000000000.00" => sub { is rur2words(549000000000.00), "пятьсот сорок девять миллиардов рублей 00 копеек"; };
	it "550000000000.00" => sub { is rur2words(550000000000.00), "пятьсот пятьдесят миллиардов рублей 00 копеек"; };
	it "551000000000.00" => sub { is rur2words(551000000000.00), "пятьсот пятьдесят один миллиард рублей 00 копеек"; };
	it "552000000000.00" => sub { is rur2words(552000000000.00), "пятьсот пятьдесят два миллиарда рублей 00 копеек"; };
	it "553000000000.00" => sub { is rur2words(553000000000.00), "пятьсот пятьдесят три миллиарда рублей 00 копеек"; };
	it "554000000000.00" => sub { is rur2words(554000000000.00), "пятьсот пятьдесят четыре миллиарда рублей 00 копеек"; };
	it "555000000000.00" => sub { is rur2words(555000000000.00), "пятьсот пятьдесят пять миллиардов рублей 00 копеек"; };
	it "556000000000.00" => sub { is rur2words(556000000000.00), "пятьсот пятьдесят шесть миллиардов рублей 00 копеек"; };
	it "557000000000.00" => sub { is rur2words(557000000000.00), "пятьсот пятьдесят семь миллиардов рублей 00 копеек"; };
	it "558000000000.00" => sub { is rur2words(558000000000.00), "пятьсот пятьдесят восемь миллиардов рублей 00 копеек"; };
	it "559000000000.00" => sub { is rur2words(559000000000.00), "пятьсот пятьдесят девять миллиардов рублей 00 копеек"; };
	it "560000000000.00" => sub { is rur2words(560000000000.00), "пятьсот шестьдесят миллиардов рублей 00 копеек"; };
	it "561000000000.00" => sub { is rur2words(561000000000.00), "пятьсот шестьдесят один миллиард рублей 00 копеек"; };
	it "562000000000.00" => sub { is rur2words(562000000000.00), "пятьсот шестьдесят два миллиарда рублей 00 копеек"; };
	it "563000000000.00" => sub { is rur2words(563000000000.00), "пятьсот шестьдесят три миллиарда рублей 00 копеек"; };
	it "564000000000.00" => sub { is rur2words(564000000000.00), "пятьсот шестьдесят четыре миллиарда рублей 00 копеек"; };
	it "565000000000.00" => sub { is rur2words(565000000000.00), "пятьсот шестьдесят пять миллиардов рублей 00 копеек"; };
	it "566000000000.00" => sub { is rur2words(566000000000.00), "пятьсот шестьдесят шесть миллиардов рублей 00 копеек"; };
	it "567000000000.00" => sub { is rur2words(567000000000.00), "пятьсот шестьдесят семь миллиардов рублей 00 копеек"; };
	it "568000000000.00" => sub { is rur2words(568000000000.00), "пятьсот шестьдесят восемь миллиардов рублей 00 копеек"; };
	it "569000000000.00" => sub { is rur2words(569000000000.00), "пятьсот шестьдесят девять миллиардов рублей 00 копеек"; };
	it "570000000000.00" => sub { is rur2words(570000000000.00), "пятьсот семьдесят миллиардов рублей 00 копеек"; };
	it "571000000000.00" => sub { is rur2words(571000000000.00), "пятьсот семьдесят один миллиард рублей 00 копеек"; };
	it "572000000000.00" => sub { is rur2words(572000000000.00), "пятьсот семьдесят два миллиарда рублей 00 копеек"; };
	it "573000000000.00" => sub { is rur2words(573000000000.00), "пятьсот семьдесят три миллиарда рублей 00 копеек"; };
	it "574000000000.00" => sub { is rur2words(574000000000.00), "пятьсот семьдесят четыре миллиарда рублей 00 копеек"; };
	it "575000000000.00" => sub { is rur2words(575000000000.00), "пятьсот семьдесят пять миллиардов рублей 00 копеек"; };
	it "576000000000.00" => sub { is rur2words(576000000000.00), "пятьсот семьдесят шесть миллиардов рублей 00 копеек"; };
	it "577000000000.00" => sub { is rur2words(577000000000.00), "пятьсот семьдесят семь миллиардов рублей 00 копеек"; };
	it "578000000000.00" => sub { is rur2words(578000000000.00), "пятьсот семьдесят восемь миллиардов рублей 00 копеек"; };
	it "579000000000.00" => sub { is rur2words(579000000000.00), "пятьсот семьдесят девять миллиардов рублей 00 копеек"; };
	it "580000000000.00" => sub { is rur2words(580000000000.00), "пятьсот восемьдесят миллиардов рублей 00 копеек"; };
	it "581000000000.00" => sub { is rur2words(581000000000.00), "пятьсот восемьдесят один миллиард рублей 00 копеек"; };
	it "582000000000.00" => sub { is rur2words(582000000000.00), "пятьсот восемьдесят два миллиарда рублей 00 копеек"; };
	it "583000000000.00" => sub { is rur2words(583000000000.00), "пятьсот восемьдесят три миллиарда рублей 00 копеек"; };
	it "584000000000.00" => sub { is rur2words(584000000000.00), "пятьсот восемьдесят четыре миллиарда рублей 00 копеек"; };
	it "585000000000.00" => sub { is rur2words(585000000000.00), "пятьсот восемьдесят пять миллиардов рублей 00 копеек"; };
	it "586000000000.00" => sub { is rur2words(586000000000.00), "пятьсот восемьдесят шесть миллиардов рублей 00 копеек"; };
	it "587000000000.00" => sub { is rur2words(587000000000.00), "пятьсот восемьдесят семь миллиардов рублей 00 копеек"; };
	it "588000000000.00" => sub { is rur2words(588000000000.00), "пятьсот восемьдесят восемь миллиардов рублей 00 копеек"; };
	it "589000000000.00" => sub { is rur2words(589000000000.00), "пятьсот восемьдесят девять миллиардов рублей 00 копеек"; };
	it "590000000000.00" => sub { is rur2words(590000000000.00), "пятьсот девяносто миллиардов рублей 00 копеек"; };
	it "591000000000.00" => sub { is rur2words(591000000000.00), "пятьсот девяносто один миллиард рублей 00 копеек"; };
	it "592000000000.00" => sub { is rur2words(592000000000.00), "пятьсот девяносто два миллиарда рублей 00 копеек"; };
	it "593000000000.00" => sub { is rur2words(593000000000.00), "пятьсот девяносто три миллиарда рублей 00 копеек"; };
	it "594000000000.00" => sub { is rur2words(594000000000.00), "пятьсот девяносто четыре миллиарда рублей 00 копеек"; };
	it "595000000000.00" => sub { is rur2words(595000000000.00), "пятьсот девяносто пять миллиардов рублей 00 копеек"; };
	it "596000000000.00" => sub { is rur2words(596000000000.00), "пятьсот девяносто шесть миллиардов рублей 00 копеек"; };
	it "597000000000.00" => sub { is rur2words(597000000000.00), "пятьсот девяносто семь миллиардов рублей 00 копеек"; };
	it "598000000000.00" => sub { is rur2words(598000000000.00), "пятьсот девяносто восемь миллиардов рублей 00 копеек"; };
	it "599000000000.00" => sub { is rur2words(599000000000.00), "пятьсот девяносто девять миллиардов рублей 00 копеек"; };
	it "600000000000.00" => sub { is rur2words(600000000000.00), "шестьсот миллиардов рублей 00 копеек"; };
	it "601000000000.00" => sub { is rur2words(601000000000.00), "шестьсот один миллиард рублей 00 копеек"; };
	it "602000000000.00" => sub { is rur2words(602000000000.00), "шестьсот два миллиарда рублей 00 копеек"; };
	it "603000000000.00" => sub { is rur2words(603000000000.00), "шестьсот три миллиарда рублей 00 копеек"; };
	it "604000000000.00" => sub { is rur2words(604000000000.00), "шестьсот четыре миллиарда рублей 00 копеек"; };
	it "605000000000.00" => sub { is rur2words(605000000000.00), "шестьсот пять миллиардов рублей 00 копеек"; };
	it "606000000000.00" => sub { is rur2words(606000000000.00), "шестьсот шесть миллиардов рублей 00 копеек"; };
	it "607000000000.00" => sub { is rur2words(607000000000.00), "шестьсот семь миллиардов рублей 00 копеек"; };
	it "608000000000.00" => sub { is rur2words(608000000000.00), "шестьсот восемь миллиардов рублей 00 копеек"; };
	it "609000000000.00" => sub { is rur2words(609000000000.00), "шестьсот девять миллиардов рублей 00 копеек"; };
	it "610000000000.00" => sub { is rur2words(610000000000.00), "шестьсот десять миллиардов рублей 00 копеек"; };
	it "611000000000.00" => sub { is rur2words(611000000000.00), "шестьсот одиннадцать миллиардов рублей 00 копеек"; };
	it "612000000000.00" => sub { is rur2words(612000000000.00), "шестьсот двенадцать миллиардов рублей 00 копеек"; };
	it "613000000000.00" => sub { is rur2words(613000000000.00), "шестьсот тринадцать миллиардов рублей 00 копеек"; };
	it "614000000000.00" => sub { is rur2words(614000000000.00), "шестьсот четырнадцать миллиардов рублей 00 копеек"; };
	it "615000000000.00" => sub { is rur2words(615000000000.00), "шестьсот пятнадцать миллиардов рублей 00 копеек"; };
	it "616000000000.00" => sub { is rur2words(616000000000.00), "шестьсот шестнадцать миллиардов рублей 00 копеек"; };
	it "617000000000.00" => sub { is rur2words(617000000000.00), "шестьсот семнадцать миллиардов рублей 00 копеек"; };
	it "618000000000.00" => sub { is rur2words(618000000000.00), "шестьсот восемнадцать миллиардов рублей 00 копеек"; };
	it "619000000000.00" => sub { is rur2words(619000000000.00), "шестьсот девятнадцать миллиардов рублей 00 копеек"; };
	it "620000000000.00" => sub { is rur2words(620000000000.00), "шестьсот двадцать миллиардов рублей 00 копеек"; };
	it "621000000000.00" => sub { is rur2words(621000000000.00), "шестьсот двадцать один миллиард рублей 00 копеек"; };
	it "622000000000.00" => sub { is rur2words(622000000000.00), "шестьсот двадцать два миллиарда рублей 00 копеек"; };
	it "623000000000.00" => sub { is rur2words(623000000000.00), "шестьсот двадцать три миллиарда рублей 00 копеек"; };
	it "624000000000.00" => sub { is rur2words(624000000000.00), "шестьсот двадцать четыре миллиарда рублей 00 копеек"; };
	it "625000000000.00" => sub { is rur2words(625000000000.00), "шестьсот двадцать пять миллиардов рублей 00 копеек"; };
	it "626000000000.00" => sub { is rur2words(626000000000.00), "шестьсот двадцать шесть миллиардов рублей 00 копеек"; };
	it "627000000000.00" => sub { is rur2words(627000000000.00), "шестьсот двадцать семь миллиардов рублей 00 копеек"; };
	it "628000000000.00" => sub { is rur2words(628000000000.00), "шестьсот двадцать восемь миллиардов рублей 00 копеек"; };
	it "629000000000.00" => sub { is rur2words(629000000000.00), "шестьсот двадцать девять миллиардов рублей 00 копеек"; };
	it "630000000000.00" => sub { is rur2words(630000000000.00), "шестьсот тридцать миллиардов рублей 00 копеек"; };
	it "631000000000.00" => sub { is rur2words(631000000000.00), "шестьсот тридцать один миллиард рублей 00 копеек"; };
	it "632000000000.00" => sub { is rur2words(632000000000.00), "шестьсот тридцать два миллиарда рублей 00 копеек"; };
	it "633000000000.00" => sub { is rur2words(633000000000.00), "шестьсот тридцать три миллиарда рублей 00 копеек"; };
	it "634000000000.00" => sub { is rur2words(634000000000.00), "шестьсот тридцать четыре миллиарда рублей 00 копеек"; };
	it "635000000000.00" => sub { is rur2words(635000000000.00), "шестьсот тридцать пять миллиардов рублей 00 копеек"; };
	it "636000000000.00" => sub { is rur2words(636000000000.00), "шестьсот тридцать шесть миллиардов рублей 00 копеек"; };
	it "637000000000.00" => sub { is rur2words(637000000000.00), "шестьсот тридцать семь миллиардов рублей 00 копеек"; };
	it "638000000000.00" => sub { is rur2words(638000000000.00), "шестьсот тридцать восемь миллиардов рублей 00 копеек"; };
	it "639000000000.00" => sub { is rur2words(639000000000.00), "шестьсот тридцать девять миллиардов рублей 00 копеек"; };
	it "640000000000.00" => sub { is rur2words(640000000000.00), "шестьсот сорок миллиардов рублей 00 копеек"; };
	it "641000000000.00" => sub { is rur2words(641000000000.00), "шестьсот сорок один миллиард рублей 00 копеек"; };
	it "642000000000.00" => sub { is rur2words(642000000000.00), "шестьсот сорок два миллиарда рублей 00 копеек"; };
	it "643000000000.00" => sub { is rur2words(643000000000.00), "шестьсот сорок три миллиарда рублей 00 копеек"; };
	it "644000000000.00" => sub { is rur2words(644000000000.00), "шестьсот сорок четыре миллиарда рублей 00 копеек"; };
	it "645000000000.00" => sub { is rur2words(645000000000.00), "шестьсот сорок пять миллиардов рублей 00 копеек"; };
	it "646000000000.00" => sub { is rur2words(646000000000.00), "шестьсот сорок шесть миллиардов рублей 00 копеек"; };
	it "647000000000.00" => sub { is rur2words(647000000000.00), "шестьсот сорок семь миллиардов рублей 00 копеек"; };
	it "648000000000.00" => sub { is rur2words(648000000000.00), "шестьсот сорок восемь миллиардов рублей 00 копеек"; };
	it "649000000000.00" => sub { is rur2words(649000000000.00), "шестьсот сорок девять миллиардов рублей 00 копеек"; };
	it "650000000000.00" => sub { is rur2words(650000000000.00), "шестьсот пятьдесят миллиардов рублей 00 копеек"; };
	it "651000000000.00" => sub { is rur2words(651000000000.00), "шестьсот пятьдесят один миллиард рублей 00 копеек"; };
	it "652000000000.00" => sub { is rur2words(652000000000.00), "шестьсот пятьдесят два миллиарда рублей 00 копеек"; };
	it "653000000000.00" => sub { is rur2words(653000000000.00), "шестьсот пятьдесят три миллиарда рублей 00 копеек"; };
	it "654000000000.00" => sub { is rur2words(654000000000.00), "шестьсот пятьдесят четыре миллиарда рублей 00 копеек"; };
	it "655000000000.00" => sub { is rur2words(655000000000.00), "шестьсот пятьдесят пять миллиардов рублей 00 копеек"; };
	it "656000000000.00" => sub { is rur2words(656000000000.00), "шестьсот пятьдесят шесть миллиардов рублей 00 копеек"; };
	it "657000000000.00" => sub { is rur2words(657000000000.00), "шестьсот пятьдесят семь миллиардов рублей 00 копеек"; };
	it "658000000000.00" => sub { is rur2words(658000000000.00), "шестьсот пятьдесят восемь миллиардов рублей 00 копеек"; };
	it "659000000000.00" => sub { is rur2words(659000000000.00), "шестьсот пятьдесят девять миллиардов рублей 00 копеек"; };
	it "660000000000.00" => sub { is rur2words(660000000000.00), "шестьсот шестьдесят миллиардов рублей 00 копеек"; };
	it "661000000000.00" => sub { is rur2words(661000000000.00), "шестьсот шестьдесят один миллиард рублей 00 копеек"; };
	it "662000000000.00" => sub { is rur2words(662000000000.00), "шестьсот шестьдесят два миллиарда рублей 00 копеек"; };
	it "663000000000.00" => sub { is rur2words(663000000000.00), "шестьсот шестьдесят три миллиарда рублей 00 копеек"; };
	it "664000000000.00" => sub { is rur2words(664000000000.00), "шестьсот шестьдесят четыре миллиарда рублей 00 копеек"; };
	it "665000000000.00" => sub { is rur2words(665000000000.00), "шестьсот шестьдесят пять миллиардов рублей 00 копеек"; };
	it "666000000000.00" => sub { is rur2words(666000000000.00), "шестьсот шестьдесят шесть миллиардов рублей 00 копеек"; };
	it "667000000000.00" => sub { is rur2words(667000000000.00), "шестьсот шестьдесят семь миллиардов рублей 00 копеек"; };
	it "668000000000.00" => sub { is rur2words(668000000000.00), "шестьсот шестьдесят восемь миллиардов рублей 00 копеек"; };
	it "669000000000.00" => sub { is rur2words(669000000000.00), "шестьсот шестьдесят девять миллиардов рублей 00 копеек"; };
	it "670000000000.00" => sub { is rur2words(670000000000.00), "шестьсот семьдесят миллиардов рублей 00 копеек"; };
	it "671000000000.00" => sub { is rur2words(671000000000.00), "шестьсот семьдесят один миллиард рублей 00 копеек"; };
	it "672000000000.00" => sub { is rur2words(672000000000.00), "шестьсот семьдесят два миллиарда рублей 00 копеек"; };
	it "673000000000.00" => sub { is rur2words(673000000000.00), "шестьсот семьдесят три миллиарда рублей 00 копеек"; };
	it "674000000000.00" => sub { is rur2words(674000000000.00), "шестьсот семьдесят четыре миллиарда рублей 00 копеек"; };
	it "675000000000.00" => sub { is rur2words(675000000000.00), "шестьсот семьдесят пять миллиардов рублей 00 копеек"; };
	it "676000000000.00" => sub { is rur2words(676000000000.00), "шестьсот семьдесят шесть миллиардов рублей 00 копеек"; };
	it "677000000000.00" => sub { is rur2words(677000000000.00), "шестьсот семьдесят семь миллиардов рублей 00 копеек"; };
	it "678000000000.00" => sub { is rur2words(678000000000.00), "шестьсот семьдесят восемь миллиардов рублей 00 копеек"; };
	it "679000000000.00" => sub { is rur2words(679000000000.00), "шестьсот семьдесят девять миллиардов рублей 00 копеек"; };
	it "680000000000.00" => sub { is rur2words(680000000000.00), "шестьсот восемьдесят миллиардов рублей 00 копеек"; };
	it "681000000000.00" => sub { is rur2words(681000000000.00), "шестьсот восемьдесят один миллиард рублей 00 копеек"; };
	it "682000000000.00" => sub { is rur2words(682000000000.00), "шестьсот восемьдесят два миллиарда рублей 00 копеек"; };
	it "683000000000.00" => sub { is rur2words(683000000000.00), "шестьсот восемьдесят три миллиарда рублей 00 копеек"; };
	it "684000000000.00" => sub { is rur2words(684000000000.00), "шестьсот восемьдесят четыре миллиарда рублей 00 копеек"; };
	it "685000000000.00" => sub { is rur2words(685000000000.00), "шестьсот восемьдесят пять миллиардов рублей 00 копеек"; };
	it "686000000000.00" => sub { is rur2words(686000000000.00), "шестьсот восемьдесят шесть миллиардов рублей 00 копеек"; };
	it "687000000000.00" => sub { is rur2words(687000000000.00), "шестьсот восемьдесят семь миллиардов рублей 00 копеек"; };
	it "688000000000.00" => sub { is rur2words(688000000000.00), "шестьсот восемьдесят восемь миллиардов рублей 00 копеек"; };
	it "689000000000.00" => sub { is rur2words(689000000000.00), "шестьсот восемьдесят девять миллиардов рублей 00 копеек"; };
	it "690000000000.00" => sub { is rur2words(690000000000.00), "шестьсот девяносто миллиардов рублей 00 копеек"; };
	it "691000000000.00" => sub { is rur2words(691000000000.00), "шестьсот девяносто один миллиард рублей 00 копеек"; };
	it "692000000000.00" => sub { is rur2words(692000000000.00), "шестьсот девяносто два миллиарда рублей 00 копеек"; };
	it "693000000000.00" => sub { is rur2words(693000000000.00), "шестьсот девяносто три миллиарда рублей 00 копеек"; };
	it "694000000000.00" => sub { is rur2words(694000000000.00), "шестьсот девяносто четыре миллиарда рублей 00 копеек"; };
	it "695000000000.00" => sub { is rur2words(695000000000.00), "шестьсот девяносто пять миллиардов рублей 00 копеек"; };
	it "696000000000.00" => sub { is rur2words(696000000000.00), "шестьсот девяносто шесть миллиардов рублей 00 копеек"; };
	it "697000000000.00" => sub { is rur2words(697000000000.00), "шестьсот девяносто семь миллиардов рублей 00 копеек"; };
	it "698000000000.00" => sub { is rur2words(698000000000.00), "шестьсот девяносто восемь миллиардов рублей 00 копеек"; };
	it "699000000000.00" => sub { is rur2words(699000000000.00), "шестьсот девяносто девять миллиардов рублей 00 копеек"; };
	it "700000000000.00" => sub { is rur2words(700000000000.00), "семьсот миллиардов рублей 00 копеек"; };
	it "701000000000.00" => sub { is rur2words(701000000000.00), "семьсот один миллиард рублей 00 копеек"; };
	it "702000000000.00" => sub { is rur2words(702000000000.00), "семьсот два миллиарда рублей 00 копеек"; };
	it "703000000000.00" => sub { is rur2words(703000000000.00), "семьсот три миллиарда рублей 00 копеек"; };
	it "704000000000.00" => sub { is rur2words(704000000000.00), "семьсот четыре миллиарда рублей 00 копеек"; };
	it "705000000000.00" => sub { is rur2words(705000000000.00), "семьсот пять миллиардов рублей 00 копеек"; };
	it "706000000000.00" => sub { is rur2words(706000000000.00), "семьсот шесть миллиардов рублей 00 копеек"; };
	it "707000000000.00" => sub { is rur2words(707000000000.00), "семьсот семь миллиардов рублей 00 копеек"; };
	it "708000000000.00" => sub { is rur2words(708000000000.00), "семьсот восемь миллиардов рублей 00 копеек"; };
	it "709000000000.00" => sub { is rur2words(709000000000.00), "семьсот девять миллиардов рублей 00 копеек"; };
	it "710000000000.00" => sub { is rur2words(710000000000.00), "семьсот десять миллиардов рублей 00 копеек"; };
	it "711000000000.00" => sub { is rur2words(711000000000.00), "семьсот одиннадцать миллиардов рублей 00 копеек"; };
	it "712000000000.00" => sub { is rur2words(712000000000.00), "семьсот двенадцать миллиардов рублей 00 копеек"; };
	it "713000000000.00" => sub { is rur2words(713000000000.00), "семьсот тринадцать миллиардов рублей 00 копеек"; };
	it "714000000000.00" => sub { is rur2words(714000000000.00), "семьсот четырнадцать миллиардов рублей 00 копеек"; };
	it "715000000000.00" => sub { is rur2words(715000000000.00), "семьсот пятнадцать миллиардов рублей 00 копеек"; };
	it "716000000000.00" => sub { is rur2words(716000000000.00), "семьсот шестнадцать миллиардов рублей 00 копеек"; };
	it "717000000000.00" => sub { is rur2words(717000000000.00), "семьсот семнадцать миллиардов рублей 00 копеек"; };
	it "718000000000.00" => sub { is rur2words(718000000000.00), "семьсот восемнадцать миллиардов рублей 00 копеек"; };
	it "719000000000.00" => sub { is rur2words(719000000000.00), "семьсот девятнадцать миллиардов рублей 00 копеек"; };
	it "720000000000.00" => sub { is rur2words(720000000000.00), "семьсот двадцать миллиардов рублей 00 копеек"; };
	it "721000000000.00" => sub { is rur2words(721000000000.00), "семьсот двадцать один миллиард рублей 00 копеек"; };
	it "722000000000.00" => sub { is rur2words(722000000000.00), "семьсот двадцать два миллиарда рублей 00 копеек"; };
	it "723000000000.00" => sub { is rur2words(723000000000.00), "семьсот двадцать три миллиарда рублей 00 копеек"; };
	it "724000000000.00" => sub { is rur2words(724000000000.00), "семьсот двадцать четыре миллиарда рублей 00 копеек"; };
	it "725000000000.00" => sub { is rur2words(725000000000.00), "семьсот двадцать пять миллиардов рублей 00 копеек"; };
	it "726000000000.00" => sub { is rur2words(726000000000.00), "семьсот двадцать шесть миллиардов рублей 00 копеек"; };
	it "727000000000.00" => sub { is rur2words(727000000000.00), "семьсот двадцать семь миллиардов рублей 00 копеек"; };
	it "728000000000.00" => sub { is rur2words(728000000000.00), "семьсот двадцать восемь миллиардов рублей 00 копеек"; };
	it "729000000000.00" => sub { is rur2words(729000000000.00), "семьсот двадцать девять миллиардов рублей 00 копеек"; };
	it "730000000000.00" => sub { is rur2words(730000000000.00), "семьсот тридцать миллиардов рублей 00 копеек"; };
	it "731000000000.00" => sub { is rur2words(731000000000.00), "семьсот тридцать один миллиард рублей 00 копеек"; };
	it "732000000000.00" => sub { is rur2words(732000000000.00), "семьсот тридцать два миллиарда рублей 00 копеек"; };
	it "733000000000.00" => sub { is rur2words(733000000000.00), "семьсот тридцать три миллиарда рублей 00 копеек"; };
	it "734000000000.00" => sub { is rur2words(734000000000.00), "семьсот тридцать четыре миллиарда рублей 00 копеек"; };
	it "735000000000.00" => sub { is rur2words(735000000000.00), "семьсот тридцать пять миллиардов рублей 00 копеек"; };
	it "736000000000.00" => sub { is rur2words(736000000000.00), "семьсот тридцать шесть миллиардов рублей 00 копеек"; };
	it "737000000000.00" => sub { is rur2words(737000000000.00), "семьсот тридцать семь миллиардов рублей 00 копеек"; };
	it "738000000000.00" => sub { is rur2words(738000000000.00), "семьсот тридцать восемь миллиардов рублей 00 копеек"; };
	it "739000000000.00" => sub { is rur2words(739000000000.00), "семьсот тридцать девять миллиардов рублей 00 копеек"; };
	it "740000000000.00" => sub { is rur2words(740000000000.00), "семьсот сорок миллиардов рублей 00 копеек"; };
	it "741000000000.00" => sub { is rur2words(741000000000.00), "семьсот сорок один миллиард рублей 00 копеек"; };
	it "742000000000.00" => sub { is rur2words(742000000000.00), "семьсот сорок два миллиарда рублей 00 копеек"; };
	it "743000000000.00" => sub { is rur2words(743000000000.00), "семьсот сорок три миллиарда рублей 00 копеек"; };
	it "744000000000.00" => sub { is rur2words(744000000000.00), "семьсот сорок четыре миллиарда рублей 00 копеек"; };
	it "745000000000.00" => sub { is rur2words(745000000000.00), "семьсот сорок пять миллиардов рублей 00 копеек"; };
	it "746000000000.00" => sub { is rur2words(746000000000.00), "семьсот сорок шесть миллиардов рублей 00 копеек"; };
	it "747000000000.00" => sub { is rur2words(747000000000.00), "семьсот сорок семь миллиардов рублей 00 копеек"; };
	it "748000000000.00" => sub { is rur2words(748000000000.00), "семьсот сорок восемь миллиардов рублей 00 копеек"; };
	it "749000000000.00" => sub { is rur2words(749000000000.00), "семьсот сорок девять миллиардов рублей 00 копеек"; };
	it "750000000000.00" => sub { is rur2words(750000000000.00), "семьсот пятьдесят миллиардов рублей 00 копеек"; };
	it "751000000000.00" => sub { is rur2words(751000000000.00), "семьсот пятьдесят один миллиард рублей 00 копеек"; };
	it "752000000000.00" => sub { is rur2words(752000000000.00), "семьсот пятьдесят два миллиарда рублей 00 копеек"; };
	it "753000000000.00" => sub { is rur2words(753000000000.00), "семьсот пятьдесят три миллиарда рублей 00 копеек"; };
	it "754000000000.00" => sub { is rur2words(754000000000.00), "семьсот пятьдесят четыре миллиарда рублей 00 копеек"; };
	it "755000000000.00" => sub { is rur2words(755000000000.00), "семьсот пятьдесят пять миллиардов рублей 00 копеек"; };
	it "756000000000.00" => sub { is rur2words(756000000000.00), "семьсот пятьдесят шесть миллиардов рублей 00 копеек"; };
	it "757000000000.00" => sub { is rur2words(757000000000.00), "семьсот пятьдесят семь миллиардов рублей 00 копеек"; };
	it "758000000000.00" => sub { is rur2words(758000000000.00), "семьсот пятьдесят восемь миллиардов рублей 00 копеек"; };
	it "759000000000.00" => sub { is rur2words(759000000000.00), "семьсот пятьдесят девять миллиардов рублей 00 копеек"; };
	it "760000000000.00" => sub { is rur2words(760000000000.00), "семьсот шестьдесят миллиардов рублей 00 копеек"; };
	it "761000000000.00" => sub { is rur2words(761000000000.00), "семьсот шестьдесят один миллиард рублей 00 копеек"; };
	it "762000000000.00" => sub { is rur2words(762000000000.00), "семьсот шестьдесят два миллиарда рублей 00 копеек"; };
	it "763000000000.00" => sub { is rur2words(763000000000.00), "семьсот шестьдесят три миллиарда рублей 00 копеек"; };
	it "764000000000.00" => sub { is rur2words(764000000000.00), "семьсот шестьдесят четыре миллиарда рублей 00 копеек"; };
	it "765000000000.00" => sub { is rur2words(765000000000.00), "семьсот шестьдесят пять миллиардов рублей 00 копеек"; };
	it "766000000000.00" => sub { is rur2words(766000000000.00), "семьсот шестьдесят шесть миллиардов рублей 00 копеек"; };
	it "767000000000.00" => sub { is rur2words(767000000000.00), "семьсот шестьдесят семь миллиардов рублей 00 копеек"; };
	it "768000000000.00" => sub { is rur2words(768000000000.00), "семьсот шестьдесят восемь миллиардов рублей 00 копеек"; };
	it "769000000000.00" => sub { is rur2words(769000000000.00), "семьсот шестьдесят девять миллиардов рублей 00 копеек"; };
	it "770000000000.00" => sub { is rur2words(770000000000.00), "семьсот семьдесят миллиардов рублей 00 копеек"; };
	it "771000000000.00" => sub { is rur2words(771000000000.00), "семьсот семьдесят один миллиард рублей 00 копеек"; };
	it "772000000000.00" => sub { is rur2words(772000000000.00), "семьсот семьдесят два миллиарда рублей 00 копеек"; };
	it "773000000000.00" => sub { is rur2words(773000000000.00), "семьсот семьдесят три миллиарда рублей 00 копеек"; };
	it "774000000000.00" => sub { is rur2words(774000000000.00), "семьсот семьдесят четыре миллиарда рублей 00 копеек"; };
	it "775000000000.00" => sub { is rur2words(775000000000.00), "семьсот семьдесят пять миллиардов рублей 00 копеек"; };
	it "776000000000.00" => sub { is rur2words(776000000000.00), "семьсот семьдесят шесть миллиардов рублей 00 копеек"; };
	it "777000000000.00" => sub { is rur2words(777000000000.00), "семьсот семьдесят семь миллиардов рублей 00 копеек"; };
	it "778000000000.00" => sub { is rur2words(778000000000.00), "семьсот семьдесят восемь миллиардов рублей 00 копеек"; };
	it "779000000000.00" => sub { is rur2words(779000000000.00), "семьсот семьдесят девять миллиардов рублей 00 копеек"; };
	it "780000000000.00" => sub { is rur2words(780000000000.00), "семьсот восемьдесят миллиардов рублей 00 копеек"; };
	it "781000000000.00" => sub { is rur2words(781000000000.00), "семьсот восемьдесят один миллиард рублей 00 копеек"; };
	it "782000000000.00" => sub { is rur2words(782000000000.00), "семьсот восемьдесят два миллиарда рублей 00 копеек"; };
	it "783000000000.00" => sub { is rur2words(783000000000.00), "семьсот восемьдесят три миллиарда рублей 00 копеек"; };
	it "784000000000.00" => sub { is rur2words(784000000000.00), "семьсот восемьдесят четыре миллиарда рублей 00 копеек"; };
	it "785000000000.00" => sub { is rur2words(785000000000.00), "семьсот восемьдесят пять миллиардов рублей 00 копеек"; };
	it "786000000000.00" => sub { is rur2words(786000000000.00), "семьсот восемьдесят шесть миллиардов рублей 00 копеек"; };
	it "787000000000.00" => sub { is rur2words(787000000000.00), "семьсот восемьдесят семь миллиардов рублей 00 копеек"; };
	it "788000000000.00" => sub { is rur2words(788000000000.00), "семьсот восемьдесят восемь миллиардов рублей 00 копеек"; };
	it "789000000000.00" => sub { is rur2words(789000000000.00), "семьсот восемьдесят девять миллиардов рублей 00 копеек"; };
	it "790000000000.00" => sub { is rur2words(790000000000.00), "семьсот девяносто миллиардов рублей 00 копеек"; };
	it "791000000000.00" => sub { is rur2words(791000000000.00), "семьсот девяносто один миллиард рублей 00 копеек"; };
	it "792000000000.00" => sub { is rur2words(792000000000.00), "семьсот девяносто два миллиарда рублей 00 копеек"; };
	it "793000000000.00" => sub { is rur2words(793000000000.00), "семьсот девяносто три миллиарда рублей 00 копеек"; };
	it "794000000000.00" => sub { is rur2words(794000000000.00), "семьсот девяносто четыре миллиарда рублей 00 копеек"; };
	it "795000000000.00" => sub { is rur2words(795000000000.00), "семьсот девяносто пять миллиардов рублей 00 копеек"; };
	it "796000000000.00" => sub { is rur2words(796000000000.00), "семьсот девяносто шесть миллиардов рублей 00 копеек"; };
	it "797000000000.00" => sub { is rur2words(797000000000.00), "семьсот девяносто семь миллиардов рублей 00 копеек"; };
	it "798000000000.00" => sub { is rur2words(798000000000.00), "семьсот девяносто восемь миллиардов рублей 00 копеек"; };
	it "799000000000.00" => sub { is rur2words(799000000000.00), "семьсот девяносто девять миллиардов рублей 00 копеек"; };
	it "800000000000.00" => sub { is rur2words(800000000000.00), "восемьсот миллиардов рублей 00 копеек"; };
	it "801000000000.00" => sub { is rur2words(801000000000.00), "восемьсот один миллиард рублей 00 копеек"; };
	it "802000000000.00" => sub { is rur2words(802000000000.00), "восемьсот два миллиарда рублей 00 копеек"; };
	it "803000000000.00" => sub { is rur2words(803000000000.00), "восемьсот три миллиарда рублей 00 копеек"; };
	it "804000000000.00" => sub { is rur2words(804000000000.00), "восемьсот четыре миллиарда рублей 00 копеек"; };
	it "805000000000.00" => sub { is rur2words(805000000000.00), "восемьсот пять миллиардов рублей 00 копеек"; };
	it "806000000000.00" => sub { is rur2words(806000000000.00), "восемьсот шесть миллиардов рублей 00 копеек"; };
	it "807000000000.00" => sub { is rur2words(807000000000.00), "восемьсот семь миллиардов рублей 00 копеек"; };
	it "808000000000.00" => sub { is rur2words(808000000000.00), "восемьсот восемь миллиардов рублей 00 копеек"; };
	it "809000000000.00" => sub { is rur2words(809000000000.00), "восемьсот девять миллиардов рублей 00 копеек"; };
	it "810000000000.00" => sub { is rur2words(810000000000.00), "восемьсот десять миллиардов рублей 00 копеек"; };
	it "811000000000.00" => sub { is rur2words(811000000000.00), "восемьсот одиннадцать миллиардов рублей 00 копеек"; };
	it "812000000000.00" => sub { is rur2words(812000000000.00), "восемьсот двенадцать миллиардов рублей 00 копеек"; };
	it "813000000000.00" => sub { is rur2words(813000000000.00), "восемьсот тринадцать миллиардов рублей 00 копеек"; };
	it "814000000000.00" => sub { is rur2words(814000000000.00), "восемьсот четырнадцать миллиардов рублей 00 копеек"; };
	it "815000000000.00" => sub { is rur2words(815000000000.00), "восемьсот пятнадцать миллиардов рублей 00 копеек"; };
	it "816000000000.00" => sub { is rur2words(816000000000.00), "восемьсот шестнадцать миллиардов рублей 00 копеек"; };
	it "817000000000.00" => sub { is rur2words(817000000000.00), "восемьсот семнадцать миллиардов рублей 00 копеек"; };
	it "818000000000.00" => sub { is rur2words(818000000000.00), "восемьсот восемнадцать миллиардов рублей 00 копеек"; };
	it "819000000000.00" => sub { is rur2words(819000000000.00), "восемьсот девятнадцать миллиардов рублей 00 копеек"; };
	it "820000000000.00" => sub { is rur2words(820000000000.00), "восемьсот двадцать миллиардов рублей 00 копеек"; };
	it "821000000000.00" => sub { is rur2words(821000000000.00), "восемьсот двадцать один миллиард рублей 00 копеек"; };
	it "822000000000.00" => sub { is rur2words(822000000000.00), "восемьсот двадцать два миллиарда рублей 00 копеек"; };
	it "823000000000.00" => sub { is rur2words(823000000000.00), "восемьсот двадцать три миллиарда рублей 00 копеек"; };
	it "824000000000.00" => sub { is rur2words(824000000000.00), "восемьсот двадцать четыре миллиарда рублей 00 копеек"; };
	it "825000000000.00" => sub { is rur2words(825000000000.00), "восемьсот двадцать пять миллиардов рублей 00 копеек"; };
	it "826000000000.00" => sub { is rur2words(826000000000.00), "восемьсот двадцать шесть миллиардов рублей 00 копеек"; };
	it "827000000000.00" => sub { is rur2words(827000000000.00), "восемьсот двадцать семь миллиардов рублей 00 копеек"; };
	it "828000000000.00" => sub { is rur2words(828000000000.00), "восемьсот двадцать восемь миллиардов рублей 00 копеек"; };
	it "829000000000.00" => sub { is rur2words(829000000000.00), "восемьсот двадцать девять миллиардов рублей 00 копеек"; };
	it "830000000000.00" => sub { is rur2words(830000000000.00), "восемьсот тридцать миллиардов рублей 00 копеек"; };
	it "831000000000.00" => sub { is rur2words(831000000000.00), "восемьсот тридцать один миллиард рублей 00 копеек"; };
	it "832000000000.00" => sub { is rur2words(832000000000.00), "восемьсот тридцать два миллиарда рублей 00 копеек"; };
	it "833000000000.00" => sub { is rur2words(833000000000.00), "восемьсот тридцать три миллиарда рублей 00 копеек"; };
	it "834000000000.00" => sub { is rur2words(834000000000.00), "восемьсот тридцать четыре миллиарда рублей 00 копеек"; };
	it "835000000000.00" => sub { is rur2words(835000000000.00), "восемьсот тридцать пять миллиардов рублей 00 копеек"; };
	it "836000000000.00" => sub { is rur2words(836000000000.00), "восемьсот тридцать шесть миллиардов рублей 00 копеек"; };
	it "837000000000.00" => sub { is rur2words(837000000000.00), "восемьсот тридцать семь миллиардов рублей 00 копеек"; };
	it "838000000000.00" => sub { is rur2words(838000000000.00), "восемьсот тридцать восемь миллиардов рублей 00 копеек"; };
	it "839000000000.00" => sub { is rur2words(839000000000.00), "восемьсот тридцать девять миллиардов рублей 00 копеек"; };
	it "840000000000.00" => sub { is rur2words(840000000000.00), "восемьсот сорок миллиардов рублей 00 копеек"; };
	it "841000000000.00" => sub { is rur2words(841000000000.00), "восемьсот сорок один миллиард рублей 00 копеек"; };
	it "842000000000.00" => sub { is rur2words(842000000000.00), "восемьсот сорок два миллиарда рублей 00 копеек"; };
	it "843000000000.00" => sub { is rur2words(843000000000.00), "восемьсот сорок три миллиарда рублей 00 копеек"; };
	it "844000000000.00" => sub { is rur2words(844000000000.00), "восемьсот сорок четыре миллиарда рублей 00 копеек"; };
	it "845000000000.00" => sub { is rur2words(845000000000.00), "восемьсот сорок пять миллиардов рублей 00 копеек"; };
	it "846000000000.00" => sub { is rur2words(846000000000.00), "восемьсот сорок шесть миллиардов рублей 00 копеек"; };
	it "847000000000.00" => sub { is rur2words(847000000000.00), "восемьсот сорок семь миллиардов рублей 00 копеек"; };
	it "848000000000.00" => sub { is rur2words(848000000000.00), "восемьсот сорок восемь миллиардов рублей 00 копеек"; };
	it "849000000000.00" => sub { is rur2words(849000000000.00), "восемьсот сорок девять миллиардов рублей 00 копеек"; };
	it "850000000000.00" => sub { is rur2words(850000000000.00), "восемьсот пятьдесят миллиардов рублей 00 копеек"; };
	it "851000000000.00" => sub { is rur2words(851000000000.00), "восемьсот пятьдесят один миллиард рублей 00 копеек"; };
	it "852000000000.00" => sub { is rur2words(852000000000.00), "восемьсот пятьдесят два миллиарда рублей 00 копеек"; };
	it "853000000000.00" => sub { is rur2words(853000000000.00), "восемьсот пятьдесят три миллиарда рублей 00 копеек"; };
	it "854000000000.00" => sub { is rur2words(854000000000.00), "восемьсот пятьдесят четыре миллиарда рублей 00 копеек"; };
	it "855000000000.00" => sub { is rur2words(855000000000.00), "восемьсот пятьдесят пять миллиардов рублей 00 копеек"; };
	it "856000000000.00" => sub { is rur2words(856000000000.00), "восемьсот пятьдесят шесть миллиардов рублей 00 копеек"; };
	it "857000000000.00" => sub { is rur2words(857000000000.00), "восемьсот пятьдесят семь миллиардов рублей 00 копеек"; };
	it "858000000000.00" => sub { is rur2words(858000000000.00), "восемьсот пятьдесят восемь миллиардов рублей 00 копеек"; };
	it "859000000000.00" => sub { is rur2words(859000000000.00), "восемьсот пятьдесят девять миллиардов рублей 00 копеек"; };
	it "860000000000.00" => sub { is rur2words(860000000000.00), "восемьсот шестьдесят миллиардов рублей 00 копеек"; };
	it "861000000000.00" => sub { is rur2words(861000000000.00), "восемьсот шестьдесят один миллиард рублей 00 копеек"; };
	it "862000000000.00" => sub { is rur2words(862000000000.00), "восемьсот шестьдесят два миллиарда рублей 00 копеек"; };
	it "863000000000.00" => sub { is rur2words(863000000000.00), "восемьсот шестьдесят три миллиарда рублей 00 копеек"; };
	it "864000000000.00" => sub { is rur2words(864000000000.00), "восемьсот шестьдесят четыре миллиарда рублей 00 копеек"; };
	it "865000000000.00" => sub { is rur2words(865000000000.00), "восемьсот шестьдесят пять миллиардов рублей 00 копеек"; };
	it "866000000000.00" => sub { is rur2words(866000000000.00), "восемьсот шестьдесят шесть миллиардов рублей 00 копеек"; };
	it "867000000000.00" => sub { is rur2words(867000000000.00), "восемьсот шестьдесят семь миллиардов рублей 00 копеек"; };
	it "868000000000.00" => sub { is rur2words(868000000000.00), "восемьсот шестьдесят восемь миллиардов рублей 00 копеек"; };
	it "869000000000.00" => sub { is rur2words(869000000000.00), "восемьсот шестьдесят девять миллиардов рублей 00 копеек"; };
	it "870000000000.00" => sub { is rur2words(870000000000.00), "восемьсот семьдесят миллиардов рублей 00 копеек"; };
	it "871000000000.00" => sub { is rur2words(871000000000.00), "восемьсот семьдесят один миллиард рублей 00 копеек"; };
	it "872000000000.00" => sub { is rur2words(872000000000.00), "восемьсот семьдесят два миллиарда рублей 00 копеек"; };
	it "873000000000.00" => sub { is rur2words(873000000000.00), "восемьсот семьдесят три миллиарда рублей 00 копеек"; };
	it "874000000000.00" => sub { is rur2words(874000000000.00), "восемьсот семьдесят четыре миллиарда рублей 00 копеек"; };
	it "875000000000.00" => sub { is rur2words(875000000000.00), "восемьсот семьдесят пять миллиардов рублей 00 копеек"; };
	it "876000000000.00" => sub { is rur2words(876000000000.00), "восемьсот семьдесят шесть миллиардов рублей 00 копеек"; };
	it "877000000000.00" => sub { is rur2words(877000000000.00), "восемьсот семьдесят семь миллиардов рублей 00 копеек"; };
	it "878000000000.00" => sub { is rur2words(878000000000.00), "восемьсот семьдесят восемь миллиардов рублей 00 копеек"; };
	it "879000000000.00" => sub { is rur2words(879000000000.00), "восемьсот семьдесят девять миллиардов рублей 00 копеек"; };
	it "880000000000.00" => sub { is rur2words(880000000000.00), "восемьсот восемьдесят миллиардов рублей 00 копеек"; };
	it "881000000000.00" => sub { is rur2words(881000000000.00), "восемьсот восемьдесят один миллиард рублей 00 копеек"; };
	it "882000000000.00" => sub { is rur2words(882000000000.00), "восемьсот восемьдесят два миллиарда рублей 00 копеек"; };
	it "883000000000.00" => sub { is rur2words(883000000000.00), "восемьсот восемьдесят три миллиарда рублей 00 копеек"; };
	it "884000000000.00" => sub { is rur2words(884000000000.00), "восемьсот восемьдесят четыре миллиарда рублей 00 копеек"; };
	it "885000000000.00" => sub { is rur2words(885000000000.00), "восемьсот восемьдесят пять миллиардов рублей 00 копеек"; };
	it "886000000000.00" => sub { is rur2words(886000000000.00), "восемьсот восемьдесят шесть миллиардов рублей 00 копеек"; };
	it "887000000000.00" => sub { is rur2words(887000000000.00), "восемьсот восемьдесят семь миллиардов рублей 00 копеек"; };
	it "888000000000.00" => sub { is rur2words(888000000000.00), "восемьсот восемьдесят восемь миллиардов рублей 00 копеек"; };
	it "889000000000.00" => sub { is rur2words(889000000000.00), "восемьсот восемьдесят девять миллиардов рублей 00 копеек"; };
	it "890000000000.00" => sub { is rur2words(890000000000.00), "восемьсот девяносто миллиардов рублей 00 копеек"; };
	it "891000000000.00" => sub { is rur2words(891000000000.00), "восемьсот девяносто один миллиард рублей 00 копеек"; };
	it "892000000000.00" => sub { is rur2words(892000000000.00), "восемьсот девяносто два миллиарда рублей 00 копеек"; };
	it "893000000000.00" => sub { is rur2words(893000000000.00), "восемьсот девяносто три миллиарда рублей 00 копеек"; };
	it "894000000000.00" => sub { is rur2words(894000000000.00), "восемьсот девяносто четыре миллиарда рублей 00 копеек"; };
	it "895000000000.00" => sub { is rur2words(895000000000.00), "восемьсот девяносто пять миллиардов рублей 00 копеек"; };
	it "896000000000.00" => sub { is rur2words(896000000000.00), "восемьсот девяносто шесть миллиардов рублей 00 копеек"; };
	it "897000000000.00" => sub { is rur2words(897000000000.00), "восемьсот девяносто семь миллиардов рублей 00 копеек"; };
	it "898000000000.00" => sub { is rur2words(898000000000.00), "восемьсот девяносто восемь миллиардов рублей 00 копеек"; };
	it "899000000000.00" => sub { is rur2words(899000000000.00), "восемьсот девяносто девять миллиардов рублей 00 копеек"; };
	it "900000000000.00" => sub { is rur2words(900000000000.00), "девятьсот миллиардов рублей 00 копеек"; };
	it "901000000000.00" => sub { is rur2words(901000000000.00), "девятьсот один миллиард рублей 00 копеек"; };
	it "902000000000.00" => sub { is rur2words(902000000000.00), "девятьсот два миллиарда рублей 00 копеек"; };
	it "903000000000.00" => sub { is rur2words(903000000000.00), "девятьсот три миллиарда рублей 00 копеек"; };
	it "904000000000.00" => sub { is rur2words(904000000000.00), "девятьсот четыре миллиарда рублей 00 копеек"; };
	it "905000000000.00" => sub { is rur2words(905000000000.00), "девятьсот пять миллиардов рублей 00 копеек"; };
	it "906000000000.00" => sub { is rur2words(906000000000.00), "девятьсот шесть миллиардов рублей 00 копеек"; };
	it "907000000000.00" => sub { is rur2words(907000000000.00), "девятьсот семь миллиардов рублей 00 копеек"; };
	it "908000000000.00" => sub { is rur2words(908000000000.00), "девятьсот восемь миллиардов рублей 00 копеек"; };
	it "909000000000.00" => sub { is rur2words(909000000000.00), "девятьсот девять миллиардов рублей 00 копеек"; };
	it "910000000000.00" => sub { is rur2words(910000000000.00), "девятьсот десять миллиардов рублей 00 копеек"; };
	it "911000000000.00" => sub { is rur2words(911000000000.00), "девятьсот одиннадцать миллиардов рублей 00 копеек"; };
	it "912000000000.00" => sub { is rur2words(912000000000.00), "девятьсот двенадцать миллиардов рублей 00 копеек"; };
	it "913000000000.00" => sub { is rur2words(913000000000.00), "девятьсот тринадцать миллиардов рублей 00 копеек"; };
	it "914000000000.00" => sub { is rur2words(914000000000.00), "девятьсот четырнадцать миллиардов рублей 00 копеек"; };
	it "915000000000.00" => sub { is rur2words(915000000000.00), "девятьсот пятнадцать миллиардов рублей 00 копеек"; };
	it "916000000000.00" => sub { is rur2words(916000000000.00), "девятьсот шестнадцать миллиардов рублей 00 копеек"; };
	it "917000000000.00" => sub { is rur2words(917000000000.00), "девятьсот семнадцать миллиардов рублей 00 копеек"; };
	it "918000000000.00" => sub { is rur2words(918000000000.00), "девятьсот восемнадцать миллиардов рублей 00 копеек"; };
	it "919000000000.00" => sub { is rur2words(919000000000.00), "девятьсот девятнадцать миллиардов рублей 00 копеек"; };
	it "920000000000.00" => sub { is rur2words(920000000000.00), "девятьсот двадцать миллиардов рублей 00 копеек"; };
	it "921000000000.00" => sub { is rur2words(921000000000.00), "девятьсот двадцать один миллиард рублей 00 копеек"; };
	it "922000000000.00" => sub { is rur2words(922000000000.00), "девятьсот двадцать два миллиарда рублей 00 копеек"; };
	it "923000000000.00" => sub { is rur2words(923000000000.00), "девятьсот двадцать три миллиарда рублей 00 копеек"; };
	it "924000000000.00" => sub { is rur2words(924000000000.00), "девятьсот двадцать четыре миллиарда рублей 00 копеек"; };
	it "925000000000.00" => sub { is rur2words(925000000000.00), "девятьсот двадцать пять миллиардов рублей 00 копеек"; };
	it "926000000000.00" => sub { is rur2words(926000000000.00), "девятьсот двадцать шесть миллиардов рублей 00 копеек"; };
	it "927000000000.00" => sub { is rur2words(927000000000.00), "девятьсот двадцать семь миллиардов рублей 00 копеек"; };
	it "928000000000.00" => sub { is rur2words(928000000000.00), "девятьсот двадцать восемь миллиардов рублей 00 копеек"; };
	it "929000000000.00" => sub { is rur2words(929000000000.00), "девятьсот двадцать девять миллиардов рублей 00 копеек"; };
	it "930000000000.00" => sub { is rur2words(930000000000.00), "девятьсот тридцать миллиардов рублей 00 копеек"; };
	it "931000000000.00" => sub { is rur2words(931000000000.00), "девятьсот тридцать один миллиард рублей 00 копеек"; };
	it "932000000000.00" => sub { is rur2words(932000000000.00), "девятьсот тридцать два миллиарда рублей 00 копеек"; };
	it "933000000000.00" => sub { is rur2words(933000000000.00), "девятьсот тридцать три миллиарда рублей 00 копеек"; };
	it "934000000000.00" => sub { is rur2words(934000000000.00), "девятьсот тридцать четыре миллиарда рублей 00 копеек"; };
	it "935000000000.00" => sub { is rur2words(935000000000.00), "девятьсот тридцать пять миллиардов рублей 00 копеек"; };
	it "936000000000.00" => sub { is rur2words(936000000000.00), "девятьсот тридцать шесть миллиардов рублей 00 копеек"; };
	it "937000000000.00" => sub { is rur2words(937000000000.00), "девятьсот тридцать семь миллиардов рублей 00 копеек"; };
	it "938000000000.00" => sub { is rur2words(938000000000.00), "девятьсот тридцать восемь миллиардов рублей 00 копеек"; };
	it "939000000000.00" => sub { is rur2words(939000000000.00), "девятьсот тридцать девять миллиардов рублей 00 копеек"; };
	it "940000000000.00" => sub { is rur2words(940000000000.00), "девятьсот сорок миллиардов рублей 00 копеек"; };
	it "941000000000.00" => sub { is rur2words(941000000000.00), "девятьсот сорок один миллиард рублей 00 копеек"; };
	it "942000000000.00" => sub { is rur2words(942000000000.00), "девятьсот сорок два миллиарда рублей 00 копеек"; };
	it "943000000000.00" => sub { is rur2words(943000000000.00), "девятьсот сорок три миллиарда рублей 00 копеек"; };
	it "944000000000.00" => sub { is rur2words(944000000000.00), "девятьсот сорок четыре миллиарда рублей 00 копеек"; };
	it "945000000000.00" => sub { is rur2words(945000000000.00), "девятьсот сорок пять миллиардов рублей 00 копеек"; };
	it "946000000000.00" => sub { is rur2words(946000000000.00), "девятьсот сорок шесть миллиардов рублей 00 копеек"; };
	it "947000000000.00" => sub { is rur2words(947000000000.00), "девятьсот сорок семь миллиардов рублей 00 копеек"; };
	it "948000000000.00" => sub { is rur2words(948000000000.00), "девятьсот сорок восемь миллиардов рублей 00 копеек"; };
	it "949000000000.00" => sub { is rur2words(949000000000.00), "девятьсот сорок девять миллиардов рублей 00 копеек"; };
	it "950000000000.00" => sub { is rur2words(950000000000.00), "девятьсот пятьдесят миллиардов рублей 00 копеек"; };
	it "951000000000.00" => sub { is rur2words(951000000000.00), "девятьсот пятьдесят один миллиард рублей 00 копеек"; };
	it "952000000000.00" => sub { is rur2words(952000000000.00), "девятьсот пятьдесят два миллиарда рублей 00 копеек"; };
	it "953000000000.00" => sub { is rur2words(953000000000.00), "девятьсот пятьдесят три миллиарда рублей 00 копеек"; };
	it "954000000000.00" => sub { is rur2words(954000000000.00), "девятьсот пятьдесят четыре миллиарда рублей 00 копеек"; };
	it "955000000000.00" => sub { is rur2words(955000000000.00), "девятьсот пятьдесят пять миллиардов рублей 00 копеек"; };
	it "956000000000.00" => sub { is rur2words(956000000000.00), "девятьсот пятьдесят шесть миллиардов рублей 00 копеек"; };
	it "957000000000.00" => sub { is rur2words(957000000000.00), "девятьсот пятьдесят семь миллиардов рублей 00 копеек"; };
	it "958000000000.00" => sub { is rur2words(958000000000.00), "девятьсот пятьдесят восемь миллиардов рублей 00 копеек"; };
	it "959000000000.00" => sub { is rur2words(959000000000.00), "девятьсот пятьдесят девять миллиардов рублей 00 копеек"; };
	it "960000000000.00" => sub { is rur2words(960000000000.00), "девятьсот шестьдесят миллиардов рублей 00 копеек"; };
	it "961000000000.00" => sub { is rur2words(961000000000.00), "девятьсот шестьдесят один миллиард рублей 00 копеек"; };
	it "962000000000.00" => sub { is rur2words(962000000000.00), "девятьсот шестьдесят два миллиарда рублей 00 копеек"; };
	it "963000000000.00" => sub { is rur2words(963000000000.00), "девятьсот шестьдесят три миллиарда рублей 00 копеек"; };
	it "964000000000.00" => sub { is rur2words(964000000000.00), "девятьсот шестьдесят четыре миллиарда рублей 00 копеек"; };
	it "965000000000.00" => sub { is rur2words(965000000000.00), "девятьсот шестьдесят пять миллиардов рублей 00 копеек"; };
	it "966000000000.00" => sub { is rur2words(966000000000.00), "девятьсот шестьдесят шесть миллиардов рублей 00 копеек"; };
	it "967000000000.00" => sub { is rur2words(967000000000.00), "девятьсот шестьдесят семь миллиардов рублей 00 копеек"; };
	it "968000000000.00" => sub { is rur2words(968000000000.00), "девятьсот шестьдесят восемь миллиардов рублей 00 копеек"; };
	it "969000000000.00" => sub { is rur2words(969000000000.00), "девятьсот шестьдесят девять миллиардов рублей 00 копеек"; };
	it "970000000000.00" => sub { is rur2words(970000000000.00), "девятьсот семьдесят миллиардов рублей 00 копеек"; };
	it "971000000000.00" => sub { is rur2words(971000000000.00), "девятьсот семьдесят один миллиард рублей 00 копеек"; };
	it "972000000000.00" => sub { is rur2words(972000000000.00), "девятьсот семьдесят два миллиарда рублей 00 копеек"; };
	it "973000000000.00" => sub { is rur2words(973000000000.00), "девятьсот семьдесят три миллиарда рублей 00 копеек"; };
	it "974000000000.00" => sub { is rur2words(974000000000.00), "девятьсот семьдесят четыре миллиарда рублей 00 копеек"; };
	it "975000000000.00" => sub { is rur2words(975000000000.00), "девятьсот семьдесят пять миллиардов рублей 00 копеек"; };
	it "976000000000.00" => sub { is rur2words(976000000000.00), "девятьсот семьдесят шесть миллиардов рублей 00 копеек"; };
	it "977000000000.00" => sub { is rur2words(977000000000.00), "девятьсот семьдесят семь миллиардов рублей 00 копеек"; };
	it "978000000000.00" => sub { is rur2words(978000000000.00), "девятьсот семьдесят восемь миллиардов рублей 00 копеек"; };
	it "979000000000.00" => sub { is rur2words(979000000000.00), "девятьсот семьдесят девять миллиардов рублей 00 копеек"; };
	it "980000000000.00" => sub { is rur2words(980000000000.00), "девятьсот восемьдесят миллиардов рублей 00 копеек"; };
	it "981000000000.00" => sub { is rur2words(981000000000.00), "девятьсот восемьдесят один миллиард рублей 00 копеек"; };
	it "982000000000.00" => sub { is rur2words(982000000000.00), "девятьсот восемьдесят два миллиарда рублей 00 копеек"; };
	it "983000000000.00" => sub { is rur2words(983000000000.00), "девятьсот восемьдесят три миллиарда рублей 00 копеек"; };
	it "984000000000.00" => sub { is rur2words(984000000000.00), "девятьсот восемьдесят четыре миллиарда рублей 00 копеек"; };
	it "985000000000.00" => sub { is rur2words(985000000000.00), "девятьсот восемьдесят пять миллиардов рублей 00 копеек"; };
	it "986000000000.00" => sub { is rur2words(986000000000.00), "девятьсот восемьдесят шесть миллиардов рублей 00 копеек"; };
	it "987000000000.00" => sub { is rur2words(987000000000.00), "девятьсот восемьдесят семь миллиардов рублей 00 копеек"; };
	it "988000000000.00" => sub { is rur2words(988000000000.00), "девятьсот восемьдесят восемь миллиардов рублей 00 копеек"; };
	it "989000000000.00" => sub { is rur2words(989000000000.00), "девятьсот восемьдесят девять миллиардов рублей 00 копеек"; };
	it "990000000000.00" => sub { is rur2words(990000000000.00), "девятьсот девяносто миллиардов рублей 00 копеек"; };
	it "991000000000.00" => sub { is rur2words(991000000000.00), "девятьсот девяносто один миллиард рублей 00 копеек"; };
	it "992000000000.00" => sub { is rur2words(992000000000.00), "девятьсот девяносто два миллиарда рублей 00 копеек"; };
	it "993000000000.00" => sub { is rur2words(993000000000.00), "девятьсот девяносто три миллиарда рублей 00 копеек"; };
	it "994000000000.00" => sub { is rur2words(994000000000.00), "девятьсот девяносто четыре миллиарда рублей 00 копеек"; };
	it "995000000000.00" => sub { is rur2words(995000000000.00), "девятьсот девяносто пять миллиардов рублей 00 копеек"; };
	it "996000000000.00" => sub { is rur2words(996000000000.00), "девятьсот девяносто шесть миллиардов рублей 00 копеек"; };
	it "997000000000.00" => sub { is rur2words(997000000000.00), "девятьсот девяносто семь миллиардов рублей 00 копеек"; };
	it "998000000000.00" => sub { is rur2words(998000000000.00), "девятьсот девяносто восемь миллиардов рублей 00 копеек"; };
	it "999000000000.00" => sub { is rur2words(999000000000.00), "девятьсот девяносто девять миллиардов рублей 00 копеек"; };
};

runtests unless caller;
