/* $Id: whatnow.c,v 1.3 2000/11/03 21:00:24 karim Exp $

Copyright (C) 2000  The PARI group.

This file is part of the PARI/GP package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "pari.h"
#include "../language/anal.h"

typedef struct whatnow_t
{
  char *name, *oldarg, *newarg;
} whatnow_t;

#define SAME NULL
#define REMOV (char *)1L

/* generated by PERL script ../util/dico */
static const whatnow_t whatnowlist[]={
{SAME},
{SAME},
{SAME},
{SAME},
{"elladd","(e,z1,z2)","(e,z1,z2)"},
{SAME},
{"matadjoint","(x)","(x)"},
{SAME},
{"ellak","(e,n)","(e,n)"},
{SAME},
{"algdep","(x,n,dec)","(x,n,dec)"},
{"nfalgtobasis","(nf,x)","(nf,x)"},
{"ellan","(e,n)","(e,n)"},
{"ellap","(e,n)","(e,n)"},
{"ellap","(e,n)","(e,n,1)"},
{"padicappr","(x,a)","(x,a)"},
{SAME},
{SAME},
{SAME},
{"matcompanion","(x)","(x)"},
{SAME},
{SAME},
{"nfbasis","(x)","(x)"},
{"nfbasis","(x)","(x,2)"},
{"nfbasistoalg","(nf,x)","(nf,x)"},
{SAME},
{SAME},
{SAME},
{SAME},
{SAME},
{SAME},
{"ellbil","(e,z1,z2)","(e,z1,z2)"},
{"binomial","(x,y)","(x,y)"},
{SAME},
{SAME},
{"contfrac","(x,lmax)","(x,,lmax)"},
{"factor","(x,lim)","(x,lim)"},
{"bnfcertify","(bnf)","(bnf)"},
{"bnfunit","(bnf)","(bnf)"},
{"bnfclassunit","(P)","(P,2)"},
{"bnfclassunit","(P)","(P,1)"},
{"bnfclassunit","(P)","(P)"},
{"quadclassunit","(D,c1,c2,g)","(D,,[c1,c2,g])"},
{"bnfinit","(P)","(P,2)"},
{"bnfinit","(P)","(P,1)"},
{"bnfinit","(P)","(P)"},
{"bnfnarrow","(bnf)","(bnf)"},
{"bnrclass","(bnf,ideal)","(bnf,ideal)"},
{"bnrclass","(bnf,ideal)","(bnf,ideal,1)"},
{"bnrclass","(bnf,ideal)","(bnf,ideal,2)"},
{"quadclassunit","(D)","(D)"},
{"sizebyte","(x)","(x)"},
{SAME},
{SAME},
{"contfrac","(x)","(x)"},
{"contfrac","(b,x)","(x,b)"},
{SAME},
{"charpoly","(x,y)","(x,y)"},
{"charpoly","(x,y)","(x,y,1)"},
{"charpoly","(x,y)","(x,y,2)"},
{"ellchangecurve","(x,y)","(x,y)"},
{SAME},
{"ellchangepoint","(x,y)","(x,y)"},
{"qfbclassno","(x)","(x)"},
{"qfbclassno","(x)","(x,1)"},
{"polcoeff","(x,s)","(x,s)"},
{"x*y","(x,y)",""},
{"component","(x,s)","(x,s)"},
{"polcompositum","(pol1,pol2)","(pol1,pol2)"},
{"polcompositum","(pol1,pol2)","(pol1,pol2,1)"},
{"qfbcompraw","(x,y)","(x,y)"},
{SAME},
{"bnrconductor","(a1)","(a1)"},
{"bnrconductorofchar","(bnr,chi)","(bnr,chi)"},
{SAME},
{SAME},
{SAME},
{"serconvol","(x,y)","(x,y)"},
{SAME},
{"core","(x)","(x,1)"},
{SAME},
{"coredisc","(x)","(x,1)"},
{SAME},
{SAME},
{"truncate","(x)","(x,&e)"},
{"polcyclo","(n)","(n)"},
{"factorback","(fa)","(fa)"},
{"bnfdecodemodule","(nf,fa)","(nf,fa)"},
{"poldegree","(x)","(x)"},
{"denominator","(x)","(x)"},
{"lindep","(x)","(x,-1)"},
{SAME},
{"matdet","(x)","(x)"},
{"matdet","(x)","(x,1)"},
{"matdetint","(x)","(x)"},
{"matdiagonal","(x)","(x)"},
{SAME},
{SAME},
{SAME},
{SAME},
{SAME},
{"poldisc","(x)","(x)"},
{"nfdisc","(x)","(x)"},
{"nfdisc","(x)","(x,2)"},
{"bnrdisc","(bnr,subgroup)","(bnr,subgroup)"},
{"bnrdisc","(bnr)","(bnr,,,2)"},
{"bnrdisclist","(bnf,list)","(bnf,list)"},
{"bnrdisclist","(bnf,arch,bound)","(bnf,bound,arch)"},
{"bnrdisclist","(bnf,bound)","(bnf,bound,,1)"},
{"bnrdisclist","(bnf,bound)","(bnf,bound)"},
{"bnrdisc","(bnr,subgroup)","(bnr,subgroup,,1)"},
{"bnrdisc","(bnr,subgroup)","(bnr,subgroup,,3)"},
{SAME},
{"divrem","(x,y)","(x,y)"},
{"sumdiv","(n,X,expr)","(n,X,expr)"},
{"mateigen","(x)","(x)"},
{SAME},
{SAME},
{SAME},
{"Euler","",""},
{SAME},
{SAME},
{"vecextract","(x,y)","(x,y)"},
{"factorial","(x)","(x)"},
{"factorcantor","(x,p)","(x,p)"},
{"factorff","(x,p,a)","(x,p,a)"},
{"factormod","(x,p)","(x,p)"},
{SAME},
{"nfbasis","(x,p)","(x,,p)"},
{"nfdisc","(x,p)","(x,,p)"},
{"polred","(x,p)","(x,,p)"},
{"polred","(x,p)","(x,2,p)"},
{SAME},
{SAME},
{"factorpadic","(x,p,r)","(x,p,r,1)"},
{"factor","(x,l,hint)","(x)"},
{"factor","(x,l,hint)","(x)"},
{"fibonacci","(x)","(x)"},
{SAME},
{SAME},
{SAME},
{SAME},
{SAME},
{SAME},
{"ffinit","(p,n)","(p,n)"},
{SAME},
{"polgalois","(x)","(x)"},
{"nfgaloisapply","(nf,aut,x)","(nf,aut,x)"},
{"nfgaloisconj","(nf)","(nf)"},
{"nfgaloisconj","(nf)","(nf,2)"},
{"nfgaloisconj","","(nf,1)"},
{"gammah","(x)","(x)"},
{SAME},
{"matsolve","(a,b)","(a,b)"},
{"matsolvemod","(M,D,Y)","(M,D,Y)"},
{"matsolvemod","(M,D,Y)","(M,D,Y,1)"},
{SAME},
{SAME},
{SAME},
{SAME},
{SAME},
{"ellglobalred","(x,y)","(x,y)"},
{REMOV},
{"qfbhclassno","(x)","(x)"},
{"ellheight","(e,x)","(e,x)"},
{"ellheight","(e,x)","(e,x,1)"},
{"mathnf","(x)","(x)"},
{"mathnf","(x)","(x,1)"},
{"mathnf","(x)","(x,2)"},
{"mathnfmod","(x,d)","(x,d)"},
{"mathnfmodid","(x,d)","(x,d)"},
{"mathnf","(x)","(x,3)"},
{"mathess","(x)","(x)"},
{"hilbert","(x,y)","(x,y)"},
{"mathilbert","(n)","(n)"},
{"hilbert","(x,y,p)","(x,y,p)"},
{"vector","(n,X,expr)","(n,X,expr)"},
{SAME},
{"I","",""},
{SAME},
{"idealaddtoone","(nf,list)","(nf,list)"},
{"idealaddtoone","(nf,x,y)","(nf,x,y)"},
{SAME},
{"idealappr","(nf,x)","(nf,x,1)"},
{SAME},
{SAME},
{SAME},
{"idealdiv","(nf,x,y)","(nf,x,y,1)"},
{SAME},
{"idealhnf","(nf,x)","(nf,x)"},
{"idealhnf","(nf,x)","(nf,x)"},
{SAME},
{SAME},
{"idealinv","(nf,x)","(nf,x,1)"},
{SAME},
{SAME},
{"ideallistarch","(nf,list,arch)","(nf,list,arch,1)"},
{"ideallist","(nf,list)","(nf,list,2)"},
{"ideallistarch","","(nf,list,arch,2)"},
{"ideallistarch","","(nf,list,arch,3)"},
{"ideallist","","(nf,list,3)"},
{"ideallist","(nf,bound)","(nf,bound)"},
{"ideallist","(nf,bound)","(nf,bound,1)"},
{"idealred","(nf,x,vdir)","(nf,x,vdir)"},
{SAME},
{"idealmul","(nf,x,y)","(nf,x,y,1)"},
{SAME},
{SAME},
{"idealpow","(nf,x,y)","(nf,x,y,1)"},
{SAME},
{"idealtwoelt","(nf,x,a)","(nf,x,a)"},
{SAME},
{"matid","(n)","(n)"},
{SAME},
{SAME},
{"matimage","(x)","(x)"},
{"matimage","(x)","(x,1)"},
{"matimagecompl","(x)","(x)"},
{SAME},
{REMOV},
{REMOV},
{REMOV},
{"incgam","(s,x,y)","(s,x,y)"},
{"matindexrank","(x)","(x)"},
{"vecsort","(x)","(x,,1)"},
{"nfinit","(pol)","(pol)"},
{"nfinit","(x)","(x,2)"},
{"nfinit","(x)","(x,3)"},
{"ellinit","(x)","(x)"},
{"zetakinit","(x)","(x)"},
{"intformal","(x,y)","(x,y)"},
{"matintersect","(x,y)","(x,y)"},
{"intnum","(x=a,b,s)","(x=a,b,s,1)"},
{"intnum","(x=a,b,s)","(x=a,b,s,2)"},
{SAME},
{"intnum","(x=a,b,s)","(x=a,b,s,3)"},
{"matinverseimage","(x,y)","(x,y)"},
{"matisdiagonal","(x)","(x)"},
{"isfundamental","(x)","(x)"},
{"nfisideal","(nf,x)","(nf,x)"},
{"nfisincl","(x,y)","(x,y)"},
{"nfisincl","(nf1,nf2)","(nf1,nf2,1)"},
{"polisirreducible","(x)","(x)"},
{"nfisisom","(x,y)","(x,y)"},
{"nfisisom","(x,y)","(x,y)"},
{"ellisoncurve","(e,x)","(e,x)"},
{SAME},
{"bnfisprincipal","(bnf,x)","(bnf,x,0)"},
{"bnfisprincipal","(bnf,x)","(bnf,x,2)"},
{"bnfisprincipal","(bnf,x)","(bnf,x)"},
{"bnfisprincipal","(bnf,x)","(bnf,x,3)"},
{"bnrisprincipal","(bnf,x)","(bnf,x)"},
{SAME},
{"ispseudoprime","(x)","(x)"},
{"sqrtint","(x)","(x)"},
{"setisset","(x)","(x)"},
{"issquarefree","(x)","(x)"},
{SAME},
{"bnfisunit","(bnf,x)","(bnf,x)"},
{"qfjacobi","(x)","(x)"},
{"besseljh","(n,x)","(n,x)"},
{"ellj","(x)","(x)"},
{REMOV},
{"besselk","(nu,x)","(nu,x)"},
{"besselk","(nu,x)","(nu,x,1)"},
{"matker","(x)","(x)"},
{"matker","(x)","(x,1)"},
{"matkerint","(x)","(x)"},
{"matkerint","(x)","(x,1)"},
{"matkerint","(x)","(x,2)"},
{"kronecker","(x,y)","(x,y)"},
{REMOV},
{"zetak","(nfz,s)","(nfz,s,1)"},
{"serlaplace","(x)","(x)"},
{SAME},
{"pollegendre","(n)","(n)"},
{SAME},
{SAME},
{"vecsort","(x)","(x,,2)"},
{SAME},
{SAME},
{"lindep","(x)","(x,1)"},
{"qflll","(x)","(x)"},
{"qflll","(x)","(x,7)"},
{"qflll","(x)","(x,8)"},
{"qflllgram","(x)","(x)"},
{"qflllgram","(x)","(x,7)"},
{"qflllgram","(x)","(x,8)"},
{"qflllgram","(x)","(x,1)"},
{"qflllgram","(x)","(x,4)"},
{"qflllgram","(x)","(x,5)"},
{"qflll","(x)","(x,1)"},
{"qflll","(x)","(x,2)"},
{"qflll","(x)","(x,4)"},
{"qflll","(x)","(x,5)"},
{"qflll","(x)","(x,3)"},
{"log","(x)","(x)"},
{SAME},
{"elllocalred","(e)","(e)"},
{SAME},
{"log","(x)","(x,1)"},
{"elllseries","(e,s,N,A)","(e,s,A)"},
{"bnfmake","(sbnf)","(sbnf)"},
{"Mat","(x)","(x)"},
{"vecextract","(x,y,z)","(x,y,z)"},
{"ellheightmatrix","(e,x)","(e,x)"},
{SAME},
{SAME},
{"matrixqz","(x,p)","(x,-1)"},
{"matrixqz","(x,p)","(x,-2)"},
{SAME},
{SAME},
{SAME},
{"idealmin","(nf,ix,vdir)","(nf,ix,vdir)"},
{"qfminim","(x,bound,maxnum)","(x,bound,maxnum)"},
{"qfminim","(x,bound)","(x,bound,,1)"},
{"Mod","(x,y)","(x,y)"},
{"Mod","(x,y,p)","(x,y,1)"},
{SAME},
{"gcd","(x,y)","(x,y,1)"},
{"moebius","(n)","(n)"},
{SAME},
{SAME},
{SAME},
{"nfeltdiv","(nf,a,b)","(nf,a,b)"},
{"nfeltdiveuc","(nf,a,b)","(nf,a,b)"},
{"nfeltdivrem","(nf,a,b)","(nf,a,b)"},
{"nfhnf","(nf,x)","(nf,x)"},
{"nfhnfmod","(nf,x,detx)","(nf,x,detx)"},
{"nfeltmod","(nf,a,b)","(nf,a,b)"},
{"nfeltmul","(nf,a,b)","(nf,a,b)"},
{"nfeltpow","(nf,a,k)","(nf,a,k)"},
{"nfeltreduce","(nf,a,id)","(nf,a,id)"},
{"nfsnf","(nf,x)","(nf,x)"},
{"nfeltval","(nf,a,pr)","(nf,a,pr)"},
{SAME},
{SAME},
{"qfbnucomp","(x,y,l)","(x,y,l)"},
{SAME},
{"numerator","(x)","(x)"},
{"qfbnupow","(x,n)","(x,n)"},
{"O","(x)","(x)"},
{SAME},
{"ellordinate","(e,x)","(e,x)"},
{"znorder","(x)","(x)"},
{"ellorder","(e,x)","(e,x)"},
{"polredord","(x)","(x)"},
{SAME},
{"matpascal","(n)","(n)"},
{"qfperfection","(a)","(a)"},
{"numtoperm","(n,k)","(n,k)"},
{"permtonum","(vect)","(vect)"},
{"qfbprimeform","(x,p)","(x,p)"},
{"eulerphi","(x)","(x)"},
{"Pi","",""},
{"contfracpnqn","(x)","(x)"},
{"ellztopoint","(e,z)","(e,z)"},
{"polinterpolate","(xa,ya,x)","(xa,ya,p)"},
{SAME},
{"polred","(x)","(x,2)"},
{SAME},
{"polredabs","(x)","(x,1)"},
{"polredabs","(x)","(x,4)"},
{"polredabs","(x)","(x,8)"},
{"polredabs","(x)","(x,2)"},
{SAME},
{"variable","(x)","(x)"},
{"Pol","(x,v)","(x,v)"},
{SAME},
{"polylog","(m,x)","(m,x,1)"},
{"polylog","(m,x)","(m,x,2)"},
{"polylog","(m,x)","(m,x,3)"},
{"Polrev","(x,v)","(x,v)"},
{"polzagier","(n,m)","(n,m)"},
{"ellpow","(e,x,n)","(e,x,n)"},
{"qfbpowraw","(x,n)","(x,n)"},
{"precision","(x,n)","(x,n)"},
{SAME},
{SAME},
{"idealprimedec","(nf,p)","(nf,p)"},
{SAME},
{"znprimroot","(n)","(n)"},
{"idealprincipal","(nf,x)","(nf,x)"},
{"ideleprincipal","(nf,x)","(nf,x)"},
{"prod","(x,X=a,b,expr)","(X=a,b,expr,x)"},
{SAME},
{SAME},
{"prodinf","(X=a,expr)","(X=a,expr,1)"},
{SAME},
{"Qfb","(a,b,c)","(a,b,c)"},
{"Qfb","(a,b,c,d)","(a,b,c,d)"},
{SAME},
{SAME},
{SAME},
{SAME},
{"matrank","(x)","(x)"},
{"bnrclassno","(bnf,x)","(bnf,x)"},
{"bnrclassnolist","(bnf,liste)","(bnf,liste)"},
{SAME},
{"polrecip","(x)","(x)"},
{"qfbred","(x)","(x)"},
{"qfbred","(x)","(x)"},
{"qfbred","(x,d)","(x,2,,d)"},
{"poldiscreduced","(f)","(f)"},
{"quadregulator","(x)","(x)"},
{SAME},
{"polresultant","(x,y)","(x,y)"},
{"polresultant","(x,y)","(x,y,1)"},
{"serreverse","(x)","(x)"},
{"qfbred","(x)","(x,1)"},
{"qfbred","(x,d)","(x,3,,d)"},
{"round","(x)","(x,&e)"},
{SAME},
{"rnfdisc","(nf,pol)","(nf,pol)"},
{SAME},
{"rnfequation","(nf,pol)","(nf,pol,1)"},
{"rnfhnfbasis","(bnf,order)","(bnf,order)"},
{SAME},
{SAME},
{SAME},
{SAME},
{SAME},
{"polrootsmod","(x,p)","(x,p)"},
{"polrootsmod","(x,p)","(x,p,1)"},
{"polrootspadic","(x,p,r)","(x,p,r)"},
{"polroots","(x)","(x)"},
{"nfrootsof1","(nf)","(nf)"},
{"polroots","(x)","(x,1)"},
{SAME},
{"round","(x)","(x,&e)"},
{"Ser","(x,v)","(x,v)"},
{"Set","(x)","(x)"},
{SAME},
{SAME},
{SAME},
{SAME},
{SAME},
{SAME},
{SAME},
{SAME},
{"sigma","(k,x)","(x,k)"},
{SAME},
{"qfsign","(x)","(x)"},
{"bnfsignunit","(bnf)","(bnf)"},
{"factormod","(x,p)","(x,p,1)"},
{SAME},
{SAME},
{SAME},
{"sizedigit","(x)","(x)"},
{"nfbasis","(x)","(x,1)"},
{"bnfinit","(x)","(x,3)"},
{"nfdisc","(x)","(x,1)"},
{"factor","(x)","(x,0)"},
{"ellinit","(x)","(x,1)"},
{"polred","(x)","(x,1)"},
{"polred","(x)","(x,3)"},
{"matsnf","(x)","(x)"},
{"matsnf","(x)","(x,1)"},
{"matsnf","(x)","(x,4)"},
{"matsnf","(x)","(x,2)"},
{SAME},
{"vecsort","(x)","(x)"},
{SAME},
{"qfgaussred","(x)","(x)"},
{SAME},
{"gcd","(x,y)","(x,y,2)"},
{"polsturm","(x)","(x)"},
{"polsturm","(x,a,b)","(x,a,b)"},
{"polsubcyclo","(p,d)","(p,d)"},
{"ellsub","(e,a,b)","(e,a,b)"},
{SAME},
{"sum","(x,X=a,b,expr)","(X=a,b,expr,x)"},
{SAME},
{"sumalt","(X=a,expr)","(X=a,expr,1)"},
{SAME},
{SAME},
{"sumpos","(X=a,expr)","(X=a,expr,1)"},
{"matsupplement","(x)","(x)"},
{"polsylvestermatrix","(x,y)","(x,y)"},
{SAME},
{SAME},
{"elltaniyama","(e)","(e)"},
{SAME},
{"poltchebi","(n)","(n)"},
{"teichmuller","(x)","(x)"},
{SAME},
{SAME},
{REMOV},
{REMOV},
{"elltors","(e)","(e)"},
{SAME},
{"mattranspose","(x)","(x)"},
{"truncate","(x)","(x)"},
{"poltschirnhaus","(x)","(x)"},
{REMOV},
{"quadunit","(x)","(x)"},
{SAME},
{SAME},
{"Vec","(x)","(x)"},
{"vecsort","(x)","(x,,1)"},
{"vecsort","(x)","(x,,2)"},
{SAME},
{SAME},
{SAME},
{SAME},
{"vectorv","(n,X,expr)","(n,X,expr)"},
{"ellwp","(e)","(e)"},
{"weber","(x)","(x)"},
{"weber","(x)","(x,2)"},
{SAME},
{"ellpointtoz","(e,P)","(e,P)"},
{SAME},
{SAME},
{"ideallog","(nf,x,bid)","(nf,x,bid)"},
{"idealstar","(nf,I)","(nf,I)"},
{"idealstar","(nf,id)","(nf,id,1)"},
{"idealstar","(nf,id)","(nf,id,2)"},
{SAME},

{SAME},
{"plotbox","(x,a)","(x,a)"},
{"plotcolor","(w,c)","(w,c)"},
{"plotcursor","(w)","(w)"},
{SAME},
{"plotdraw","(list)","(list)"},
{"plotinit","(w,x,y)","(w,x,y)"},
{SAME},
{"plotkill","(w)","(w)"},
{"plotlines","(w,x2,y2)","(w,x2,y2)"},
{"plotlines","(w,x2,y2)","(w,x2,y2)"},
{"plotmove","(w,x,y)","(w,x,y)"},
{SAME},
{SAME},
{"ploth","(X=a,b,expr)","(X=a,b,expr,1)"},
{"ploth","(X=a,b,expr)","(X=a,b,expr)"},
{SAME},
{"plotpoints","(w,x,y)","(w,x,y)"},
{"plotpoints","(w,x,y)","(w,x,y)"},
{"psdraw","(list)","(list)"},
{"psploth","(X=a,b,expr)","(X=a,b,expr)"},
{"psploth","(X=a,b,expr)","(X=a,b,expr,1)"},
{"psplothraw","(listx,listy)","(listx,listy)"},
{"printp","(x)","(x)"},
{"printp1","(x)","(x)"},
{SAME},
{SAME},
{"plotrbox","(w,dx,dy)","(w,dx,dy)"},
{"input","(x)","(x)"},
{"plotrline","(w,dx,dy)","(w,dx,dy)"},
{"plotrlines","(w,dx,dy)","(w,dx,dy,1)"},
{"plotrmove","(w,dx,dy)","(w,dx,dy)"},
{"plotrpoint","(w,dx,dy)","(w,dx,dy)"},
{"plotrpoints","(w,dx,dy)","(w,dx,dy)"},
{"plotscale","(w,x1,x2,y1,y2)","(w,x1,x2,y1,y2)"},
{"default","(n)","(realprecision,n)"},
{"default","(n)","(seriesprecision,n)"},
{"type","(x,t)","(x,t)"},
{"plotstring","(w,x)","(w,x)"},
{SAME},
{"printtex","(x)","(x)"},
{SAME}
};

/* If flag = 0 (default): check if s existed in 1.39.15 and print verbosely
 * the answer.
 * If flag > 0: silently return n+1 if function changed, 0 otherwise.
 *   (where n is the index of s in whatnowlist).
 * If flag < 0: -flag-1 is the index in whatnowlist
 */
int
whatnow(char *s, int flag)
{
  int n;
  char *def;
  whatnow_t wp;
  entree *ep;

  if (flag < 0) { n = -flag; flag = 0; }
  else
  {
    if (flag && strlen(s)==1) return 0; /* special case "i" and "o" */
    if (!is_identifier(s) || !is_entry_intern(s,funct_old_hash,NULL))
    {
      if (flag) return 0;
      err(talker,"as far as I can recall, this function never existed");
    }
    n = 0;
    do
      def = (oldfonctions[n++]).name;
    while (def && strcmp(def,s));
    if (!def)
    {
      int m=0;
      do
        def = (functions_oldgp[m++]).name;
      while (def && strcmp(def,s));
      n += m - 1;
    }
  }

  wp=whatnowlist[n-1]; def=wp.name;
  if (def == SAME)
  {
    if (flag) return 0;
    err(talker,"this function did not change");
  }
  if (flag) return n;

  if (def == REMOV)
    err(talker,"this function was suppressed");
  if (!strcmp(def,"x*y"))
  {
    pariputsf("  %s is now called *.\n\n",s);
    pariputsf("    %s%s ===> %s%s\n\n",s,wp.oldarg,wp.name,wp.newarg);
    return 1;
  }
  ep = is_entry(wp.name);
  if (!ep) err(bugparier,"whatnow");
  pariputs("New syntax: "); term_color(c_ERR);
  pariputsf("%s%s ===> %s%s\n\n",s,wp.oldarg,wp.name,wp.newarg);
  term_color(c_NONE);
  print_text(ep->help); pariputc('\n');
  return 1;
}
