
package Paws::IoT::DescribeProvisioningTemplateVersion;
  use Moose;
  has TemplateName => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'templateName', required => 1);
  has VersionId => (is => 'ro', isa => 'Int', traits => ['ParamInURI'], uri_name => 'versionId', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'DescribeProvisioningTemplateVersion');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/provisioning-templates/{templateName}/versions/{versionId}');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'GET');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::IoT::DescribeProvisioningTemplateVersionResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::DescribeProvisioningTemplateVersion - Arguments for method DescribeProvisioningTemplateVersion on L<Paws::IoT>

=head1 DESCRIPTION

This class represents the parameters used for calling the method DescribeProvisioningTemplateVersion on the
L<AWS IoT|Paws::IoT> service. Use the attributes of this class
as arguments to method DescribeProvisioningTemplateVersion.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to DescribeProvisioningTemplateVersion.

=head1 SYNOPSIS

    my $iot = Paws->service('IoT');
    my $DescribeProvisioningTemplateVersionResponse =
      $iot->DescribeProvisioningTemplateVersion(
      TemplateName => 'MyTemplateName',
      VersionId    => 1,

      );

    # Results:
    my $CreationDate =
      $DescribeProvisioningTemplateVersionResponse->CreationDate;
    my $IsDefaultVersion =
      $DescribeProvisioningTemplateVersionResponse->IsDefaultVersion;
    my $TemplateBody =
      $DescribeProvisioningTemplateVersionResponse->TemplateBody;
    my $VersionId = $DescribeProvisioningTemplateVersionResponse->VersionId;

   # Returns a L<Paws::IoT::DescribeProvisioningTemplateVersionResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/iot/DescribeProvisioningTemplateVersion>

=head1 ATTRIBUTES


=head2 B<REQUIRED> TemplateName => Str

The template name.



=head2 B<REQUIRED> VersionId => Int

The fleet provisioning template version ID.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method DescribeProvisioningTemplateVersion in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

