C  CONTROL BLOCK FOR THE DEVICE-DEPENDENT AREA EXTENSION FOR THE
C  VERSATEC ELECTROSTATIC PLOTTER USING FAN FOLD PAPER.
      SAVE          /UGVF00/
C  NUMBER OF RASTER UNITS IN X DIRECTION.
      INTEGER       DDXZ1
      PARAMETER     (DDXZ1=2112)
C  NUMBER OF RASTER UNITS IN Y DIRECTION.
      INTEGER       DDXZ2
      PARAMETER     (DDXZ2=1560)
C  NUMBER OF SCAN LINES PER BAND.
      INTEGER       DDXZ3
      PARAMETER     (DDXZ3=32)
C  NUMBER OF BYTES PER SCAN LINE.
      INTEGER       DDXZ4
      PARAMETER     (DDXZ4=DDXZ1/8)
C  NUMBER OF FULL WORDS PER SCAN LINE.
      INTEGER       DDXZ5
      PARAMETER     (DDXZ5=DDXZ1/32)
C  LENGTH OF PSEUDO-PRINT LINE.
      INTEGER       DDXZ6
      PARAMETER     (DDXZ6=132)
C  CONTROL BLOCK LENGTH.
      INTEGER       DDXZZ
      PARAMETER     (DDXZZ=2301)
C  THE DECLARATION OF THE COMMON BLOCK.
      COMMON        /UGVF00/
     X              DDXID,
     X              DDXB1,DDXV3,DDXV5,
     X              DDXNS,DDXGL,DDXRA,DDXTM,
     X              DDXBD,DDXPL,DDXDL,
     X              DDXOB,DDXNO,
     X              DDXEC,
     X              DDXBB,DDXTB,
     X              DDXPP,DDXPC,
     X              DDXPW,DDXLW,
     X              DDXLS,DDXPV,DDXDC,
     X              DDXIO
C  DEVICE-DEPENDENT AREA EXTENSION IDENTIFICATION.
      CHARACTER*8   DDXID
C  POINTER TO SUBROUTINE UGB001.
      INTEGER       DDXB1
C  POINTER TO SUBROUTINE UGVF03.
      INTEGER       DDXV3
C  POINTER TO SUBROUTINE UGVF05.
      INTEGER       DDXV5
C  SIZE OF SAVE BLOCKS FOR ACCUMULATING A COMPLETE PICTURE.
      INTEGER       DDXNS
C  GENERATE INTENSITY LEVEL FLAG:
C    0 MEANS DO NOT GENERATE INTENSITY WITH LINE WIDTH, AND
C    1 MEANS GENERATE INTENSITY WITH LINE WIDTH.
      INTEGER       DDXGL
C  ROTATE AXIS FLAG:
C    0 MEANS DO NOT ROTATE THE PICTURE 90 DEGREES, AND
C    1 MEANS ROTATE THE PICTURE 90 DEGREES.
      INTEGER       DDXRA
C  TOP MARGIN OFFSET COUNT FROM PERFORATION.
      INTEGER       DDXTM
C  ONE BAND OF SCAN LINES.
      INTEGER*4     DDXBD(DDXZ5,DDXZ3)
C  PREVIOUS SCAN LINE.
      INTEGER*4     DDXPL(DDXZ5)
C  SCAN LINE DIFFERENCES.
      INTEGER*4     DDXDL(DDXZ5)
      CHARACTER*(DDXZ4) DDXDB
      EQUIVALENCE   (DDXDL(1),DDXDB)
C  OUTPUT BUFFER.
      CHARACTER*(DDXZ6) DDXOB
C  CURRENT LENGTH OF OUTPUT BUFFER.
      INTEGER       DDXNO
C  EQUAL LINE COUNT.
      INTEGER       DDXEC
C  BEGINNING LINE NUMBER IN THE CURRENT BAND OF SCAN LINES.
      INTEGER       DDXBB
C  TERMINAL LINE NUMBER IN THE CURRENT BAND OF SCAN LINES.
      INTEGER       DDXTB
C  POINTER TO THE PRIMARY SAVE BLOCK.
      INTEGER       DDXPP
C  POINTER TO THE CURRENT SAVE BLOCK.
      INTEGER       DDXPC
C  ACTUAL POINT WIDTH.
      INTEGER       DDXPW
C  ACTUAL LINE WIDTH.
      INTEGER       DDXLW
C  LINE SEGMENT COORDINATES.
      INTEGER       DDXLS(4)
C  PICTURE AVAILABLE FLAG:
C    0 MEANS NO PREVIOUS PICTURE IS AVAILABLE, AND
C    1 MEANS A PICTURE HAS PREVIOUSLY BEEN PRODUCED.
      INTEGER       DDXPV
C  DEFERRED CLEAR FLAG:
C    0 MEANS THE START OF A NEW PICTURE HAS NOT BEEN DEFERRED, AND
C    1 MEANS THE START OF A NEW PICTURE HAS BEEN DEFERRED.
      INTEGER       DDXDC
C  INPUT/OUTPUT IDENTIFICATION VALUE.
      INTEGER       DDXIO
C  THE FOLLOWING ARRAY OVERLAYS THE ENTIRE DDA EXTENSION.
      INTEGER       DDXRY(DDXZZ)
      EQUIVALENCE   (DDXRY(1),DDXID)
