      SUBROUTINE UGWRIT(OPTN,IDNT,SEGM)

*******************  THE UNIFIED GRAPHICS SYSTEM  *******************
*            WRITE A GRAPHIC SEGMENT TO A GRAPHIC DEVICE            *
*                                                                   *
*  THIS SUBROUTINE MAY BE USED TO TRANSMIT A PREVIOUSLY GENERATED   *
*  GRAPHIC SEGMENT TO A DISPLAY FILE.  WHEN A GRAPHIC SEGMENT IS    *
*  TRANSMITTED TO A GRAPHIC DEVICE, IT IS FIRST TRANSLATED TO       *
*  DEVICE-DEPENDENT ORDERS, AND THEN ADDED TO THE DISPLAY FILE OF   *
*  THE GRAPHIC DEVICE.                                              *
*                                                                   *
*  THE CALLING SEQUENCE IS:                                         *
*    CALL UGWRIT(OPTN,IDNT,SEGM)                                    *
*                                                                   *
*  THE PARAMETERS IN THE CALLING SEQUENCE ARE:                      *
*    OPTN  THE OPTIONS LIST.                                        *
*    IDNT  THE IDENTIFICATION OF THE GRAPHIC SEGMENT.               *
*    SEGM  THE GRAPHIC SEGMENT WHICH WILL BE TRANSMITTED TO THE     *
*          GRAPHIC DEVICE.                                          *
*                                                                   *
*                          ROBERT C. BEACH                          *
*                    COMPUTATION RESEARCH GROUP                     *
*                STANFORD LINEAR ACCELERATOR CENTER                 *
*                                                                   *
*********************************************************************

      CHARACTER*(*) OPTN
      INTEGER       IDNT
      INTEGER*4     SEGM(*)
C
      INCLUDE       'UGSYSTEM:UGMCACBK.FOR'
      INCLUDE       'UGSYSTEM:UGDDACBK.FOR'
      INCLUDE       'UGSYSTEM:UGERRCBK.FOR'

      SAVE       /UGA011/
      COMMON        /UGA011/
     X              CHRTP1,
     X              CHRNC1,
     X              CHRCS1,
     X              CHRSC1,
     X              CHROT1,
     X              CHRLT1,
     X              CHRCT1,
     X              CHRID1
      INTEGER*2     CHRTP1
      INTEGER*2     CHRNC1
      INTEGER*2     CHRSC1
      INTEGER*2     CHRCS1
      INTEGER*2     CHROT1(   11)
      INTEGER*2     CHRLT1(  127)
      CHARACTER*2   CHRCT1(   11)
      CHARACTER*8   CHRID1
 
      SAVE          /UGA012/
      COMMON        /UGA012/
     X              CHRTP2,
     X              CHRNC2,
     X              CHRSC2,
     X              CHRCS2,
     X              CHROT2,
     X              CHRLT2,
     X              CHRCT2,
     X              CHRID2
      INTEGER*2     CHRTP2
      INTEGER*2     CHRNC2
      INTEGER*2     CHRCS2
      INTEGER*2     CHRSC2
      INTEGER*2     CHROT2(   96)
      INTEGER*2     CHRLT2(  617)
      CHARACTER*2   CHRCT2(   96)
      CHARACTER*8   CHRID2
 
      SAVE          /UGA013/
      COMMON        /UGA013/
     X              CHRTP3,
     X              CHRNC3,
     X              CHRSC3,
     X              CHRCS3,
     X              CHROT3,
     X              CHRLT3,
     X              CHRCT3,
     X              CHRID3
      INTEGER*2     CHRTP3
      INTEGER*2     CHRNC3
      INTEGER*2     CHRSC3
      INTEGER*2     CHRCS3
      INTEGER*2     CHROT3(  365)
      INTEGER*2     CHRLT3( 2572)
      CHARACTER*2   CHRCT3(  365)
      CHARACTER*8   CHRID3
 
      SAVE          /UGA014/
      COMMON        /UGA014/
     X              CHRTP4,
     X              CHRNC4,
     X              CHRSC4,
     X              CHRCS4,
     X              CHROT4,
     X              CHRLT4,
     X              CHRCT4,
     X              CHRID4
      INTEGER*2     CHRTP4
      INTEGER*2     CHRNC4
      INTEGER*2     CHRSC4
      INTEGER*2     CHRCS4
C     INTEGER*2     CHROT4(  365)
C     INTEGER*2     CHRLT4( 6453)
C     CHARACTER*2   CHRCT4(  365)
      INTEGER*2     CHROT4(  904)
      INTEGER*2     CHRLT4(20160)
      CHARACTER*2   CHRCT4(  904)
      CHARACTER*8   CHRID4

      INTEGER       EFLG
      INTEGER       SEGX,SEGT,SEGI
      INTEGER       DIMN,S3DF
      INTEGER       FGLS,FIXZ
      INTEGER       DTAI,DTAT
      REAL          XCRD,YCRD,ZCRD,SIZE,RATO,ANGL
      INTEGER       BBIT
      REAL          TXCD,TYCD
      INTEGER       DELX,DELY,XSPC,YSPC
      INTEGER       CHRI,CHRJ,CHRN
      CHARACTER*1024  CHRP,CHRS
      REAL          XARY(64),YARY(64)
      INTEGER       NPTS
      CHARACTER*1   DIGT(0:9)
      INTEGER       DDIN(136),DDEX(5)

      INTEGER*4     OVI4
      REAL*4        OVR4
      CHARACTER*4   OVC4
      EQUIVALENCE   (OVI4,OVR4,OVC4)
      INTEGER       INT1,INT2,INT3
      REAL          FLT1,FLT2,FLT3
      CHARACTER*1   CHR1

      INTEGER*4     EXST(3),EXPK,EXOM,EXER
      EQUIVALENCE   (EXPK,EXST(1)),       (EXOM,EXST(2)),
     X              (EXER,EXST(3))

      INTEGER       DESC_NUM
      PARAMETER    (DESC_NUM = 3)
      INTEGER*4     INST(4,DESC_NUM)
      CHARACTER*16  IFLAG(DESC_NUM)

      LOGICAL       BTEST

      DATA   (INST(I,1),I=1,4) / 1,4,1,1 /, IFLAG(1) / 'PICK'/
      DATA   (INST(I,2),I=1,4) / 1,4,2,1 /, IFLAG(2) / 'OMIT'/
      DATA   (INST(I,3),I=1,4) / 1,5,3,1 /, IFLAG(3) / 'ERASE'/

      DATA          DIGT/'0','1','2','3','4','5','6','7','8','9'/

C  INITIALIZE AND CHECK FOR AN ACTIVE DEVICE.
      EFLG=0
      DDAFW=1
      IF (DDAAI.EQ.0) GO TO 905

C  SCAN THE OPTIONS LIST.
      EXPK=0
      EXOM=0
      EXER=0

      CALL UGOPTION(OPTN,DESC_NUM,INST,IFLAG,EXST,EXSTR)

C  INITIALIZE SEGMENT PROCESSING.
      IF ((EXER.NE.0).AND.(DDADM.NE.2)) GO TO 906
      IF ((EXOM.NE.0).AND.(DDADM.NE.3)) GO TO 907
      IF ((EXPK.NE.0).AND.(DDAIC(2).EQ.0)) GO TO 907
C    SIGNAL THE BEGINNING OF A GRAPHIC SEGMENT.
  101 DDIN(1)=5
      DDIN(2)=IDNT
      CALL UGZ005(SEGM,DDIN(3))
      DDIN(4)=EXER
      DDIN(5)=EXPK
      DDIN(6)=EXOM
      CALL UGZ006(DDAAC,0,0,DDIN,OPTN,DDEX)
      IF (DDEX(1).EQ.-1) GO TO 801
      S3DF=DDEX(2)
C    INITIALIZE SEGMENT SCANNING POINTERS.
      SEGX=SEGM(2)
      SEGT=SEGM(1)
C
C  SELECT NEXT BLOCK OF DATA OR TERMINATE.
  201 IF (SEGX.LT.SEGT) THEN
        SEGI=SEGX
        SEGX=SEGX+SEGM(SEGI+1)
C    INITIALIZE FOR SENDING A GRAPHIC INQUIRY.
        DDIN(3)=SEGM(SEGI+2)
        DDIN(4)=SEGM(SEGI+3)
        DDIN(5)=SEGM(SEGI+4)
        DDIN(6)=SEGM(SEGI+5)
C    TRANSFER TO THE PROPER SECTION OF CODE.
        INT1=SEGM(SEGI)
        IF (INT1.LT.1) GO TO 903
        IF (INT1.GT.9) GO TO 903
        GO TO (301,351,401,451,501,551,601,651,701),INT1
      END IF
C    SIGNAL THE END OF A GRAPHIC SEGMENT.
  202 DDIN(1)=6
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
      IF (DDEX(1).NE.0) GO TO 901
      GO TO 801
C
C  PROCESS MARKER DATA BLOCK.
  301 DIMN=2
  302 DTAI=SEGI+8
      DTAT=SEGI+SEGM(SEGI+1)
C    INITIALIZE FOR SENDING A GRAPHIC INQUIRY.
      DDIN(1)=8
C    CHECK FOR POINTS OR DRAWN MARKERS.
      IF (SEGM(SEGI+7).GE.0) GO TO 305
C    DO A GRAPHIC INQUIRY FOR POINTS.
      DDIN(2)=1
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
C    INITIALIZE FOR SENDING POINTS.
      DDIN(1)=9
C    SELECT THE NEXT MARKER IN THE GRAPHIC SEGMENT.
  303 IF (DTAI.GE.DTAT) GO TO 201
      OVI4=SEGM(DTAI)
      XCRD=OVR4
      OVI4=SEGM(DTAI+1)
      YCRD=OVR4
      IF (DIMN.EQ.3) THEN
        OVI4=SEGM(DTAI+2)
        ZCRD=OVR4
      END IF
      DTAI=DTAI+DIMN
C    SCISSOR AND SHIELD THE POINT.  THREE-DIMENSIONAL POINTS ARE
C    ALSO PROJECTED INTO TWO-DIMENSIONS.
      IF (DIMN.EQ.2) THEN
        IF (XCRD.LT.DDAWS(1,1)) GO TO 303
        IF (XCRD.GT.DDAWS(1,2)) GO TO 303
        IF (YCRD.LT.DDAWS(2,1)) GO TO 303
        IF (YCRD.GT.DDAWS(2,2)) GO TO 303
        IF (DDASA.GT.0) THEN
          DO 304 INT1=1,DDAZ5
            IF (DDASF(INT1).NE.0) THEN
              IF ((XCRD.GT.DDASH(1,1,INT1)).AND.
     X            (XCRD.LT.DDASH(1,2,INT1)).AND.
     X            (YCRD.GT.DDASH(2,1,INT1)).AND.
     X            (YCRD.LT.DDASH(2,2,INT1))) GO TO 303
            END IF
  304     CONTINUE
        END IF
      ELSE
        IF ((XCRD*DDA3P(1)+YCRD*DDA3P(2)+ZCRD*DDA3P(3)+DDA3P(4))
     X     .LT.0.0) GO TO 303
        CALL UGB012(XCRD,YCRD,ZCRD,TXCD,TYCD)
        IF (TXCD.LT.DDA3V(1,1)) GO TO 303
        IF (TXCD.GT.DDA3V(1,2)) GO TO 303
        IF (TYCD.LT.DDA3V(2,1)) GO TO 303
        IF (TYCD.GT.DDA3V(2,2)) GO TO 303
        XCRD=TXCD
        YCRD=TYCD
      END IF
C    TRANSFORM THE POINT TO DEVICE COORDINATES.
      IF (DIMN.EQ.2) THEN
        CALL UGB003(XCRD,YCRD,DDIN(3),DDIN(4))
      ELSE
        CALL UGB013(XCRD,YCRD,DDIN(3),DDIN(4))
      END IF
C    DO A GRAPHIC DISPLAY FOR POINTS.
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
      IF (DDEX(1).NE.0) GO TO 902
      GO TO 303
C    INITIALIZE THE SCISSORING AND SHIELDING MODULE.
  305 CALL UGC001(DDAWS)
      IF (DDASA.GT.0) THEN
        DO 306 INT1=1,DDAZ5
          IF (DDASF(INT1).NE.0) CALL UGC002(DDASH(1,1,INT1))
  306   CONTINUE
      END IF
C    DO A GRAPHIC INQUIRY FOR SOLID LINES.
      DDIN(2)=2
      DDIN(7)=1
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
C    INITIALIZE FOR SENDING LINES.
      DDIN(1)=9
      DDIN(2)=2
C    INITIALIZE THE MARKER PROPERTIES.
      CHR1=DIGT(SEGM(SEGI+7))
      OVI4=SEGM(SEGI+6)
      SIZE=OVR4
      IF (SIZE.LT.0.0) SIZE=-SIZE*DDATR(5)
      RATO=DDATR(6)
C    SELECT THE NEXT MARKER IN THE GRAPHIC SEGMENT.
  307 IF (DTAI.GE.DTAT) GO TO 201
      OVI4=SEGM(DTAI)
      XCRD=OVR4
      OVI4=SEGM(DTAI+1)
      YCRD=OVR4
      DTAI=DTAI+2
C    INITIALIZE THE CHARACTER STROKE GENERATOR.
      CALL UGE001(0,0,0,0,XCRD,YCRD,SIZE,0.0,RATO,CHRTP1,INT1)
C    OBTAIN THE NEXT STROKE END POINT.
  308 CALL UGE002(CHR1,' ',1,CHRTP1,BBIT,XCRD,YCRD,INT1)
      IF (BBIT.LT.0) GO TO 307
C    SCISSOR AND SHIELD THE STROKE END POINT.
      CALL UGC003(BBIT,XCRD,YCRD)
  309 CALL UGC004(BBIT,XCRD,YCRD)
      IF (BBIT.LT.0) GO TO 308
C    TRANSFORM THE POINT TO DEVICE COORDINATES.
      CALL UGB003(XCRD,YCRD,DDIN(3),DDIN(4))
C    DO A GRAPHIC DISPLAY FOR LINES.
      DDIN(5)=BBIT
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
      IF (DDEX(1).NE.0) GO TO 902
      GO TO 309
C
C  PROCESS LINE DATA BLOCK.
  351 DIMN=2
  352 DTAI=SEGI+7
      DTAT=SEGI+SEGM(SEGI+1)
C    INITIALIZE THE SCISSORING AND SHIELDING MODULE.
      IF (DIMN.EQ.2) THEN
        CALL UGC001(DDAWS)
        IF (DDASA.GT.0) THEN
          DO 353 INT1=1,DDAZ5
            IF (DDASF(INT1).NE.0) CALL UGC002(DDASH(1,1,INT1))
  353     CONTINUE
        END IF
      ELSE
        CALL UGG001(DDA3P)
        CALL UGC001(DDA3V)
      END IF
C    DO A GRAPHIC INQUIRY FOR LINES.
      DDIN(1)=8
      DDIN(2)=2
      DDIN(7)=SEGM(SEGI+6)
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
      FGLS=DDEX(1)
      IF (FGLS.NE.0) THEN
C    DO A GRAPHIC INQUIRY FOR SOLID LINES.
        INT1=DDIN(7)-1
        DDIN(7)=1
        CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
C    INITIALIZE THE LINE STRUCTURE GENERATOR.
        CALL UGD001(INT1,DDAWX,DDAWY)
      END IF
C    INITIALIZE FOR SENDING LINES.
      DDIN(1)=9
C    SELECT THE NEXT LINE END POINT IN THE GRAPHIC SEGMENT.
  354 IF (DTAI.GE.DTAT) GO TO 201
      OVI4=SEGM(DTAI)
      XCRD=OVR4
      OVI4=SEGM(DTAI+1)
      IF (.NOT.BTEST(OVI4,LSBFLO)) THEN
        BBIT=0
      ELSE
        BBIT=1
      END IF
      OVI4=IBCLR(OVI4,LSBFLO)
      YCRD=OVR4
      IF (DIMN.EQ.3) THEN
        OVI4=SEGM(DTAI+2)
        ZCRD=OVR4
      END IF
      DTAI=DTAI+DIMN
C    SCISSOR AND SHIELD THE LINE END POINT.  THREE-DIMENSIONAL LINES
C    ARE ALSO PROJECTED INTO TWO-DIMENSIONS.
      IF (DIMN.EQ.2) THEN
        CALL UGC003(BBIT,XCRD,YCRD)
      ELSE
        CALL UGG003(BBIT,XCRD,YCRD,ZCRD)
      END IF
  355 IF (DIMN.EQ.2) THEN
        CALL UGC004(BBIT,XCRD,YCRD)
        IF (BBIT.LT.0) GO TO 354
      ELSE
  356   CALL UGC004(BBIT,XCRD,YCRD)
        IF (BBIT.LT.0) THEN
          CALL UGG004(BBIT,XCRD,YCRD,ZCRD)
          IF (BBIT.LT.0) GO TO 354
          CALL UGB012(XCRD,YCRD,ZCRD,TXCD,TYCD)
          CALL UGC003(BBIT,TXCD,TYCD)
          GO TO 356
        END IF
      END IF
C    GENERATE LINE STRUCTURE IF NECESSARY.
      IF (FGLS.EQ.0) GO TO 358
      CALL UGD002(BBIT,XCRD,YCRD)
  357 CALL UGD003(BBIT,XCRD,YCRD)
      IF (BBIT.LT.0) GO TO 355
      IF (BBIT.EQ.2) THEN
        DDIN(2)=1
      ELSE
        DDIN(2)=2
      END IF
C    TRANSFORM THE POINT TO DEVICE COORDINATES.
  358 IF (DIMN.EQ.2) THEN
        CALL UGB003(XCRD,YCRD,DDIN(3),DDIN(4))
      ELSE
        CALL UGB013(XCRD,YCRD,DDIN(3),DDIN(4))
      END IF
C    DO A GRAPHIC DISPLAY FOR LINES.
      DDIN(5)=BBIT
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
      IF (DDEX(1).NE.0) GO TO 902
      IF (FGLS.NE.0) GO TO 357
      GO TO 355
C
C  PROCESS TEXT DATA BLOCK.
  401 DIMN=2
  402 DTAI=SEGI+10
      DTAT=SEGI+SEGM(SEGI+1)
C    INITIALIZE FOR SENDING A GRAPHIC INQUIRY.
      DDIN(1)=8
      IF (SEGM(SEGI+9).EQ.3) GO TO 405
C    DO A GRAPHIC INQUIRY FOR TEXT.
      DDIN(2)=3
      OVI4=SEGM(SEGI+6)
      SIZE=OVR4
      IF (DIMN.EQ.2) THEN
        IF (SIZE.LT.0.0) SIZE=-SIZE*DDATR(5)
        CALL UGB003(0.0,0.0,INT1,INT2)
        CALL UGB003(SIZE,0.0,INT2,INT3)
      ELSE
        SIZE=-SIZE*DDA3T(17)
        CALL UGB013(0.0,0.0,INT1,INT2)
        CALL UGB013(SIZE,0.0,INT2,INT3)
      END IF
      DDIN(7)=INT2-INT1
      OVI4=SEGM(SEGI+7)
      DDIN(8)=MOD(NINT(OVR4)+720,360)
      DDIN(9)=SEGM(SEGI+9)
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
      IF (DDEX(1).NE.0) GO TO 405
      DELX=DDEX(2)
      DELY=DDEX(3)
      XSPC=DDEX(4)
      YSPC=DDEX(5)
C    INITIALIZE FOR SENDING TEXT STRINGS.
      DDIN(1)=9
C    SELECT THE NEXT TEXT STRING IN THE GRAPHIC SEGMENT.
  403 IF (DTAI.GE.DTAT) GO TO 201
      OVI4=SEGM(DTAI+1)
      XCRD=OVR4
      OVI4=SEGM(DTAI+2)
      YCRD=OVR4
      IF (DIMN.EQ.3) THEN
        OVI4=SEGM(DTAI+3)
        ZCRD=OVR4
      END IF
      CHRN=SEGM(DTAI+DIMN+1)
      CHRI=DTAI+DIMN+2
      INT1=(CHRN+3)/4
      DO 404 INT2=1,INT1
        INT3=4*INT2-3
        OVI4=SEGM(CHRI+INT2-1)
        CHRP(INT3:INT3+3)=OVC4
  404 CONTINUE
      DTAI=DTAI+SEGM(DTAI)
C    SCISSOR A THREE-DIMENSIONAL TEXT STRING USING THE NEAR
C    SCISSORING PLANE.
      IF (DIMN.EQ.3) THEN
        IF ((XCRD*DDA3P(1)+YCRD*DDA3P(2)+ZCRD*DDA3P(3)+DDA3P(4))
     X     .LT.0.0) GO TO 403
      END IF
C    TRANSFORM THE POINT TO DEVICE COORDINATES.
      IF (DIMN.EQ.2) THEN
        CALL UGB003(XCRD,YCRD,DDIN(3),DDIN(4))
      ELSE
        CALL UGB012(XCRD,YCRD,ZCRD,TXCD,TYCD)
        CALL UGB013(TXCD,TYCD,DDIN(3),DDIN(4))
      END IF
      DDIN(3)=DDIN(3)+DELX
      DDIN(4)=DDIN(4)+DELY
C    PROCESS THE "CENTER" AND "RIGHT" OPTIONS.
      IF (SEGM(SEGI+8).EQ.2) THEN
        DDIN(3)=DDIN(3)-(CHRN-1)*XSPC
        DDIN(4)=DDIN(4)-(CHRN-1)*YSPC
      ELSE IF (SEGM(SEGI+8).EQ.3) THEN
        DDIN(3)=DDIN(3)-((CHRN-1)*XSPC/2)
        DDIN(4)=DDIN(4)-((CHRN-1)*YSPC/2)
      END IF
C    SCISSOR THE TEXT STRING.
      CHRI=1
      CHRJ=CHRN
      IF (DIMN.EQ.2) THEN
        IF (XSPC.EQ.0) THEN
          IF (DDIN(3).LT.DDAWD(1,1)) GO TO 403
          IF (DDIN(3).GT.DDAWD(1,2)) GO TO 403
        ELSE IF (XSPC.GT.0) THEN
          CHRI=MAX(CHRI,((DDAWD(1,1)-DDIN(3)+XSPC-1)/XSPC)+1)
          CHRJ=MIN(CHRJ,((DDAWD(1,2)-DDIN(3))/XSPC)+1)
        ELSE
          CHRI=MAX(CHRI,((DDIN(3)-DDAWD(1,2)+ABS(XSPC)-1)/ABS(XSPC))+1)
          CHRJ=MIN(CHRJ,((DDIN(3)-DDAWD(1,1))/ABS(XSPC))+1)
        END IF
        IF (YSPC.EQ.0) THEN
          IF (DDIN(4).LT.DDAWD(2,1)) GO TO 403
          IF (DDIN(4).GT.DDAWD(2,2)) GO TO 403
        ELSE IF (YSPC.GT.0) THEN
          CHRI=MAX(CHRI,((DDAWD(2,1)-DDIN(4)+YSPC-1)/YSPC)+1)
          CHRJ=MIN(CHRJ,((DDAWD(2,2)-DDIN(4))/YSPC)+1)
        ELSE
          CHRI=MAX(CHRI,((DDIN(4)-DDAWD(2,2)+ABS(YSPC)-1)/ABS(YSPC))+1)
          CHRJ=MIN(CHRJ,((DDIN(4)-DDAWD(2,1))/ABS(YSPC))+1)
        END IF
      ELSE
        IF (XSPC.EQ.0) THEN
          IF (DDIN(3).LT.DDAXV(1,1)) GO TO 403
          IF (DDIN(3).GT.DDAXV(1,2)) GO TO 403
        ELSE IF (XSPC.GT.0) THEN
          CHRI=MAX(CHRI,((DDAXV(1,1)-DDIN(3)+XSPC-1)/XSPC)+1)
          CHRJ=MIN(CHRJ,((DDAXV(1,2)-DDIN(3))/XSPC)+1)
        ELSE
          CHRI=MAX(CHRI,((DDIN(3)-DDAXV(1,2)+ABS(XSPC)-1)/ABS(XSPC))+1)
          CHRJ=MIN(CHRJ,((DDIN(3)-DDAXV(1,1))/ABS(XSPC))+1)
        END IF
        IF (YSPC.EQ.0) THEN
          IF (DDIN(4).LT.DDAXV(2,1)) GO TO 403
          IF (DDIN(4).GT.DDAXV(2,2)) GO TO 403
        ELSE IF (YSPC.GT.0) THEN
          CHRI=MAX(CHRI,((DDAXV(2,1)-DDIN(4)+YSPC-1)/YSPC)+1)
          CHRJ=MIN(CHRJ,((DDAXV(2,2)-DDIN(4))/YSPC)+1)
        ELSE
          CHRI=MAX(CHRI,((DDIN(4)-DDAXV(2,2)+ABS(YSPC)-1)/ABS(YSPC))+1)
          CHRJ=MIN(CHRJ,((DDIN(4)-DDAXV(2,1))/ABS(YSPC))+1)
        END IF
      END IF
      IF (CHRI.GT.CHRJ) GO TO 403
      DDIN(3)=DDIN(3)+(CHRI-1)*XSPC
      DDIN(4)=DDIN(4)+(CHRI-1)*YSPC
C    DO A GRAPHIC DISPLAY FOR TEXT STRINGS.
      CALL UGZ006(DDAAC,0,0,DDIN,CHRP(CHRI:CHRJ),DDEX)
      IF (DDEX(1).NE.0) GO TO 902
      GO TO 403
C    INITIALIZE THE SCISSORING AND SHIELDING MODULE.
  405 IF (DIMN.EQ.2) THEN
        CALL UGC001(DDAWS)
        IF (DDASA.GT.0) THEN
          DO 406 INT1=1,DDAZ5
            IF (DDASF(INT1).NE.0) CALL UGC002(DDASH(1,1,INT1))
  406     CONTINUE
        END IF
      ELSE
        CALL UGC001(DDA3V)
      END IF
C    DO A GRAPHIC INQUIRY FOR SOLID LINES.
      DDIN(2)=2
      DDIN(7)=1
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
C    INITIALIZE FOR SENDING LINES.
      DDIN(1)=9
C    INITIALIZE THE TEXT STRING PROPERTIES.
      OVI4=SEGM(SEGI+6)
      SIZE=OVR4
      IF (DIMN.EQ.2) THEN
        IF (SIZE.LT.0.0) SIZE=-SIZE*DDATR(5)
        RATO=DDATR(6)
      ELSE
        SIZE=-SIZE*DDA3T(17)
        RATO=DDA3T(18)
      END IF
      OVI4=SEGM(SEGI+7)
      ANGL=OVR4
C    SELECT THE NEXT TEXT STRING IN THE GRAPHIC SEGMENT.
  407 IF (DTAI.GE.DTAT) GO TO 201
      OVI4=SEGM(DTAI+1)
      XCRD=OVR4
      OVI4=SEGM(DTAI+2)
      YCRD=OVR4
      IF (DIMN.EQ.3) THEN
        OVI4=SEGM(DTAI+3)
        ZCRD=OVR4
      END IF
      CHRN=SEGM(DTAI+DIMN+1)
      CHRI=DTAI+DIMN+2
      INT1=(CHRN+3)/4
      DO 408 INT2=1,INT1
        INT3=4*INT2-3
        OVI4=SEGM(CHRI+INT2-1)
        CHRP(INT3:INT3+3)=OVC4
  408 CONTINUE
      DTAI=DTAI+SEGM(DTAI)
C    SCISSOR A THREE-DIMENSIONAL TEXT STRING USING THE NEAR
C    SCISSORING PLANE AND PROJECT THE POINT TO TWO-DIMENSIONS.
      IF (DIMN.EQ.3) THEN
        IF ((XCRD*DDA3P(1)+YCRD*DDA3P(2)+ZCRD*DDA3P(3)+DDA3P(4))
     X     .LT.0.0) GO TO 407
        CALL UGB012(XCRD,YCRD,ZCRD,TXCD,TYCD)
        XCRD=TXCD
        YCRD=TYCD
      END IF
C    PROCESS THE "CENTER" AND "RIGHT" OPTIONS.
      IF (SEGM(SEGI+8).NE.1) THEN
        CALL UGE001(1,0,0,0,0.0,0.0,SIZE,ANGL,RATO,CHRTP2,INT1)
        CALL UGE002(CHRP,' ',CHRN,CHRTP2,INT1,FLT1,FLT2,FLT3)
        IF (SEGM(SEGI+8).EQ.2) THEN
          XCRD=XCRD-FLT1
          YCRD=YCRD-FLT2
        ELSE
          XCRD=XCRD-0.5*FLT1
          YCRD=YCRD-0.5*FLT2
        END IF
      END IF
C    INITIALIZE THE CHARACTER STROKE GENERATOR.
      CALL UGE001(0,0,0,0,XCRD,YCRD,SIZE,ANGL,RATO,CHRTP2,INT1)
C    OBTAIN THE NEXT STROKE END POINT.
  409 CALL UGE002(CHRP,' ',CHRN,CHRTP2,BBIT,XCRD,YCRD,FLT1)
      IF (BBIT.LT.0) GO TO 407
C    SCISSOR AND SHIELD THE STROKE END POINT.
      CALL UGC003(BBIT,XCRD,YCRD)
  410 CALL UGC004(BBIT,XCRD,YCRD)
      IF (BBIT.LT.0) GO TO 409
C    TRANSFORM THE POINT TO DEVICE COORDINATES.
      IF (DIMN.EQ.2) THEN
        CALL UGB003(XCRD,YCRD,DDIN(3),DDIN(4))
      ELSE
        CALL UGB013(XCRD,YCRD,DDIN(3),DDIN(4))
      END IF
C    DO A GRAPHIC DISPLAY FOR LINES.
      DDIN(5)=BBIT
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
      IF (DDEX(1).NE.0) GO TO 902
      GO TO 410
C
C  PROCESS EXTENDED TEXT DATA BLOCK. (removed 19940425)
  451 CONTINUE

      DTAI=SEGI+10
      DTAT=SEGI+SEGM(SEGI+1)
C    INITIALIZE THE SCISSORING AND SHIELDING MODULE.
      CALL UGC001(DDAWS)
      IF (DDASA.GT.0) THEN
        DO 452 INT1=1,DDAZ5
          IF (DDASF(INT1).NE.0) CALL UGC002(DDASH(1,1,INT1))
  452   CONTINUE
      END IF
C    DO A GRAPHIC INQUIRY FOR SOLID LINES.
      DDIN(1)=8
      DDIN(2)=2
      DDIN(7)=1
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
C    INITIALIZE FOR SENDING LINES.
      DDIN(1)=9
      DDIN(2)=2
C    INITIALIZE THE TEXT STRING PROPERTIES.
      OVI4=SEGM(SEGI+6)
      SIZE=OVR4
      IF (SIZE.LT.0.0) SIZE=-SIZE*DDATR(5)
      RATO=DDATR(6)
      OVI4=SEGM(SEGI+7)
      ANGL=OVR4
      FIXZ=2-SEGM(SEGI+9)
C    SELECT THE NEXT TEXT STRING IN THE GRAPHIC SEGMENT.
  453 IF (DTAI.GE.DTAT) GO TO 201
      OVI4=SEGM(DTAI+1)
      XCRD=OVR4
      OVI4=SEGM(DTAI+2)
      YCRD=OVR4
      CHRN=SEGM(DTAI+3)
      CHRI=DTAI+4
      INT1=(CHRN+3)/4
      CHRJ=CHRI+INT1
      DO 454 INT2=1,INT1
        INT3=4*INT2-3
        OVI4=SEGM(CHRI+INT2-1)
        CHRP(INT3:INT3+3)=OVC4
        OVI4=SEGM(CHRJ+INT2-1)
        CHRS(INT3:INT3+3)=OVC4
  454 CONTINUE
      DTAI=DTAI+SEGM(DTAI)
C    PROCESS THE "CENTER" AND "RIGHT" OPTIONS.
      IF (SEGM(SEGI+8).NE.1) THEN
        IF ( MCACN .EQ. 'SIMPLEX' ) THEN
          CALL UGE001(1,FIXZ,1,1,0.0,0.0,SIZE,ANGL,RATO,CHRTP3,INT1)
        ELSE
          CALL UGE001(1,FIXZ,1,1,0.0,0.0,SIZE,ANGL,RATO,CHRTP4,INT1)
        ENDIF
        IF (INT1.NE.0) GO TO 908
        IF ( MCACN .EQ. 'SIMPLEX' ) THEN
          CALL UGE002(CHRP,CHRS,CHRN,CHRTP3,INT1,FLT1,FLT2,FLT3)
        ELSE
          CALL UGE002(CHRP,CHRS,CHRN,CHRTP4,INT1,FLT1,FLT2,FLT3)
        ENDIF
        IF (SEGM(SEGI+8).EQ.2) THEN
          XCRD=XCRD-FLT1
          YCRD=YCRD-FLT2
        ELSE
          XCRD=XCRD-0.5*FLT1
          YCRD=YCRD-0.5*FLT2
        END IF
      END IF
C    INITIALIZE THE CHARACTER STROKE GENERATOR.
        IF ( MCACN .EQ. 'SIMPLEX' ) THEN
          CALL UGE001(0,FIXZ,1,1,XCRD,YCRD,SIZE,ANGL,RATO,CHRTP3,INT1)
        ELSE
          CALL UGE001(0,FIXZ,1,1,XCRD,YCRD,SIZE,ANGL,RATO,CHRTP4,INT1)
        ENDIF
      IF (INT1.NE.0) GO TO 908
C    OBTAIN THE NEXT STROKE END POINT.
  455 CONTINUE
      IF ( MCACN .EQ. 'SIMPLEX' ) THEN
        CALL UGE002(CHRP,CHRS,CHRN,CHRTP3,BBIT,XCRD,YCRD,FLT1)
      ELSE
        CALL UGE002(CHRP,CHRS,CHRN,CHRTP4,BBIT,XCRD,YCRD,FLT1)
      ENDIF
      IF (BBIT.LT.0) GO TO 453
C    SCISSOR AND SHIELD THE STROKE END POINT.
      CALL UGC003(BBIT,XCRD,YCRD)
  456 CALL UGC004(BBIT,XCRD,YCRD)
      IF (BBIT.LT.0) GO TO 455
C    TRANSFORM THE POINT TO DEVICE COORDINATES.
      CALL UGB003(XCRD,YCRD,DDIN(3),DDIN(4))
C    DO A GRAPHIC DISPLAY FOR LINES.
      DDIN(5)=BBIT
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
      IF (DDEX(1).NE.0) GO TO 902
      GO TO 456
C
C  PROCESS POLYGON FILL DATA BLOCK.
C    OBTAIN THE VERTICES OF THE POLYGON.
  501 NPTS=SEGM(SEGI+6)
      DO 502 INT1=1,NPTS
        OVI4=SEGM(SEGI+2*INT1+5)
        XARY(INT1)=OVR4
        OVI4=SEGM(SEGI+2*INT1+6)
        YARY(INT1)=OVR4
  502 CONTINUE
C    SCISSOR THE POLYGON.
      CALL UGF001(DDAWS)
      CALL UGF002(XARY,YARY,NPTS,INT1)
      IF (INT1.NE.0) GO TO 904
  503 CALL UGF003(XARY,YARY,NPTS)
      IF (NPTS.LT.0) GO TO 201
C    INITIALIZE FOR SENDING A GRAPHIC INQUIRY.
      DDIN(1)=8
      DDIN(2)=4
      DDIN(3)=SEGM(SEGI+2)
      DDIN(4)=SEGM(SEGI+3)
      DDIN(5)=SEGM(SEGI+4)
      DDIN(6)=SEGM(SEGI+5)
      DDIN(7)=NPTS
C  TRANSFORM THE POLYGON TO DEVICE COORDINATES.
      DO 504 INT1=1,NPTS
        CALL UGB003(XARY(INT1),YARY(INT1),DDIN(2*INT1+6),DDIN(2*INT1+7))
  504 CONTINUE
C    DO A GRAPHIC INQUIRY FOR POLYGON FILL DATA.
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
      IF (DDEX(1).NE.0) GO TO 506
C    DO A GRAPHIC DISPLAY FOR POLYGON FILL DATA.
      DDIN(1)=9
      DO 505 INT1=1,(2*NPTS+1)
        DDIN(INT1+2)=DDIN(INT1+6)
  505 CONTINUE
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
      IF (DDEX(1).NE.0) GO TO 902
      GO TO 503
C    DO A GRAPHIC INQUIRY FOR SOLID LINES.
  506 DDIN(1)=8
      DDIN(2)=2
      DDIN(7)=1
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
C    DO A SERIES OF GRAPHIC DISPLAYS FOR LINES.
      DDIN(1)=9
      DDIN(5)=0
      DO 507 INT1=1,NPTS
        DDIN(3)=DDIN(2*INT1+6)
        DDIN(4)=DDIN(2*INT1+7)
        CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
        IF (DDEX(1).NE.0) GO TO 902
        DDIN(5)=1
  507 CONTINUE
      GO TO 503
C
C  PROCESS DEVICE-DEPENDENT DATA BLOCK.
  551 DTAI=SEGI+6
      DTAT=SEGI+SEGM(SEGI+1)
C    DO A GRAPHIC INQUIRY FOR DEVICE-DEPENDENT DATA.
      DDIN(1)=8
      DDIN(2)=5
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
      IF (DDEX(1).NE.0) GO TO 201
C    INITIALIZE FOR SENDING DEVICE-DEPENDENT DATA.
      DDIN(1)=9
C    SELECT THE NEXT DEVICE-DEPENDENT DATA STRING IN THE GRAPHIC
C    SEGMENT.
  552 IF (DTAI.GE.DTAT) GO TO 201
      OVI4=SEGM(DTAI+1)
      XCRD=OVR4
      OVI4=SEGM(DTAI+2)
      YCRD=OVR4
      CHRN=SEGM(DTAI+3)
      CHRI=DTAI+4
      INT1=(CHRN+3)/4
      DO 553 INT2=1,INT1
        INT3=4*INT2-3
        OVI4=SEGM(CHRI+INT2-1)
        CHRP(INT3:INT3+3)=OVC4
  553 CONTINUE
      DTAI=DTAI+SEGM(DTAI)
C    SCISSOR THE DEVICE-DEPENDENT DATA.
      IF (XCRD.LT.DDAWS(1,1)) GO TO 552
      IF (XCRD.GT.DDAWS(1,2)) GO TO 552
      IF (YCRD.LT.DDAWS(2,1)) GO TO 552
      IF (YCRD.GT.DDAWS(2,2)) GO TO 552
C    TRANSFORM THE POINT TO DEVICE COORDINATES.
      CALL UGB003(XCRD,YCRD,DDIN(3),DDIN(4))
C    DO A GRAPHIC DISPLAY FOR DEVICE-DEPENDENT DATA.
      CALL UGZ006(DDAAC,0,0,DDIN,CHRP(1:CHRN),DDEX)
      IF (DDEX(1).NE.0) GO TO 902
      GO TO 552
C
C  PROCESS THREE-DIMENSIONAL MARKERS DATA BLOCK.
  601 DIMN=3
      IF (DDADF.NE.3) GO TO 302
      DTAI=SEGI+8
      DTAT=SEGI+SEGM(SEGI+1)
C    DO A GRAPHIC INQUIRY FOR THREE-DIMENSIONAL POINTS.
      DDIN(1)=8
      DDIN(2)=6
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
C    INITIALIZE FOR SENDING THREE-DIMENSIONAL POINTS.
      DDIN(1)=9
C    SELECT THE NEXT MARKER IN THE GRAPHIC SEGMENT.
  602 IF (DTAI.GE.DTAT) GO TO 201
      OVI4=SEGM(DTAI)
      XCRD=OVR4
      OVI4=SEGM(DTAI+1)
      YCRD=OVR4
      OVI4=SEGM(DTAI+2)
      ZCRD=OVR4
      DTAI=DTAI+3
C    SCISSOR THE POINT.
      IF (S3DF.EQ.0) THEN
        IF (XCRD.LT.DDA3W(1,1)) GO TO 602
        IF (XCRD.GT.DDA3W(1,2)) GO TO 602
        IF (YCRD.LT.DDA3W(2,1)) GO TO 602
        IF (YCRD.GT.DDA3W(2,2)) GO TO 602
        IF (ZCRD.LT.DDA3W(3,1)) GO TO 602
        IF (ZCRD.GT.DDA3W(3,2)) GO TO 602
      ELSE
        IF (XCRD.LT.DDA3O(1,1)) GO TO 602
        IF (XCRD.GT.DDA3O(1,2)) GO TO 602
        IF (YCRD.LT.DDA3O(2,1)) GO TO 602
        IF (YCRD.GT.DDA3O(2,2)) GO TO 602
        IF (ZCRD.LT.DDA3O(3,1)) GO TO 602
        IF (ZCRD.GT.DDA3O(3,2)) GO TO 602
      END IF
C    TRANSFORM THE POINT TO DEVICE COORDINATES.
      CALL UGB008(XCRD,YCRD,ZCRD,DDIN(3),DDIN(4),DDIN(5))
C    DO A GRAPHIC DISPLAY FOR THREE-DIMENSIONAL POINTS.
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
      IF (DDEX(1).NE.0) GO TO 902
      GO TO 602
C
C  PROCESS THREE-DIMENSIONAL LINE DATA BLOCK.
  651 DIMN=3
      IF (DDADF.NE.3) GO TO 352
      DTAI=SEGI+7
      DTAT=SEGI+SEGM(SEGI+1)
C    INITIALIZE THE SCISSORING MODULE.
      IF (S3DF.EQ.0) THEN
        CALL UGG002(DDA3W)
      ELSE
        CALL UGG002(DDA3O)
      END IF
C    DO A GRAPHIC INQUIRY FOR THREE-DIMENSIONAL LINES.
      DDIN(1)=8
      DDIN(2)=7
      DDIN(7)=1
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
C    INITIALIZE FOR SENDING THREE-DIMENSIONAL LINES.
      DDIN(1)=9
C    SELECT THE NEXT LINE END POINT IN THE GRAPHIC SEGMENT.
  652 IF (DTAI.GE.DTAT) GO TO 201
      OVI4=SEGM(DTAI)
      XCRD=OVR4
      OVI4=SEGM(DTAI+1)
      IF (.NOT.BTEST(OVI4,LSBFLO)) THEN
        BBIT=0
      ELSE
        BBIT=1
      END IF
      OVI4=IBCLR(OVI4,LSBFLO)
      YCRD=OVR4
      OVI4=SEGM(DTAI+2)
      ZCRD=OVR4
      DTAI=DTAI+3
C    SCISSOR THE LINE END POINT.
      CALL UGG003(BBIT,XCRD,YCRD,ZCRD)
  653 CALL UGG004(BBIT,XCRD,YCRD,ZCRD)
      IF (BBIT.LT.0) GO TO 652
C    TRANSFORM THE POINT TO DEVICE COORDINATES.
      CALL UGB008(XCRD,YCRD,ZCRD,DDIN(3),DDIN(4),DDIN(5))
C    DO A GRAPHIC DISPLAY FOR THREE-DIMENSIONAL LINES.
      DDIN(6)=BBIT
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
      IF (DDEX(1).NE.0) GO TO 902
      GO TO 653
C
C  PROCESS THREE-DIMENSIONAL TEXT DATA BLOCK.
  701 DIMN=3
      IF (DDADF.NE.3) GO TO 402
      DTAI=SEGI+10
      DTAT=SEGI+SEGM(SEGI+1)
C    DO A GRAPHIC INQUIRY FOR THREE-DIMENSIONAL TEXT.
      DDIN(1)=8
      DDIN(2)=8
      OVI4=SEGM(SEGI+6)
      SIZE=-OVR4*DDA3T(17)
      CALL UGB013(0.0,0.0,INT1,INT2)
      CALL UGB013(SIZE,0.0,INT2,INT3)
      DDIN(7)=INT2-INT1
      OVI4=SEGM(SEGI+7)
      DDIN(8)=MOD(NINT(OVR4)+720,360)
      DDIN(9)=2
      CALL UGZ006(DDAAC,0,0,DDIN,' ',DDEX)
      DELX=DDEX(2)
      DELY=DDEX(3)
      XSPC=DDEX(4)
      YSPC=DDEX(5)
C    INITIALIZE FOR SENDING THREE-DIMENSIONAL TEXT STRINGS.
      DDIN(1)=9
C    SELECT THE NEXT TEXT STRING IN THE GRAPHIC SEGMENT.
  702 IF (DTAI.GE.DTAT) GO TO 201
      OVI4=SEGM(DTAI+1)
      XCRD=OVR4
      OVI4=SEGM(DTAI+2)
      YCRD=OVR4
      OVI4=SEGM(DTAI+3)
      ZCRD=OVR4
      CHRN=SEGM(DTAI+4)
      CHRI=DTAI+5
      INT1=(CHRN+3)/4
      DO 703 INT2=1,INT1
        INT3=4*INT2-3
        OVI4=SEGM(CHRI+INT2-1)
        CHRP(INT3:INT3+3)=OVC4
  703 CONTINUE
      DTAI=DTAI+SEGM(DTAI)
C    SCISSOR A THREE-DIMENSIONAL TEXT STRING.
      IF (S3DF.EQ.0) THEN
        IF (XCRD.LT.DDA3W(1,1)) GO TO 702
        IF (XCRD.GT.DDA3W(1,2)) GO TO 702
        IF (YCRD.LT.DDA3W(2,1)) GO TO 702
        IF (YCRD.GT.DDA3W(2,2)) GO TO 702
        IF (ZCRD.LT.DDA3W(3,1)) GO TO 702
        IF (ZCRD.GT.DDA3W(3,2)) GO TO 702
      ELSE
        IF (XCRD.LT.DDA3O(1,1)) GO TO 702
        IF (XCRD.GT.DDA3O(1,2)) GO TO 702
        IF (YCRD.LT.DDA3O(2,1)) GO TO 702
        IF (YCRD.GT.DDA3O(2,2)) GO TO 702
        IF (ZCRD.LT.DDA3O(3,1)) GO TO 702
        IF (ZCRD.GT.DDA3O(3,2)) GO TO 702
      END IF
C    TRANSFORM THE POINT TO DEVICE COORDINATES.
      CALL UGB008(XCRD,YCRD,ZCRD,DDIN(3),DDIN(4),DDIN(5))
C    PROCESS THE "CENTER" AND "RIGHT" OPTIONS.
      DDIN(6)=DELX
      DDIN(7)=DELY
      IF (SEGM(SEGI+8).EQ.2) THEN
        DDIN(6)=DDIN(6)-(CHRN-1)*XSPC
        DDIN(7)=DDIN(7)-(CHRN-1)*YSPC
      ELSE IF (SEGM(SEGI+8).EQ.3) THEN
        DDIN(6)=DDIN(6)-((CHRN-1)*XSPC/2)
        DDIN(7)=DDIN(7)-((CHRN-1)*YSPC/2)
      END IF
C    DO A GRAPHIC DISPLAY FOR THREE-DIMENSIONAL TEXT STRINGS.
      CALL UGZ006(DDAAC,0,0,DDIN,CHRP(1:CHRN),DDEX)
      IF (DDEX(1).NE.0) GO TO 902
      GO TO 702
C
C  RESET ERROR INDICATORS AND RETURN TO CALLER.
  801 IF (EFLG.EQ.0) THEN
        UGELV=0
        UGENM='        '
        UGEIX=0
      END IF
  802 RETURN
C
C  REPORT ERRORS TO THE UNIFIED GRAPHICS SYSTEM ERROR PROCESSOR.
  901 CALL UGRERR(2,'UGWRIT  ', 1)
      GO TO 802
  902 CALL UGRERR(2,'UGWRIT  ', 2)
      EFLG=1
      GO TO 202
  903 CALL UGRERR(4,'UGWRIT  ', 3)
      GO TO 802
  904 CALL UGRERR(2,'UGWRIT  ', 4)
      EFLG=1
      GO TO 201
  905 CALL UGRERR(3,'UGWRIT  ',12)
      GO TO 802
  906 CALL UGRERR(2,'UGWRIT  ',13)
      GO TO 802
  907 CALL UGRERR(2,'UGWRIT  ',13)
      EFLG=1
      GO TO 101
  908 CALL UGRERR(3,'UGWRIT  ',14)
      GO TO 802
C
      END
