      LOGICAL FUNCTION GATE2(XTEST,YTEST,IUNIT)
      PARAMETER (MAXGT2=20,MAXDIV=255,MAXPNT=1000)
      INTEGER*4 IGATE(10:99)
      CHARACTER FLNAME*180
      DIMENSION SX(MAXGT2),X0(MAXGT2),SY(MAXGT2),Y0(MAXGT2),
     -          X(MAXPNT),Y(MAXPNT),XC(MAXPNT),YC(MAXPNT)
      LOGICAL*1 G(0:MAXDIV,0:MAXDIV,MAXGT2)
      LOGICAL*4 GO(10:99),OK
      CHARACTER LINE*72
      DATA      NGATE/0/,GO/90*.FALSE./
      IF (IUNIT.LT.10.OR.IUNIT.GE.100) THEN
          WRITE(6,'(A,I2,A)') ' **  Illigal Unit-No. (',
     -                  IUNIT,') for 2-dim Gate !! **'
          STOP 1024
        ENDIF
      IF (GO(IUNIT)) GOTO 20000
C
C   INITIALIZE 2-DIMENSIONAL GATE TABLE
      NGATE=NGATE+1
      CALL EXCMAX(NGATE,MAXGT2,' GATE2')
      IGATE(IUNIT)=NGATE
      GO(IUNIT)=.TRUE.
      INQUIRE(UNIT=IUNIT,OPENED=OK)
      IF (.NOT.OK) OPEN(UNIT=IUNIT,STATUS='OLD',ERR=90000)
      XMIN= 1.E30
      XMAX=-1.E30
      YMIN= 1.E30
      YMAX=-1.E30
      N=0
10010   READ(IUNIT,'(A)',END=10020) LINE
        L=1
        DO WHILE (LINE(L:L).EQ.' '.AND.L.LT.LEN(LINE))
          L=L+1
        ENDDO
        IF (INDEX('0123456789.+-',LINE(L:L)).EQ.0) GOTO 10018
        READ(LINE,*,ERR=10018) W,V
        IF (W.LT.XMIN) XMIN=W
        IF (W.GT.XMAX) XMAX=W
        IF (V.LT.YMIN) YMIN=V
        IF (V.GT.YMAX) YMAX=V
        N=N+1
        CALL EXCMAX(N,MAXPNT,' POINT')
        X(N)=W
        Y(N)=V
      GOTO 10010
10018 IF (N.EQ.0) GOTO 10010
10020 INQUIRE(UNIT=IUNIT,NAME=FLNAME)
      CLOSE(IUNIT)
      IF (FLNAME.EQ.' ') WRITE(FLNAME,'(2HFT,I2,4HF001)') IUNIT
C     CALL LIB$TRIM_FILESPEC(FLNAME,FLNAME,40,L)
      WRITE(6,'(/1H ,3A,I5,A,I2,A)')
     -    '**  2-dim Gate "',FLNAME(:LENGTH(FLNAME)),
     -    '" (',N,'-Points) has been Read from Unit(',IUNIT,').  **'
      X(N+1)=X(1)
      Y(N+1)=Y(1)
      IF (N.LT.3) THEN
          WRITE(6,'(/1H ,A)')
     -      '**  Input Data does NOT Make Any Loop (GATE2) !!  **'
          STOP 1024
        ENDIF
      CALL SCALE(XMIN,XMAX,MAXDIV+1,SX(NGATE),X0(NGATE),*99999)
      CALL SCALE(YMIN,YMAX,MAXDIV+1,SY(NGATE),Y0(NGATE),*99999)
      DO 10030 I=1,N+1
        XC(I)=MAX(0.,MIN(256.,SX(NGATE)*X(I)+X0(NGATE)))
10030   YC(I)=MAX(0.,MIN(256.,SY(NGATE)*Y(I)+Y0(NGATE)))
      DO 10050 I=0,MAXDIV
        X1=FLOAT(I)
        DO 10050 J=0,MAXDIV
          Y1=FLOAT(J)
          NCROSS=0
          DO 10040 M=1,N
            Y3=YC(M  )
            Y4=YC(M+1)
            IF ((Y3-Y1)*(Y4-Y1).GT.0.) GOTO 10040
            IF (Y3.EQ.Y4) GOTO 10040
            XS=(Y1-Y3)/(Y4-Y3)*(XC(M+1)-XC(M))+XC(M)
            IF (XS.LT.0..OR.XS.GE.X1) GOTO 10040
            NCROSS=NCROSS+1
10040     CONTINUE
10050     G(I,J,NGATE)=(MOD(NCROSS,2).NE.0)
C
C   EVALUATE 2-DIMENSIONAL GATE
20000   K=IGATE(IUNIT)
        I=NINT(XTEST*SX(K)+X0(K))
        J=NINT(YTEST*SY(K)+Y0(K))
        IF (I.GE.0.AND.I.LE.MAXDIV.AND.
     -      J.GE.0.AND.J.LE.MAXDIV) THEN
            GATE2=G(I,J,K)
          ELSE
            GATE2=.FALSE.
          ENDIF
        RETURN
C
90000 WRITE(6,'(A,I2,A)') ' **  Unit-',IUNIT,
     -           ' for 2-dim Gate can NOT be Accessed !!  **'
      CLOSE(IUNIT)
      STOP 1024
99999 WRITE(6,'(/1H ,A)') '**  Invalid Curve for GATE2 !!  **'
      STOP 1024
      END

      SUBROUTINE SCALE(X1,X2,N,SX,X0,*)
      IF (X1.EQ.X2) RETURN 1
      SX=FLOAT(N)/(X2-X1)
      X0=-SX*X1
      RETURN
      END
