#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>

extern char *optarg;
extern int optind, opterr, optopt;

static char path[2][256] = {"/dev/nrmt0", "\0"};
static int li, lo, tape;
static int after = 0;
static int norew = 0;
static int chekf = 0;
static int files[256];
static int chekr = 0;
static int runos[256];

#define buflen 16384
char buffer[buflen];
static int block, illigal, total = 0, file = 0;

struct mtop mt_offl = {MTOFFL, 1};
struct mtop mt_bsf  = {MTBSF , 1};
struct mtop mt_weof = {MTWEOF, 1};
#if  defined(__OSF1)
struct mtop mt_eom  = {MTSEOD, 1};
#else
struct mtop mt_eom  = {MTEOM , 1};
#endif

void usage(char *cmd)
{
  int i = 0;
  static char *options[] = {
    "  source  : tape device name (default /dev/nrmt0)",
    "  destin. : directory name or tape device name",
    "  options :",
    "    -a      [after]      copy files after EOV of destin. (if it is tape)",
    "    -n      [norewind]   do not rewind at end of copy.",
    "    -f arg  [fileno]     specify files to be copied by File No.",
    "    -r arg  [runno]      specify files to be copied by Run No.",
    "    -h      [help]",
    "       arg: single number, or numbers separated by comma and/or hyphen.",
    "\0"
  };
  fprintf(stderr, "Usage:\n\t%s [options] source [destin.]\n\n", cmd);
  do fprintf(stderr, "%s\n", options[i++]); while (*options[i]);
  exit(2);
}

int rdseq(int *nseq, int *seq)
{
  int  i1 = -1, i2;
  char parm[256], *bp;
  bp = parm;
  do {
    switch (*optarg) {
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
      *bp++ = *optarg; break;
    case '-':
      *bp++ = '\0'; i1 = atoi(parm); bp = parm; break;
    case ',': case '\0':
      *bp++ = '\0';
      if (i1 == -1) {
	*(seq++) = atoi(parm); (*nseq)++;
      } else {
	i2 = atoi(parm);
	do {*seq++ = i1++ ; (*nseq)++;} while (i1 <= i2);
      }
      i1 = -1; bp = parm; break;
    default:
      fprintf(stderr, "Invalid Argument (%s)\n\n", optarg); return 1;
    }
  } while (*optarg++ != '\0');
  return 0;
}

void write_comment ()
{
  char runtime[47], date[10], comment[81], *p;
  const char ord[10][4]
    = {"-th","-st","-nd","-rd","-th","-th","-th","-th","-th","-th"};
  strncpy(runtime, (char *)buffer+ 20, 46); runtime[46] = '\0';
  strncpy(date   , (char *)buffer+ 87,  9); date   [ 9] = '\0';
  strncpy(comment, (char *)buffer+100, 80);
  for (p = comment + 79 ; p != comment && *p <= ' ' ; p--) *p = '\0';
  switch (buffer[0]) {
  case  1: printf("      Starting Comment "); break;
  case  0: return;
  case -1: printf("      Stopping Comment "); break;
  default: illigal++; return;
  }
  printf("%s%s\n", runtime, date);
  printf("      (%5d%s Block) %s\n", block,
	 ord[((block%100)/10 == 1) ? 0 : block%10], comment);
  fflush(NULL);
}

void abandon ()
{
  ioctl(li, MTIOCTOP, (char *)&mt_offl);
  if ((int)path[1][0] && tape)
  ioctl(lo, MTIOCTOP, (char *)&mt_offl);
  exit(2);
}

main (int argc, char *argv[])
{
  int  io, i, runno, p = 0, label = 0 ;
  char f[3][256], runs[5], option;
  struct stat buf;

  while ((option = getopt(argc, argv, "anf:r:h")) != -1)
    switch(option) {
    case 'f': if (rdseq(&chekf, &files[0])) usage(argv[0]); break;
    case 'r': if (rdseq(&chekr, &runos[0])) usage(argv[0]); break;
    case 'a': after = 1; break;
    case 'n': norew = 1; break;
    case 'h': default: usage(argv[0]);
    }
  for (i = 0; i < 2 && optind < argc;) strncpy(path[i++], argv[optind++], 256);

  if (stat(path[0], &buf) == -1) {
    fprintf(stderr, "Illigal Device (%s)\n\n", path[0]); usage(argv[0]);
  } else {
    if(!S_ISCHR(buf.st_mode)) {
      fprintf(stderr, "%s is not Tape Device\n\n", path[0]); usage(argv[0]);
    } else {
      if ((li = open(path[0], O_RDONLY)) == -1)
	{fprintf(stderr, "Device Open Error (%s)\n", path[0]); abandon();}
    }
  }

  if ((int)path[1][0]) {
    if (stat(path[1], &buf) == -1) {
      fprintf(stderr, "Illigal Device (%s)\n\n", path[1]); usage(argv[0]);
    } else {
      if (tape = S_ISCHR(buf.st_mode)) {
	if ((lo = open(path[1], O_WRONLY)) == -1)
	  {fprintf(stderr,"Device Open Error (%s)\n",path[1]); abandon();}
	if (after) {
	  ioctl(lo, MTIOCTOP, (char *)&mt_eom);
	  ioctl(lo, MTIOCTOP, (char *)&mt_bsf);
	  fprintf(stderr,"Skipped to End-Of-Media.\n"); }
      } else {
	strcpy(f[0], path[1]);
	if (f[0][strlen(f[0])-1] == '/')
	  strcat(f[0], "run"); else strcat(f[0], "/run");
      }
    }
  }

  printf("****  Comment List of Raw-Data MT  ****\n"); fflush(NULL);
  for (;;) {
    block = 0; illigal = 0;
    switch (read(li, buffer, buflen)) {
    case -1:
      fprintf(stderr,"Device Read Error (%s)\n", path[0]); abandon();
    case  0:
      printf("\n****%7d Files  (%7d Blocks)  ****\n", file, total);
      fflush(NULL);
      ioctl(li, MTIOCTOP, (char *)&mt_offl); close(li);
      if ((int)path[1][0] && tape) {
	ioctl(lo, MTIOCTOP, (char *)&mt_weof);
	if (norew) ioctl(lo, MTIOCTOP, (char *)&mt_bsf );
	      else ioctl(lo, MTIOCTOP, (char *)&mt_offl);
	close(lo); }
      exit(0);
    default:
      printf("\n  ==> Label%8d", ++file);
      if ((int)path[1][0]) {
	strncpy(runs, (char *)buffer+24, 4);
	sscanf(runs, "%d", &runno);
	p = (chekf == 0 && chekr == 0) ? 1 : 0;
	for (i = 0 ; i < chekf ; i++) if (files[i] == file ) p = 1;
	for (i = 0 ; i < chekr ; i++) if (runos[i] == runno) p = 1;
	if (p) {
	  if (!tape) {
	    strcpy(f[1], f[0]); strcat(f[1], runs); strcat(f[1], ".dat");
	    strcpy(f[2], f[1]); strcat(f[2], "~");
	    rename(f[1], f[2]);
	    if ((lo = creat(f[1], 0644)) == -1) {
	      fprintf(stderr, "File Open Error (%s)\n", f[1]); abort(); }
	    printf("    copied to \"%s\"", f[1]);
	  } else {
	    printf("    copied to Label%8d", ++label);
	  }
	}
      } else p = 0;
      printf("\n"); fflush(NULL);
      do {
	if (p) {
	  if (write(lo, buffer, buflen) != buflen) {
	    fprintf(stderr, "Error during Write\n"); abort(); }	}
	block++; write_comment();
      } while ((io = read(li, buffer, buflen)) > 0);
      total += block;
      if (io < 0) {
	fprintf(stderr,"Device Read Error (%s)\n",path[0]); abandon();
      } else {
	if (p) {
	  if (tape) ioctl(lo, MTIOCTOP, (char *)&mt_weof);
	       else close(lo); }
      }
    } /* switch */
  } /* for-infinite-loop */

}
