#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>

static int after = 0;
int li, lo;

#define buflen 16384
char buffer[buflen];
static int block, illigal, total = 0, file = 0;

struct mtop mt_offl = {MTOFFL, 1};
struct mtop mt_bsf  = {MTBSF , 1};
struct mtop mt_weof = {MTWEOF, 1};
#if  defined(__OSF1)
struct mtop mt_eom  = {MTSEOD, 1};
#else
struct mtop mt_eom  = {MTEOM , 1};
#endif

void usage(char *cmd)
{
  fprintf(stderr, "Usage:\n\t%s [-a] tape-device files [...]\n", cmd);
  fprintf(stderr, "      -a ... write files after EOV of tape.\n");
  exit(2);
}

void abandon()
{
  ioctl(lo, MTIOCTOP, (char *)&mt_offl); exit(2);
}

main (int argc, char *argv[])
{
  int io, p = 1, i;
  struct stat buf;
  if (argc < 3) usage(argv[0]);
  if (!strcmp(argv[1], "-a")) {after = 1; p++;}
  if (stat(argv[p], &buf) == -1) {
    fprintf(stderr, "Illigal Device (%s)\n\n", argv[p]);
    usage(argv[0]);
  } else {
    if(!S_ISCHR(buf.st_mode)) {
      fprintf(stderr, "%s is not Tape Device\n\n", argv[p]);
      usage(argv[0]);
    } else {
      if ((lo = open(argv[p], O_WRONLY)) == -1) {
	fprintf(stderr, "Device Open Error (%s)\n", argv[p]); exit(2);}
    }
  }

  for (i = ++p ; i < argc ; i++) {
    if ((li = open(argv[i], O_RDONLY)) == -1) {
      fprintf(stderr, "File Open Error (%s)\n", argv[i]); exit(2);}
    close(li);
  }
  if (after) {
    ioctl(lo, MTIOCTOP, (char *)&mt_eom);
    ioctl(lo, MTIOCTOP, (char *)&mt_bsf);
    fprintf(stderr,"Skipped to End-Of-Media.\n");
  }

  for ( ; p < argc ; p++) {
    printf("%s", argv[p]);
    if ((li = open(argv[p], O_RDONLY)) == -1) {
      fprintf(stderr, "File Open Error (%s)\n", argv[p]); abandon();
    } else {
      block = 0;
      while ((io = read(li, buffer, buflen)) == buflen) {
	if (write(lo, buffer, buflen) != buflen) {
	  fprintf(stderr, "Error during Write\n"); abandon();}
	block++;
      }
      if (io < 0) {
	fprintf(stderr, "Data Read Error (%s)\n", argv[p]); abandon();}
      if (io != 0) {printf("%s is not Raw-Data\n"); abandon();}
      close(li); ioctl(lo, MTIOCTOP, (char *)&mt_weof);
      printf("  ... %7d Blocks\n", block); fflush(stdout); file++;
    }
  }
  ioctl(lo, MTIOCTOP, (char *)&mt_weof);
  printf("%5d File(s)\n", file);
  ioctl(lo, MTIOCTOP, (char *)&mt_offl);
}
