#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>

#define buflen 16384

void write_comment (char *buffer, int block, int *illigal)
{
  char  runtime[47], date[10], comment[81], *p;
  const char ord[10][4]
    = {"-th","-st","-nd","-rd","-th","-th","-th","-th","-th","-th"};
  strncpy(runtime, (char *)buffer+ 20, 46); runtime[46] = '\0';
  strncpy(date   , (char *)buffer+ 87,  9); date   [ 9] = '\0';
  strncpy(comment, (char *)buffer+100, 80);
  for (p = comment + 79 ; p != comment && *p <= ' ' ; p--) *p = '\0';
  switch (buffer[0]) {
  case  1: printf("      Starting Comment "); break;
  case  0: return;
  case -1: printf("      Stopping Comment "); break;
  default: *illigal++; return;
  }
  printf("%s%s\n", runtime, date);
  if (block < 0) printf("                       ");
            else printf("      (%5d%s Block) ", block,
			ord[((block%100)/10 == 1) ? 0 : block%10]);
  printf("%s\n",comment); fflush(stdout);
}

void list_mt (char *path)
{
  int  lun, illigal, file = 0;
  char buffer[buflen];
  struct mtop mt_offl = {MTOFFL, 1};
  struct mtop mt_fsfm = {MTFSFM, 1};
  struct mtop mt_fsf  = {MTFSF , 1};
  struct mtop mt_bsr  = {MTBSR , 1};

  if ((lun = open(path, O_RDONLY)) == -1) {
      fprintf(stderr,"Device Open Error (%s)\n",path);
      exit(2);
    }
  printf("****  Comment List of Raw-Data MT  ****\n");
  for (;;) {
    switch (read(lun, (char *)buffer, buflen)) {
    case -1:
      fprintf(stderr,"Device Read Error (%s)\n",path);
      exit(2);
    case  0:
      printf("\n****%7d Files  ****\n",file);
      ioctl(lun, MTIOCTOP, (char *)&mt_offl);
      close(lun);
      exit(0);
    default:
      printf("\n  ==> Label%8d\n", ++file);
      write_comment(buffer, -1, &illigal);
      ioctl(lun, MTIOCTOP, (char *)&mt_fsfm);
      ioctl(lun, MTIOCTOP, (char *)&mt_bsr );
      read(lun, (char *)buffer, buflen);
      write_comment(buffer, -1, &illigal);
      ioctl(lun, MTIOCTOP, (char *)&mt_fsf );
    }
  }
}

void list_disk(int argc, char *argv[])
{
  int  lun, len, block, illigal, total = 0, file = 0;
  char buffer[buflen];
  printf("****  Comment List of Raw-Data on Disk  ****\n");
  while (argc-- != 0) {
    if ((lun = open(argv[++file], O_RDONLY)) == -1) {
      fprintf(stderr,"File Open Error (%d)\n",argv[file--]);
    } else {
      printf("\n  ==> %s\n", argv[file]);
      block = 0; illigal = 0;
      while ((len = read(lun, (char *)buffer, buflen)) > 0) {
        block++; write_comment(buffer, block, &illigal);
      }
      switch (len) {
      case -1: fprintf(stderr,"File Read Error (%s)\n",argv[file]); break;
      case  0: close(lun);
        printf("      Blocks%7d",block);
        if (illigal != 0) printf("     (Illigal%7d)",illigal);
        printf("\n"); break;
      }
      total += block;
    }
  }
  printf("\n****%7d Files  (%7d Blocks)  ****\n", file, total);
}

void usage(char *cmd)
{
  fprintf(stderr,"Usage:\n\t%s [tape-device]\n  or\n\t%s files [...]\n\n  * default tape device = /dev/nrmt0.  \n    wild-card is allowed for files.  \n\n",cmd,cmd);
  exit(2);
}

main (int argc, char *argv[])
{
  char path[255] = "/dev/nrmt0";
  struct stat buf;

  if (argc >= 2) {
    if (argv[1][0] == '-') usage(argv[0]);
    strcpy(path, argv[1]);
  }
  if (stat(path, &buf) == -1) {
    fprintf(stderr,"Illigal Device (%s)\n\n",path);
    usage(argv[0]);
  } else {
    if S_ISCHR(buf.st_mode) {
      list_mt(path);
    } else {
      list_disk(--argc, argv);
    }
  }
}
