#!/bin/sh

#  Modification History

#  Changed on 04/30/99 by Dan Espen (dane):
#  - Do all the man pages using "find" and generate the man page index.

#  Created on 11/06/98 by DanEspen (dje):
#  - Use man2html to convert fvwm2 man pages to html.

# Arg1 is the source tree location
# Arg2 is where the html should be put...

sourcedir=$1
if [ "$1" = "" ] ; then
  sourcedir="../"
fi
outdir=$2
if [ "$2" = "" ] ; then
  outdir=./
fi


# Not really needed...
index='man-pages'

# Start the index page:
page="Index"
file="man-pages"

# If this was ksh, this would be the "header" function.
echo "<html>
<head>
<title>FVWM Manpage - $page</title>
</head>
  <body BACKGROUND=\"black-stone1.jpg\"
    bgcolor=\"#000000\" text=\"#ffffff\"
    link=\"#FFFF88\" vlink=\"#EEDDDD\" alink=\"#ff0000\">
<center>
<h1><font color=\"pink\">FVWM Manpage - $page</font></h1>
</center>
<pre>
" > $outdir/$file.html

echo '</pre>
<!-- Generic header logic turned on "pre" had to turn it off -->
<hr>
These pages were last generated on '`date`' by '`whoami`,'
from the man pages in directory '"$sourcedir"'.
'>>$outdir/$index.html

# Init the current section to 0.
curr_section="0"

# There is some logic in here for man pages in other than section 1,
# right now we don't need it.  Also it doesn't work because this isn't ksh...
for i in `find $sourcedir -name '*.[1]'` ; do
  file=`basename $i | cut -d. -f1`
  page=$file
  section=1

  # If this was ksh, this would be the "header" function.
  echo "<html>
<head>
<title>FVWM Manpage - $page</title>
</head>
  <body BACKGROUND=\"black-stone1.jpg\"
    bgcolor=\"#000000\" text=\"#ffffff\"
    link=\"#FFFF88\" vlink=\"#EEDDDD\" alink=\"#ff0000\">
<center>
<h1><font color=\"pink\">FVWM Manpage - $file</font></h1>
</center>
<pre>
" > $outdir/$file.html

  # Embed the text with some adjustment:
  # Italics are shown in yellow.  References, (if there were any)
  # would be shown in cyan.  Unfortunately bold stuff in man pages
  # is lost.  Maybe in the man command, maybe in man2html.
  # Output looks pretty good anyway (to my eyes).
  echo "Doing $page."
  nroff -man $i | man2html -bare \
   -belem 'font color="cyan"'\
   -uelem 'font color="yellow"'\
  | sed -e 's/color="yellow"</color="yellow"></'\
  >> $outdir/$file.html


# If this was ksh, this would be the "footer" function.
  echo "</pre>
<hr>
<!-- This file automatically generated by all_man2html.ksh
on `date` -->
</body>
</html>
" >> $outdir/$file.html

  # Section header, right now, one section...
  if [ "$curr_section" != "$section" ] ; then
    if [ "$curr_section" != "0" ] ; then
      echo '</menu></MULTICOL>'>>$outdir/$index.html
    fi
    echo '<hr><font color="cyan">Start of man pages in section '$section'.
</font>
<MULTICOL COLS=4 WIDTH="100%">
<menu>'>>$outdir/$index.html
    curr_section=$section
  fi

  echo '<li><a href="'$outdir/$file'.html">'$page'('$section')</a>'>>$outdir/$index.html
done

# Finish the index page:
page="Index"
file="man-pages"
# This puts out a <pre> only because the footer puts out </pre>
echo '</menu></MULTICOL><pre>'>>$outdir/$index.html

# If this was ksh, this would be the "footer" function.
  echo "</pre>
<hr>
<!-- This file automatically generated by all_man2html.ksh
on `date` -->
</body>
</html>
" >> $outdir/$file.html
