/****************************************************************************
 * This module is based on Twm, but has been siginificantly modified
 * by Rob Nation
 ****************************************************************************/
/*****************************************************************************/
/**       Copyright 1988 by Evans & Sutherland Computer Corporation,        **/
/**                          Salt Lake City, Utah                           **/
/**  Portions Copyright 1989 by the Massachusetts Institute of Technology   **/
/**                        Cambridge, Massachusetts                         **/
/**                                                                         **/
/**                           All Rights Reserved                           **/
/**                                                                         **/
/**    Permission to use, copy, modify, and distribute this software and    **/
/**    its documentation  for  any  purpose  and  without  fee is hereby    **/
/**    granted, provided that the above copyright notice appear  in  all    **/
/**    copies and that both  that  copyright  notice  and  this  permis-    **/
/**    sion  notice appear in supporting  documentation,  and  that  the    **/
/**    names of Evans & Sutherland and M.I.T. not be used in advertising    **/
/**    in publicity pertaining to distribution of the  software  without    **/
/**    specific, written prior permission.                                  **/
/**                                                                         **/
/**    EVANS & SUTHERLAND AND M.I.T. DISCLAIM ALL WARRANTIES WITH REGARD    **/
/**    TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES  OF  MERCHANT-    **/
/**    ABILITY  AND  FITNESS,  IN  NO  EVENT SHALL EVANS & SUTHERLAND OR    **/
/**    M.I.T. BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL  DAM-    **/
/**    AGES OR  ANY DAMAGES WHATSOEVER  RESULTING FROM LOSS OF USE, DATA    **/
/**    OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER    **/
/**    TORTIOUS ACTION, ARISING OUT OF OR IN  CONNECTION  WITH  THE  USE    **/
/**    OR PERFORMANCE OF THIS SOFTWARE.                                     **/
/*****************************************************************************/

/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/**********************************************************************
 *
 * Add a new window, put the titlbar and other stuff around
 * the window
 *
 **********************************************************************/
#include "config.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "fvwm.h"
#include "style.h"
#include <X11/Xatom.h>
#include "screen.h"
#include "misc.h"
#include "bindings.h"
#ifdef SHAPE
#include <X11/extensions/shape.h>
#include <X11/Xresource.h>
#endif /* SHAPE */
#include "module.h"
#include "session.h"


/* Used to parse command line of clients for specific desk requests. */
/* Todo: check for multiple desks. */
static XrmDatabase db;
static XrmOptionDescRec table [] = {
  /* Want to accept "-workspace N" or -xrm "fvwm*desk:N" as options
   * to specify the desktop. I have to include dummy options that
   * are meaningless since Xrm seems to allow -w to match -workspace
   * if there would be no ambiguity. */
    {"-workspacf",      "*junk",        XrmoptionSepArg, (caddr_t) NULL},
    {"-workspace",	"*desk",	XrmoptionSepArg, (caddr_t) NULL},
    {"-xrn",		NULL,		XrmoptionResArg, (caddr_t) NULL},
    {"-xrm",		NULL,		XrmoptionResArg, (caddr_t) NULL},
};


/***********************************************************************
 *
 *  Procedure:
 *	AddWindow - add a new window to the fvwm list
 *
 *  Returned Value:
 *	(FvwmWindow *) - pointer to the FvwmWindow structure
 *
 *  Inputs:
 *	w	- the window id of the window to add
 *	iconm	- flag to tell if this is an icon manager window
 *
 ***********************************************************************/
FvwmWindow *AddWindow(Window w, FvwmWindow *ReuseWin)
{
  /* new fvwm window structure */
  register FvwmWindow *tmp_win;
  /* mask for create windows */
  unsigned long valuemask;
#if defined(PIXMAP_BUTTONS) && defined(BORDERSTYLE)
  Pixmap TexturePixmap = None, TexturePixmapSave = None;
#endif
  unsigned long valuemask_save = 0;
  /* attributes for create windows */
  XSetWindowAttributes attributes;
  /* area for merged styles */
  window_style style;
  /* used for faster access */
  style_flags *sflags;
  int i,width,height;
  int a,b;
/*  RBW - 11/02/1998  */
  int tmpno1 = -1, tmpno2 = -1, tmpno3 = -1, spargs = 0;
/**/
  extern Bool NeedToResizeToo;
  extern FvwmWindow *colormap_win;
  int client_argc;
  char **client_argv = NULL, *str_type;
  Bool status;
  XrmValue rm_value;
  XTextProperty text_prop;
  extern Boolean PPosOverride;

  int do_shade, do_maximize;
  int x_max, y_max, w_max, h_max;

  NeedToResizeToo = False;

  /*
      Allocate space for the FvwmWindow struct, or reuse an
      old one (on Recapture).
  */
  if (ReuseWin == NULL)
    {
      tmp_win = (FvwmWindow *)safemalloc(sizeof(FvwmWindow));
      if (tmp_win == (FvwmWindow *)0)
        {
          return NULL;
        }
    }
  else
    {
      tmp_win = ReuseWin;
    }

  /*
    RBW - 1999/03/20 - modify this when we implement the preserving of
    various states across a Restart. The Destroy function in misc.c may
    also need tweaking, depending on what you want to preserve.
    For now, just zap any old information.
  */
  memset(tmp_win, '\0', sizeof(FvwmWindow));
  tmp_win->w = w;

  tmp_win->cmap_windows = (Window *)NULL;
#ifdef MINI_ICONS
  tmp_win->mini_pixmap_file = NULL;
  tmp_win->mini_icon = NULL;
#endif

  if(!PPosOverride)
    if (XGetGeometry(dpy, tmp_win->w, &JunkRoot, &JunkX, &JunkY,
		     &JunkWidth, &JunkHeight, &JunkBW, &JunkDepth) == 0)
      {
	free((char *)tmp_win);
	return(NULL);
      }
  if ( XGetWMName(dpy, tmp_win->w, &text_prop) != 0 )
    tmp_win->name = (char *)text_prop.value;
  else
    tmp_win->name = NoName;

  /* removing NoClass change for now... */
#if 0
  tmp_win->class.res_name = tmp_win->class.res_class = NULL;
#else
  tmp_win->class.res_name = NoResource;
  tmp_win->class.res_class = NoClass;
#endif /* 0 */
  XGetClassHint(dpy, tmp_win->w, &tmp_win->class);
#if 1
  if (tmp_win->class.res_name == NULL)
    tmp_win->class.res_name = NoResource;
  if (tmp_win->class.res_class == NULL)
    tmp_win->class.res_class = NoClass;
#endif /* 1 */

  FetchWmProtocols (tmp_win);
  FetchWmColormapWindows (tmp_win);
  if(!(XGetWindowAttributes(dpy,tmp_win->w,&(tmp_win->attr))))
    tmp_win->attr.colormap = PictureCMap;

  tmp_win->wmhints = XGetWMHints(dpy, tmp_win->w);

  SET_TRANSIENT(tmp_win, !!XGetTransientForHint(dpy, tmp_win->w,
						&tmp_win->transientfor));

  tmp_win->old_bw = tmp_win->attr.border_width;

#ifdef SHAPE
  if (ShapesSupported)
  {
    int xws, yws, xbs, ybs;
    unsigned wws, hws, wbs, hbs;
    int boundingShaped, clipShaped;

    XShapeSelectInput (dpy, tmp_win->w, ShapeNotifyMask);
    XShapeQueryExtents (dpy, tmp_win->w,
			&boundingShaped, &xws, &yws, &wws, &hws,
			&clipShaped, &xbs, &ybs, &wbs, &hbs);
    tmp_win->wShaped = boundingShaped;
  }
#endif /* SHAPE */


  /* if the window is in the NoTitle list, or is a transient,
   *  dont decorate it.
   * If its a transient, and DecorateTransients was specified,
   *  decorate anyway
   */
  /*  Assume that we'll decorate */
  SET_HAS_BORDER(tmp_win, 1);
  SET_HAS_TITLE(tmp_win, 1);

  /* get merged styles */
  lookup_style(tmp_win, &style);
  sflags = SGET_FLAGS_POINTER(style);

  /* copy iconboxes ptr (if any) */
  tmp_win->IconBoxes = SGET_ICON_BOXES(style);
  /* on and off buttons combined. */
  tmp_win->buttons = SGET_BUTTONS(style);
  /* FIXME: shouldn't transients inherit the layer ? */
  tmp_win->default_layer = SGET_LAYER(style);
  tmp_win->layer = SGET_LAYER(style);

#ifdef USEDECOR
  /* search for a UseDecor tag in the Style */
  tmp_win->fl = NULL;
  if (SGET_DECOR_NAME(style) != NULL) {
      FvwmDecor *fl = &Scr.DefaultDecor;
      for (; fl; fl = fl->next)
	  if (strcasecmp(SGET_DECOR_NAME(style), fl->tag) == 0) {
	      tmp_win->fl = fl;
	      break;
	  }
  }
  if (tmp_win->fl == NULL)
      tmp_win->fl = &Scr.DefaultDecor;
#endif

  tmp_win->title_height = GetDecor(tmp_win,TitleHeight);

  GetMwmHints(tmp_win);
  GetOlHints(tmp_win);

  SelectDecor(tmp_win, sflags, SGET_BORDER_WIDTH(style),
	      SGET_HANDLE_WIDTH(style));

#ifdef GNOME
  /* set GNOME window hints & FVWM flags translated from those hints */
  GNOME_GetHints(tmp_win);
#endif

#ifdef SHAPE
  /* set boundary width to zero for shaped windows */
  if (tmp_win->wShaped)
    tmp_win->boundary_width = 0;
#endif /* SHAPE */

  memcpy(&(tmp_win->flags), sflags, sizeof(common_flags_type));
  /* find a suitable icon pixmap */
  if(SHAS_ICON(sflags))
    {
      /* an icon was specified */
      tmp_win->icon_bitmap_file = SGET_ICON_NAME(style);
    }
  else if((tmp_win->wmhints)
	  &&(tmp_win->wmhints->flags & (IconWindowHint|IconPixmapHint)))
    {
      /* window has its own icon */
      tmp_win->icon_bitmap_file = NULL;
    }
  else
    {
      /* use default icon */
      tmp_win->icon_bitmap_file = Scr.DefaultIcon;
    }

#ifdef MINI_ICONS
  if (SHAS_MINI_ICON(sflags)) {
    tmp_win->mini_pixmap_file = SGET_MINI_ICON_NAME(style);
  }
  else {
    tmp_win->mini_pixmap_file = NULL;
  }
#endif

  GetWindowSizeHints (tmp_win);

  /* Tentative size estimate */
  tmp_win->frame_width = tmp_win->attr.width+2*tmp_win->boundary_width;
  tmp_win->frame_height = tmp_win->attr.height + tmp_win->title_height+
    2*tmp_win->boundary_width;

  ConstrainSize(tmp_win, &tmp_win->frame_width, &tmp_win->frame_height, False,
		0, 0);

  /* Find out if the client requested a specific desk on the command line. */
  /*  RBW - 11/20/1998 - allow a desk of -1 to work.  */
  if (XGetCommand (dpy, tmp_win->w, &client_argv, &client_argc)) {
      XrmParseCommand (&db, table, 4, "fvwm", &client_argc, client_argv);
      XFreeStringList(client_argv);
      status = XrmGetResource (db, "fvwm.desk", "Fvwm.Desk",
                               &str_type, &rm_value);
      if ((status == True) && (rm_value.size != 0)) {
          SGET_START_DESK(style) = atoi(rm_value.addr);
          /*  RBW - 11/20/1998  */
          if (SGET_START_DESK(style) > -1)
            {
              style.start_desk++;
            }
          /**/
	  style.flags.use_start_on_desk = 1;
      }
/*  RBW - 11/02/1998  */
/*  RBW - 11/20/1998 - allow desk or page specs of -1 to work.  */
      /*  Handle the X Resource equivalent of StartsOnPage.  */
      status = XrmGetResource (db, "fvwm.page", "Fvwm.Page", &str_type,
			       &rm_value);
      if ((status == True) && (rm_value.size != 0)) {
          spargs = sscanf (rm_value.addr, "%d %d %d", &tmpno1, &tmpno2,
			   &tmpno3);
          switch (spargs)
            {
            case 1:
              {
		style.flags.use_start_on_desk = 1;
                style.start_desk =  (tmpno1 > -1) ? tmpno1 + 1 : tmpno1;
                break;
              }
            case 2:
              {
		style.flags.use_start_on_desk = 1;
                style.start_page_x = (tmpno1 > -1) ? tmpno1 + 1 : tmpno1;
                style.start_page_y = (tmpno2 > -1) ? tmpno2 + 1 : tmpno2;
                break;
              }
            case 3:
              {
		style.flags.use_start_on_desk = 1;
                style.start_desk = (tmpno1 > -1) ? tmpno1 + 1 : tmpno1;
                style.start_page_x = (tmpno2 > -1) ? tmpno2 + 1 : tmpno2;
                style.start_page_y = (tmpno3 > -1) ? tmpno3 + 1 : tmpno3;
                break;
              }
            default:
              {
                break;
              }
            }
      }
/**/
      XrmDestroyDatabase (db);
      db = NULL;
  }

/*  RBW - 11/02/1998  */
  if(!PlaceWindow(tmp_win, sflags, SGET_START_DESK(style),
		  SGET_START_PAGE_X(style), SGET_START_PAGE_Y(style)))
    return NULL;

  /*
   * Make sure the client window still exists.  We don't want to leave an
   * orphan frame window if it doesn't.  Since we now have the server
   * grabbed, the window can't disappear later without having been
   * reparented, so we'll get a DestroyNotify for it.  We won't have
   * gotten one for anything up to here, however.
   */
  MyXGrabServer(dpy);
  if(XGetGeometry(dpy, w, &JunkRoot, &JunkX, &JunkY,
		  &JunkWidth, &JunkHeight,
		  &JunkBW,  &JunkDepth) == 0)
    {
      free((char *)tmp_win);
      MyXUngrabServer(dpy);
      return(NULL);
    }

  XSetWindowBorderWidth (dpy, tmp_win->w,0);
  if (XGetWMIconName (dpy, tmp_win->w, &text_prop))
    {
      tmp_win->icon_name = (char *)text_prop.value;
    }
  else
    {
      tmp_win->icon_name = NULL;
    }
  if(tmp_win->icon_name==(char *)NULL)
    tmp_win->icon_name = tmp_win->name;

  SET_ICONIFIED(tmp_win, 0);
  SET_ICON_UNMAPPED(tmp_win, 0);
  SET_MAXIMIZED(tmp_win, 0);

  tmp_win->TextPixel = Scr.StdColors.fore;
  tmp_win->ReliefPixel = Scr.StdRelief.fore;
  tmp_win->ShadowPixel = Scr.StdRelief.back;
  tmp_win->BackPixel = Scr.StdColors.back;

  if(SGET_FORE_COLOR_NAME(style) != NULL) {
    XColor color;

    if(XParseColor(dpy, PictureCMap, SGET_FORE_COLOR_NAME(style), &color) &&
       XAllocColor(dpy, PictureCMap, &color))
      {
        tmp_win->TextPixel = color.pixel;
      }
  }
  if(SGET_BACK_COLOR_NAME(style) != NULL) {
    XColor color;

    if((XParseColor (dpy, PictureCMap, SGET_BACK_COLOR_NAME(style), &color))
       &&(XAllocColor (dpy, PictureCMap, &color)))

      {
        tmp_win->BackPixel = color.pixel;
      }
    tmp_win->ShadowPixel = GetShadow(tmp_win->BackPixel);
    tmp_win->ReliefPixel = GetHilite(tmp_win->BackPixel);
  }


  /* add the window to the end of the fvwm list */
  tmp_win->next = Scr.FvwmRoot.next;
  tmp_win->prev = &Scr.FvwmRoot;
  while (tmp_win->next != NULL)
  {
    tmp_win->prev = tmp_win->next;
    tmp_win->next = tmp_win->next->next;
  }
  /* tmp_win->prev points to the last window in the list, tmp_win->next is NULL.
     Now fix the last window to point to tmp_win */
  tmp_win->prev->next = tmp_win;
  /*
      RBW - 11/13/1998 - add it into the stacking order chain also.
      This chain is anchored at both ends on Scr.FvwmRoot, there are
      no null pointers.
  */
  tmp_win->stack_next = Scr.FvwmRoot.stack_next;
  Scr.FvwmRoot.stack_next->stack_prev = tmp_win;
  tmp_win->stack_prev = &Scr.FvwmRoot;
  Scr.FvwmRoot.stack_next = tmp_win;

  /*
      MatchWinToSM changes tmp_win->attr and tmp_win->stack_{prev,next}.
      Thus it is important have this call *after* PlaceWindow and the
      stacking order initialization.
  */
  MatchWinToSM(tmp_win, &x_max, &y_max, &w_max, &h_max, &do_shade, &do_maximize);

  /* set up geometry */
  tmp_win->frame_x = tmp_win->attr.x + tmp_win->old_bw;
  tmp_win->frame_y = tmp_win->attr.y + tmp_win->old_bw;
  tmp_win->frame_width = tmp_win->attr.width+2*tmp_win->boundary_width;
  tmp_win->frame_height = tmp_win->attr.height + tmp_win->title_height
			  + 2 * tmp_win->boundary_width;
  ConstrainSize(tmp_win, &tmp_win->frame_width, &tmp_win->frame_height, False,
		0, 0);
  tmp_win->title_x = tmp_win->title_y = 0;
  tmp_win->title_w = 0;
  tmp_win->title_width = tmp_win->frame_width - 2 * tmp_win->boundary_width;
  if(tmp_win->title_width < 1)
    tmp_win->title_width = 1;

  /* create windows */

  /* mono screens use a stipple pixmap to get greys */
  if(Scr.depth < 2) {
    valuemask_save = CWBackPixmap;
    if(IS_STICKY(tmp_win))
      attributes.background_pixmap = Scr.sticky_gray_pixmap;
    else
      attributes.background_pixmap = Scr.light_gray_pixmap;
  } else {
    valuemask_save = CWBackPixel;
    attributes.background_pixel = tmp_win->BackPixel;
    attributes.background_pixmap = None;
  }

  valuemask = valuemask_save|CWCursor|CWColormap|CWBorderPixel|CWEventMask;
  attributes.cursor = Scr.FvwmCursors[DEFAULT];
  attributes.colormap = Scr.cmap;
  attributes.border_pixel = 0;
  attributes.event_mask = (SubstructureRedirectMask | ButtonPressMask
			   | ButtonReleaseMask | EnterWindowMask
			   | LeaveWindowMask | ExposureMask
			   | VisibilityChangeMask);

  /* stash valuemask bits in case BorderStyle TiledPixmap overwrites */
#if defined(PIXMAP_BUTTONS) && defined(BORDERSTYLE)
  TexturePixmapSave = attributes.background_pixmap;
  if ((GetDecor(tmp_win, BorderStyle.inactive.style) & ButtonFaceTypeMask)
      == TiledPixmapButton)
    TexturePixmap = GetDecor(tmp_win,BorderStyle.inactive.u.p->picture);
  if (TexturePixmap) {
    attributes.background_pixmap = TexturePixmap;
    valuemask = (valuemask & ~CWBackPixel) | CWBackPixmap;
  }
#endif

  /* create the frame window, child of root, grandparent of client */
  tmp_win->frame = XCreateWindow(dpy, Scr.Root, tmp_win->frame_x,
				 tmp_win->frame_y, tmp_win->frame_width,
				 tmp_win->frame_height, 0, Scr.depth,
				 InputOutput, Scr.viz, valuemask, &attributes);

#if defined(PIXMAP_BUTTONS) && defined(BORDERSTYLE)
  /* restore background */
  attributes.background_pixmap = TexturePixmapSave;
#endif


  /* restore valuemask to remember background */
  valuemask = valuemask_save|CWCursor|CWColormap|CWBorderPixel|CWEventMask;
  attributes.event_mask = (ButtonPressMask | ButtonReleaseMask
			   | EnterWindowMask | LeaveWindowMask | ExposureMask);

  if (HAS_TITLE(tmp_win)) {
    tmp_win->title_x = tmp_win->boundary_width + tmp_win->title_height + 1;
    tmp_win->title_y = tmp_win->boundary_width;
    attributes.cursor = Scr.FvwmCursors[TITLE_CURSOR];
    tmp_win->title_w = XCreateWindow (dpy, tmp_win->frame, tmp_win->title_x,
				      tmp_win->title_y, tmp_win->title_width,
				      tmp_win->title_height, 0, CopyFromParent,
				      InputOutput, CopyFromParent, valuemask,
				      &attributes);
    attributes.cursor = Scr.FvwmCursors[SYS];
    for(i = 4; i >= 0; i--) {
      if((i < Scr.nr_left_buttons) && (tmp_win->left_w[i] > 0)) {
#if defined(PIXMAP_BUTTONS) && defined(BORDERSTYLE)
        if (TexturePixmap
	    && GetDecor(tmp_win,left_buttons[i].flags) & UseBorderStyle) {
	  valuemask = CWBackPixmap|CWCursor|CWColormap|CWBorderPixel|
	    CWEventMask;
	  attributes.background_pixmap = TexturePixmap;
        } else {
	  valuemask=valuemask_save|CWCursor|CWColormap|CWBorderPixel|
	    CWEventMask;
          attributes.background_pixmap = TexturePixmapSave;
        }
#endif
        tmp_win->left_w[i] = XCreateWindow (dpy, tmp_win->frame,
					    tmp_win->title_height * i, 0,
					    tmp_win->title_height,
					    tmp_win->title_height, 0,
					    CopyFromParent, InputOutput,
					    CopyFromParent, valuemask,
					    &attributes);
      } else
        tmp_win->left_w[i] = None;

      if((i < Scr.nr_right_buttons) && (tmp_win->right_w[i] > 0)) {
#if defined(PIXMAP_BUTTONS) && defined(BORDERSTYLE)
        if (TexturePixmap
	    && GetDecor(tmp_win,right_buttons[i].flags) & UseBorderStyle) {
	  valuemask = CWBackPixmap|CWCursor|CWColormap|CWBorderPixel|
	    CWEventMask;
          attributes.background_pixmap = TexturePixmap;
        } else {
	  valuemask=valuemask_save|CWCursor|CWColormap|CWBorderPixel|
	    CWEventMask;
          attributes.background_pixmap = TexturePixmapSave;
        }
#endif
        tmp_win->right_w[i] = XCreateWindow (dpy, tmp_win->frame,
					     tmp_win->title_width
					     - tmp_win->title_height * (i + 1),
					     0, tmp_win->title_height,
					     tmp_win->title_height, 0,
					     CopyFromParent, InputOutput,
					     CopyFromParent, valuemask,
					     &attributes);
      } else
        tmp_win->right_w[i] = None;
    }
  }

  /* create the resize handles */
  /* sides and corners are input only */
  /* title and buttons maybe one day */
  valuemask = CWCursor | CWEventMask;
  attributes.event_mask = (ButtonPressMask | ButtonReleaseMask
			   | EnterWindowMask | LeaveWindowMask);
  if(HAS_BORDER(tmp_win)) {
    /* Just dump the windows any old place and let SetupFrame take
     * care of the mess */
    for(i=0;i<4;i++) {
      attributes.cursor = Scr.FvwmCursors[TOP_LEFT+i];
      tmp_win->corners[i] = XCreateWindow (dpy, tmp_win->frame, 0, 0,
					   tmp_win->corner_width,
					   tmp_win->corner_width, 0, 0,
					   InputOnly,
					   DefaultVisual(dpy, Scr.screen),
					   valuemask, &attributes);
      XLowerWindow(dpy, tmp_win->corners[i]);

      attributes.cursor = Scr.FvwmCursors[TOP+i];
      tmp_win->sides[i] = XCreateWindow (dpy, tmp_win->frame, 0, 0,
					 tmp_win->boundary_width,
					 tmp_win->boundary_width, 0, 0,
					 InputOnly,
					 DefaultVisual(dpy, Scr.screen),
					 valuemask, &attributes);
    }
  }

  /* create the parent of the client window */
  /* make sure this does not have a BackPixel or BackPixmap so that
     that when the client dies there is no flash of BackPixel/BackPixmap */
  /* may look odd with shaped windows if fvwm has shapes disabled */
  valuemask = CWCursor|CWColormap|CWBorderPixel|CWBackPixmap|CWEventMask;
  attributes.cursor = Scr.FvwmCursors[DEFAULT];
  attributes.colormap = Scr.cmap;
  attributes.background_pixmap = None;
  attributes.event_mask = SubstructureRedirectMask;
  tmp_win->Parent = XCreateWindow (dpy, tmp_win->frame, tmp_win->boundary_width,
				   tmp_win->boundary_width
				   + tmp_win->title_height,
				   (tmp_win->frame_width
				   - 2 * tmp_win->boundary_width),
				   (tmp_win->frame_height
				   - 2 * tmp_win->boundary_width
				   - tmp_win->title_height), 0, CopyFromParent,
				   InputOutput, CopyFromParent, valuemask,
				   &attributes);


#ifdef MINI_ICONS
  if (tmp_win->mini_pixmap_file) {
    tmp_win->mini_icon = CachePicture (dpy, Scr.NoFocusWin, NULL,
				       tmp_win->mini_pixmap_file, Scr.ColorLimit);
  }
  else {
    tmp_win->mini_icon = NULL;
  }
#endif

  XMapSubwindows (dpy, tmp_win->frame);
  XRaiseWindow(dpy, tmp_win->Parent);
  XReparentWindow(dpy, tmp_win->w, tmp_win->Parent, 0, 0);

  valuemask = (CWEventMask | CWDontPropagate);
  attributes.event_mask = (StructureNotifyMask | PropertyChangeMask |
			   EnterWindowMask | LeaveWindowMask |
			   ColormapChangeMask | FocusChangeMask);

  attributes.do_not_propagate_mask = ButtonPressMask | ButtonReleaseMask;

  XChangeWindowAttributes (dpy, tmp_win->w, valuemask, &attributes);

  XAddToSaveSet(dpy, tmp_win->w);

  /*
   * Reparenting generates an UnmapNotify event, followed by a MapNotify.
   * Set the map state to FALSE to prevent a transition back to
   * WithdrawnState in HandleUnmapNotify.  Map state gets set correctly
   * again in HandleMapNotify.
   */
  SET_MAPPED(tmp_win, 0);
  width = tmp_win->frame_width;
  tmp_win->frame_width = 0;
  height = tmp_win->frame_height;
  tmp_win->frame_height = 0;

  SetupFrame(tmp_win, tmp_win->frame_x, tmp_win->frame_y,width,height,
	     True, False);

  if (do_maximize) {
    /* This is essentially Maximize, only we want the given dimensions */
    SET_MAXIMIZED(tmp_win, 1);
    ConstrainSize (tmp_win, &w_max, &h_max, False, 0, 0);
    tmp_win->maximized_ht = h_max;
    SetupFrame(tmp_win, x_max, y_max, w_max, h_max, TRUE, False);
    SetBorder(tmp_win, Scr.Hilite == tmp_win, True, True, None);
    /* fix orig values to not change page on unmaximize  */
    if (tmp_win->orig_x >= Scr.MyDisplayWidth)
      tmp_win->orig_x = tmp_win->orig_x % Scr.MyDisplayWidth;
    if (tmp_win->orig_y >= Scr.MyDisplayHeight)
      tmp_win->orig_y = tmp_win->orig_y % Scr.MyDisplayHeight;
  }

  if (do_shade) {
    WindowShade(&Event, tmp_win->w, tmp_win, C_WINDOW, "", 0);
  }
  /* wait until the window is iconified and the icon window is mapped
   * before creating the icon window
   */
  tmp_win->icon_w = None;
  GrabAllWindowButtons(dpy, tmp_win->frame, Scr.AllBindings, C_WINDOW,
		       GetUnusedModifiers(), Scr.FvwmCursors[DEFAULT], True);
  GrabAllWindowKeys(dpy, tmp_win->frame, Scr.AllBindings,
		    C_WINDOW|C_TITLE|C_RALL|C_LALL|C_SIDEBAR,
		    GetUnusedModifiers(), True);

  XSaveContext(dpy, tmp_win->w, FvwmContext, (caddr_t) tmp_win);
  XSaveContext(dpy, tmp_win->frame, FvwmContext, (caddr_t) tmp_win);
  XSaveContext(dpy, tmp_win->Parent, FvwmContext, (caddr_t) tmp_win);
  if (HAS_TITLE(tmp_win))
    {
      XSaveContext(dpy, tmp_win->title_w, FvwmContext, (caddr_t) tmp_win);
      for(i=0;i<Scr.nr_left_buttons;i++)
	XSaveContext(dpy, tmp_win->left_w[i], FvwmContext, (caddr_t) tmp_win);
      for(i=0;i<Scr.nr_right_buttons;i++)
	if(tmp_win->right_w[i] != None)
	  XSaveContext(dpy, tmp_win->right_w[i], FvwmContext,
		       (caddr_t) tmp_win);
    }
  if (HAS_BORDER(tmp_win))
    {
      for(i=0;i<4;i++)
	{
	  XSaveContext(dpy, tmp_win->sides[i], FvwmContext, (caddr_t) tmp_win);
	  XSaveContext(dpy,tmp_win->corners[i],FvwmContext, (caddr_t) tmp_win);
	}
    }
  if (tmp_win->stack_prev == &Scr.FvwmRoot) {
    /* RaiseWindow/LowerWindow will put the window in its layer */
    if (SDO_START_LOWERED(sflags))
      {
	LowerWindow(tmp_win);
      }
    else
      {
	RaiseWindow(tmp_win);
      }
  } else {
    XWindowChanges xwc;
    xwc.sibling = tmp_win->stack_next->frame;
    xwc.stack_mode = Above;
    XConfigureWindow(dpy, tmp_win->frame, CWSibling|CWStackMode, &xwc);
  }
  MyXUngrabServer(dpy);

  XGetGeometry(dpy, tmp_win->w, &JunkRoot, &JunkX, &JunkY,
		   &JunkWidth, &JunkHeight, &JunkBW, &JunkDepth);
  XTranslateCoordinates(dpy,tmp_win->frame,Scr.Root,JunkX,JunkY,
			&a,&b,&JunkChild);
  tmp_win->xdiff -= a;
  tmp_win->ydiff -= b;
  if(HAS_CLICK_FOCUS(tmp_win) || Scr.go.MouseFocusClickRaises)
    {
     /* need to grab all buttons for window that we are about to
      * unhighlight */
      for(i=1;i<=3;i++)
	if(Scr.buttons2grab & (1<<i))
	  {
#if 0
	    XGrabButton(dpy,(i),0,tmp_win->frame,True,
			ButtonPressMask, GrabModeSync,GrabModeAsync,None,
			Scr.FvwmCursors[SYS]);
	    XGrabButton(dpy,(i),GetUnusedModifiers(),tmp_win->frame,True,
			ButtonPressMask, GrabModeSync,GrabModeAsync,None,
			Scr.FvwmCursors[SYS]);
#else
            /* should we accept any modifier on this button? */
	    /* domivogt (2-Jan-1999): No. Or at least not like this. In the
	     * present form no button presses go through to the title bar
	     * anymore. They are all swallowed by the frame window. */
	    XGrabButton(dpy,(i),AnyModifier,tmp_win->frame,True,
  			ButtonPressMask, GrabModeSync,GrabModeAsync,None,
  			Scr.FvwmCursors[SYS]);
#endif
	  }
    }
  BroadcastConfig(M_ADD_WINDOW,tmp_win);

  BroadcastName(M_WINDOW_NAME,tmp_win->w,tmp_win->frame,
		(unsigned long)tmp_win,tmp_win->name);
  BroadcastName(M_ICON_NAME,tmp_win->w,tmp_win->frame,
		(unsigned long)tmp_win,tmp_win->icon_name);
   if (tmp_win->icon_bitmap_file != NULL &&
       tmp_win->icon_bitmap_file != Scr.DefaultIcon)
     BroadcastName(M_ICON_FILE,tmp_win->w,tmp_win->frame,
		   (unsigned long)tmp_win,tmp_win->icon_bitmap_file);
  BroadcastName(M_RES_CLASS,tmp_win->w,tmp_win->frame,
		(unsigned long)tmp_win,tmp_win->class.res_class);
  BroadcastName(M_RES_NAME,tmp_win->w,tmp_win->frame,
		(unsigned long)tmp_win,tmp_win->class.res_name);
#ifdef MINI_ICONS
  if (tmp_win->mini_icon != NULL)
    BroadcastMiniIcon(M_MINI_ICON,
                      tmp_win->w, tmp_win->frame, (unsigned long)tmp_win,
                      tmp_win->mini_icon->width,
                      tmp_win->mini_icon->height,
                      tmp_win->mini_icon->depth,
                      tmp_win->mini_icon->picture,
                      tmp_win->mini_icon->mask,
                      tmp_win->mini_pixmap_file);
#endif

  FetchWmProtocols (tmp_win);
  FetchWmColormapWindows (tmp_win);
  if(!(XGetWindowAttributes(dpy,tmp_win->w,&(tmp_win->attr))))
    tmp_win->attr.colormap = PictureCMap;
  if(NeedToResizeToo)
    {
      XWarpPointer(dpy, Scr.Root, Scr.Root, 0, 0, Scr.MyDisplayWidth,
		   Scr.MyDisplayHeight,
		   tmp_win->frame_x + (tmp_win->frame_width>>1),
		   tmp_win->frame_y + (tmp_win->frame_height>>1));
      Event.xany.type = ButtonPress;
      Event.xbutton.button = 1;
      Event.xbutton.x_root = tmp_win->frame_x + (tmp_win->frame_width>>1);
      Event.xbutton.y_root = tmp_win->frame_y + (tmp_win->frame_height>>1);
      Event.xbutton.x = (tmp_win->frame_width>>1);
      Event.xbutton.y = (tmp_win->frame_height>>1);
      Event.xbutton.subwindow = None;
      Event.xany.window = tmp_win->w;
      resize_window(&Event , tmp_win->w, tmp_win, C_WINDOW, "", 0);
    }
  InstallWindowColormaps(colormap_win);

#ifdef GNOME
  /* set GNOME hints on the window from flags set on tmp_win */
  GNOME_SetHints(tmp_win);
#endif

  return (tmp_win);
}


/***********************************************************************
 *
 *  Procedure:
 *	FetchWMProtocols - finds out which protocols the window supports
 *
 *  Inputs:
 *	tmp - the fvwm window structure to use
 *
 ***********************************************************************/
void FetchWmProtocols (FvwmWindow *tmp)
{
  Atom *protocols = NULL, *ap;
  int i, n;
  Atom atype;
  int aformat;
  unsigned long bytes_remain,nitems;

  if(tmp == NULL) return;
  /* First, try the Xlib function to read the protocols.
   * This is what Twm uses. */
  if (XGetWMProtocols (dpy, tmp->w, &protocols, &n))
    {
      for (i = 0, ap = protocols; i < n; i++, ap++)
	{
	  if (*ap == (Atom)_XA_WM_TAKE_FOCUS)
	    SET_WM_TAKES_FOCUS(tmp, 1);
	  if (*ap == (Atom)_XA_WM_DELETE_WINDOW)
	    SET_WM_DELETES_WINDOW(tmp, 1);
	}
      if (protocols)
	XFree((char *)protocols);
    }
  else
    {
      /* Next, read it the hard way. mosaic from Coreldraw needs to
       * be read in this way. */
      if ((XGetWindowProperty(dpy, tmp->w, _XA_WM_PROTOCOLS, 0L, 10L, False,
			      _XA_WM_PROTOCOLS, &atype, &aformat, &nitems,
			      &bytes_remain,
			      (unsigned char **)&protocols))==Success)
	{
	  for (i = 0, ap = protocols; i < nitems; i++, ap++)
	    {
	      if (*ap == (Atom)_XA_WM_TAKE_FOCUS)
		SET_WM_TAKES_FOCUS(tmp, 1);
	      if (*ap == (Atom)_XA_WM_DELETE_WINDOW)
		SET_WM_DELETES_WINDOW(tmp, 1);
	    }
	  if (protocols)
	    XFree((char *)protocols);
	}
    }
  return;
}

/***********************************************************************
 *
 *  Procedure:
 *	GetWindowSizeHints - gets application supplied size info
 *
 *  Inputs:
 *	tmp - the fvwm window structure to use
 *
 ***********************************************************************/
void GetWindowSizeHints(FvwmWindow *tmp)
{
  long supplied = 0;

  if (!XGetWMNormalHints (dpy, tmp->w, &tmp->hints, &supplied))
    tmp->hints.flags = 0;

  /* Beat up our copy of the hints, so that all important field are
   * filled in! */
  if (tmp->hints.flags & PResizeInc)
    {
      if (tmp->hints.width_inc == 0) tmp->hints.width_inc = 1;
      if (tmp->hints.height_inc == 0) tmp->hints.height_inc = 1;
    }
  else
    {
      tmp->hints.width_inc = 1;
      tmp->hints.height_inc = 1;
    }

  /*
   * ICCCM says that PMinSize is the default if no PBaseSize is given,
   * and vice-versa.
   */

  if(!(tmp->hints.flags & PBaseSize))
    {
      if(tmp->hints.flags & PMinSize)
	{
	  tmp->hints.base_width = tmp->hints.min_width;
	  tmp->hints.base_height = tmp->hints.min_height;
	}
      else
	{
	  tmp->hints.base_width = 0;
	  tmp->hints.base_height = 0;
	}
    }
  if(!(tmp->hints.flags & PMinSize))
    {
      tmp->hints.min_width = tmp->hints.base_width;
      tmp->hints.min_height = tmp->hints.base_height;
    }
  if(!(tmp->hints.flags & PMaxSize))
    {
      tmp->hints.max_width = MAX_WINDOW_WIDTH;
      tmp->hints.max_height = MAX_WINDOW_HEIGHT;
    }
  if (tmp->hints.flags & PBaseSize)
    {
      if (((tmp->hints.flags & PMinSize) &&
	   (tmp->hints.base_width < tmp->hints.min_width ||
	    tmp->hints.base_height < tmp->hints.min_height)) ||
	  ((tmp->hints.flags & PMaxSize) &&
	   (tmp->hints.base_width > tmp->hints.max_width ||
	    tmp->hints.base_height > tmp->hints.max_height)))
	{
	  /* The size hints are broken. Ignore min and max hints! */
	  tmp->hints.max_width = MAX_WINDOW_WIDTH;
	  tmp->hints.max_height = MAX_WINDOW_HEIGHT;
	  tmp->hints.min_height = 1;
	  tmp->hints.min_width = 1;
	}
    }
  if(tmp->hints.max_width < tmp->hints.min_width)
    tmp->hints.max_width = MAX_WINDOW_WIDTH;
  if(tmp->hints.max_height < tmp->hints.min_height)
    tmp->hints.max_height = MAX_WINDOW_HEIGHT;

  /* Zero width/height windows are bad news! */
  if(tmp->hints.min_height <= 0)
    tmp->hints.min_height = 1;
  if(tmp->hints.min_width <= 0)
    tmp->hints.min_width = 1;

  if(!(tmp->hints.flags & PWinGravity))
    {
      tmp->hints.win_gravity = NorthWestGravity;
      tmp->hints.flags |= PWinGravity;
    }

  if (tmp->hints.flags & PAspect)
  {
    /*
    ** check to make sure min/max aspect ratios look valid
    */
#define maxAspectX tmp->hints.max_aspect.x
#define maxAspectY tmp->hints.max_aspect.y
#define minAspectX tmp->hints.min_aspect.x
#define minAspectY tmp->hints.min_aspect.y
    /*
    ** The math looks like this:
    **
    **   minAspectX    maxAspectX
    **   ---------- <= ----------
    **   minAspectY    maxAspectY
    **
    ** If that is multiplied out, this must be satisfied:
    **
    **   minAspectX * maxAspectY <=  maxAspectX * minAspectY
    **
    ** So, what to do if this isn't met?  Ignoring it entirely
    ** seems safest.
    **
    */
    if ((minAspectX * maxAspectY) > (maxAspectX * minAspectY))
    {
      tmp->hints.flags &= ~PAspect;
      fvwm_msg(WARN,
               "GetWindowSizeHints",
               "window id 0x%08x max_aspect ratio is < min_aspect ratio -> ignoring, but program displaying this window should be fixed!!!!",
               tmp->w);
    }
  }
}
