#!/bin/sh

#  Modification History

#  Created on 11/06/98 by DanEspen (dje):
#  - Use man2html to convert fvwm2 man pages to html.

# Arg 1 is the man page name.
# The man pages have to be installed so the man command can find them.
# This has to be run from the directory where the output file is wanted.
#
# If you run, run_man2html.sh fvwm2, this creates "fvwm2.html" in
# the current directory.

name=`basename $1`
outfile=$name.html

# make header:
echo "<html>
<head>
<title>The Official FVWM Homepage - $name Man Page</title>
</head>
  <body BACKGROUND=\"black-stone1.jpg\"
    bgcolor=\"#000000\" text=\"#ffffff\"
    link=\"#FFFF88\" vlink=\"#EEDDDD\" alink=\"#ff0000\">
<center>
<h1><font color=\"pink\">The Official FVWM Homepage - $name Man Page</font></h1>
</center>
<pre>
" > $outfile

# Embed the text with some adjustment:
# Italics are shown in yellow.  References, (if there were any)
# would be shown in cyan.  Unfortunately bold stuff in man pages
# is lost.  Maybe in the man command, maybe in man2html.
# Output looks pretty good anyway (to my eyes).
man $name | man2html -bare \
  -uelem 'font color="yellow"'\
  -belem 'font color="cyan"'\
   >> $outfile

# make footer:
echo "</pre>
    <hr>
<!-- This file automatically generated by run_man2html.sh
     on `date` -->
  </body>
</html>
" >> $outfile
