/* FvwmPrompt
 * - Provide a Yes/No prompt before executing an FVWM action.
 *
 * Copyright 1994, Drew Moseley.
 * No guarantees or warantees or anything
 * are provided or implied in any way whatsoever. Use this program at your
 * own risk. Permission to use this program for any purpose is given,
 * as long as the copyright is kept intact. 
 */

#include "../../configure.h"
#include "../../libs/fvwmlib.h"

#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <ctype.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>

#include "../../fvwm/module.h"
#include "../../version.h"

char *MyName,command[256];
int fd[2];
unsigned long window;

#define SYS_FONT "fixed"

char *BackColor = "white";
char *ForeColor = "black";
char *font_string = SYS_FONT;
char *Geometry = NULL;

void No(Widget, XtPointer, XtPointer);
void Yes(Widget, XtPointer, XtPointer);
void DeadPipe(int);
void CopyString(char**, char*);



/***********************************************************************
 *
 * start of module
 *
 ***********************************************************************/
void main(int argc, char **argv)
{
   char *temp, *s;
   FILE *file;
   int Clength;
   XtAppContext app_context;
   Widget box, prompt, no, yes, topLevel;
   String fallback[5];
   char *tline = NULL;

   /* Save the program name for error messages and config parsing */
   temp = argv[0];
   s = strrchr(argv[0], '/');
   if (s != NULL)
      temp = s + 1;
   
   MyName = safemalloc(strlen(temp)+2);
   strcpy(MyName,"*");
   strcat(MyName, temp);
   Clength = strlen(MyName);
   
   if(argc != 8)
   {
      fprintf(stderr,"%s Version %s should only be executed by fvwm\n",MyName,
              VERSION, argc);
      exit(1);
   }

   /* Dead pipe == dead fvwm */
   signal (SIGPIPE, DeadPipe);  
   
   fd[0] = atoi(argv[1]);
   fd[1] = atoi(argv[2]);
   window = atol(argv[4]);

   strcpy(command,argv[7]);
   
   /* scan config file for set-up parameters */
   /* Colors and fonts */
   GetConfigLine(fd,&tline);
   while(tline != NULL)
     {
       if(strlen(tline)>1)
	 {
	   if(mystrncasecmp(tline, CatString3(MyName, "Font",NULL),Clength+4)==0)
	     {
	       CopyString(&font_string,&tline[Clength+4]);
	     }
	   else if(mystrncasecmp(tline,CatString3(MyName,"Fore",NULL),
				 Clength+4)==0)
	     {
	       CopyString(&ForeColor,&tline[Clength+4]);
	     }
	   else if(mystrncasecmp(tline,CatString3(MyName, "Back",NULL),
				 Clength+4)==0)
	     {
	       CopyString(&BackColor,&tline[Clength+4]);
	     }    
	   else if(mystrncasecmp(tline,CatString3(MyName, "Geometry",NULL),
				 Clength+8)==0)
	     {
	       CopyString(&Geometry,&tline[Clength+8]);
	     }    
	 }
       GetConfigLine(fd,&tline);
     }

   /*
    * Main X-toolkit code.
    */

   /*
    * Because of the way the resources are handled (ie. not
    * in a resource file spec, but in the .fvwmrc file), we
    * need to setup the fallback resources to set everything
    * up.
    */
   fallback[0] = safemalloc(strlen("Prompt*Background: ") + strlen(BackColor)+1);
   sprintf(fallback[0], "Prompt*Background: %s", BackColor);
   fallback[1] = safemalloc(strlen("Prompt*Foreground: ") + strlen(ForeColor)+1);
   sprintf(fallback[1], "Prompt*Foreground: %s", ForeColor);
   fallback[2] = safemalloc(strlen("Prompt*Font: ") + strlen(font_string)+1);
   sprintf(fallback[2], "Prompt*Font: %s", font_string);
   if (Geometry && *Geometry)
   {
      fallback[3] = malloc(strlen("Prompt*Geometry: ") + strlen(Geometry)+1);
      sprintf(fallback[3], "Prompt*Geometry: %s", Geometry);
   }
   else
     fallback[3] = NULL;
   fallback[4] = NULL;

   topLevel = XtVaAppInitialize(&app_context,
				"Prompt",
				NULL, 0,
				&argc, argv,
				fallback,
				NULL);

   box = XtVaCreateManagedWidget("box",
				 formWidgetClass,
				 topLevel,
				 NULL);

   prompt = XtVaCreateManagedWidget("Sure?",
				    labelWidgetClass,
				    box,
				    NULL);

   XtVaSetValues(prompt, XtNlabel, strtok(argv[7], "\""));

   no = XtVaCreateManagedWidget("No",
				commandWidgetClass,
				box,
				XtNfromVert, prompt,
				NULL);
   yes = XtVaCreateManagedWidget("Yes",
				 commandWidgetClass,
				 box,
				 XtNfromVert, prompt,
				 XtNfromHoriz, no,
				 NULL);

   XtAddCallback(no, XtNcallback, No, 0);
   XtAddCallback(yes, XtNcallback, Yes, 0);

   XtRealizeWidget(topLevel);
   XtAppMainLoop(app_context);
}


/**************************************************************************
 *
 * Callback for the "no" button
 *
 *************************************************************************/
/*ARGSUSED*/
void No(Widget w,XtPointer client_data,XtPointer call_data)
{
   SendInfo(fd,"NOP",window);
   exit(0); 
}


/**************************************************************************
 *
 * Callback for the "yes" button
 *
 *************************************************************************/
/*ARGSUSED*/
void Yes(Widget w,XtPointer client_data,XtPointer call_data)
{ 
/*   char *rs = strtok(NULL, "\0"), *rsend; */
   char *rs = command, *rsend;

   /* Strip all whitespace from the front */
   while (rs && *rs && (isspace(*rs))) rs++;
   if (!rs || !(*rs))  /* Nothing to send back */
   {
      SendInfo(fd,"NOP",window);
      exit(0);
   }

   /* Strip all whitespace from the back */
   rsend = rs + strlen(rs) - 1;
   while (isspace(*rs))
   {
      *rs = '\0';
      rs--;
   }

   SendInfo(fd,rs,window);
   exit(0);
}

/***********************************************************************
 *
 * Detected a broken pipe - time to exit 
 *
 **********************************************************************/
void DeadPipe(int nonsense)
{
   exit(0);
}







