/***************************************************************************
 *                         fvwm/configure.h
 * This is the only file you should have to edit to build and install Fvwm2.
 ***************************************************************************/

/***************************************************************************
 * #define RENAME_FVWM2
 *
 * If you want to install both fvwm 1.xx and fvwm 2.xx concurently, specify
 * #define RENAME_FVWM2. Otherwise, comment out the following line.
 * This will affect the name of the "fvwm" binary, library, and manual.
 ***************************************************************************/
#define RENAME_FVWM2

/*
** FVWM is the name of the module
** FVWMRC is the name of the rc file to read by default
** FVWMDIR is the install dir for all execs
*/

#ifdef RENAME_FVWM2
#define FVWM fvwm2
#define FVWMRC ".fvwm2rc"
#define FVWMDIR "/usr/lib/X11/fvwm2"
/* #define FVWMDIR "/usr/local/X11R6/lib/X11/fvwm2" */
#else
#define FVWM fvwm
#define FVWMRC ".fvwmrc"
#define FVWMDIR "/usr/lib/X11/fvwm"
#endif /* RENAME_FVWM2 */

/***************************************************************************
 * The following section only needs to be changed if you do not want
 * Imake's default behaviour. 
 * Uncomment and edit to suit your requirements.
 ***************************************************************************/

/* Where do you want the fvwm binaries installed. */
/* #define FVWM_BINDIR /usr/bin/X11 */

/* Where do you want the fvwm modules installed. The default is FVWMDIR. */
/* #define FVWM_MODULEDIR /usr/lib/X11/fvwm2 */

/* Where do you want the fvwm libraries installed. */
/* #define FVWM_LIBDIR /usr/lib/X11 */

/* Where do you want the fvwm man pages installed. */
/* #define FVWM_MANDIR /usr/local/man/man1 */
/* #define FVWM_MANSUFFIX 1 */

/* Where do you want the fvwm icons to go. */
#define FVWM_ICONDIR "/usr/include/X11/bitmaps:/usr/include/X11/pixmaps"
/* #define FVWM_ICONDIR "/usr/local/X11R6/include/X11/bitmaps:/usr/local/X11R6/include/X11/pixmaps" */

/* What compiler over-ride's do you want. */
/* #define FVWM_COMPILER gcc -g -Wall */

/***************************************************************************
 * #define XPM
 *
 * If you want color icons, specify #define XPM, and get libXpm from
 * sunsite.unc.edu (precompiled for Linux), or the source from
 * ftp.x.org.  If you want more color icons in addition to the ones
 * included in the fvwm package, check out the ctwm distribution,
 * which has lots of nice color icons.
 *
 * For monochrome, Xpm icons still work, but they're only better than regular
 * bitmaps because they're shaped (if you specify #define SHAPE).
 ***************************************************************************/
#define XPM                      

#ifdef XPM
#define XPM_LIBRARIES -lXpm 
/* #define XPM_INCLUDES -I/usr/local/include */
#endif

/***************************************************************************
 * #define HAVE_RPLAY
 *
 * To add builtin support for the rplay library.  Also make sure that the 
 * include and lib settings are correct for your rplay installation.
 * This currently only effects the FvwmAudio module.
 ***************************************************************************/
/* #define HAVE_RPLAY */

#ifdef HAVE_RPLAY
#define AUDIO_LIBRARIES -L/usr/local/lib -lrplay
/* #define  AUDIO_INCLUDES -I/usr/local/include */
#endif

/**************************************************************************
 * #define NO_SAMPLE
 *
 * If you would not like sample.fvwmrc/system.fvwmrc to be installed.
 * You probably want this if you have a modified FVWMDIR/FVWMRC. 
 *************************************************************************/
/* #define NO_SAMPLE */

/**************************************************************************
 * #define NO_UTILS
 *
 * If you would not like the programs in the utils directory installed.
 *************************************************************************/
/* #define NO_UTILS */

/**************************************************************************
 * #define NO_LIBS
 *
 * If you would not like libFVWM.a to be installed.
 *************************************************************************/
/* #define NO_LIBS */

/**************************************************************************
 * #define MODALITY_IS_EVIL
 *
 * Totally disables motif applications ability to have modal dialogs.
 * Use with care.
 *************************************************************************/
/* #define MODALITY_IS_EVIL */

/***************************************************************************
 * #define NO_SAVEUNDERS 
 *
 * Tells the WM not to request save unders for pop-up
 * menus. A quick test using monochrome X11 shows that save
 * unders cost about 4Kbytes RAM, but saves a lot of
 * window redraws if you have windows that take a while
 * to refresh. For xcolor, I assume the cost is more like
 * 4Kbytesx8 = 32kbytes (256 color).
 ***************************************************************************/
/* #define NO_SAVEUNDERS */

/***************************************************************************
 * #define SHAPE
 *
 * If you want the Shaped window extensions.
 * Shaped window extensions seem to increase the window managers RSS
 * by about 60 Kbytes. They provide for leaving a title-bar on the window
 * without a border.
 * If you don't use shaped window extension, you can either make your 
 * shaped windows undecorated, or live with a border and backdrop around
 * all your shaped windows (oclock, xeyes)
 *
 * If you normally use a shaped window (xeyes or oclock), you might as
 * well compile this extension in, since the memory cost is  minimal in
 * this case (The shaped window shared libs will be loaded anyway). If you
 * don't normally use a shaped window, you have to decide for yourself
 ***************************************************************************/
#define SHAPE                       

/*************************************************************************
 * #define BROKEN_SUN_HEADERS          
 *
 * Really, no one but me (Rob) should need this 
 ************************************************************************/
#if 0
#if defined __sun__ && !defined SYSV
#define BROKEN_SUN_HEADERS          
#endif
#endif /* 0 */

/***************************************************************************
 *
 * In theory, this stuff can be replaced with GNU Autoconf 
 *
 **************************************************************************/

#if defined _POSIX_SOURCE || defined SYSV || defined __sun__

#define HAVE_WAITPID  1
#define HAVE_SYSCONF 1
#define HAVE_UNAME 1
#undef HAVE_GETHOSTNAME 

#else

/**************************************************************************
 *
 * Do it yourself here if you don't like the above!
 *
 **************************************************************************/
/***************************************************************************
 * Define if you have waitpid.  
 **************************************************************************/
#define HAVE_WAITPID  1

/***************************************************************************
 * Define if you have sysconf
 **************************************************************************/
#define HAVE_SYSCONF 1

/***************************************************************************
 * Define if you have uname. Otherwise, define gethostname
 ***************************************************************************/
#define HAVE_UNAME 1
/* #define HAVE_GETHOSTNAME 1 */

#endif /* End of do-it-yourself OS support section */


/***************************************************************************
 * Please translate the strings into the language which you use for 
 * your pop-up menus.
 *
 * Some decisions about where a function is prohibited (based on 
 * mwm-function-hints) is based on a string comparison between the 
 * menu item and the strings below.
 ***************************************************************************/
#define MOVE_STRING "move"
#define RESIZE_STRING1 "size"
#define RESIZE_STRING2 "resize"
#define MINIMIZE_STRING "minimize"
#define MINIMIZE_STRING2 "iconify"
#define MAXIMIZE_STRING "maximize"
#define CLOSE_STRING1 "close"
#define CLOSE_STRING2 "delete"
#define CLOSE_STRING3 "destroy"
#define CLOSE_STRING4 "quit"

#ifdef __alpha
#define NEEDS_ALPHA_HEADER
#undef BROKEN_SUN_HEADERS
#endif /* (__alpha) */


/* Allows gcc users to use inline. This doesn't cause problems for others. */
#ifndef __GNUC__
#define FVWM_INLINE /*nothing*/
#else
#if defined(__GNUC__) && !defined(inline)
#define FVWM_INLINE __inline__
#else
#define FVWM_INLINE inline
#endif
#endif


/*
** if you would like to see lots of debug messages from fvwm, for debugging
** purposes, uncomment the next line
*/
/* #define FVWM_DEBUG_MSGS */
#ifdef FVWM_DEBUG_MSGS
#define DBUG(x) fprintf(stderr,"[FVWM2]: %s\n",x)
#else
#define DBUG(x) /* no messages */
#endif

/* end of configure.h */
