/****************************************************************************
 * This module is all original code 
 * by Rob Nation 
 * Copyright 1993, Robert Nation
 *     You may use this code for any purpose, as long as the original
 *     copyright remains in the source code and all documentation
 ****************************************************************************/


/****************************************************************************
 *
 * Routines to handle initialization, loading, and removing of xpm's or mono-
 * icon images.
 *
 ****************************************************************************/

#include "../configure.h"

#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <X11/keysym.h>
#include <sys/types.h>
#include <sys/time.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#ifdef XPM
#include <X11/xpm.h>
#endif

#include "fvwmlib.h"
void GetPicture(Display *dpy, Window Root, char *IconPath, char *PixmapPath, 
		char *name, Picture *p)
{
  XWindowAttributes root_attr;
#ifdef XPM
  XpmAttributes xpm_attributes;
#endif
  int HotX,HotY;
  char *path = NULL;
  Pixmap mask;
#ifdef XPM


  path = findIconFile(name, PixmapPath,R_OK);
  if(path == NULL)return;  

  XGetWindowAttributes(dpy,Root,&root_attr);
  xpm_attributes.colormap = root_attr.colormap;
  xpm_attributes.closeness = 40000; /* Allow for "similar" colors */
  xpm_attributes.valuemask = 
    XpmSize | XpmReturnPixels | XpmColormap | XpmCloseness;

  if(XpmReadFileToPixmap(dpy, Root, path,
			 &p->picture, 
			 &p->mask, 
			 &xpm_attributes) == XpmSuccess) 
    { 
      p->width = xpm_attributes.width;
      p->height = xpm_attributes.height;
      p->depth = DefaultDepthOfScreen(DefaultScreenOfDisplay(dpy));
      p->name = path;
      return;
    } 
  free(path);
#endif

  path = findIconFile(name, IconPath,R_OK);
  if(path == NULL)return;
  
  if(XReadBitmapFile (dpy, Root,path,
		      (unsigned int *)&p->width,
		      (unsigned int *)&p->height, 
		      &p->picture,
		      &HotX, &HotY) != BitmapSuccess)
    {
      free(path);
      return;
    }
  p->depth = 1;
  p->mask = None;
  p->name = path;
}


void DestroyPicture(Display *dpy, Picture *p)
{
  if(p->name != NULL)
    free(p->name);
  if(p->picture != None)
    XFreePixmap(dpy,p->picture);
  if(p->mask != None)
    XFreePixmap(dpy,p->mask);
}

void InitPicture(Picture *p)
{
  p->width = 0;
  p->height = 0;
  p->picture = None;
  p->mask = None;
  p->name = NULL;
  p->depth = 0;
}
