/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test for bank widgets.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestbankwidgets.h"
#include "skgunitcombobox.h"
#include "skgquerycreator.h"
#include "skgbkwidgetcollectiondesignerplugin.h"
#include "skgdocumentbank.h"
#include "skgtestmacro.h"

void SKGTESTBankWidgets::TestSKGUnitComboBox()
{
    SKGDocumentBank doc;
    QVERIFY2(!doc.load(SKGTest::getTestPath("OUT") % "/advice.skg"), "Load document failed");

    SKGUnitComboBox unitWidget(NULL);
    unitWidget.setDocument(&doc);
    unitWidget.setWhereClauseCondition("t_type='S'");
    SKGUnitObject unit = unitWidget.getUnit();
    unitWidget.setUnit(unit);

    unitWidget.setText("newunit");
    SKGUnitObject newunit = unitWidget.getUnit();
}

void SKGTESTBankWidgets::TestSKGQueryCreator()
{
    SKGDocumentBank doc;
    QVERIFY2(!doc.load(SKGTest::getTestPath("OUT") % "/advice.skg"), "Load document failed");

    QStringList attributeForQuery;
    attributeForQuery << "d_date" << "i_number" << "t_mode" << "t_PAYEE" << "t_comment" << "t_REALCOMMENT" << "t_REALCATEGORY" << "t_status" << "t_bookmarked" << "t_imported" << "t_TRANSFER" << "t_UNIT" << "t_ACCOUNT" << "t_TOACCOUNT" << "f_REALCURRENTAMOUNT" << "t_REALREFUND" << "f_BALANCE";

    SKGQueryCreator creator(NULL);
    creator.setParameters(&doc, "v_operation", attributeForQuery);
    QCOMPARE(creator.getColumnsCount(), 0);
    QCOMPARE(creator.getLinesCount(), 1);

    QString cond = "<!DOCTYPE SKGML><element> <!--OR--> <element>  <!--AND-->  <element operator=\"#ATT# LIKE '%#V1S#%'\" att2s=\"\" attribute=\"t_PAYEE\" att2=\"\" value=\"VIR CAF \" value2=\"\"/> </element></element>";
    creator.setXMLCondition(cond);
    QTest::qWait(100);
    QString result = creator.getXMLCondition();

    QVERIFY(result.contains("operator=\"#ATT# LIKE '%#V1S#%'\""));
    QVERIFY(result.contains("att2s=\"\""));
    QVERIFY(result.contains("attribute=\"t_PAYEE\""));
    QVERIFY(result.contains("att2=\"\""));
    QVERIFY(result.contains("value=\"VIR CAF \""));
    QVERIFY(result.contains("value2=\"\""));

    QCOMPARE(creator.getColumnsCount(), 1);
    QCOMPARE(creator.getLinesCount(), 2);

    creator.addNewLine();
    QCOMPARE(creator.getColumnsCount(), 1);
    QCOMPARE(creator.getLinesCount(), 3);

    creator.removeLine(0);
    creator.removeLine(0);
    QCOMPARE(creator.getColumnsCount(), 1);
    QCOMPARE(creator.getLinesCount(), 1);

    creator.removeColumn(0);
    QCOMPARE(creator.getColumnsCount(), 0);
    QCOMPARE(creator.getLinesCount(), 1);

    creator.removeLine(0);
    QCOMPARE(creator.getColumnsCount(), 0);
    QCOMPARE(creator.getLinesCount(), 1);
}

void SKGTESTBankWidgets::TestSKGBKWidgetCollectionDesignerPlugin()
{
    SKGBKWidgetCollectionDesignerPlugin col(NULL);
    QList<QDesignerCustomWidgetInterface*> items = col.customWidgets();
    foreach(QDesignerCustomWidgetInterface * item, items) {
        QCOMPARE(item != NULL, true);

        item->isContainer();
        QCOMPARE(item->isInitialized(), false);
        item->initialize(NULL);
        QCOMPARE(item->isInitialized(), true);
        item->icon();
        QCOMPARE(item->domXml() != "", true);
        QCOMPARE(item->group(), QString("SKG Widgets"));
        QCOMPARE(item->includeFile() != "", true);
        QCOMPARE(item->name() != "", true);
        QCOMPARE(item->toolTip() != "", true);
        QCOMPARE(item->whatsThis() != "", true);
        QCOMPARE(item->createWidget(NULL) != NULL, true);
    }
}

QTEST_MAIN(SKGTESTBankWidgets)

