/*
* kfbrowsebtn.h -- Declaration of class KBrowseButton.
* Generated by newclass on Tue Aug  4 03:44:44 EST 1998.
*/
#ifndef SSK_KFBROWSEBTN_H
#define SSK_KFBROWSEBTN_H

#include<qpushbutton.h>

class KFileDialog;
class QString;

/**
* Abstract base class for "Browse" buttons that allows URL selection
* via a @ref KFileDialog browser.
*
* Note that this class cannot be instantiated directly. Instead, use
* one of the concrete subclasses or create a subclass that implements
* @ref ::newBrowserDialog
*
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: kfbrowsebtn.h,v 1.4 2000/09/29 11:35:21 habenich Exp $
*/
class KBrowseButton : public QPushButton
{
	Q_OBJECT

public:
	/**
	* KBrowseButton Constructor.
	*
	* @param caption The button caption. If the default 0 is
	*		specified, the word "Browse.." (or its translation
	*		if available) is used.
	* @param path	The default path setting.
	* @param modal	Specify whether the launched browser will be
	*		modal.
	*/
	KBrowseButton(
    const QString & caption = QString::null,
    const QString & path = QString::null,
    QWidget *parent = 0,
    const char *name = 0,
    bool modal=false
  );

	/**
	* KBrowseButton Destructor
	*/
	virtual ~KBrowseButton();
	
	/**
	* Return the current path setting for the button.
	*/
	QString path() const;
	
public slots:

	/**
	* Set the path that will be displayed in the browser.
	*
	*/
	void setPath( const QString & url );

signals:
	/**
	* This is emitted if the user changes the path VIA THE
	* BROWSE DIALOG, ie not via the @ref ::setPath slot.
	*/
	void pathChanged( const QString &url );
	
protected:

	/**
	* Creates and returns a new file dialog object, which is
	* used when the user clicks the button. 
	*
	* Override this to return a custom dialog object derived from 
	* @ref KFileDialog for dialog customization.
	* There is no default implementation for this function. Instead,
	* you should use one of the its concrete subclasses.
	*
	* @param modal	If this is true, the reimplementation should
	*		return a modal window.
	*/
	virtual KFileDialog *newBrowserDialog( bool modal ) = 0;

private slots:
	void showDialog();
	void setPathAndRaise( const QString & url );
	void acceptPath();

private:
	KBrowseButton& operator=( KBrowseButton& );
	KBrowseButton( const KBrowseButton& );

	KFileDialog	*_dialog;
	QString		_path;
	bool		_modal;
};

/**
* "Browse" button that allows selection of files.
*
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: kfbrowsebtn.h,v 1.4 2000/09/29 11:35:21 habenich Exp $
*/
class KFileBrowseButton : public KBrowseButton
{

public:

	/**
	* KFileBrowseButton Constructor.
	* @see KBrowseButton::KBrowseButton
	*/
	KFileBrowseButton(
    const QString & text = QString::null,
    const QString & path = QString::null,
    QWidget *parent = 0,
    const char *name = 0,
    bool modal = false
  )
		: KBrowseButton( text, path, parent, name, modal )
		{}

	/**
	* KFileBrowseButton Destructor
	*/
	virtual ~KFileBrowseButton() {}

protected:
	virtual KFileDialog *newBrowserDialog( bool modal );
};


/**
* "Browse" button that allows selection of directories.
*
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: kfbrowsebtn.h,v 1.4 2000/09/29 11:35:21 habenich Exp $
*/
class KDirBrowseButton : public KBrowseButton
{

public:

	/**
	* KDirBrowseButton Constructor.
	*
	* @see KBrowseButton::KBrowseButton
	*/
	KDirBrowseButton(
    const QString & text = QString::null,
    const QString & path = QString::null,
    QWidget *parent = 0,
    const char *name = 0
  )
		: KBrowseButton( text, path, parent, name, true )
		{}

	/**
	* KDirBrowseButton Destructor
	*/
	virtual ~KDirBrowseButton() {}

protected:
	virtual KFileDialog *newBrowserDialog( bool );
};

#endif // SSK_KFBROWSEBTN_H
