/*
    SPDX-FileCopyrightText: 2012-2013 Daniel Nicoletti <dantti12@gmail.com>
    SPDX-FileCopyrightText: 2013, 2015 Kai Uwe Broulik <kde@privat.broulik.de>

    SPDX-License-Identifier: LGPL-2.0-or-later
*/

import QtQuick 2.15
import QtQuick.Layouts 1.15

import org.kde.plasma.components 3.0 as PlasmaComponents3
import org.kde.kirigami 2.20 as Kirigami

PlasmaComponents3.ItemDelegate {
    id: root

    enum Type {
        Screen,
        Keyboard
    }

    property alias slider: control
    property alias value: control.value
    property alias maximumValue: control.to
    property alias stepSize: control.stepSize
    property alias showPercentage: percent.visible
    required property /*BrightnessItem.Type*/ int type

    readonly property real percentage: Math.round(100 * value / maximumValue)

    signal moved()

    background.visible: highlighted
    highlighted: activeFocus
    hoverEnabled: false

    Accessible.description: percent.text
    Accessible.role: Accessible.Slider
    Keys.forwardTo: [slider]

    contentItem: RowLayout {
        spacing: Kirigami.Units.gridUnit

        Kirigami.Icon {
            id: image
            Layout.alignment: Qt.AlignTop
            Layout.preferredWidth: Kirigami.Units.iconSizes.medium
            Layout.preferredHeight: Kirigami.Units.iconSizes.medium
            source: root.icon.name
        }

        ColumnLayout {
            Layout.fillWidth: true
            Layout.alignment: Qt.AlignTop
            spacing: 0

            RowLayout {
                Layout.fillWidth: true
                spacing: Kirigami.Units.smallSpacing

                PlasmaComponents3.Label {
                    id: title
                    Layout.fillWidth: true
                    text: root.text
                }

                PlasmaComponents3.Label {
                    id: percent
                    Layout.alignment: Qt.AlignRight
                    text: i18nc("Placeholder is brightness percentage", "%1%", root.percentage)
                }
            }

            PlasmaComponents3.Slider {
                id: control
                Layout.fillWidth: true

                activeFocusOnTab: false
                // Don't allow the slider to turn off the screen
                // Please see https://git.reviewboard.kde.org/r/122505/ for more information
                from: root.type == BrightnessItem.Type.Screen ? 1 : 0
                stepSize: 1

                Accessible.name: root.text
                Accessible.description: percent.text

                onMoved: root.moved()
            }
        }
    }
}
