/*
 *   SPDX-FileCopyrightText: 2015 Aleix Pol Gonzalez <aleixpol@blue-systems.com>
 *
 *   SPDX-License-Identifier: LGPL-2.0-or-later
 */

import QtQuick 2.15
import org.kde.kirigami 2.14 as Kirigami

Kirigami.ScrollablePage {
    id: root

    Kirigami.Theme.colorSet: Kirigami.Theme.View
    Kirigami.Theme.inherit: false
    property bool compact: root.width < Kirigami.Units.gridUnit * 28 || !applicationWindow().wideScreen

    readonly property var s1: Shortcut {
        sequences: [ StandardKey.MoveToNextPage ]
        enabled: root.isCurrentPage
        onActivated: {
            root.flickable.contentY = Math.min(root.flickable.contentHeight - root.flickable.height,
                                               root.flickable.contentY + root.flickable.height);
        }
    }

    readonly property var s2: Shortcut {
        sequences: [ StandardKey.MoveToPreviousPage ]
        enabled: root.isCurrentPage
        onActivated: {
            root.flickable.contentY = Math.max(0, root.flickable.contentY - root.flickable.height);
        }
    }

    readonly property var sClose: Shortcut {
        sequences: [ StandardKey.Cancel ]
        enabled: root.isCurrentPage && applicationWindow().pageStack.depth>1
        onActivated: {
            applicationWindow().pageStack.pop()
        }
    }

    readonly property var sRefresh: Shortcut {
        sequences: [ StandardKey.Refresh ]
        enabled: root.isCurrentPage && root.supportsRefreshing
        onActivated: {
            if (root.supportsRefreshing) {
                root.refreshing = true
            }
        }
    }

    readonly property var readableCharacters: /\w+/
    Keys.onPressed: event => {
        if (event.text.length > 0 && event.modifiers === Qt.NoModifier && event.text.match(readableCharacters)) {
            window.globalDrawer.suggestSearchText(event.text)
        }
    }
}
