// Copyright (C) 2009 EPITA Research and Development Laboratory (LRDE)
//
// This file is part of Olena.
//
// Olena is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, version 2 of the License.
//
// Olena is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Olena.  If not, see <http://www.gnu.org/licenses/>.
//
// As a special exception, you may use this file as part of a free
// software project without restriction.  Specifically, if other files
// instantiate templates or use macros or inline functions from this
// file, or you compile this file and link it with other files to produce
// an executable, this file does not by itself cause the resulting
// executable to be covered by the GNU General Public License.  This
// exception does not however invalidate any other reasons why the
// executable file might be covered by the GNU General Public License.

#ifndef MLN_TOPO_IS_N_FACE_HH
# define MLN_TOPO_IS_N_FACE_HH

/// \file
///
/// \brief Testing whether an mln::complex_psite is an n-face.

# include <mln/core/site_set/complex_psite.hh>
# include <mln/core/image/complex_neighborhoods.hh>
# include <mln/core/image/complex_neighborhood_piter.hh>

namespace mln
{

  namespace topo
  {

    // Forward declaration.
    template <unsigned N> struct is_n_face;

    /// A functor testing wheter a mln::complex_psite is an \p N -face.
    template <unsigned N>
    struct is_n_face : public mln::Function_v2b< is_n_face<N> >
    {
      typedef bool result;

      template <typename P>
      bool operator()(const P& p) const;
    };


# ifndef MLN_INCLUDE_ONLY

    template <unsigned N> 
    template <typename P>
    inline
    bool
    is_n_face<N>::operator()(const P& p) const
    {
      return p.n() == N;
    }

# endif // MLN_INCLUDE_ONLY

  } // end of namespace mln::topo

} // end of namespace mln

#endif // ! MLN_TOPO_IS_N_FACE_HH
