# - Find Kasten library
#
# This module defines
#  LIBOKTETAKASTEN_FOUND - whether the libkasten libraries were found
#  LIBOKTETAKASTEN_LIBRARIES - the libkasten libraries
#  LIBOKTETAKASTEN_INCLUDE_DIR - the include path of the libkasten libraries


if( LIBOKTETAKASTEN_INCLUDE_DIR AND LIBOKTETAKASTEN_LIBRARIES )
    # Already in cache, be silent
    set( OktetaKasten_FIND_QUIETLY TRUE )
endif( LIBOKTETAKASTEN_INCLUDE_DIR AND LIBOKTETAKASTEN_LIBRARIES )


find_library( LIBOKTETAKASTENCORE_LIBRARY
  NAMES
  oktetakastencore
  HINTS
  ${LIB_INSTALL_DIR}
  ${KDE4_LIB_DIR}
)

find_library( LIBOKTETAKASTENGUI_LIBRARY
  NAMES
  oktetakastengui
  HINTS
  ${LIB_INSTALL_DIR}
  ${KDE4_LIB_DIR}
)

find_library( LIBOKTETAKASTENCONTROLLERS_LIBRARY
  NAMES
  oktetakastencontrollers
  HINTS
  ${LIB_INSTALL_DIR}
  ${KDE4_LIB_DIR}
)

set( LIBOKTETAKASTEN_LIBRARIES
  ${LIBOKTETAKASTENCORE_LIBRARY}
  ${LIBOKTETAKASTENGUI_LIBRARY}
  ${LIBOKTETAKASTENCONTROLLERS_LIBRARY}
)


find_path( LIBOKTETAKASTEN_INCLUDE_DIR
  NAMES
  bytearraydocument.h
  PATH_SUFFIXES
  kasten
  HINTS
  ${INCLUDE_INSTALL_DIR}
  ${KDE4_INCLUDE_DIR}
)

if( LIBOKTETAKASTEN_INCLUDE_DIR AND LIBOKTETAKASTEN_LIBRARIES )
   set( LIBOKTETAKASTEN_FOUND  TRUE )
else( LIBOKTETAKASTEN_INCLUDE_DIR AND LIBOKTETAKASTEN_LIBRARIES )
   set( LIBOKTETAKASTEN_FOUND  FALSE )
endif( LIBOKTETAKASTEN_INCLUDE_DIR AND LIBOKTETAKASTEN_LIBRARIES )


if( LIBOKTETAKASTEN_FOUND )
   if( NOT OktetaKasten_FIND_QUIETLY )
      message( STATUS "Found Okteta Kasten libraries: ${LIBOKTETAKASTEN_LIBRARIES}" )
   endif( NOT OktetaKasten_FIND_QUIETLY )
else( LIBOKTETAKASTEN_FOUND )
   if( LibKasten_FIND_REQUIRED )
      message( FATAL_ERROR "Could not find Okteta Kasten libraries" )
   endif( LibKasten_FIND_REQUIRED )
endif( LIBOKTETAKASTEN_FOUND )

mark_as_advanced( LIBOKTETAKASTEN_INCLUDE_DIR LIBOKTETAKASTEN_LIBRARIES )
