/*
   Copyright (C) 2008 by Sebastian Trueg <trueg at kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef _NEPOMUK_SEARCH_HIT_VIEW_H_
#define _NEPOMUK_SEARCH_HIT_VIEW_H_

#include <KCategorizedView>
#include <nepomuk/nepomuk_export.h>

#include "searchresult.h"

namespace Nepomuk {
    /**
     * Uses SearchHitModel to display results.
     */
    class NEPOMUK_EXPORT SearchHitView : public KCategorizedView
    {
        Q_OBJECT

    public:
        SearchHitView( QWidget* parent = 0 );
        ~SearchHitView();

        QList<QUrl> selectedResources() const;

    Q_SIGNALS:
        void resourceActivated( const QUrl& resource );

    public Q_SLOTS:
        void clear();
        void setResources( const QList<Search::Result>& resources );
        void updateResource( const Nepomuk::Search::Result& resource );

    private:
        class Private;
        Private* const d;

        Q_PRIVATE_SLOT( d, void _k_itemActivated( const QModelIndex& index ) )
    };
}

#endif
