#include <qlabel.h>
#include <qpainter.h>
#include <qtimer.h>

#include <kprogress.h>

#include "kstatwidget.moc"

KStatWidget::KStatWidget (const char *name=0) :
  KTMainWindow (name)
{
  kprogress = new KProgress (0, 100, 0, 
			     KProgress::Horizontal,
			     statusBar());

  statusBar()->insertItem ("Progress: ",1);

  //This widget is stretched to fit the window.
  statusBar()->addWidget (kprogress, 1, 2);

  QTimer *qtimer = new QTimer;
  connect ( qtimer, SIGNAL (timeout()),
	    this, SLOT (slotTimeout()) );
  qtimer->start (500);

  QLabel *qlabel = new QLabel (this);
  setView (qlabel);
}

void
KStatWidget::slotTimeout()
{
  kprogress->advance (10);
}
