#include <kapp.h>
#include <kmenubar.h>
#include <kstdaction.h>
#include <kaction.h>

#include "kjogger.moc"


KJogger::KJogger (const char *name) : KTMainWindow (name)
{
  KStdAction::quit (kapp, SLOT (closeAllWindows()), actionCollection());

  createGUI();
  view=new JogView(this);

  setView (view);

}

void
KJogger::saveProperties(KConfig* config)
{
  config->writeEntry("program",view->text());
}

void
KJogger::readProperties(KConfig* config)
{
  view->setText(config->readEntry("program",""));
}

JogView::JogView (QWidget *parent) : KLineEdit(parent)
{
  connect(this, SIGNAL(returnPressed()), SLOT (slotRun()) );
  connect(&proc, SIGNAL (processExited(KProcess*)), SLOT (slotEnable(KProcess*)) );
}

void
JogView::slotRun()
{
  setEnabled(false);
  proc.clearArguments();
  proc << text();

  proc.start();
}

void
JogView::slotEnable(KProcess*)
{
  setEnabled(true);
}
