#include <qmultilineedit.h>
#include <qtextstream.h>

#include <kapp.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <kstdaction.h>
#include <kaction.h>
#include <kfiledialog.h>
#include <knotifyclient.h>
#include <kmessagebox.h>
#include <klocale.h>
//CHANGE: This file has moved.
#include <kio/netaccess.h>
#include <ktempfile.h>

#include "keditor.moc"

//Status Bar id
const int SBLineNumber = 2;

KEditor::KEditor (const char *name) : KTMainWindow (name)
{
  qmle = new QMultiLineEdit (this);

  KStdAction::openNew (qmle, SLOT (clear()), actionCollection());
  KStdAction::quit (kapp, SLOT (closeAllWindows()), actionCollection());
  KStdAction::copy (qmle, SLOT (copy()), actionCollection());
  KStdAction::cut (qmle, SLOT (cut()), actionCollection());
  KStdAction::paste (qmle, SLOT (paste()), actionCollection());
  KStdAction::undo (qmle, SLOT (undo()), actionCollection());
  KStdAction::redo (qmle, SLOT (redo()), actionCollection());

  KStdAction::open(this, SLOT(slotOpen()), actionCollection());
  KStdAction::save(this, SLOT(slotSave()), actionCollection());
  KStdAction::saveAs(this, SLOT(slotSaveAs()), actionCollection());

  createGUI();

  statusBar()->insertItem ("Line", 1);
  statusBar()->insertItem ("0000", SBLineNumber);
  slotUpdateStatusBar();

  connect ( qmle, SIGNAL (textChanged()),
	    this, SLOT (slotUpdateStatusBar()) );


  setView (qmle);
}

void
KEditor::slotUpdateStatusBar ()
{
  QString linenumber;
  int line, col;

  qmle->getCursorPosition (&line, &col);
  linenumber.sprintf ("%4d", line);

  statusBar()->changeItem (linenumber, SBLineNumber);
}

void
KEditor::slotSaveAs()
{
  url=KFileDialog::getSaveURL(0, "*.txt|Text Files (*.txt)",this);
  file=url.path();

  if (!url.isLocalFile())
  {
     KTempFile temp;
     file=temp.name();

     slotSave();
     temp.unlink();
     return;
  }
  slotSave();
}

void
KEditor::slotSave()
{
  if (url.isEmpty() || file.isEmpty())
    {
      slotSaveAs();
      return;
    }

  QFile f(file);

  if (!f.open(IO_WriteOnly | IO_Truncate))
    {
      KNotifyClient::event("cannotopenfile");
      return;
    }

  QTextStream t( &f );
  t << qmle->text();

  f.close();
  qmle->setEdited(false);
}

void
KEditor::slotOpen()
{
  if ( qmle->edited() )
  {
    int result=KMessageBox::questionYesNo(this,
      i18n("You already have a file open! Would you like to save the currently "
           "opened file and open another?"), i18n("Continue?"));

    if (result==KMessageBox::Yes)
      slotSave();
    else
      return;
  }

  url=KFileDialog::getOpenURL(0, "*.txt|Text Files (*.txt)", this);

  if (!KIO::NetAccess::download(url, file))
    {
      KNotifyClient::event("cannotopenfile");
      return;
    }

  QFile f(file);
  if (!f.open(IO_ReadOnly))
    {
      KNotifyClient::event("cannotopenfile");
      return;
    }

  QTextStream t( &f );
  QString text(t.read());
  qmle->clear();
  qmle->setText(text);

  f.close();
}
