#ifndef __KQUICKDRAW_H__
#define __KQUICKDRAW_H__


#include <qwidget.h>

class QPixmap;

const int NEllipses=1000;

/**
 * KQuickDraw
 * Quickly redraw a window.
 **/

class KQuickDraw : public QWidget
{
 public:
  KQuickDraw (QWidget *parent, const char *name=0);

 protected:
  /**
   * Repaint the window using a bit-block transfer from the
   *  off-screen buffer (a QPixmap).  Recreate the pixmap first,
   *  if necessary.
   **/
  void paintEvent (QPaintEvent *);

  void resizeEvent (QResizeEvent *);

 private:
  QPixmap *qpixmap;
  bool bneedrecreate;
  double x[NEllipses], y[NEllipses];

};

#endif
