#include <qtimer.h>

#include <kapp.h>
#include <kaction.h>
#include <kstdaction.h>

#include "klongjob.moc"

KLongJob::KLongJob (const char *name=0) :
  KTMainWindow (name)
{
  start = 
    new KAction ("&Start", 0,  this, SLOT(slotStartComputation()), 
		 actionCollection(), "start");
  stop =
    new KAction ("Sto&p", 0,  this, SLOT(slotStopComputation()), 
		 actionCollection(), "stop");
  KStdAction::quit (kapp, SLOT (closeAllWindows()),
		    actionCollection());
  stop->setEnabled (false);

  createGUI();

  qlabel = new QLabel (this);
  qlabel->setAlignment (QLabel::AlignCenter);
  setView (qlabel);

  qtimer = new QTimer (this);
  connect ( qtimer, SIGNAL (timeout()),
	    this, SLOT (slotComputeSome()) );

}

void
KLongJob::slotStartComputation ()
{
  start->setEnabled (false);
  stop->setEnabled (true);

  qtimer->start (0);

  count=total=0;
}

void
KLongJob::slotStopComputation ()
{
  start->setEnabled (true);
  stop->setEnabled (false);

  qtimer->stop();
}

void
KLongJob::slotComputeSome()
{
  const int NumberOfFlips = 10;
  double deviation;
  int i;

  for (i=0; i<NumberOfFlips; i++)
    if (kapp->random()%2==1)
      count++;
  total+=NumberOfFlips;

  if (!(total%5000))
    {
      deviation = (count - total/2.)/(double)total;
      QString qstring;
      qstring.sprintf ("Total flips: %10d\nDeviation from 50%% heads: %10.5f",
		       total, deviation);
      qlabel->setText (qstring);
    }

  if (total>=1000000)
    slotStopComputation();
}
