/** 
 Changes from 1.x:
    Used BarIcon instead of Icon
    "exclamation" instead of "exclamation.xpm"  (.xpm would be stripped)
**/

#include <qlabel.h>

#include <kstdaccel.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <kapp.h>

#include "ksimpleapp.moc"

KSimpleApp::KSimpleApp (const char *name) :
  KTMainWindow (name)
{
  KStdAccel keys;

  QPopupMenu *filemenu = new QPopupMenu;
  filemenu->insertItem (BarIcon ("idea"), "&Reposition Text", 
			this, SLOT (slotRepositionText()),
			CTRL+Key_R);
  filemenu->insertSeparator();
  filemenu->insertItem ("&Quit", this, SLOT (slotClose()), keys.quit());
			
  menuBar()->insertItem ("&File", filemenu);

  const int buttonid = 1;
  toolBar()->insertButton ( BarIcon("idea"), buttonid,
			    SIGNAL(clicked()), this,
			    SLOT (slotRepositionText()), true,
			    "Reposition text" );


  statusBar()->message ("Ready!");

  text = new QLabel ("Hello!", this);
  text->setBackgroundColor (Qt::white);
  alignment [0] = QLabel::AlignLeft | QLabel::AlignVCenter;
  alignment [1] = QLabel::AlignHCenter | QLabel::AlignVCenter;
  alignment [2] = QLabel::AlignRight | QLabel::AlignVCenter;
  indexalignment = 0;
  
  text->setAlignment (alignment [indexalignment]);
  setView (text);
  
}

void
KSimpleApp::slotRepositionText ()
{
  indexalignment = (indexalignment+1)%3;
  text->setAlignment (alignment[indexalignment]);

  statusBar()->message ("Repositioned text in content area", 1000);
}

void
KSimpleApp::slotClose()
{
  close();
}
