#include <qlabel.h>

#include <kstdaccel.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <kapp.h>
#include <kaction.h>
#include <kstdaction.h>
#include <klocale.h>

#include "ksimpleapp.moc"

KSimpleApp::KSimpleApp (const char *name) :
  KTMainWindow (name)
{

  QPopupMenu *filemenu = new QPopupMenu;

  KAction *reposition = 
    new KAction (i18n("&Reposition Text"), QIconSet(BarIcon ("idea")),
		 CTRL+Key_R, this, SLOT (slotRepositionText()),
		 this);

  reposition->plug (filemenu);
  filemenu->insertSeparator();
  KStdAction::quit( kapp, SLOT (closeAllWindows()) )->plug (filemenu);
			
  menuBar()->insertItem (i18n("&File"), filemenu);

  reposition->plug(toolBar());

  statusBar()->message (i18n("Ready!"));

  text = new QLabel (i18n("Hello!"), this);
  text->setBackgroundColor (Qt::white);
  alignment [0] = QLabel::AlignLeft | QLabel::AlignVCenter;
  alignment [1] = QLabel::AlignHCenter | QLabel::AlignVCenter;
  alignment [2] = QLabel::AlignRight | QLabel::AlignVCenter;
  indexalignment = 0;
  
  text->setAlignment (alignment [indexalignment]);
  setView (text);
  
}

void
KSimpleApp::slotRepositionText ()
{
  indexalignment = (indexalignment+1)%3;
  text->setAlignment (alignment[indexalignment]);

  statusBar()->message (i18n("Repositioned text in content area"), 1000);
}
