/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#include "qt_QRect.h"

qt_QRect *qt_new_QRect()

{
	return (qt_QRect *) new QRect( );
}

qt_QRect *qt_new_QRect1(qt_QPoint * topleft,qt_QPoint * bottomright)

{
	return (qt_QRect *) new QRect( (QPoint&)*topleft,(QPoint&)*bottomright );
}

qt_QRect *qt_new_QRect2(qt_QPoint * topleft,qt_QSize * size)

{
	return (qt_QRect *) new QRect( (QPoint&)*topleft,(QSize&)*size );
}

qt_QRect *qt_new_QRect3(int left,int top,int width,int height)

{
	return (qt_QRect *) new QRect( (int)left,(int)top,(int)width,(int)height );
}

void qt_del_QRect (qt_QRect *p)
{
delete (QRect*) p;
}

int qt_QRect_isNull( qt_QRect *instPointer){
	return (int)((QRect *)instPointer)->isNull();
}
int qt_QRect_isEmpty( qt_QRect *instPointer){
	return (int)((QRect *)instPointer)->isEmpty();
}
int qt_QRect_isValid( qt_QRect *instPointer){
	return (int)((QRect *)instPointer)->isValid();
}
qt_QRect * qt_QRect_normalize( qt_QRect *instPointer){
    QRect r=((QRect *)instPointer)->normalize();
    return (qt_QRect *)new QRect(r.left(),r.top(),r.width(),r.height());
}
int qt_QRect_left( qt_QRect *instPointer){
	return (int)((QRect *)instPointer)->left();
}
int qt_QRect_top( qt_QRect *instPointer){
	return (int)((QRect *)instPointer)->top();
}
int qt_QRect_right( qt_QRect *instPointer){
	return (int)((QRect *)instPointer)->right();
}
int qt_QRect_bottom( qt_QRect *instPointer){
	return (int)((QRect *)instPointer)->bottom();
}
int qt_QRect_x( qt_QRect *instPointer){
	return (int)((QRect *)instPointer)->x();
}
int qt_QRect_y( qt_QRect *instPointer){
	return (int)((QRect *)instPointer)->y();
}
void qt_QRect_setLeft( qt_QRect *instPointer,int pos){
	((QRect *)instPointer)->setLeft((int )pos);
}
void qt_QRect_setTop( qt_QRect *instPointer,int pos){
	((QRect *)instPointer)->setTop((int )pos);
}
void qt_QRect_setRight( qt_QRect *instPointer,int pos){
	((QRect *)instPointer)->setRight((int )pos);
}
void qt_QRect_setBottom( qt_QRect *instPointer,int pos){
	((QRect *)instPointer)->setBottom((int )pos);
}
void qt_QRect_setX( qt_QRect *instPointer,int x){
	((QRect *)instPointer)->setX((int )x);
}
void qt_QRect_setY( qt_QRect *instPointer,int y){
	((QRect *)instPointer)->setY((int )y);
}
qt_QPoint * qt_QRect_topLeft( qt_QRect *instPointer){
    QPoint p=((QRect *)instPointer)->topLeft();
    return (qt_QPoint *)new QPoint (p.x(),p.y());
}
qt_QPoint * qt_QRect_bottomRight( qt_QRect *instPointer){
    QPoint p=((QRect *)instPointer)->bottomRight();
    return (qt_QPoint *)new QPoint (p.x(),p.y());
}
qt_QPoint * qt_QRect_topRight( qt_QRect *instPointer){
    QPoint p=((QRect *)instPointer)->topRight();
    return (qt_QPoint *)new QPoint (p.x(),p.y());
}
qt_QPoint * qt_QRect_bottomLeft( qt_QRect *instPointer){
    QPoint p=((QRect *)instPointer)->bottomLeft();
    return (qt_QPoint *)new QPoint (p.x(),p.y());
}
qt_QPoint * qt_QRect_center( qt_QRect *instPointer){
    QPoint p=((QRect *)instPointer)->center();
    return (qt_QPoint *)new QPoint (p.x(),p.y());
}
void qt_QRect_rect( qt_QRect *instPointer,int x,int y,int w,int h){
	((QRect *)instPointer)->rect((int* )x,(int* )y,(int* )w,(int* )h);
}
void qt_QRect_coords( qt_QRect *instPointer,int x1,int y1,int x2,int y2){
	((QRect *)instPointer)->coords((int* )x1,(int* )y1,(int* )x2,(int* )y2);
}
void qt_QRect_moveTopLeft( qt_QRect *instPointer,qt_QPoint * p){
	((QRect *)instPointer)->moveTopLeft((QPoint& )*p);
}
void qt_QRect_moveBottomRight( qt_QRect *instPointer,qt_QPoint * p){
	((QRect *)instPointer)->moveBottomRight((QPoint& )*p);
}
void qt_QRect_moveTopRight( qt_QRect *instPointer,qt_QPoint * p){
	((QRect *)instPointer)->moveTopRight((QPoint& )*p);
}
void qt_QRect_moveBottomLeft( qt_QRect *instPointer,qt_QPoint * p){
	((QRect *)instPointer)->moveBottomLeft((QPoint& )*p);
}
void qt_QRect_moveCenter( qt_QRect *instPointer,qt_QPoint * p){
	((QRect *)instPointer)->moveCenter((QPoint& )*p);
}
void qt_QRect_moveBy( qt_QRect *instPointer,int dx,int dy){
	((QRect *)instPointer)->moveBy((int )dx,(int )dy);
}
void qt_QRect_setRect( qt_QRect *instPointer,int x,int y,int w,int h){
	((QRect *)instPointer)->setRect((int )x,(int )y,(int )w,(int )h);
}
void qt_QRect_setCoords( qt_QRect *instPointer,int x1,int y1,int x2,int y2){
	((QRect *)instPointer)->setCoords((int )x1,(int )y1,(int )x2,(int )y2);
}
qt_QSize * qt_QRect_size( qt_QRect *instPointer){
    QSize s=((QRect *)instPointer)->size();
	return (qt_QSize *)new QSize(s.width(),s.height());
}
int qt_QRect_width( qt_QRect *instPointer){
	return (int)((QRect *)instPointer)->width();
}
int qt_QRect_height( qt_QRect *instPointer){
	return (int)((QRect *)instPointer)->height();
}
void qt_QRect_setWidth( qt_QRect *instPointer,int w){
	((QRect *)instPointer)->setWidth((int )w);
}
void qt_QRect_setHeight( qt_QRect *instPointer,int h){
	((QRect *)instPointer)->setHeight((int )h);
}
void qt_QRect_setSize( qt_QRect *instPointer,qt_QSize * s){
	((QRect *)instPointer)->setSize((QSize& )*s);
}
int qt_QRect_contains( qt_QRect *instPointer,qt_QPoint * p,int proper){
	return (int)((QRect *)instPointer)->contains((QPoint& )*p,(bool )proper);
}
int qt_QRect_contains1( qt_QRect *instPointer,qt_QRect * r,int proper){
	return (int)((QRect *)instPointer)->contains((QRect& )*r,(bool )proper);
}
qt_QRect * qt_QRect_unite( qt_QRect *instPointer,qt_QRect * r){
    QRect rr=((QRect *)instPointer)->unite((QRect& )*r);
    return (qt_QRect *)new QRect(rr.left(),rr.top(),rr.width(),rr.height());
}
qt_QRect * qt_QRect_intersect( qt_QRect *instPointer,qt_QRect * r){
    QRect rr=((QRect *)instPointer)->intersect((QRect& )*r);
    return (qt_QRect *)new QRect(rr.left(),rr.top(),rr.width(),rr.height());
}
int qt_QRect_intersects( qt_QRect *instPointer,qt_QRect * r){
	return (int)((QRect *)instPointer)->intersects((QRect& )*r);
}
