#include <ktreelist.h>

; As will item searching/sorting

suicidal virtual class KTreeList : virtual QTableView {
    KTreeList(QWidget * = 0, const char * = 0, WFlags = 0);
    virtual ~KTreeList();
    void addChildItem(const char *, const QPixmap *, int);
    void addChildItem(const char *, const QPixmap *, const KPath *);
    void addChildItem(KTreeListItem *, int);
    void addChildItem(KTreeListItem *, const KPath *);
    bool autoBottomScrollBar() const;
    bool autoScrollBar() const;
    bool autoUpdate() const;
    bool bottomScrollBar() const;
    void changeItem(const char *, const QPixmap *, int);
    void changeItem(const char *, const QPixmap *, const KPath *);
    void clear();
    void collapseItem(int);
    uint count();
    int currentItem() const;
    void expandItem(int);
    int expandLevel() const;
    void expandOrCollapseItem(int);
;    void forEveryItem(KForEvery, void *);   // This will work eventually
;    void forEveryVisibleItem(KForEvery, void *);
    KTreeListItem *getCurrentItem();
    int indentSpacing();
    void insertItem(const char *, const QPixmap *, int = -1, bool = TRUE);
    void insertItem(const char *, const QPixmap *, const KPath *, bool = TRUE);
    void insertItem(KTreeListItem *, const KPath *, bool = TRUE);
    KTreeListItem *itemAt(int);
    KTreeListItem *itemAt(const KPath *);
    int itemIndex(KTreeListItem *);
;    KPath *itemPath(int);
    void join(int);
    void lowerItem(int);
    void lowerItem(const KPath *);
    void raiseItem(int);
    void raiseItem(const KPath *);
    void removeItem(int);
    void removeItem(const KPath *);
    bool scrollBar() const;
    void setAutoUpdate(bool);
    void setBottomScrollBar(bool);
    void setCurrentItem(int);
    void setExpandButtonDrawing(bool);
    void setExpandLevel(int);
    void setIndentSpacing(int);
    void setScrollBar(bool);
    void setShowItemText(bool);
    void setSmoothScrolling(bool);
    void setTreeDrawing(bool);
    bool showItemText() const;
    bool smoothScrolling() const;
    void split(int);
    void split(const KPath *);
    KTreeListItem *takeItem(int);
    KTreeListItem *takeItem(const KPath *);
    bool treeDrawing() const;
    int visibleCount();
protected:
    void addChildItem(KTreeListItem *, KTreeListItem *);
    virtual int cellHeight(int);
    void changeItem(KTreeListItem *, int, const char *, const QPixmap *);
    bool checkItemPath(const KPath *) const;
    bool checkItemText(const char *) const;
    void collapsed(int) signal;
    void collapseSubTree(KTreeListItem *);
;    bool countItem(KTreeListItem *, void *);
    void draw_rubberband();
    void end_rubberband();
    void expanded(int) signal;
    void expandOrCollapse(KTreeListItem *);
    void expandSubTree(KTreeListItem *);
;    bool findItemAt(KTreeListItem *, void *);
    void fixChildBranches(KTreeListItem *);
    virtual void focusInEvent(QFocusEvent *);
;    void forEveryItem(KForEveryM, void *);
;    void forEveryVisibleItem(KForEveryM, void *);
;    bool getItemIndex(KTreeListItem *, void *);
;    bool getMaxItemWidth(KTreeListItem *, void *);
    void highlighted(int) signal;
    void insertItem(KTreeListItem *, KTreeListItem *, bool);
    void join(KTreeListItem *);
    virtual void keyPressEvent(QKeyEvent *);
    void lowerItem(KTreeListItem *);
    virtual void mouseDoubleClickEvent(QMouseEvent *);
    virtual void mouseMoveEvent(QMouseEvent *);
    virtual void mousePressEvent(QMouseEvent *);
    virtual void mouseReleaseEvent(QMouseEvent *);
    void move_rubberband(const QPoint &);
    virtual void paintCell(QPainter *, int, int);
    virtual void paintHighlight(QPainter *, KTreeListItem *);
    virtual void paintItem(QPainter *, KTreeListItem *, bool);
    virtual void paletteChange(const QPalette &);
    void raiseItem(KTreeListItem *);
;    KTreeListItem *recursiveFind(KTreeListItem *, KPath *);
    void selected(int) signal;
;    bool setItemExpanded(KTreeListItem *, void *);
;    bool setItemExpandButtonDrawing(KTreeListItem *, void *);
;    bool setItemIndent(KTreeListItem *, void *);
;    bool setItemShowText(KTreeListItem *, void *);
;    bool setItemTreeDrawing(KTreeListItem *, void *);
    void singleSelected(int) signal;
    void split(KTreeListItem *);
    void start_rubberband(const QPoint &);
    void takeItem(KTreeListItem *);
    virtual void updateCellWidth();
} KDE::TreeList;
