
#include <unistd.h>
#include <pwd.h>

#include <kapplication.h>
#include <kconfig.h>

#include "ksopts.h"

KSOptions *KSOptions::s_options = 0;

KSOGeneral::KSOGeneral()
{
    displayMode = MDI;
    autoCreateWin = true;
    nickCompletion = true;
    displayTopic = true;
    timeStamp = true;
    beepNotify = true;
    colorPicker = true;
    autoRejoin = false;
    windowLength = 200;
    logging = false;
    beepOnMsg = false;
    publicAway = true;
}

QPixmap KSOGeneral::backgroundPixmap()
{
    if ( m_backgroundPixmap.isNull() && !backgroundFile.isEmpty() )
	m_backgroundPixmap = QPixmap( backgroundFile );
    return m_backgroundPixmap;
}

KSOStartup::KSOStartup()
{
    docked = false;
    struct passwd *pw = getpwuid( getuid() );
    if ( pw )
    {
        nick = QString::fromLocal8Bit( pw->pw_name );
        realName = QString::fromLocal8Bit( pw->pw_gecos ).section( ',', 0, 0 );
    }
}

KSOColors::KSOColors()
{
    textColor = Qt::black;
    infoColor = Qt::blue;
    channelColor = Qt::green;
    errorColor = Qt::red;

    ksircColors = true;
    mircColors = false;

    backgroundColor = kapp->palette().color( QPalette::Active, QColorGroup::Mid );

    ircColors[0] = Qt::white;
    ircColors[1] = Qt::black;
    ircColors[2] = Qt::darkBlue;
    ircColors[3] = Qt::darkGreen;
    ircColors[4] = Qt::red;
    ircColors[5] = QColor ( 165, 42, 42 );
    ircColors[6] = Qt::darkMagenta;
    ircColors[7] = QColor ( 255, 255, 0 );
    ircColors[8] = Qt::yellow;
    ircColors[9] = Qt::green;
    ircColors[10] = Qt::darkCyan;
    ircColors[11] = Qt::cyan;
    ircColors[12] = Qt::blue;
    ircColors[13] = QColor ( 255, 192, 203 );
    ircColors[14] = Qt::gray;
    ircColors[15] = Qt::lightGray;
}

KSORMBMenu::KSORMBMenu()
{
}

KSOServChan::KSOServChan()
{
}

void KSOptions::load( int sections )
{
    KConfig *conf = kapp->config();
    conf->setGroup( "ServerController" );
    docked = conf->readBoolEntry( "Docked", false );
    geometry = conf->readRectEntry( "Size" );

    // Using the fields itself as default values as they are already
    // set to the defaults.
    if ( sections & General )
    {
        conf->setGroup( "General" );
        int mode = conf->readNumEntry( "DisplayMode", static_cast<int>(displayMode) );
        if (mode == 0)
            displayMode = SDI;
        else
            displayMode = MDI;

        autoCreateWin = conf->readBoolEntry( "AutoCreateWin", autoCreateWin );
        nickCompletion = conf->readBoolEntry( "NickCompletion", nickCompletion );
        displayTopic = conf->readBoolEntry( "DisplayTopic", displayTopic );
        timeStamp = conf->readBoolEntry( "TimeStamp", timeStamp );
        beepNotify = conf->readBoolEntry( "BeepNotify", beepNotify );
        colorPicker = conf->readBoolEntry( "ColourPicker", colorPicker );
        autoRejoin = conf->readBoolEntry( "AutoRejoin", autoRejoin );
        windowLength = conf->readNumEntry( "WindowLength", windowLength );
        backgroundFile = conf->readEntry( "BackgroundFile", backgroundFile );
        logging = conf->readBoolEntry( "Logging", logging );
        beepOnMsg = conf->readBoolEntry( "BeepOnMessage", false );
        publicAway = conf->readBoolEntry( "PublicAway", publicAway );
    }

    if ( sections & Startup )
    {
        conf->setGroup( "StartUp" );
        nick = conf->readEntry( "Nick", nick );
		altNick = conf->readEntry( "AlternativeNick", altNick );
        realName = conf->readEntry( "RealName", realName );
        if ( !conf->hasKey( "NotifyList" ) && conf->hasGroup( "NotifyList" ) )
        {
            conf->setGroup( "NotifyList" );
            int count = conf->readNumEntry( "Number" );
            for ( int i = 0; i < count; ++i )
                notifyList.append( conf->readEntry(
                    QString::fromLatin1( "Notify-%1" ).arg( i ) ) );
        }
        notifyList = conf->readListEntry( "NotifyList" );
    }

    if ( sections & Colors )
    {
        if ( !conf->hasGroup( "ColorScheme" ) && conf->hasGroup( "Colours" ) )
        {
            conf->setGroup( "Colours" );
            textColor = conf->readColorEntry( "text", &textColor );
            infoColor = conf->readColorEntry( "info", &infoColor );
            channelColor = conf->readColorEntry( "chan", &channelColor );
            errorColor = conf->readColorEntry( "error", &errorColor );
            int c = conf->readNumEntry( "uscolour", -1 );
            if ( c >= 0 && c < 16 )
                ownNickColor = ircColors[c];
            c = conf->readNumEntry( "nickfcolour", -1 );
            if ( c >= 0 && c < 16 )
                nickForeground = ircColors[c];
            c = conf->readNumEntry( "nickbcolour", -1 );
            if ( c >= 0 && c < 16 )
                nickBackground = ircColors[c];
            backgroundColor = conf->readColorEntry( "Background", &backgroundColor );
        }
        else
        {
            conf->setGroup( "ColorScheme" );
            textColor = conf->readColorEntry( "Text", &textColor );
            infoColor = conf->readColorEntry( "Info", &infoColor );
            channelColor = conf->readColorEntry( "Channel", &channelColor );
            errorColor = conf->readColorEntry( "Error", &errorColor );
            ownNickColor = conf->readColorEntry( "OwnNick", &ownNickColor );
            nickForeground = conf->readColorEntry( "NickForeground", &nickForeground );
            nickBackground = conf->readColorEntry( "NickBackground", &nickBackground );
            backgroundColor = conf->readColorEntry( "Background", &backgroundColor );
            for ( int i = 0; i < 16; ++i )
                ircColors[i] = conf->readColorEntry(
                    QString::fromLatin1( "IRC-%1" ).arg( i ), &ircColors[i] );
        }
        conf->setGroup( "GlobalOptions" );
        defaultFont = conf->readFontEntry( "MainFont" );
        QApplication::setFont( defaultFont, true, "KSirc::TextView" );
    }
}

void KSOptions::save( int sections )
{
    KConfig *conf = kapp->config();

    if ( sections & General )
    {
        conf->setGroup( "General" );
        conf->writeEntry( "DisplayMode", static_cast<int>(displayMode) );
        conf->writeEntry( "AutoCreateWin", autoCreateWin );
        conf->writeEntry( "NickCompletion", nickCompletion );
        conf->writeEntry( "DisplayTopic", displayTopic );
        conf->writeEntry( "TimeStamp", timeStamp );
        conf->writeEntry( "BeepNotify", beepNotify );
        conf->writeEntry( "ColourPicker", colorPicker );
        conf->writeEntry( "AutoRejoin", autoRejoin );
        conf->writeEntry( "WindowLength", windowLength );
        conf->writeEntry( "BackgroundFile", backgroundFile );
        conf->writeEntry( "Logging", logging );
        conf->writeEntry( "BeepOnMessage", beepOnMsg );
        conf->writeEntry( "PublicAway", publicAway );
    }

    if ( sections & Startup )
    {
        conf->setGroup( "StartUp" );
        conf->writeEntry( "Nick", nick );
		conf->writeEntry( "AlternativeNick", altNick );
        conf->writeEntry( "RealName", realName );
        conf->writeEntry( "NotifyList", notifyList );
    }

    if ( sections & Colors )
    {
        conf->setGroup( "ColorScheme" );
        conf->writeEntry( "Text", textColor );
        conf->writeEntry( "Info", infoColor );
        conf->writeEntry( "Channel", channelColor );
        conf->writeEntry( "Error", errorColor );
        conf->writeEntry( "OwnNick", ownNickColor );
        conf->writeEntry( "NickForeground", nickForeground );
        conf->writeEntry( "NickBackground", nickBackground );
        conf->writeEntry( "Background", backgroundColor );
        for ( int i = 0; i < 16; ++i )
            conf->writeEntry( QString::fromLatin1( "IRC-%1" ).arg( i ), &ircColors[i] );
		/* Store the font setting */
		conf->setGroup( "GlobalOptions" );
		conf->writeEntry("MainFont", defaultFont);
		/* end of storing the font settings */
	}
	
    conf->sync();
}

/* vim: et sw=4 ts=4
 */
