/***************************************************************************
 *   Copyright 2013 by Shantanu Tushar <shantanu@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef SETTINGS_H
#define SETTINGS_H

#include "mediacenter_export.h"
#include <KConfigGroup>

#include <QtCore/QObject>
#include <QtCore/QVariant>

class MEDIACENTER_EXPORT Settings : public QObject
{
    Q_OBJECT
public:
    explicit Settings(QObject *parent = 0);

    Q_INVOKABLE QVariant value(const QString &key, const QVariant &defaultValue = QVariant()) const;
    Q_INVOKABLE void setValue(const QString &key, const QVariant &value);

    Q_INVOKABLE void sync();
    Q_INVOKABLE bool contains(const QString &key) const;
    Q_INVOKABLE void remove (const QString &key);

private:
    KConfigGroup configGroup;
};

Q_DECLARE_METATYPE(Settings*)

#endif // SETTINGS_H
