/*  This file is part of the KDE project
    Copyright (C) 2008 Lukas Appelhans <l.appelhans@gmx.de>
    Copyright (C) 2008 Alessandro Diaferia <alediaferia@gmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#include "pkgroup.h"

#include "AuthorizationsModel.h"

#include <KIcon>

Group::Group(const QString &title, const QString &internalId, AbstractItem* parent)
        : AbstractItem(parent),
        m_internalId(internalId)
{
    if (parent && parent->isGroup()) {
        static_cast<Group*>(parent)->appendChild(this);
    }
    setTitle(title);
}

Group::~Group()
{
    qDeleteAll(m_children);
}

void Group::setTitle(const QString &title)
{
    m_title = title;
}

QVariant Group::data(int column, int datarole)
{
    Q_UNUSED(column);
    if (datarole == Qt::DisplayRole) {
        return m_title;
    } else if (datarole == Qt::UserRole) {
        return m_internalId;
    } else if (datarole == Qt::DecorationRole) {
        return KIcon("folder-locked");
    } else if (datarole == PolkitKde::AuthorizationsModel::EntryTypeRole) {
        return PolkitKde::AuthorizationsModel::GroupEntry;
    }
    return QVariant();
}

QList<AbstractItem*> Group::children()
{
    return m_children;
}
AbstractItem* Group::childAt(int i) const
{
    return m_children.at(i);
}
void Group::appendChild(AbstractItem *item)
{
    m_children << item;
}
