/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Mit Nov 14 19:09:53 CEST 2000
    copyright            : (C) 2000 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <dcopclient.h>

#include "ksteak.h"


static const char *description =
I18N_NOOP("KSteak - an english-german dictionary");

int main(int argc, char *argv[])
{
	KAboutData aboutData( "ksteak", I18N_NOOP("KSteak"),
						"0.9.3", description, KAboutData::License_GPL,
						"(c) 2000-2003 Michael Heidecke");
	aboutData.addAuthor("Michael Heidecke", 0, "heidecke@web.de");
	aboutData.addAuthor("Olaf Hartig", 0, "olebowle@gmx.de");

	KCmdLineArgs::init( argc, argv, &aboutData );

	KApplication a;

	KSteak *ksteak = new KSteak();
	ksteak->setMinimumSize(320,220);

	a.setMainWidget(ksteak);

	DCOPClient * pClient = a.dcopClient();
	pClient->attach();
	pClient->registerAs( "ksteak", false );

	return a.exec();
}
