/***************************************************************************
                          normalization.cpp
                             -------------------
    begin                : 08/15/08
    copyright            : (C) 2008 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "normalization.h"
#include <stdio.h>
#include <math.h>
#include <kgenericfactory.h>

#ifdef NAN
const double NOPOINT = NAN;
#else
const double NOPOINT = 0.0/0.0; // NaN
#endif

static const QString& VECTOR_IN = KGlobal::staticQString("Vector In");
static const QString& VECTOR_OUT = KGlobal::staticQString("Vector Out");

KST_KEY_DATAOBJECT_PLUGIN( normalization )

K_EXPORT_COMPONENT_FACTORY(kstobject_normalization,
         KGenericFactory<Normalization>("kstobject_normalizaion"))

Normalization::Normalization( QObject */*parent*/, const char */*name*/, const QStringList &/*args*/ )
    : KstBasicPlugin() {
}


Normalization::~Normalization() {
}


bool Normalization::algorithm() {
  KstVectorPtr vectorIn = inputVector(VECTOR_IN);
  KstVectorPtr vectorOut = outputVector(VECTOR_OUT);
  double dTotal = 0.0;
  double dSquaredTotal = 0.0;
  double dMean = 0.0;
  double dVariance = 1.0;
  double dStandardDeviation = 1.0;
  bool bRetVal = false;
  int iLength = vectorIn->length();
  int iLengthValid = 0;
  int i;

  if (iLength > 0) {
    vectorOut->resize(iLength, false);

    for (i=0; i<iLength; i++) {
      if (vectorIn->value()[i] == vectorIn->value()[i]) {
        dTotal += vectorIn->value()[i];
        dSquaredTotal += vectorIn->value()[i] * vectorIn->value()[i];
        iLengthValid++;
      }
    }

    if (iLengthValid > 1) {
      dMean = dTotal / (double)iLengthValid;
      dVariance  = 1.0 / ( (double)iLengthValid - 1.0 );
      dVariance *= dSquaredTotal - ( dTotal * dTotal / (double)iLengthValid );
      dStandardDeviation = sqrt( dVariance );
    }

    //
    // normalize
    //

    for (i=0; i<iLength; i++) {
      if (vectorIn->value()[i] == vectorIn->value()[i]) {
        vectorOut->value()[i] = ( vectorIn->value()[i]  - dMean ) / dStandardDeviation;
      } else {
        vectorOut->value()[i] = vectorIn->value()[i];
      }
    }

    bRetVal = true;
  }

  return bRetVal;
}

QStringList Normalization::inputVectorList() const {
  return QStringList( VECTOR_IN );
}


QStringList Normalization::inputScalarList() const {
  return QStringList();
}


QStringList Normalization::inputStringList() const {
  return QStringList();
}


QStringList Normalization::outputVectorList() const {
  return QStringList( VECTOR_OUT);
}


QStringList Normalization::outputScalarList() const {
  return QStringList();
}


QStringList Normalization::outputStringList() const {
  return QStringList();
}

#include "normalization.moc"
